/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.sosanumbers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Random;
import javax.swing.JComponent;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;

public class ProgressBar
implements PropertyChangeListener {
    private ProgressMonitor progressMonitor;
    private Task task;

    public ProgressBar(JComponent component) {
        this.progressMonitor = new ProgressMonitor(component, "Running a Long Task", "", 0, 100);
        this.progressMonitor.setProgress(0);
        this.task = new Task();
        this.task.addPropertyChangeListener(this);
        this.task.execute();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress" == evt.getPropertyName()) {
            int progress = (Integer)evt.getNewValue();
            String message = String.format("Completed %d%%.\n", progress);
            this.progressMonitor.setNote(message);
            this.progressMonitor.setProgress(progress);
            if ((this.progressMonitor.isCanceled() || this.task.isDone()) && this.progressMonitor.isCanceled()) {
                this.task.cancel(true);
            }
        }
    }

    class Task
    extends SwingWorker<Void, Void> {
        Task() {
        }

        @Override
        public Void doInBackground() {
            Random random = new Random();
            int progress = 0;
            this.setProgress(0);
            try {
                Thread.sleep(1000L);
                while (progress < 100 && !this.isCancelled()) {
                    Thread.sleep(random.nextInt(1000));
                    this.setProgress(Math.min(progress += random.nextInt(10), 100));
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return null;
        }

        @Override
        public void done() {
            ProgressBar.this.progressMonitor.setProgress(100);
        }
    }
}

