/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.sosanumbers;

import ancestris.modules.gedcom.sosanumbers.Constants;
import ancestris.modules.gedcom.sosanumbers.Pair;
import ancestris.modules.gedcom.sosanumbers.SosaComparator;
import ancestris.modules.gedcom.sosanumbers.Task;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.util.Registry;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.ProgressMonitor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class SosaNumbersGenerator
implements Constants {
    private static final Logger LOG = Logger.getLogger(SosaNumbersGenerator.class.getName(), null);
    private static final int STOP_COUNTER = 5000;
    private static final Comparator SOSA_COMPARE = new SosaComparator();
    private Gedcom gedcom = null;
    private int mode = 1;
    private int numbering = 1;
    private boolean allSosa = false;
    private boolean numberSpouse = false;
    private Indi indiDeCujus = null;
    private boolean save = true;
    private Set<Indi> changedIndis = null;
    private boolean runBlank = false;
    private int maxCounter = 0;
    private int stoppedCounter = 0;
    private ProgressMonitor progressMonitor = null;
    private Task fullTask = null;
    private Runnable task = null;

    public void run(Gedcom gedcom, Indi indiDeCujus, final String message) {
        String title;
        this.gedcom = gedcom;
        Registry registry = gedcom.getRegistry();
        this.mode = registry.get("sosaPanelAction", 1);
        this.numbering = registry.get("sosaPanelNumbering", 1);
        this.allSosa = registry.get("sosaPanelAllSosa", false);
        this.numberSpouse = registry.get("sosaPanelNumberSpouse", false);
        this.indiDeCujus = indiDeCujus;
        this.changedIndis = new HashSet<Indi>();
        this.save = registry.get("sosaPanelSave", true);
        if (this.mode == 2 && indiDeCujus == null) {
            title = NbBundle.getMessage(this.getClass(), (String)"SosaNumbersGenerator.taskErase");
            this.task = () -> this.eraseAll();
        } else if (indiDeCujus == null) {
            title = "";
        } else if (this.numbering == 4 || this.numbering == 1 || this.numbering == 2) {
            title = NbBundle.getMessage(this.getClass(), (String)(this.mode != 2 ? "SosaNumbersGenerator.taskNb" : "SosaNumbersGenerator.taskErase"));
            this.task = () -> this.numberUp();
        } else if (this.numbering == 3) {
            title = NbBundle.getMessage(this.getClass(), (String)(this.mode != 2 ? "SosaNumbersGenerator.taskNb" : "SosaNumbersGenerator.taskErase"));
            this.task = () -> this.numberDown(indiDeCujus, BigInteger.ZERO);
        } else {
            title = "";
        }
        JProgressBar progressBar = new JProgressBar(0, 100);
        progressBar.setValue(0);
        progressBar.setStringPainted(false);
        progressBar.setIndeterminate(true);
        JOptionPane optionPane = new JOptionPane(progressBar, 1, -1, null, new Object[0], null);
        final JDialog dialog = new JDialog((Frame)null, NbBundle.getMessage(this.getClass(), (String)"SosaNumbersGenerator.calc"), true);
        dialog.setContentPane(optionPane);
        dialog.setDefaultCloseOperation(0);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        dialog.setLocation((screenSize.width - optionPane.getPreferredSize().width) / 2, (screenSize.height - optionPane.getPreferredSize().height) / 2);
        dialog.pack();
        this.fullTask = new Task(null, 100){

            @Override
            public Void doInBackground() {
                SosaNumbersGenerator.this.runBlank = true;
                SosaNumbersGenerator.this.changedIndis.clear();
                SosaNumbersGenerator.this.maxCounter = 0;
                try {
                    SosaNumbersGenerator.this.task.run();
                }
                catch (Throwable e) {
                    LOG.log(Level.WARNING, "Error with numbering", e);
                }
                SosaNumbersGenerator.this.runBlank = false;
                dialog.dispose();
                return null;
            }
        };
        this.fullTask.execute();
        dialog.setVisible(true);
        boolean cont = true;
        if (this.maxCounter >= 5000 && DialogManager.YES_OPTION != DialogManager.create((String)NbBundle.getMessage(this.getClass(), (String)"SosanNumberGenerator.longOpTitle"), (String)NbBundle.getMessage(this.getClass(), (String)"SosanNumberGenerator.longOpConfirm", (Object)5000)).setMessageType(2).setOptionType(0).show()) {
            cont = false;
        }
        if (cont) {
            this.progressMonitor = new ProgressMonitor(null, title, "", 0, this.maxCounter);
            this.progressMonitor.setProgress(0);
            this.progressMonitor.setMillisToPopup(1);
            this.fullTask = new Task(this.progressMonitor, this.maxCounter){

                @Override
                public Void doInBackground() {
                    SosaNumbersGenerator.this.maxCounter = 0;
                    SosaNumbersGenerator.this.changedIndis.clear();
                    SosaNumbersGenerator.this.stoppedCounter = 0;
                    String msg = "<html>";
                    try {
                        SosaNumbersGenerator.this.commit(SosaNumbersGenerator.this.task);
                        msg = SosaNumbersGenerator.this.stoppedCounter == 0 ? (message == null ? msg + NbBundle.getMessage(this.getClass(), (String)"SosaNumbersGenerator.autogen") + "<br>" + NbBundle.getMessage(this.getClass(), (String)"SosaNumbersGenerator.changes", (Object)SosaNumbersGenerator.this.maxCounter) + "</html>" : msg + message + "<br>" + NbBundle.getMessage(this.getClass(), (String)"SosaNumbersGenerator.changes", (Object)SosaNumbersGenerator.this.maxCounter) + "</html>") : msg + NbBundle.getMessage(this.getClass(), (String)"SosaNumbersGenerator.stopped", (Object)SosaNumbersGenerator.this.stoppedCounter) + "</html>";
                    }
                    catch (Throwable e) {
                        LOG.log(Level.WARNING, "Error with numbering", e);
                        msg = msg + "Error during numbering unable to complete task </html>";
                    }
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 1));
                    return null;
                }
            };
            this.fullTask.execute();
        }
    }

    public boolean setProgress(int progress) {
        if (progress % 10 != 0) {
            return true;
        }
        String message = String.format(NbBundle.getMessage(this.getClass(), (String)"SosaNumbersGenerator.progress", (Object)"%d"), progress);
        this.progressMonitor.setNote(message);
        this.progressMonitor.setProgress(progress);
        if ((this.progressMonitor.isCanceled() || this.fullTask.isDone()) && this.progressMonitor.isCanceled()) {
            this.stoppedCounter = progress;
            return false;
        }
        return true;
    }

    private void eraseAll() {
        if (!(this.numbering != 4 && this.numbering != 1 || this.deleteTags(Indi.TAG_SOSADABOVILLE))) {
            return;
        }
        if (!(this.numbering != 4 && this.numbering != 2 || this.deleteTags(Indi.TAG_SOSA))) {
            return;
        }
        if (this.numbering == 4 || this.numbering == 3) {
            this.deleteTags(Indi.TAG_DABOVILLE);
        }
    }

    private void numberUp() {
        HashMap<String, Pair> sosaPairs = new HashMap<String, Pair>();
        LinkedList<Pair> listIter = new LinkedList<Pair>();
        this.updateIndi(this.indiDeCujus, BigInteger.ONE, listIter, sosaPairs, null);
        if (this.treeup(listIter, sosaPairs)) {
            return;
        }
        if (this.numbering == 4 || this.numbering == 1) {
            TreeSet sosaSet = new TreeSet(SOSA_COMPARE);
            sosaSet.addAll(sosaPairs.values());
            for (Pair p : sosaSet) {
                if (this.numberDown(p.getIndi(), new BigInteger(p.getValue())) || 1 != p.getIndi().getSex()) continue;
                return;
            }
        }
    }

    private boolean treeup(Queue<Pair> iter, Map<String, Pair> listCurrent) {
        while (!iter.isEmpty()) {
            if (this.runBlank && iter.size() >= 5000) {
                return false;
            }
            Pair pair = iter.poll();
            if (pair == null) continue;
            BigInteger sosa = new BigInteger(pair.getValue());
            Fam famc = pair.getIndi().getFamilyWhereBiologicalChild();
            if (famc == null) continue;
            Indi husband = famc.getHusband();
            if (husband != null && !this.updateIndi(husband, sosa.shiftLeft(1), iter, listCurrent, null)) {
                return true;
            }
            Indi wife = famc.getWife();
            if (wife == null || this.updateIndi(wife, sosa.shiftLeft(1).add(BigInteger.ONE), iter, listCurrent, null)) continue;
            return true;
        }
        return false;
    }

    private boolean numberDown(Indi indiFrom, BigInteger sosaValue) {
        HashMap<String, Pair> dabovillePairs = new HashMap<String, Pair>();
        LinkedList<Pair> listIter = new LinkedList<Pair>();
        if (this.numbering == 4 || this.numbering == 3) {
            this.updateIndi(indiFrom, sosaValue, listIter, dabovillePairs, "1");
        } else {
            Pair newPair = new Pair(indiFrom, sosaValue == BigInteger.ZERO ? "1" : "");
            listIter.offer(newPair);
            dabovillePairs.put(indiFrom.getId(), newPair);
        }
        return this.treedown(sosaValue, listIter, dabovillePairs);
    }

    private boolean treedown(BigInteger sosaValue, Queue<Pair> listIter, Map<String, Pair> dabovillePairs) {
        while (!listIter.isEmpty()) {
            Fam[] families;
            if (this.runBlank && listIter.size() >= 5000) {
                return false;
            }
            Pair current = listIter.poll();
            if (current == null) continue;
            Character suffix = Character.valueOf('a');
            String daboCounter = current.getValue();
            if (daboCounter != null && !"".equals(daboCounter) && Character.isLetter(daboCounter.charAt(daboCounter.length() - 1))) {
                return this.treedown(sosaValue, listIter, dabovillePairs);
            }
            for (Fam family : families = current.getIndi().getFamiliesWhereSpouse()) {
                Indi wife;
                Indi indi;
                int childOrder = 0;
                for (Indi child : family.getChildren(true)) {
                    ++childOrder;
                    if (this.changedIndis.contains(child)) continue;
                    String counter = daboCounter + (families.length > 1 ? suffix.toString() : "");
                    counter = counter + (counter.length() > 0 ? "." : "");
                    if (this.updateIndi(child, sosaValue, listIter, dabovillePairs, counter = counter + childOrder)) continue;
                    return false;
                }
                if (this.numberSpouse && ((indi = family.getHusband()) != null && !indi.getId().equals(current.getIndi().getId()) ? !this.changedIndis.contains(indi) && !this.updateIndi(indi, sosaValue, listIter, dabovillePairs, daboCounter + suffix.toString()) : (wife = family.getWife()) != null && !this.changedIndis.contains(wife) && !wife.getId().equals(current.getIndi().getId()) && !this.updateIndi(wife, sosaValue, listIter, dabovillePairs, daboCounter + suffix.toString()))) {
                    return false;
                }
                Character object = suffix;
                Character c = suffix = Character.valueOf((char)(suffix.charValue() + '\u0001'));
            }
        }
        return true;
    }

    private boolean updateIndi(Indi indi, BigInteger sosaNumber, Queue<Pair> listIter, Map<String, Pair> list, String daboValue) {
        boolean isNew;
        int nbErased = 0;
        boolean bl = isNew = !list.containsKey(indi.getId());
        if (isNew && (this.numbering == 4 || this.numbering == 1)) {
            nbErased += indi.getProperties(Indi.TAG_SOSADABOVILLE).length;
            if (!this.runBlank) {
                indi.delProperties(Indi.TAG_SOSADABOVILLE);
            }
        }
        if (isNew && (this.numbering == 4 || this.numbering == 2)) {
            nbErased += indi.getProperties(Indi.TAG_SOSA).length;
            if (!this.runBlank) {
                indi.delProperties(Indi.TAG_SOSA);
            }
        }
        if (isNew && (this.numbering == 4 || this.numbering == 3)) {
            nbErased += indi.getProperties(Indi.TAG_DABOVILLE).length;
            if (!this.runBlank) {
                indi.delProperties(Indi.TAG_DABOVILLE);
            }
        }
        if (isNew || this.allSosa) {
            Pair newPair = new Pair(indi, daboValue == null ? this.nbToString(sosaNumber) : daboValue);
            listIter.offer(newPair);
            if (isNew) {
                list.put(indi.getId(), newPair);
            } else {
                Pair current = list.get(indi.getId());
                if (SOSA_COMPARE.compare(newPair, current) < 0) {
                    list.remove(indi.getId());
                    list.put(indi.getId(), newPair);
                }
            }
        }
        if (isNew) {
            this.changedIndis.add(indi);
            this.maxCounter = this.mode != 2 ? ++this.maxCounter : (this.maxCounter += nbErased);
            if (this.runBlank) {
                return true;
            }
        }
        if (this.mode != 2 && (isNew || this.allSosa)) {
            Property prop = null;
            try {
                String value = this.nbToString(sosaNumber, "", true, daboValue);
                switch (this.numbering) {
                    case 1: {
                        prop = indi.addProperty(Indi.TAG_SOSADABOVILLE, value, this.getNumberPosition((Property)indi, Indi.TAG_SOSADABOVILLE, sosaNumber));
                        break;
                    }
                    case 2: {
                        prop = indi.addProperty(Indi.TAG_SOSA, value, this.getNumberPosition((Property)indi, Indi.TAG_SOSA, sosaNumber));
                        break;
                    }
                    case 3: {
                        prop = indi.addProperty(Indi.TAG_DABOVILLE, value, this.setPropertyPosition((Property)indi, Indi.TAG_DABOVILLE));
                        break;
                    }
                }
                LOG.log(Level.FINER, "{0} -> {1}", new Object[]{indi.toString(true), value});
            }
            catch (GedcomException ex) {
                LOG.log(Level.WARNING, "Error during Numbering.", ex);
            }
            if (prop != null) {
                prop.setGuessed(!this.save);
            }
        }
        return !isNew || this.setProgress(this.maxCounter);
    }

    public boolean deleteTags(String tagToRemove) {
        if (this.runBlank) {
            for (Entity entity : this.gedcom.getIndis()) {
                List props = entity.getAllProperties(tagToRemove);
                ++this.maxCounter;
            }
        } else {
            for (Entity entity : this.gedcom.getIndis()) {
                boolean counterPlus = true;
                List props = entity.getAllProperties(tagToRemove);
                for (Property prop : props) {
                    Property parent = prop.getParent();
                    if (parent == null) continue;
                    LOG.log(Level.FINER, "Tag {0} {1} deleted for {1}", new Object[]{tagToRemove, prop.getDisplayValue(), entity.toString(true)});
                    parent.delProperty(prop);
                    if (counterPlus) {
                        ++this.maxCounter;
                        counterPlus = false;
                    }
                    if (this.setProgress(this.maxCounter)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private int getNumberPosition(Property prop, String tag, BigInteger value) {
        if (prop == null) {
            return 1;
        }
        Property[] props = prop.getProperties(tag);
        if (props != null && props.length != 0) {
            for (Property p : props) {
                BigInteger bi = this.extractNumber(p.getDisplayValue());
                if (bi.compareTo(value) <= 0) continue;
                return prop.getPropertyPosition(p);
            }
            return prop.getPropertyPosition(props[props.length - 1]) + 1;
        }
        Property pName = prop.getProperty("NAME");
        if (pName != null) {
            return prop.getPropertyPosition(pName) + 1;
        }
        return 1;
    }

    private int setPropertyPosition(Property prop, String tag) {
        if (prop == null) {
            return 1;
        }
        Property[] props = prop.getProperties(tag);
        if (props != null && props.length != 0) {
            return prop.getPropertyPosition(props[props.length - 1]) + 1;
        }
        Property pName = prop.getProperty("NAME");
        if (pName != null) {
            return prop.getPropertyPosition(pName) + 1;
        }
        return 1;
    }

    private BigInteger extractNumber(String str) {
        int end;
        int start;
        for (start = 0; start <= str.length() - 1 && !Character.isDigit(str.charAt(start)); ++start) {
        }
        for (end = start; end <= str.length() - 1 && Character.isDigit(str.charAt(end)); ++end) {
        }
        if (end == start) {
            return BigInteger.ZERO;
        }
        return new BigInteger(str.substring(start, end));
    }

    protected String nbToString(BigInteger sosa) {
        return this.nbToString(sosa, "", false);
    }

    protected String nbToString(BigInteger sosa, String suffix, boolean gen) {
        return this.nbToString(sosa, suffix, gen, "");
    }

    protected String nbToString(BigInteger sosa, String suffix, boolean gen, String daboValue) {
        String sosaStr;
        DecimalFormat formatNbrs = new DecimalFormat("0");
        String string = sosaStr = sosa != BigInteger.ZERO ? formatNbrs.format(sosa) : "";
        String dabo = daboValue == null || daboValue.isEmpty() ? "" : (sosa != BigInteger.ZERO ? "-" + daboValue : daboValue);
        int genInt = sosa.bitLength();
        if (!dabo.isEmpty()) {
            int i = 1;
            for (int k = 0; k < dabo.length(); ++k) {
                if (dabo.charAt(k) != '.') continue;
                ++i;
            }
            genInt -= i;
        }
        String genStr = gen && sosa != BigInteger.ZERO ? " G" + genInt : "";
        return sosaStr + suffix + dabo + genStr;
    }

    private void commit(Runnable change) {
        block5: {
            try {
                if (this.gedcom.isWriteLocked()) {
                    change.run();
                    break block5;
                }
                this.gedcom.doUnitOfWork(gedcom1 -> change.run());
            }
            catch (GedcomException t) {
                LOG.log(Level.WARNING, "Error committing sosa generator", t);
            }
        }
    }
}

