/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.sosanumbers;

import ancestris.modules.gedcom.sosanumbers.Constants;
import ancestris.modules.gedcom.sosanumbers.GenerateSosaAction;
import genj.common.SelectEntityWidget;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.util.Registry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SosaPanel
extends JPanel
implements Constants {
    private int mode = 0;
    private Gedcom gedcom = null;
    private Registry registry = null;
    private Indi selectedIndividual = null;
    private Indi decujusIndividual = null;
    private SelectEntityWidget selectEntityWidget = null;
    private ButtonGroup actionButtonGroup;
    private JLabel actionLabel;
    private JRadioButton allIndividualRadioButton;
    private JRadioButton allNumberingRadioButton;
    private JCheckBox allSosaCheckBox;
    private JRadioButton currentDecujusRadioButton;
    private JRadioButton dabovilleRadioButton;
    private JRadioButton eraseRadioButton;
    private JRadioButton generateRadioButton;
    private ButtonGroup individualButtonGroup;
    private JLabel individualLabel;
    private JCheckBox numberSpouseCheckBox;
    private ButtonGroup numberingButtonGroup;
    private JLabel numberingLabel;
    private JRadioButton otherIndividualRadioButton;
    private JCheckBox saveCheckBox;
    private JPanel selectIndiPanel;
    private JRadioButton selectedIndividualRadioButton;
    private JRadioButton sosaRadioButton;
    private JRadioButton sosadabovilleRadioButton;

    public SosaPanel(Context context) {
        this.gedcom = context.getGedcom();
        this.selectedIndividual = null;
        Entity entity = context.getEntity();
        if (entity instanceof Indi) {
            this.selectedIndividual = (Indi)entity;
        } else if (entity instanceof Fam) {
            Fam fam = (Fam)entity;
            Indi husb = fam.getHusband();
            Indi wife = fam.getWife();
            if (husb != null) {
                this.selectedIndividual = husb;
            } else if (wife != null) {
                this.selectedIndividual = wife;
            }
        }
        this.registry = this.gedcom.getRegistry();
        this.initComponents();
        this.selectEntityWidget = new SelectEntityWidget(this.gedcom, "INDI", null);
        this.selectIndiPanel.add((Component)this.selectEntityWidget);
        this.mode = this.registry.get("sosaPanelAction", 1);
        this.generateRadioButton.setSelected(this.mode == 1);
        this.eraseRadioButton.setSelected(this.mode == 2);
        int n = this.registry.get("sosaPanelNumbering", 1);
        this.sosadabovilleRadioButton.setSelected(n == 1);
        this.sosaRadioButton.setSelected(n == 2);
        this.dabovilleRadioButton.setSelected(n == 3);
        this.allNumberingRadioButton.setSelected(n == 4);
        this.allSosaCheckBox.setSelected(this.registry.get("sosaPanelAllSosa", false));
        this.numberSpouseCheckBox.setSelected(this.registry.get("sosaPanelNumberSpouse", false));
        int s = this.registry.get("sosaPanelSelectedIndi", 1);
        this.saveCheckBox.setSelected(this.registry.get("sosaPanelSave", true));
        this.selectedIndividualRadioButton.setVisible(this.selectedIndividual != null);
        this.selectedIndividualRadioButton.setText(NbBundle.getMessage(SosaPanel.class, (String)"SosaPanel.selectedIndividualRadioButton.text", (Object)(this.selectedIndividual != null ? this.selectedIndividual.toString(true) : "")));
        String decujusID = this.registry.get("sosaPanelDecujus.id", "");
        if (!decujusID.isEmpty()) {
            this.decujusIndividual = (Indi)this.gedcom.getEntity(decujusID);
            if (this.decujusIndividual != null) {
                this.currentDecujusRadioButton.setText(NbBundle.getMessage(SosaPanel.class, (String)"SosaPanel.currentDecujusRadioButton.text", (Object)this.decujusIndividual.toString(true)));
                this.currentDecujusRadioButton.setEnabled(true);
                this.selectEntityWidget.setSelection((Entity)this.decujusIndividual);
            }
            if (s == 1 && this.selectedIndividual == null) {
                s = 2;
            }
        } else {
            this.currentDecujusRadioButton.setText(NbBundle.getMessage(SosaPanel.class, (String)"SosaPanel.currentDecujusRadioButton.text", (Object)""));
            this.currentDecujusRadioButton.setVisible(false);
            if (this.selectedIndividual != null) {
                this.selectEntityWidget.setSelection((Entity)this.selectedIndividual);
                s = 1;
            } else {
                s = 3;
            }
        }
        this.selectedIndividualRadioButton.setSelected(s == 1);
        this.currentDecujusRadioButton.setSelected(s == 2);
        this.otherIndividualRadioButton.setSelected(s == 3);
        this.allIndividualRadioButton.setSelected(s == 4);
        this.setDisplay();
    }

    private void setDisplay() {
        this.numberingLabel.setText(NbBundle.getMessage(SosaPanel.class, (String)(this.mode == 1 ? "SosaPanel.numberingLabel.text" : "SosaPanel.numberingLabel.text2")));
        this.individualLabel.setText(NbBundle.getMessage(SosaPanel.class, (String)(this.mode == 1 ? "SosaPanel.individualLabel.text" : "SosaPanel.individualLabel.text2")));
        this.saveCheckBox.setText(NbBundle.getMessage(SosaPanel.class, (String)(this.mode == 1 ? "SosaPanel.saveCheckBox.text" : "SosaPanel.saveCheckBox.text2")));
        this.allNumberingRadioButton.setVisible(this.mode == 2);
        this.allSosaCheckBox.setVisible(this.mode == 1);
        this.numberSpouseCheckBox.setVisible(this.mode == 1);
        this.selectIndiPanel.setVisible(this.otherIndividualRadioButton.isSelected());
        this.allIndividualRadioButton.setVisible(this.mode == 2);
        if (this.mode == 1 && this.allNumberingRadioButton.isSelected()) {
            this.sosadabovilleRadioButton.setSelected(true);
        }
    }

    private void initComponents() {
        this.actionButtonGroup = new ButtonGroup();
        this.numberingButtonGroup = new ButtonGroup();
        this.individualButtonGroup = new ButtonGroup();
        this.actionLabel = new JLabel();
        this.generateRadioButton = new JRadioButton();
        this.eraseRadioButton = new JRadioButton();
        this.numberingLabel = new JLabel();
        this.sosadabovilleRadioButton = new JRadioButton();
        this.sosaRadioButton = new JRadioButton();
        this.dabovilleRadioButton = new JRadioButton();
        this.allNumberingRadioButton = new JRadioButton();
        this.allSosaCheckBox = new JCheckBox();
        this.individualLabel = new JLabel();
        this.selectedIndividualRadioButton = new JRadioButton();
        this.currentDecujusRadioButton = new JRadioButton();
        this.otherIndividualRadioButton = new JRadioButton();
        this.selectIndiPanel = new JPanel();
        this.allIndividualRadioButton = new JRadioButton();
        this.saveCheckBox = new JCheckBox();
        this.numberSpouseCheckBox = new JCheckBox();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                SosaPanel.this.formComponentResized(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.actionLabel, (String)NbBundle.getMessage(SosaPanel.class, (String)"SosaPanel.actionLabel.text"));
        this.actionButtonGroup.add(this.generateRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.generateRadioButton, (String)NbBundle.getMessage(SosaPanel.class, (String)"SosaPanel.generateRadioButton.text"));
        this.generateRadioButton.setToolTipText(NbBundle.getMessage(SosaPanel.class, (String)"SosaPanel.generateRadioButton.toolTipText"));
        this.generateRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SosaPanel.this.generateRadioButtonActionPerformed(evt);
            }
        });
        this.actionButtonGroup.add(this.eraseRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.eraseRadioButton, (String)NbBundle.getMessage(SosaPanel.class, (String)"SosaPanel.eraseRadioButton.text"));
        this.eraseRadioButton.setToolTipText(NbBundle.getMessage(SosaPanel.class, (String)"SosaPanel.eraseRadioButton.toolTipText"));
        this.eraseRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SosaPanel.this.eraseRadioButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.numberingLabel, (String)NbBundle.getMessage(SosaPanel.class, (String)"SosaPanel.numberingLabel.text"));
        this.numberingButtonGroup.add(this.sosadabovilleRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.sosadabovilleRadioButton, (String)NbBundle.getMessage(SosaPanel.class, (String)"SosaPanel.sosadabovilleRadioButton.text"));
        this.sosadabovilleRadioButton.setToolTipText(NbBundle.getMessage(SosaPanel.class, (String)"SosaPanel.sosadabovilleRadioButton.toolTipText"));
        this.numberingButtonGroup.add(this.sosaRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.sosaRadioButton, (String)NbBundle.getMessage(SosaPanel.class, (String)"SosaPanel.sosaRadioButton.text"));
        this.sosaRadioButton.setToolTipText(NbBundle.getMessage(SosaPanel.class, (String)"SosaPanel.sosaRadioButton.toolTipText"));
        this.numberingButtonGroup.add(this.dabovilleRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.dabovilleRadioButton, (String)NbBundle.getMessage(SosaPanel.class, (String)"SosaPanel.dabovilleRadioButton.text"));
        this.dabovilleRadioButton.setToolTipText(NbBundle.getMessage(SosaPanel.class, (String)"SosaPanel.dabovilleRadioButton.toolTipText"));
        this.numberingButtonGroup.add(this.allNumberingRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.allNumberingRadioButton, (String)NbBundle.getMessage(SosaPanel.class, (String)"SosaPanel.allNumberingRadioButton.text"));
        this.allNumberingRadioButton.setToolTipText(NbBundle.getMessage(SosaPanel.class, (String)"SosaPanel.allNumberingRadioButton.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.allSosaCheckBox, (String)NbBundle.getMessage(SosaPanel.class, (String)"SosaPanel.allSosaCheckBox.text"));
        this.allSosaCheckBox.setToolTipText(NbBundle.getMessage(SosaPanel.class, (String)"SosaPanel.allSosaCheckBox.toolTipText"));
        Mnemonics.setLocalizedText((JLabel)this.individualLabel, (String)NbBundle.getMessage(SosaPanel.class, (String)"SosaPanel.individualLabel.text"));
        this.individualButtonGroup.add(this.selectedIndividualRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.selectedIndividualRadioButton, (String)NbBundle.getMessage(SosaPanel.class, (String)"SosaPanel.selectedIndividualRadioButton.text"));
        this.selectedIndividualRadioButton.setToolTipText(NbBundle.getMessage(SosaPanel.class, (String)"SosaPanel.selectedIndividualRadioButton.toolTipText"));
        this.selectedIndividualRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SosaPanel.this.selectedIndividualRadioButtonActionPerformed(evt);
            }
        });
        this.individualButtonGroup.add(this.currentDecujusRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.currentDecujusRadioButton, (String)NbBundle.getMessage(SosaPanel.class, (String)"SosaPanel.currentDecujusRadioButton.text"));
        this.currentDecujusRadioButton.setToolTipText(NbBundle.getMessage(SosaPanel.class, (String)"SosaPanel.currentDecujusRadioButton.toolTipText"));
        this.currentDecujusRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SosaPanel.this.currentDecujusRadioButtonActionPerformed(evt);
            }
        });
        this.individualButtonGroup.add(this.otherIndividualRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.otherIndividualRadioButton, (String)NbBundle.getMessage(SosaPanel.class, (String)"SosaPanel.otherIndividualRadioButton.text"));
        this.otherIndividualRadioButton.setToolTipText(NbBundle.getMessage(SosaPanel.class, (String)"SosaPanel.otherIndividualRadioButton.toolTipText"));
        this.otherIndividualRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SosaPanel.this.otherIndividualRadioButtonActionPerformed(evt);
            }
        });
        this.selectIndiPanel.setPreferredSize(new Dimension(0, 30));
        this.selectIndiPanel.setLayout(new BorderLayout());
        this.individualButtonGroup.add(this.allIndividualRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.allIndividualRadioButton, (String)NbBundle.getMessage(SosaPanel.class, (String)"SosaPanel.allIndividualRadioButton.text"));
        this.allIndividualRadioButton.setToolTipText(NbBundle.getMessage(SosaPanel.class, (String)"SosaPanel.allIndividualRadioButton.toolTipText"));
        this.allIndividualRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SosaPanel.this.allIndividualRadioButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.saveCheckBox, (String)NbBundle.getMessage(SosaPanel.class, (String)"SosaPanel.saveCheckBox.text"));
        this.saveCheckBox.setToolTipText(NbBundle.getMessage(SosaPanel.class, (String)"SosaPanel.saveCheckBox.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.numberSpouseCheckBox, (String)NbBundle.getMessage(SosaPanel.class, (String)"SosaPanel.numberSpouseCheckBox.text"));
        this.numberSpouseCheckBox.setToolTipText(NbBundle.getMessage(SosaPanel.class, (String)"SosaPanel.numberSpouseCheckBox.toolTipText"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.selectIndiPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.otherIndividualRadioButton).addComponent(this.selectedIndividualRadioButton).addGroup(layout.createSequentialGroup().addComponent(this.generateRadioButton).addGap(18, 18, 18).addComponent(this.eraseRadioButton)).addComponent(this.currentDecujusRadioButton).addComponent(this.allIndividualRadioButton)).addGap(0, 291, Short.MAX_VALUE)))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.numberSpouseCheckBox).addComponent(this.allSosaCheckBox).addComponent(this.sosadabovilleRadioButton).addComponent(this.sosaRadioButton).addComponent(this.dabovilleRadioButton).addComponent(this.allNumberingRadioButton).addComponent(this.actionLabel).addComponent(this.numberingLabel).addComponent(this.individualLabel).addComponent(this.saveCheckBox)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.actionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.generateRadioButton).addComponent(this.eraseRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.numberingLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sosadabovilleRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sosaRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dabovilleRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.allNumberingRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.allSosaCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.numberSpouseCheckBox).addGap(7, 7, 7).addComponent(this.individualLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectedIndividualRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.currentDecujusRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.otherIndividualRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectIndiPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.allIndividualRadioButton).addGap(18, 18, 18).addComponent(this.saveCheckBox).addContainerGap(37, Short.MAX_VALUE)));
    }

    private void formComponentResized(ComponentEvent evt) {
    }

    private void generateRadioButtonActionPerformed(ActionEvent evt) {
        this.mode = this.generateRadioButton.isSelected() ? 1 : 2;
        this.setDisplay();
    }

    private void otherIndividualRadioButtonActionPerformed(ActionEvent evt) {
        this.selectIndiPanel.setVisible(this.otherIndividualRadioButton.isSelected());
    }

    private void eraseRadioButtonActionPerformed(ActionEvent evt) {
        this.mode = this.generateRadioButton.isSelected() ? 1 : 2;
        this.setDisplay();
    }

    private void selectedIndividualRadioButtonActionPerformed(ActionEvent evt) {
        this.selectIndiPanel.setVisible(this.otherIndividualRadioButton.isSelected());
    }

    private void currentDecujusRadioButtonActionPerformed(ActionEvent evt) {
        this.selectIndiPanel.setVisible(this.otherIndividualRadioButton.isSelected());
    }

    private void allIndividualRadioButtonActionPerformed(ActionEvent evt) {
        this.selectIndiPanel.setVisible(this.otherIndividualRadioButton.isSelected());
    }

    public Indi getSelection() {
        if (this.selectedIndividualRadioButton.isSelected()) {
            return this.selectedIndividual;
        }
        if (this.currentDecujusRadioButton.isSelected()) {
            return this.decujusIndividual;
        }
        if (this.otherIndividualRadioButton.isSelected()) {
            return (Indi)this.selectEntityWidget.getSelection();
        }
        return null;
    }

    public void savePreferences() {
        this.registry.put("sosaPanelAction", this.mode);
        int n = this.sosadabovilleRadioButton.isSelected() ? 1 : (this.sosaRadioButton.isSelected() ? 2 : (this.dabovilleRadioButton.isSelected() ? 3 : 4));
        this.registry.put("sosaPanelNumbering", n);
        int s = this.selectedIndividualRadioButton.isSelected() ? 1 : (this.currentDecujusRadioButton.isSelected() ? 2 : (this.otherIndividualRadioButton.isSelected() ? 3 : 4));
        this.registry.put("sosaPanelSelectedIndi", s);
        this.registry.put("sosaPanelAllSosa", Boolean.valueOf(this.allSosaCheckBox.isSelected()));
        this.registry.put("sosaPanelNumberSpouse", Boolean.valueOf(this.numberSpouseCheckBox.isSelected()));
        this.registry.put("sosaPanelSave", Boolean.valueOf(this.saveCheckBox.isSelected()));
        if (this.mode == 1) {
            this.registry.put("sosaPanelDecujus.id", this.getSelection().getId());
        } else {
            this.registry.remove("sosaPanelDecujus.id");
        }
    }

    public String getResultMessage() {
        Indi indi = this.getSelection();
        String numbering = this.sosadabovilleRadioButton.isSelected() ? this.sosadabovilleRadioButton.getText() : (this.sosaRadioButton.isSelected() ? this.sosaRadioButton.getText() : (this.dabovilleRadioButton.isSelected() ? this.dabovilleRadioButton.getText() : this.allNumberingRadioButton.getText()));
        String msg = "";
        if (this.mode == 1) {
            if (indi != null) {
                msg = NbBundle.getMessage(GenerateSosaAction.class, (String)"GenerateSosaAction.generateDone", (Object)numbering, (Object)indi.getName());
            }
        } else {
            msg = indi != null ? NbBundle.getMessage(GenerateSosaAction.class, (String)"GenerateSosaAction.eraseDone", (Object)numbering, (Object)indi.getName()) : NbBundle.getMessage(GenerateSosaAction.class, (String)"GenerateSosaAction.eraseAll", (Object)numbering.trim());
        }
        return msg;
    }
}

