/*
 * Decompiled with CFR 0.152.
 */
package ancestris.report.svgtree.graphics;

import ancestris.report.svgtree.IndiBox;
import ancestris.report.svgtree.Translator;
import ancestris.report.svgtree.filter.TreeFilterBase;
import ancestris.report.svgtree.graphics.GraphicsRenderer;
import ancestris.report.svgtree.graphics.GraphicsUtil;
import ancestris.report.svgtree.output.GraphicsTreeElements;
import genj.gedcom.PropertyChange;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;

public class FooterRenderer
implements GraphicsRenderer {
    private static final String FOOTER_PREFIX = "footer.";
    public static final int MARGIN = 5;
    private static final int FONT_SIZE = 10;
    public String fontNameFooter = "verdana";
    public int footer_mode = 1;
    public String[] footer_modes = new String[]{"none", "local", "global", "current"};
    private String displayDate;
    private final GraphicsRenderer renderer;
    private final Translator translator;

    public FooterRenderer(GraphicsRenderer renderer, Translator translator) {
        this.renderer = renderer;
        this.translator = translator;
    }

    public void setFirstIndi(IndiBox firstIndi) {
        this.displayDate = null;
        switch (this.footer_mode) {
            case 1: {
                FindDateOfModification filter = new FindDateOfModification();
                filter.filter(firstIndi);
                this.displayDate = filter.mostRecent;
                if (this.displayDate != null) break;
            }
            case 2: {
                PropertyChange lastChange = firstIndi.individual.getGedcom().getLastChange();
                if (lastChange == null) break;
                this.displayDate = lastChange.getDisplayValue();
                break;
            }
            case 3: {
                PropertyChange currentTime = new PropertyChange();
                this.displayDate = currentTime.getDisplayValue();
            }
        }
        if (this.displayDate == null) {
            this.displayDate = this.translator.translate("not_available");
        }
    }

    @Override
    public int getImageHeight() {
        if (this.footer_mode == 0) {
            return this.renderer.getImageHeight();
        }
        return this.renderer.getImageHeight() + 10 + 5;
    }

    @Override
    public int getImageWidth() {
        return this.renderer.getImageWidth();
    }

    @Override
    public void render(Graphics2D graphics) {
        if (this.footer_mode != 0) {
            graphics.setBackground(Color.WHITE);
            graphics.clearRect(0, 0, this.getImageWidth(), this.getImageHeight());
            graphics.setColor(Color.BLACK);
            this.checkFont();
            graphics.setFont(new Font(this.fontNameFooter, 0, 10));
            String caption = this.translator.translate(FOOTER_PREFIX + this.footer_modes[this.footer_mode]) + ": " + this.displayDate;
            GraphicsTreeElements.alignRightString(graphics, caption, this.getImageWidth() - 5, this.getImageHeight() - 2 - 5);
        }
        this.renderer.render(graphics);
    }

    private void checkFont() {
        if (!GraphicsUtil.checkFont(this.fontNameFooter)) {
            this.fontNameFooter = "verdana";
        }
    }

    private static class FindDateOfModification
    extends TreeFilterBase {
        long mostRecentTime = 0L;
        String mostRecent = null;

        private FindDateOfModification() {
        }

        @Override
        protected void preFilter(IndiBox indibox) {
            this.checkDate(indibox.individual.getLastChange());
            if (indibox.family != null) {
                this.checkDate(indibox.family.family.getLastChange());
            }
        }

        private void checkDate(PropertyChange lastChange) {
            if (lastChange == null) {
                return;
            }
            long time = lastChange.getTime();
            if (time > this.mostRecentTime) {
                this.mostRecentTime = time;
                this.mostRecent = lastChange.getDisplayValue();
            }
        }
    }
}

