/*
 * Decompiled with CFR 0.152.
 */
package ancestris.report.svgtree.output;

import ancestris.report.svgtree.graphics.GraphicsRenderer;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

public class RotateRenderer
implements GraphicsRenderer {
    public static final int ROTATE_0 = 0;
    public static final int ROTATE_270 = 1;
    public static final int ROTATE_180 = 2;
    public static final int ROTATE_90 = 3;
    private final GraphicsRenderer renderer;
    public int rotation = 0;
    public String[] rotations = new String[]{"none", "270", "180", "90"};

    public RotateRenderer(GraphicsRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public int getImageHeight() {
        if (this.rotation == 0 || this.rotation == 2) {
            return this.renderer.getImageHeight();
        }
        return this.renderer.getImageWidth();
    }

    @Override
    public int getImageWidth() {
        if (this.rotation == 0 || this.rotation == 2) {
            return this.renderer.getImageWidth();
        }
        return this.renderer.getImageHeight();
    }

    @Override
    public void render(Graphics2D graphics) {
        AffineTransform transform = graphics.getTransform();
        switch (this.rotation) {
            case 3: {
                graphics.translate(this.renderer.getImageHeight(), 0);
                graphics.rotate(1.5707963267948966);
                break;
            }
            case 2: {
                graphics.translate(this.renderer.getImageWidth(), this.renderer.getImageHeight());
                graphics.rotate(Math.PI);
                break;
            }
            case 1: {
                graphics.translate(0, this.renderer.getImageWidth());
                graphics.rotate(-1.5707963267948966);
            }
        }
        this.renderer.render(graphics);
        graphics.setTransform(transform);
    }
}

