/*
 * Decompiled with CFR 0.152.
 */
package ancestris.report.svgtree.output;

import ancestris.report.svgtree.IndiBox;
import ancestris.report.svgtree.output.TreeRendererBase;
import java.awt.Dimension;
import java.util.TreeSet;

public class VerticalTreeRenderer
extends TreeRendererBase {
    @Override
    protected void drawLines(IndiBox indibox, int baseX, int baseY) {
        int midX = baseX + this.getMidX(indibox);
        int lineY = baseY + this.getChildrenLineY(indibox);
        if (indibox.hasChildren() || indibox.getDir() == IndiBox.Direction.PARENT) {
            int midY = baseY + indibox.height;
            if (indibox.spouse != null) {
                midY -= indibox.height / 2;
            }
            if (indibox.family != null) {
                midY = baseY + indibox.height + indibox.family.height;
            }
            this.elements.drawLine(midX, midY, midX, lineY);
            TreeSet<Integer> xSet = new TreeSet<Integer>();
            xSet.add(midX);
            if (indibox.getDir() == IndiBox.Direction.PARENT) {
                xSet.add(baseX - indibox.x + indibox.prev.width / 2);
            }
            if (indibox.hasChildren()) {
                for (IndiBox children : indibox.children) {
                    xSet.add(baseX + children.x + children.width / 2);
                }
            }
            int x1 = (Integer)xSet.first();
            int x2 = (Integer)xSet.last();
            this.elements.drawLine(x1, lineY, x2, lineY);
        }
        if (indibox.parent != null) {
            int parentLineY = baseY + indibox.parent.y + this.getChildrenLineY(indibox.parent);
            this.elements.drawLine(baseX + indibox.width / 2, baseY, baseX + indibox.width / 2, parentLineY);
        }
        if (indibox.hasChildren()) {
            for (IndiBox children : indibox.children) {
                int x = baseX + children.x + children.width / 2;
                this.elements.drawLine(x, baseY + children.y, x, lineY);
            }
        }
        if (indibox.nextMarriage != null) {
            lineY = indibox.height / 2;
            if (indibox.nextMarriage.height < indibox.height) {
                lineY = indibox.nextMarriage.height / 2;
            }
            if (indibox.nextMarriage.x > 0) {
                this.elements.drawDashedLine(baseX + indibox.width, baseY + lineY, baseX + indibox.nextMarriage.x, baseY + lineY);
            } else {
                this.elements.drawDashedLine(baseX, baseY + lineY, baseX + indibox.nextMarriage.x + indibox.nextMarriage.width, baseY + lineY);
            }
        }
    }

    private int getChildrenLineY(IndiBox indibox) {
        int lineY;
        if (indibox.hasChildren()) {
            lineY = indibox.children[0].y;
            for (int i = 1; i < indibox.children.length; ++i) {
                lineY = Math.min(lineY, indibox.children[i].y);
            }
            lineY -= 10;
        } else {
            lineY = indibox.height + 10;
            if (indibox.family != null) {
                lineY += indibox.family.height;
            }
        }
        return lineY;
    }

    @Override
    protected Dimension getFamboxCoords(IndiBox indibox) {
        int x = this.getMidX(indibox) - indibox.family.width / 2;
        int y = indibox.height;
        return new Dimension(x, y);
    }

    private int getMidX(IndiBox indibox) {
        if (indibox.spouse == null) {
            return indibox.width / 2;
        }
        int x = indibox.spouse.x > 0 ? (indibox.spouse.x + indibox.width) / 2 : (indibox.spouse.x + indibox.spouse.width) / 2;
        if (indibox.family != null) {
            if (indibox.spouse.x > 0) {
                if (indibox.spouse.width < indibox.family.width) {
                    int x1 = (indibox.spouse.x + indibox.spouse.width) / 2;
                    int x2 = indibox.spouse.x + (indibox.spouse.width - indibox.family.width) / 2;
                    x = Math.max(x1, x2);
                } else if (indibox.width < indibox.family.width) {
                    int x1 = (indibox.spouse.x + indibox.spouse.width) / 2;
                    int x2 = (indibox.width + indibox.family.width) / 2;
                    x = Math.min(x1, x2);
                }
            } else if (indibox.spouse.x <= 0) {
                if (indibox.spouse.width < indibox.family.width) {
                    int x1 = (indibox.width + indibox.spouse.x) / 2;
                    int x2 = indibox.spouse.x + (indibox.family.width + indibox.spouse.width) / 2;
                    x = Math.min(x1, x2);
                } else if (indibox.width < indibox.family.width) {
                    int x1 = (indibox.width + indibox.spouse.x) / 2;
                    int x2 = (indibox.width - indibox.family.width) / 2;
                    x = Math.max(x1, x2);
                }
            }
        }
        return x;
    }
}

