/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.webbook;

import ancestris.modules.webbook.WebBookVisualPanel5;
import ancestris.modules.webbook.WebBookWizardAction;
import genj.gedcom.Gedcom;
import genj.util.Registry;
import java.awt.Component;
import java.io.File;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class WebBookWizardPanel5
implements WizardDescriptor.ValidatingPanel,
WizardDescriptor.FinishablePanel {
    private Gedcom gedcom;
    private WebBookVisualPanel5 component;

    WebBookWizardPanel5(Gedcom gedcom) {
        this.gedcom = gedcom;
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new WebBookVisualPanel5();
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("ancestris.app.tools.webbook.step5");
    }

    public boolean isValid() {
        return true;
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    public void readSettings(Object settings) {
        if (this.gedcom == null) {
            return;
        }
        Registry gedcomSettings = this.gedcom.getRegistry();
        String localWebDir = gedcomSettings.get("webbook.localWebDir", "");
        if (localWebDir.isEmpty()) {
            localWebDir = System.getProperty("netbeans.user") + File.separator + "WebBook";
        }
        ((WebBookVisualPanel5)this.getComponent()).setPref01(localWebDir);
        String logFile = gedcomSettings.get("webbook.logFile", "");
        if (logFile.isEmpty()) {
            logFile = localWebDir + File.separator + "webbookLog.txt";
        }
        ((WebBookVisualPanel5)this.getComponent()).setPref02(logFile);
        this.component.setComponents();
    }

    public void storeSettings(Object settings) {
        if (this.gedcom == null) {
            return;
        }
        Registry gedcomSettings = this.gedcom.getRegistry();
        gedcomSettings.put("webbook.localWebDir", ((WebBookVisualPanel5)this.getComponent()).getPref01());
        gedcomSettings.put("webbook.logFile", ((WebBookVisualPanel5)this.getComponent()).getPref02());
    }

    public boolean isFinishPanel() {
        return false;
    }

    public void validate() throws WizardValidationException {
        String name = this.component.getPref01();
        if (name.trim().isEmpty()) {
            throw new WizardValidationException(null, NbBundle.getMessage(WebBookWizardAction.class, (String)"CTRL_Mandatory_LocalWebDir"), null);
        }
        new File(name).mkdirs();
        File file = new File(name);
        if (!file.exists()) {
            throw new WizardValidationException(null, NbBundle.getMessage(WebBookWizardAction.class, (String)"CTRL_Invalid_LocalWebDir"), null);
        }
        if (!file.isDirectory()) {
            throw new WizardValidationException(null, NbBundle.getMessage(WebBookWizardAction.class, (String)"CTRL_NotDir_LocalWebDir"), null);
        }
        if (!file.canWrite()) {
            throw new WizardValidationException(null, NbBundle.getMessage(WebBookWizardAction.class, (String)"CTRL_NotWritable_LocalWebDir"), null);
        }
        if (file.list().length != 0) {
            String[] expectedFilesArray = new String[]{"names", "persons", "cities", "theme", "daysdetails", "repsosa", "citiesdetails"};
            int foundWebbookFiles = 0;
            for (int i = 0; i < expectedFilesArray.length; ++i) {
                file = new File(name + File.separator + expectedFilesArray[i]);
                if (!file.exists() || !file.isDirectory()) continue;
                ++foundWebbookFiles;
            }
            if (foundWebbookFiles < 3) {
                throw new WizardValidationException(null, NbBundle.getMessage(WebBookWizardAction.class, (String)"CTRL_CautionForDeletion_LocalWebDir"), null);
            }
        }
        if ((name = this.component.getPref02()).trim().isEmpty()) {
            throw new WizardValidationException(null, NbBundle.getMessage(WebBookWizardAction.class, (String)"CTRL_Mandatory_LogFile"), null);
        }
        file = new File(name);
        if (!file.getParentFile().exists()) {
            throw new WizardValidationException(null, NbBundle.getMessage(WebBookWizardAction.class, (String)"CTRL_Invalid_LogDir"), null);
        }
    }
}

