/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.webbook.creator;

import ancestris.modules.webbook.WebBook;
import ancestris.modules.webbook.WebBookParams;
import ancestris.modules.webbook.creator.GedcomStats;
import ancestris.modules.webbook.creator.WebHelper;
import ancestris.modules.webbook.creator.WebSection;
import genj.gedcom.Entity;
import java.io.File;
import java.io.PrintWriter;
import java.util.Date;

public class WebHome
extends WebSection {
    private String version = "";

    public WebHome(boolean generate, WebBook wb, WebBookParams wp, WebHelper wh) {
        super(generate, wb, wp, wh);
    }

    public void init() {
        this.init("", "", "", "", 0, 0);
    }

    public void create() {
        if (this.wb.sectionIndividualsDetails != null) {
            this.personPage = this.wb.sectionIndividualsDetails.getPagesMap();
            this.prefixPersonDetailsDir = this.buildLinkShort(this, this.wb.sectionIndividualsDetails);
        }
        File dir = this.wh.createDir(this.wh.getDir().getAbsolutePath(), true);
        File file = this.wh.getFileForName(dir, this.indexFile);
        PrintWriter out = this.wh.getWriter(file, this.UTF8);
        GedcomStats stats = new GedcomStats(this.wp, this.wh);
        this.printOpenHTML(out, "", this);
        this.exportIndex(out, stats);
        this.printCloseHTML(out);
        out.close();
        this.wh.log.write(this.indexFile + this.trs("EXEC_DONE"));
    }

    private void exportIndex(PrintWriter out, GedcomStats stats) {
        out.println("<hr />");
        out.println("<div class=\"contindex\">");
        out.println("<div class=\"menu\">");
        out.println("<p>" + this.trs("TXT_menu_individuals") + "</p>");
        out.println("<ul>");
        if (this.wb.sectionLastnames.toBeGenerated) {
            out.println("<li><a href=\"" + this.wb.sectionLastnames.sectionLink + "\">" + this.htmlText(this.wb.sectionLastnames.sectionName) + "</a></li>");
        }
        if (this.wb.sectionIndividuals.toBeGenerated) {
            out.println("<li><a href=\"" + this.wb.sectionIndividuals.sectionLink + "\">" + this.htmlText(this.wb.sectionIndividuals.sectionName) + "</a></li>");
        }
        if (this.wb.sectionIndividualsDetails.toBeGenerated) {
            out.println("<li><a href=\"" + this.wb.sectionIndividualsDetails.sectionLink + "\">" + this.htmlText(this.wb.sectionIndividualsDetails.sectionName) + "</a></li>");
        }
        out.println("</ul>");
        if (this.wp.param_media_GeneSources.equals("1") || this.wp.param_media_GeneMedia.equals("1")) {
            out.println("<p>" + this.trs("TXT_menu_documents") + "</p>");
            out.println("<ul>");
            if (this.wb.sectionSources.toBeGenerated) {
                out.println("<li><a href=\"" + this.wb.sectionSources.sectionLink + "\">" + this.htmlText(this.wb.sectionSources.sectionName) + "</a></li>");
            }
            if (this.wb.sectionMedia.toBeGenerated) {
                out.println("<li><a href=\"" + this.wb.sectionMedia.sectionLink + "\">" + this.htmlText(this.wb.sectionMedia.sectionName) + "</a></li>");
            }
            out.println("</ul>");
        }
        if (this.wp.param_media_GeneMap.equals("1")) {
            out.println("<p>" + this.htmlText(this.trs("TXT_menu_locations")) + "</p>");
            out.println("<ul>");
            out.println("<li><a href=\"" + this.wb.sectionMap.sectionLink + "\">" + this.htmlText(this.wb.sectionMap.sectionName) + "</a></li>");
            out.println("<li><a href=\"" + this.wb.sectionCities.sectionLink + "\">" + this.htmlText(this.wb.sectionCities.sectionName) + "</a></li>");
            out.println("<li><a href=\"" + this.wb.sectionCitiesDetails.sectionLink + "\">" + this.htmlText(this.wb.sectionCitiesDetails.sectionName) + "</a></li>");
            out.println("</ul>");
        }
        out.println("<p>" + this.htmlText(this.trs("TXT_menu_days")) + "</p>");
        out.println("<ul>");
        out.println("<li><a href=\"" + this.wb.sectionDays.sectionLink + "\">" + this.htmlText(this.wb.sectionDays.sectionName) + "</a></li>");
        out.println("<li><a href=\"" + this.wb.sectionDaysDetails.sectionLink + "\">" + this.htmlText(this.wb.sectionDaysDetails.sectionName) + "</a></li>");
        out.println("</ul>");
        out.println("<p>" + this.htmlText(this.trs("TXT_menu_statistics")) + "</p>");
        out.println("<ul>");
        if (this.wb.sectionStatsFrequent.toBeGenerated) {
            out.println("<li><a href=\"" + this.wb.sectionStatsFrequent.sectionLink + "\">" + this.htmlText(this.wb.sectionStatsFrequent.sectionName) + "</a></li>");
        }
        if (this.wb.sectionStatsImplex.toBeGenerated) {
            out.println("<li><a href=\"" + this.wb.sectionStatsImplex.sectionLink + "\">" + this.htmlText(this.wb.sectionStatsImplex.sectionName) + "</a></li>");
        }
        out.println("</ul>");
        if (this.wp.param_dispAncestors.equals("1")) {
            out.println("<p>" + this.htmlText(this.trs("TXT_menu_structuredlist")) + "</p>");
            out.println("<ul>");
            if (this.wb.sectionRepSosa.toBeGenerated) {
                out.println("<li><a href=\"" + this.wb.sectionRepSosa.sectionLink + "\">" + this.htmlText(this.wb.sectionRepSosa.sectionName) + "</a></li>");
            }
            out.println("</ul>");
        }
        out.println("<p>" + this.htmlText(this.trs("TXT_menu_tools")) + "</p>");
        out.println("<ul>");
        if (this.wb.sectionSearch.toBeGenerated) {
            out.println("<li><a href=\"" + this.wb.sectionSearch.sectionLink + "\">" + this.htmlText(this.wb.sectionSearch.sectionName) + "</a></li>");
        }
        out.println("</ul></div>");
        out.println("<div class=\"intro\">");
        if (this.wp.param_dispMsg.equals("1")) {
            out.println(this.wp.param_message);
            out.println("<br /><br /><hr /><br />");
        }
        out.println(this.trs("TXT_text_sosa", this.wrapEntity((Entity)stats.indiDeCujus, false, 1, true, true, true, false), stats.nbAncestors, stats.nbGen) + "<br />");
        out.println(this.trs("TXT_text_old", this.wrapEntity((Entity)stats.indiOlder, false, 1, true, true, true, false)) + "<br />");
        if (this.wp.param_dispStatAncestor.equals("1")) {
            stats.calcLonguestLine(stats.indiDeCujus);
            out.println("<br />");
            if (stats.indiDeCujus == stats.longIndiG) {
                if (stats.indiDeCujus == stats.longIndiA) {
                    out.println(this.trs("TXT_text_longuest1") + "<br />");
                    out.println(this.trs("TXT_text_largest1") + "<br />");
                } else {
                    out.println(this.trs("TXT_text_longuest1") + "<br />");
                    out.println(this.trs("TXT_text_largest2", this.wrapEntity((Entity)stats.longIndiA, false, 1, true, true, true, false), stats.nbAncestorsA) + "<br />");
                }
            } else if (stats.indiDeCujus == stats.longIndiA) {
                out.println(this.trs("TXT_text_largest1") + "<br />");
                out.println(this.trs("TXT_text_longuest2", this.wrapEntity((Entity)stats.longIndiG, false, 1, true, true, true, false), stats.nbGenG) + "<br />");
            } else if (stats.longIndiG == stats.longIndiA) {
                out.println(this.trs("TXT_text_longuest2", this.wrapEntity((Entity)stats.longIndiG, false, 1, true, true, true, false), stats.nbGenG) + "<br />");
                out.println(this.trs("TXT_text_largest1") + "<br />");
            } else {
                out.println(this.trs("TXT_text_longuest2", this.wrapEntity((Entity)stats.longIndiG, false, 1, true, true, true, false), stats.nbGenG) + "<br />");
                out.println(this.trs("TXT_text_largest2", this.wrapEntity((Entity)stats.longIndiA, false, 1, true, true, true, false), stats.nbAncestorsA) + "<br />");
            }
        }
        out.println("<br /><hr /><br />");
        if (stats.place.length() > 0) {
            out.println(this.trs("TXT_text_place", stats.place) + "<br />");
        }
        out.println(this.trs("TXT_text_stats", stats.nbIndis, stats.nbFams, stats.nbNames, stats.nbPlaces) + "<br />");
        out.println(this.trs("TXT_text_cousins", stats.nbAscendants, stats.nbCousins, stats.nbOthers) + "<br />");
        out.println(this.trs("TXT_text_family", stats.nbFams, stats.nbFamsWithKids, stats.avgKids) + "<br />");
        out.println("<br /><hr /><br />");
        out.println(this.trs("WebBookVisualPanel1.jLabel3.text") + ":" + "&nbsp;" + this.wp.param_author + "<br />");
        if (!this.wp.param_address.equals("-")) {
            out.println(this.trs("WebBookVisualPanel1.jLabel4.text") + ":" + "&nbsp;" + this.wp.param_address + "<br />");
        }
        if (!this.wp.param_phone.equals("-")) {
            out.println(this.trs("WebBookVisualPanel1.jLabel5.text") + ":" + "&nbsp;" + this.wp.param_phone + "<br />");
        }
        if (!this.wp.param_email.equals("-")) {
            out.println("<a href=\"mailto:" + this.wp.param_email + "?subject=" + this.trs("TXT_idx_email_subject") + "&amp;body=" + this.trs("TXT_idx_email_dear") + "%20" + this.wp.param_author + ",%0a%0a" + this.trs("TXT_idx_email_body") + " \">" + this.trs("TXT_idx_email_link") + "</a><br />");
        }
        out.println("<br /><hr /><br />");
        out.println("<p class=\"legal\">" + this.trs("TXT_text_pages", "<a href=\"https://www.ancestris.org\" title=\"" + this.version + "\" >Ancestris WebBook</a>", new Date()) + "</p>");
        out.println("</div>");
        out.println("<div class=\"spacer\">&nbsp;</div>");
        out.println("</div>");
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

