/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.webbook.creator;

import ancestris.modules.webbook.WebBook;
import ancestris.modules.webbook.WebBookParams;
import ancestris.modules.webbook.creator.WebHelper;
import ancestris.modules.webbook.creator.WebSection;
import genj.gedcom.Entity;
import genj.gedcom.Indi;
import java.io.File;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebIndividuals
extends WebSection {
    public WebIndividuals(boolean generate, WebBook wb, WebBookParams wp, WebHelper wh) {
        super(generate, wb, wp, wh);
    }

    public void init() {
        this.init(this.trs("TXT_Individualslist"), "persons", "persons_", this.formatFromSize(this.wh.getNbIndis()), 1, this.sizeIndiSection * 2);
    }

    @Override
    public void create() {
        if (this.wb.sectionIndividualsDetails != null) {
            this.personPage = this.wb.sectionIndividualsDetails.getPagesMap();
            this.prefixPersonDetailsDir = this.buildLinkShort(this, this.wb.sectionIndividualsDetails);
        }
        this.calcLetters(this.wh.getIndividuals(this.wh.gedcom, this.sortIndividuals));
        File dir = this.wh.createDir(this.wh.getDir().getAbsolutePath() + File.separator + this.sectionDir, true);
        this.exportData(dir);
    }

    private void exportData(File dir) {
        List<Indi> indis = this.wh.getIndividuals(this.wh.gedcom, this.sortIndividuals);
        char previousLetter = ' ';
        String previousLastName = "";
        String previousListFile = "";
        File file = null;
        PrintWriter out = null;
        boolean writeLetter = false;
        boolean writeAnchor = false;
        boolean first = true;
        int iNames = 0;
        int nbNames = this.wh.getLastNames("-", this.sortLastnames).size();
        int previousPage = 0;
        int currentPage = 0;
        int nextPage = 0;
        int lastPage = nbNames / this.nbPerPage + 1;
        String listfile = "";
        for (Indi indi : indis) {
            String lastName = this.wh.getLastName(indi, "-");
            String anchorLastName = this.htmlAnchorText(lastName);
            if (anchorLastName.compareTo(previousLastName) != 0) {
                previousLastName = anchorLastName;
                ++iNames;
                writeAnchor = true;
            } else {
                writeAnchor = false;
            }
            char cLetter = anchorLastName.charAt(0);
            if (cLetter != previousLetter) {
                previousLetter = cLetter;
                writeLetter = true;
            } else {
                writeLetter = false;
            }
            currentPage = iNames / this.nbPerPage + 1;
            previousPage = currentPage == 1 ? 1 : currentPage - 1;
            nextPage = currentPage == lastPage ? currentPage : currentPage + 1;
            listfile = this.sectionPrefix + String.format(this.formatNbrs, currentPage) + this.sectionSuffix;
            if (previousListFile.compareTo(listfile) != 0) {
                if (out != null) {
                    out.println("</p>");
                    this.exportLinks(out, this.sectionPrefix + String.format(this.formatNbrs, currentPage - 1) + this.sectionSuffix, 1, Math.max(1, previousPage - 1), currentPage == lastPage ? lastPage : nextPage - 1, lastPage);
                    this.printCloseHTML(out);
                    this.wh.log.write(previousListFile + this.trs("EXEC_DONE"));
                    out.close();
                }
                previousListFile = listfile;
                file = this.wh.getFileForName(dir, listfile);
                out = this.wh.getWriter(file, this.UTF8);
                this.printOpenHTML(out, "TXT_Individualslist", this);
                out.println("<p class=\"letters\">");
                out.println("<br /><br />");
                for (WebSection.Letters l : WebSection.Letters.values()) {
                    if (this.checkLink(l.toString())) {
                        out.println("<a href=\"" + (String)this.linkForLetter.get(l.toString()) + "#" + (Object)((Object)l) + "\">" + (Object)((Object)l) + "</a>" + "&nbsp;" + "&nbsp;");
                        continue;
                    }
                    out.println((Object)((Object)l) + "&nbsp;" + "&nbsp;");
                }
                if (this.checkLink("-")) {
                    out.println("<a href=\"" + (String)this.linkForLetter.get("-") + "#" + "-" + "\">" + "-" + "</a>" + "&nbsp;" + "&nbsp;");
                } else {
                    out.println("-&nbsp;&nbsp;");
                }
                out.println("<br /><br /></p>");
                if (!writeLetter) {
                    this.exportLinks(out, listfile, 1, previousPage, nextPage, lastPage);
                    out.println("<p>");
                }
            }
            if (writeLetter) {
                if (!first) {
                    out.println("</p>");
                }
                first = false;
                this.exportLinks(out, listfile, 1, previousPage, nextPage, lastPage);
                String ancLet = String.valueOf(previousLetter);
                if (!ancLet.matches("[a-zA-Z]")) {
                    ancLet = "-";
                }
                out.println("<p class=\"letter\"><a name=\"" + ancLet + "\"></a>" + ancLet + "</p>");
                out.println("<p>");
            }
            if (writeAnchor) {
                out.println("<a name=\"" + this.htmlAnchorText(this.wh.getLastName(indi, "-")) + "\"></a>");
            }
            out.println(this.wrapEntity((Entity)indi));
            out.println("<br />");
        }
        if (out != null) {
            out.println("</p>");
            this.exportLinks(out, listfile, 1, previousPage, nextPage, lastPage);
            this.printCloseHTML(out);
            this.wh.log.write(previousListFile + this.trs("EXEC_DONE"));
        }
        if (out != null) {
            out.close();
        }
    }

    private void calcLetters(List<Indi> indis) {
        this.linkForLetter.put("-", "0");
        for (WebSection.Letters l : WebSection.Letters.values()) {
            this.linkForLetter.put(l.toString(), "0");
        }
        char letter = ' ';
        String name = "";
        int iNames = 0;
        String listfile = "";
        for (Indi indi : indis) {
            String lastname = this.wh.getLastName(indi, "-");
            String str = this.htmlAnchorText(lastname);
            if (str == null || str.compareTo(name) == 0) continue;
            listfile = this.sectionPrefix + String.format(this.formatNbrs, iNames / this.nbPerPage + 1) + this.sectionSuffix;
            this.namePage.put(str, listfile);
            name = str;
            ++iNames;
            char cLetter = str.charAt(0);
            if (cLetter == letter) continue;
            letter = cLetter;
            String l = String.valueOf(letter);
            this.linkForLetter.put(l, listfile);
        }
    }

    public Map getPagesMap() {
        return this.namePage;
    }

    private boolean checkLink(String str) {
        String flag = (String)this.linkForLetter.get(str);
        return flag != null && flag.compareTo("0") != 0;
    }
}

