/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.webbook.creator;

import ancestris.modules.webbook.WebBook;
import ancestris.modules.webbook.WebBookParams;
import ancestris.modules.webbook.creator.WebHelper;
import ancestris.modules.webbook.creator.WebMedia;
import ancestris.modules.webbook.creator.WebSection;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyComparator;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyXRef;
import java.io.File;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebIndividualsDetails
extends WebSection {
    private static final String POPUPTAG = "popupemail.htm";
    private String indi2srcDir = "";
    private String indi2mediaDir = "";
    private String fam_chronologie = "";
    private String fam_grandparents = "";
    private String fam_siblings = "";
    private String fam_family = "";
    private String fam_spouse = "";
    private String fam_kids = "";
    private String fam_stepsibfather = "";
    private String fam_stepsibmother = "";
    private String fam_stepkids = "";
    private String fam_relations = "";
    private String fam_relhas = "";
    private String fam_relis = "";
    private String fam_relunk = "";
    private String fam_relwhois = "";
    private String fam_relat = "";
    private String fam_relthe = "";
    private String fam_relof = "";
    private String fam_note = "";
    private String fam_noteSrc = "";

    public WebIndividualsDetails(boolean generate, WebBook wb, WebBookParams wp, WebHelper wh) {
        super(generate, wb, wp, wh);
    }

    public void init() {
        this.init(this.trs("TXT_Individualsdetails"), "details", "personsdetails_", this.formatFromSize(this.wh.getNbIndis()), 1, this.sizeIndiSection);
        this.calcPages();
    }

    @Override
    public void create() {
        this.initEvents();
        this.fam_chronologie = this.htmlText(this.trs("fam_chronologie"));
        this.fam_grandparents = this.htmlText(this.trs("fam_grandparents"));
        this.fam_siblings = this.htmlText(this.trs("fam_siblings"));
        this.fam_family = this.htmlText(this.trs("fam_family"));
        this.fam_spouse = this.htmlText(this.trs("fam_spouse"));
        this.fam_kids = this.htmlText(this.trs("fam_kids"));
        this.fam_stepsibfather = this.htmlText(this.trs("fam_stepsibfather"));
        this.fam_stepsibmother = this.htmlText(this.trs("fam_stepsibmother"));
        this.fam_stepkids = this.htmlText(this.trs("fam_stepkids"));
        this.fam_relations = this.htmlText(this.trs("fam_relations"));
        this.fam_relhas = this.trs("fam_relhas");
        this.fam_relis = this.trs("fam_relis");
        this.fam_relunk = this.trs("fam_relunk");
        this.fam_relwhois = this.trs("fam_relwhois");
        this.fam_relat = this.trs("fam_relat");
        this.fam_relthe = this.trs("fam_relthe");
        this.fam_relof = this.trs("fam_relof");
        this.fam_note = this.htmlText(this.trs("fam_note"));
        this.fam_noteSrc = this.htmlText(this.trs("fam_noteSrc"));
        if (this.wb.sectionSources != null && this.wb.sectionSources.toBeGenerated) {
            this.sourcePage = this.wb.sectionSources.getPagesMap();
            this.indi2srcDir = this.buildLinkShort(this, this.wb.sectionSources);
        }
        if (this.wb.sectionMedia != null && this.wb.sectionMedia.toBeGenerated) {
            this.indi2mediaDir = this.buildLinkShort(this, this.wb.sectionMedia);
        }
        File dir = this.wh.createDir(this.wh.getDir().getAbsolutePath() + File.separator + this.sectionDir, true);
        this.exportData(dir);
        if (this.wp.param_dispEmailButton.equals("1")) {
            this.createPopupEmail(this.wh.getFileForName(dir, POPUPTAG));
            this.wh.log.write(POPUPTAG + this.trs("EXEC_DONE"));
        }
    }

    private void exportData(File dir) {
        String fileStr = "";
        File file = null;
        PrintWriter out = null;
        String personfile = "";
        int cpt = 0;
        int nbIndis = this.wh.getIndividuals(this.wh.gedcom, this.sortIndividuals).size();
        int previousPage = 0;
        int currentPage = 0;
        int nextPage = 0;
        int lastPage = nbIndis / this.nbPerPage + 1;
        for (Indi indi : this.wh.getIndividuals(this.wh.gedcom, this.sortIndividuals)) {
            previousPage = (currentPage = ++cpt / this.nbPerPage + 1) == 1 ? 1 : currentPage - 1;
            nextPage = currentPage == lastPage ? currentPage : currentPage + 1;
            personfile = this.sectionPrefix + String.format(this.formatNbrs, currentPage) + this.sectionSuffix;
            if (fileStr.compareTo(personfile) != 0) {
                if (out != null) {
                    this.exportLinks(out, this.sectionPrefix + String.format(this.formatNbrs, currentPage - 1) + this.sectionSuffix, 1, Math.max(1, previousPage - 1), currentPage == lastPage ? lastPage : nextPage - 1, lastPage);
                    this.printCloseHTML(out);
                    out.close();
                    this.wh.log.write(fileStr + this.trs("EXEC_DONE"));
                }
                fileStr = personfile;
                file = this.wh.getFileForName(dir, personfile);
                out = this.wh.getWriter(file, this.UTF8);
                this.printOpenHTML(out, "TXT_Individualsdetails", this);
                this.writeScript(out);
            }
            this.exportLinks(out, personfile, 1, previousPage, nextPage, lastPage);
            this.exportIndividualDetails(out, indi, dir);
        }
        if (out != null) {
            this.exportLinks(out, personfile, 1, previousPage, nextPage, lastPage);
            this.printCloseHTML(out);
            this.wh.log.write(fileStr + this.trs("EXEC_DONE"));
        }
        if (out != null) {
            out.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void exportIndividualDetails(PrintWriter out, Indi indi, File dir) {
        HashSet<Property> notes;
        int n;
        Indi spouse;
        void var17_27;
        String themeDirLink = this.buildLinkTheme(this, this.themeDir);
        String anchor = indi.getId();
        String name = this.wrapName(indi, 0, false, true, true);
        Indi father = indi.getBiologicalFather();
        Indi mother = indi.getBiologicalMother();
        Indi fatherfather = father != null ? father.getBiologicalFather() : null;
        Indi motherfather = father != null ? father.getBiologicalMother() : null;
        Indi fathermother = mother != null ? mother.getBiologicalFather() : null;
        Indi mothermother = mother != null ? mother.getBiologicalMother() : null;
        out.println("<h2 class=\"" + this.getSexStyle(indi) + "\">");
        out.println("<a name=\"" + anchor + "\"></a>");
        out.println(this.wrapSex(indi));
        out.println("&nbsp;");
        out.println(name);
        out.println("</h2>");
        out.println("<div class=\"conteneur\">");
        if (this.wp.param_dispEmailButton.equals("1")) {
            String str = this.htmlText(this.trs("TXT_mail_comment"));
            out.println(this.wrapEmailButton(indi, "mail.gif", str));
            out.println("<br /><br />");
        }
        out.println("<p class=\"decal\"><span class=\"gras\">" + this.fam_chronologie + "</span></p>");
        out.println("<p class=\"parentm\">");
        out.println(this.wrapEvents((Entity)indi, false, this.indi2srcDir, this.indi2mediaDir));
        out.println("<br />");
        out.println("</p>");
        if (this.wp.param_media_GeneMedia.equals("1")) {
            void var17_24;
            List<WebMedia.Photo> photos = this.wh.getPhoto((Entity)indi);
            Fam[] families = indi.getFamiliesWhereSpouse();
            Fam[] famArray = families;
            int n2 = famArray.length;
            boolean bl = false;
            while (var17_24 < n2) {
                Fam family = famArray[var17_24];
                photos.addAll(this.wh.getPhoto((Entity)family));
                ++var17_24;
            }
            if (!photos.isEmpty()) {
                out.println("<p class=\"image\">");
                for (WebMedia.Photo photo : photos) {
                    if (photo.getFile() == null) continue;
                    out.println(this.wrapMedia(null, photo.getFile(), this.indi2mediaDir, false, false, true, false, "", photo.getTitle(), false, "OBJE:NOTE", "tooltip"));
                }
                out.println("</p>");
            }
        }
        out.println("<div class=\"spacer\">&nbsp;</div>");
        out.println("</div>");
        out.println("<div class=\"conteneur\">");
        out.println("<p class=\"decal\"><span class=\"gras\">" + this.fam_grandparents + "</span></p>");
        out.println("<p class=\"parentgp\">");
        out.println(this.wrapName(fatherfather));
        out.println("<br />");
        out.println(this.wrapDate(fatherfather, false));
        out.println("</p>");
        out.println("<p class=\"parentgp\">");
        out.println(this.wrapName(motherfather));
        out.println("<br />");
        out.println(this.wrapDate(motherfather, false));
        out.println("</p>");
        out.println("<p class=\"parentgp\">");
        out.println(this.wrapName(fathermother));
        out.println("<br />");
        out.println(this.wrapDate(fathermother, false));
        out.println("</p>");
        out.println("<p class=\"parentgp\">");
        out.println(this.wrapName(mothermother));
        out.println("<br />");
        out.println(this.wrapDate(mothermother, false));
        out.println("</p>");
        out.println("<div class=\"spacer\">&nbsp;</div>");
        out.println("</div>");
        out.println("<div class=\"conteneur\">");
        out.println("<p class=\"parentgpl1\"></p>");
        out.println("<p class=\"parentgpl2\"></p>");
        out.println("<p class=\"parentgpl3\"></p>");
        out.println("<p class=\"parentgpl1\"></p>");
        out.println("<p class=\"parentgpl1\"></p>");
        out.println("<p class=\"parentgpl2\"></p>");
        out.println("<p class=\"parentgpl3\"></p>");
        out.println("<p class=\"parentgpl1\"></p>");
        out.println("<div class=\"spacer\">&nbsp;</div>");
        out.println("</div>");
        out.println("<div class=\"conteneur\">");
        out.println("<p class=\"parentgpl1\"></p>");
        out.println("<p class=\"parentgpl4\"></p>");
        out.println("<p class=\"parentgpl5\"></p>");
        out.println("<p class=\"parentgpl1\"></p>");
        out.println("<p class=\"parentgpl1\"></p>");
        out.println("<p class=\"parentgpl4\"></p>");
        out.println("<p class=\"parentgpl5\"></p>");
        out.println("<p class=\"parentgpl1\"></p>");
        out.println("<div class=\"spacer\">&nbsp;</div>");
        out.println("</div>");
        out.println("<div class=\"conteneur\">");
        out.println("<p class=\"parentp\">");
        out.println(this.wrapName(father));
        out.println("<br />");
        out.println(this.wrapDate(father, false));
        out.println("</p>");
        out.println("<p class=\"parentp\">");
        out.println(this.wrapName(mother));
        out.println("<br />");
        out.println(this.wrapDate(mother, false));
        out.println("</p>");
        out.println("<div class=\"spacer\">&nbsp;</div>");
        out.println("</div>");
        out.println("<div class=\"conteneur\">");
        out.println("<p class=\"decal\"><br /><span class=\"gras\">" + this.fam_siblings + "</span></p>");
        out.println("<p class=\"parents\">");
        Indi[] osiblings = indi.getOlderSiblings();
        Arrays.sort(osiblings, new PropertyComparator("INDI:BIRT:DATE"));
        for (Fam fam : osiblings) {
            out.println(this.wrapEntity((Entity)fam));
            out.println("<br />");
        }
        out.println("<span class=\"grasplus\">");
        out.println(this.wrapEntity((Entity)indi));
        out.println("</span><br />");
        Indi[] ysiblings = indi.getYoungerSiblings();
        Arrays.sort(ysiblings, new PropertyComparator("INDI:BIRT:DATE"));
        Indi[] indiArray = ysiblings;
        int photo = indiArray.length;
        boolean bl = false;
        while (var17_27 < photo) {
            Indi ysibling = indiArray[var17_27];
            out.println(this.wrapEntity((Entity)ysibling));
            out.println("<br />");
            ++var17_27;
        }
        out.println("<br /></p>");
        out.println("<div class=\"spacer\">&nbsp;</div>");
        out.println("</div>");
        boolean hasStepSibFather = false;
        if (this.wp.param_dispSiblings.equals("1") && father != null) {
            Fam[] stepFamilies;
            for (Fam stepFamily : stepFamilies = father.getFamiliesWhereSpouse()) {
                spouse = stepFamily.getWife();
                if (spouse == mother) continue;
                Indi[] stepSiblings = stepFamily.getChildren();
                Arrays.sort(stepSiblings, new PropertyComparator("INDI:BIRT:DATE"));
                if (!hasStepSibFather && stepSiblings.length > 0) {
                    hasStepSibFather = true;
                    out.println("<div class=\"conteneur\">");
                    out.println("<p class=\"decal\"><br /><span class=\"gras\">" + this.fam_stepsibfather + "</span></p>");
                    out.println("<p class=\"parents\">");
                }
                Indi[] indiArray2 = stepSiblings;
                int n3 = indiArray2.length;
                for (n = 0; n < n3; ++n) {
                    Indi stepSbling = indiArray2[n];
                    out.println(this.wrapEntity((Entity)stepSbling));
                    out.println("<br />");
                }
            }
            if (hasStepSibFather) {
                out.println("<br /></p>");
                out.println("<div class=\"spacer\">&nbsp;</div>");
                out.println("</div>");
            }
        }
        boolean hasStepSibMother = false;
        if (this.wp.param_dispSiblings.equals("1") && mother != null) {
            Fam[] famArray;
            for (Fam stepFamily : famArray = mother.getFamiliesWhereSpouse()) {
                Indi spouse2 = stepFamily.getHusband();
                if (spouse2 == father) continue;
                Indi[] stepSiblings = stepFamily.getChildren();
                Arrays.sort(stepSiblings, new PropertyComparator("INDI:BIRT:DATE"));
                if (!hasStepSibMother && stepSiblings.length > 0) {
                    hasStepSibMother = true;
                    out.println("<div class=\"conteneur\">");
                    out.println("<p class=\"decal\"><br /><span class=\"gras\">" + this.fam_stepsibmother + "</span></p>");
                    out.println("<p class=\"parents\">");
                }
                Indi[] indiArray3 = stepSiblings;
                n = indiArray3.length;
                for (int stepSbling = 0; stepSbling < n; ++stepSbling) {
                    Indi stepSbling2 = indiArray3[stepSbling];
                    out.println(this.wrapEntity((Entity)stepSbling2));
                    out.println("<br />");
                }
            }
            if (hasStepSibMother) {
                out.println("<br /></p>");
                out.println("<div class=\"spacer\">&nbsp;</div>");
                out.println("</div>");
            }
        }
        List list = indi.getProperties(PropertyXRef.class);
        Fam[] families = indi.getFamiliesWhereSpouse();
        Arrays.sort(families, new PropertyComparator("FAM:MARR:DATE"));
        if (!this.wp.param_dispSpouse.equals("1")) {
            families = null;
        }
        for (int i = 0; families != null && i < families.length; ++i) {
            Fam family = families[i];
            list.addAll(family.getProperties(PropertyXRef.class));
            spouse = family.getHusband();
            if (spouse == indi) {
                spouse = family.getWife();
            }
            out.println("<div class=\"conteneur\">");
            out.println("<p class=\"decal\"><span class=\"gras\">" + this.fam_family + (families.length > 1 ? " (" + (i + 1) + ")" : "") + "</span></p>");
            out.println("<p class=\"parentf\">");
            out.println(this.wrapSex(spouse));
            out.println("<span class=\"gras\">" + this.fam_spouse + "</span>:" + "&nbsp;");
            out.println(this.wrapName(spouse));
            out.println(this.wrapDate(spouse, true));
            out.println("<br />");
            out.println(this.wrapEvents((Entity)family, false, this.indi2srcDir, this.indi2mediaDir));
            out.println("</p>");
            Indi[] children = family.getChildren();
            Arrays.sort(children, new PropertyComparator("INDI:BIRT:DATE"));
            if (this.wp.param_dispKids.equals("1") && children.length > 0) {
                out.println("<p class=\"parentf\">");
                out.println("<p class=\"parentf\"><img src=\"" + themeDirLink + "chld.png\" />");
                out.println("<span class=\"gras\">" + this.fam_kids + "</span>:<br /></p>");
                out.println("<p class=\"parentfc\">");
                for (Indi child : children) {
                    out.println(this.wrapEntity((Entity)child));
                    out.println("<br />");
                }
                out.println("</p>");
            }
            if (this.wp.param_dispSiblings.equals("1") && spouse != null) {
                Fam[] stepFamilies;
                for (Fam stepFamily : stepFamilies = spouse.getFamiliesWhereSpouse()) {
                    if (stepFamily == family) continue;
                    Indi[] stepSiblings = stepFamily.getChildren();
                    Arrays.sort(stepSiblings, new PropertyComparator("INDI:BIRT:DATE"));
                    if (stepSiblings.length <= 0) continue;
                    out.println("<p class=\"parentf\"><span class=\"gras\">" + this.fam_stepkids + "</span>:<br /></p>");
                    out.println("<p class=\"parentfc\">");
                    for (Indi stepSbling : stepSiblings) {
                        out.println(this.wrapEntity((Entity)stepSbling));
                        out.println("<br />");
                    }
                    out.println("</p>");
                }
            }
            out.println("<br />");
            out.println("<div class=\"spacer\">&nbsp;</div>");
            out.println("</div>");
        }
        boolean displayRelation = false;
        if (this.wp.param_dispRelations.equals("1") && list.size() > 0) {
            for (PropertyXRef xref : list) {
                PropertyDate date;
                boolean doubleup;
                String event;
                String link;
                Property prop;
                String str;
                boolean isAsso;
                Entity target = xref.getTargetEntity();
                boolean isXref = xref.getTag().compareTo("XREF") == 0;
                boolean bl2 = isAsso = xref.getTag().compareTo("ASSO") == 0;
                if (!isXref && !isAsso) continue;
                if (!displayRelation) {
                    out.println("<div class=\"conteneur\">");
                    out.println("<p class=\"decal\"><span class=\"gras\">" + this.fam_relations + "</span></p>");
                    out.println("<p class=\"rela2\">");
                    displayRelation = true;
                }
                out.println("&bull;&nbsp;");
                if (isXref) {
                    str = "";
                    str = str + this.fam_relhas + " ";
                    prop = xref.getTarget().getProperty("RELA");
                    link = prop == null ? this.fam_relunk : prop.getDisplayValue().toLowerCase();
                    event = xref.getParent().getPropertyName().toLowerCase();
                    doubleup = link.contains(event);
                    date = (PropertyDate)xref.getParent().getProperty("DATE");
                    str = !doubleup ? str + link + " " + this.fam_relat + " " + event + ", " : str + link + ", ";
                    if (date != null) {
                        str = str + this.fam_relthe + " " + date.getDisplayValue().toLowerCase() + ", ";
                    }
                    str = str + this.fam_relwhois;
                    out.println(this.wrapString((Property)indi, str));
                }
                if (isAsso) {
                    str = "";
                    str = str + this.fam_relis + " ";
                    prop = xref.getProperty("RELA");
                    link = prop == null ? this.fam_relunk : prop.getDisplayValue().toLowerCase();
                    event = xref.getTarget().getParent().getPropertyName().toLowerCase();
                    doubleup = link.contains(event);
                    date = (PropertyDate)xref.getTarget().getParent().getProperty("DATE");
                    str = !doubleup ? str + link + " " + this.fam_relat + " " + event + ", " : str + link + ", ";
                    if (date != null) {
                        str = str + this.fam_relthe + " " + date.getDisplayValue().toLowerCase() + ", ";
                    }
                    str = str + this.fam_relof;
                    out.println(this.wrapString((Property)indi, str));
                }
                out.println(this.wrapEntity(target));
                out.println("<br />");
            }
            if (displayRelation) {
                out.println("<br />");
                out.println("</p>");
                out.println("<div class=\"spacer\">&nbsp;</div>");
                out.println("</div>");
            }
        }
        boolean displayNote = false;
        if (this.wp.param_dispNotes.equals("1") && (notes = this.getNotes(indi)).size() > 0) {
            for (Property note : notes) {
                String noteStr = note.getDisplayValue().trim();
                Property parent = note.getParent();
                String parentTag = this.htmlText(parent.getPropertyName());
                if (noteStr.length() <= 0 || parent.getTag().compareTo("ASSO") == 0) continue;
                if (!displayNote) {
                    out.println("<div class=\"conteneur\">");
                    out.println("<p class=\"decal\"><span class=\"gras\">" + this.fam_note + "</span>:</p>");
                    out.println("<p class=\"note\" >");
                    displayNote = true;
                }
                String parentNote = parent.getTag().compareTo("SOUR") == 0 ? " " + this.fam_noteSrc + " " + parent.getParent().getPropertyName().toLowerCase() + ":" : ":";
                out.println("<span class=\"undl\">");
                out.println(parent.getTag().compareTo("INDI") == 0 ? "" : this.wrapString((Property)indi, parentTag + parentNote));
                out.println("</span>");
                out.println("<span class=\"ital\">");
                out.println(this.wrapString((Property)indi, noteStr));
                out.println("</span><br />");
            }
            if (displayNote) {
                out.println("</p>");
                out.println("<div class=\"spacer\">&nbsp;</div>");
                out.println("</div>");
            }
        }
    }

    public HashSet<Property> getNotes(Indi indi) {
        HashSet<Property> notes = new HashSet<Property>();
        notes.addAll(Arrays.asList(indi.getProperties("NOTE")));
        if (indi != null) {
            Fam[] families = indi.getFamiliesWhereSpouse();
            for (int i = 0; i < families.length; ++i) {
                Fam family = families[i];
                notes.addAll(Arrays.asList(indi.getProperties("NOTE")));
            }
        }
        return notes;
    }

    private void calcPages() {
        String personfile = "";
        String fileStr = "";
        int cpt = 0;
        for (Indi indi : this.wh.getIndividuals(this.wh.gedcom, this.sortIndividuals)) {
            personfile = this.sectionPrefix + String.format(this.formatNbrs, ++cpt / this.nbPerPage + 1) + this.sectionSuffix;
            if (fileStr.compareTo(personfile) != 0) {
                fileStr = personfile;
            }
            this.personPage.put(indi.getId(), personfile);
        }
    }

    public String getPageForIndi(Indi indi) {
        return indi == null ? "" : (String)this.personPage.get(indi.getId());
    }

    public Map<String, String> getPagesMap() {
        return this.personPage;
    }

    private void writeScript(PrintWriter out) {
        out.println("<script type=\"text/javascript\">");
        out.println("<!--");
        out.println("function popup(sText)");
        out.println("{");
        out.println("window.open( \"popupemail.htm?\"+sText, '', 'HEIGHT=650,WIDTH=620,toolbar=0,status=0,menubar=0');");
        out.println("}");
        out.println("//-->");
        out.println("</script>");
    }
}

