/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.webbook.creator;

import ancestris.modules.webbook.WebBook;
import ancestris.modules.webbook.WebBookParams;
import ancestris.modules.webbook.WebBookVisualPanel4;
import ancestris.modules.webbook.creator.Ancestor;
import ancestris.modules.webbook.creator.WebHelper;
import ancestris.modules.webbook.creator.WebSection;
import genj.gedcom.Entity;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.Source;
import java.io.File;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebRepSosa
extends WebSection {
    private String indi2srcDir = "";
    private String indi2mediaDir = "";
    private Map<Integer, String> linkForGen = new TreeMap<Integer, String>();
    private boolean maxGenReached = false;
    String[] events = new String[]{"BIRT", "CHR", "MARR", "DEAT", "BURI", "OCCU", "RESI"};

    public WebRepSosa(boolean generate, WebBook wb, WebBookParams wp, WebHelper wh) {
        super(generate, wb, wp, wh);
    }

    public void init() {
        this.init(this.trs("TXT_RepSosa"), "repsosa", "repsosa_", this.formatFromSize(this.wh.getNbIndis()), 1, this.sizeIndiSection / 2);
    }

    @Override
    public void create() {
        this.initEvents();
        File dir = this.wh.createDir(this.wh.getDir().getAbsolutePath() + File.separator + this.sectionDir, true);
        if (this.wb.sectionIndividualsDetails != null) {
            this.personPage = this.wb.sectionIndividualsDetails.getPagesMap();
            this.prefixPersonDetailsDir = this.buildLinkShort(this, this.wb.sectionIndividualsDetails);
        }
        if (this.wb.sectionSources != null && this.wb.sectionSources.toBeGenerated) {
            this.sourcePage = this.wb.sectionSources.getPagesMap();
            this.indi2srcDir = this.buildLinkShort(this, this.wb.sectionSources);
        }
        if (this.wb.sectionMedia != null && this.wb.sectionMedia.toBeGenerated) {
            this.indi2mediaDir = this.buildLinkShort(this, this.wb.sectionMedia);
        }
        Indi indi = this.wh.getIndiDeCujus(this.wp.param_decujus);
        this.exportData(indi, dir, this.wh.getAncestorsList(indi));
    }

    private void exportData(Indi rootIndi, File dir, List<Ancestor> ancestors) {
        int cptPage = 0;
        int maxPage = 0;
        int cptIndi = 0;
        int gen = 0;
        this.linkForGen.clear();
        for (Ancestor ancestor : ancestors) {
            if (ancestor.gen < Integer.valueOf(this.wp.param_ancestorMinGen)) continue;
            if (ancestor.gen > Integer.valueOf(this.wp.param_ancestorMaxGen)) {
                this.maxGenReached = true;
                break;
            }
            if (ancestor.gen != gen && ++cptIndi > this.nbPerPage) {
                ++cptPage;
                cptIndi = 1;
            }
            this.linkForGen.put(ancestor.gen, this.sectionPrefix + String.format(this.formatNbrs, cptPage + 1) + this.sectionSuffix);
            gen = ancestor.gen;
        }
        maxPage = cptPage + 1;
        PrintWriter doc = null;
        boolean newPage = true;
        boolean pageInProgress = false;
        boolean genInProgress = false;
        cptPage = 0;
        cptIndi = 0;
        gen = 0;
        TreeSet<Source> sources = new TreeSet<Source>(this.wh.sortSources);
        for (Ancestor ancestor : ancestors) {
            if (ancestor.gen < Integer.valueOf(this.wp.param_ancestorMinGen) || ancestor.gen > Integer.valueOf(this.wp.param_ancestorMaxGen)) continue;
            if (gen != ancestor.gen) {
                if (genInProgress) {
                    this.closeGeneration(gen, sources, doc, cptPage, maxPage);
                    sources.clear();
                    if (cptIndi > this.nbPerPage) {
                        newPage = true;
                    }
                }
                if (newPage) {
                    cptIndi = 1;
                    newPage = false;
                    if (pageInProgress) {
                        this.closePage(doc, cptPage);
                    }
                    if ((doc = this.openPage(rootIndi, dir, ++cptPage, maxPage)) == null) {
                        pageInProgress = false;
                        genInProgress = false;
                        break;
                    }
                    pageInProgress = true;
                }
                gen = ancestor.gen;
                this.openGeneration(gen, doc);
                genInProgress = true;
            }
            this.formatIndi(ancestor.indi, ancestor.gen, ancestor.sosa, doc);
            sources.addAll(this.wh.getSources(ancestor.indi));
            ++cptIndi;
        }
        if (genInProgress) {
            this.closeGeneration(gen, sources, doc, cptPage, maxPage);
        }
        if (pageInProgress) {
            this.closePage(doc, cptPage);
        }
    }

    PrintWriter openPage(Indi rootIndi, File dir, int cptPage, int maxPage) {
        String fileStr = this.sectionPrefix + String.format(this.formatNbrs, cptPage) + this.sectionSuffix;
        File file = this.wh.getFileForName(dir, fileStr);
        PrintWriter doc = this.wh.getWriter(file, this.UTF8);
        if (doc == null) {
            return null;
        }
        this.printOpenHTML(doc, null, this);
        doc.println("<div class=\"title\"><a name=\"top\">&nbsp;</a>" + this.htmlText(this.trs("RepSosaOptions.title")) + "&nbsp;" + this.wrapName(rootIndi, 1, false, true, false) + "</div>");
        this.exportGenLinks(doc);
        this.exportLinks(doc, this.sectionPrefix + String.format(this.formatNbrs, Math.min(cptPage + 1, maxPage)) + this.sectionSuffix, 1, Math.max(1, cptPage - 1), cptPage == maxPage ? maxPage : cptPage + 1, maxPage);
        return doc;
    }

    void openGeneration(int gen, PrintWriter doc) {
        doc.println("<div class=\"sosareport\">");
        doc.println("<a name=\"gen-" + gen + "\"></a>");
        doc.println("<p class=\"decal\"><br /><span class=\"gras\">" + this.htmlText(this.trs("RepSosaOptions.generation") + " " + gen) + "</span></p>");
    }

    void formatIndi(Indi indi, int gen, BigInteger sosa, PrintWriter doc) {
        doc.println("<p class=\"sosacolumn1\"><span class=\"gras\">" + sosa + "</span>" + "&nbsp;" + "-</p>");
        doc.println("<p class=\"sosacolumn2\">");
        doc.println(this.wrapEntity((Entity)indi, true, 0, true, true, true, true));
        doc.println("</p>");
        doc.println("<div class=\"sosacolumn3\">");
        this.writeEvents(indi, this.events, doc);
        doc.println("&nbsp;</div>");
    }

    void closeGeneration(int gen, SortedSet<Source> sources, PrintWriter doc, int cptPage, int maxPage) {
        doc.println("<div class=\"spacer\">&nbsp;</div>");
        doc.println("</div>");
        if (!this.wp.param_ancestorSource.equals(NbBundle.getMessage(WebBookVisualPanel4.class, (String)"sourceTypeAncestor.type1")) && !sources.isEmpty()) {
            doc.println("<div class=\"sosasources\">");
            doc.println("<span class=\"undl\">" + this.htmlText(this.trs("RepSosaOptions.sourceList", gen)) + "</span><br />\t");
            this.writeSourceList(sources, doc);
            doc.println("</div>");
        }
        this.exportLinks(doc, this.sectionPrefix + String.format(this.formatNbrs, Math.min(cptPage + 1, maxPage)) + this.sectionSuffix, 1, Math.max(1, cptPage - 1), cptPage == maxPage ? maxPage : cptPage + 1, maxPage);
    }

    void closePage(PrintWriter doc, int cptPage) {
        this.printCloseHTML(doc);
        String fileStr = this.sectionPrefix + String.format(this.formatNbrs, cptPage) + this.sectionSuffix;
        this.wh.log.write(fileStr + this.trs("EXEC_DONE"));
        doc.close();
    }

    void writeEvents(Indi indi, String[] events, PrintWriter doc) {
        doc.println(this.wrapEvents((Entity)indi, true, this.indi2srcDir, this.indi2mediaDir));
        doc.println("<br />");
    }

    void writeSourceList(SortedSet<Source> sources, PrintWriter doc) {
        for (Source src : sources) {
            doc.println("<br /><a href=\"" + this.linkSource(src.getId()) + "\">(" + src.getId() + ")</a>");
            doc.println("&nbsp;");
            doc.println(this.wrapString((Property)src, src.getTitle()));
            doc.println("<br />");
            if (!this.wp.param_ancestorSource.equals(NbBundle.getMessage(WebBookVisualPanel4.class, (String)"sourceTypeAncestor.type3")) || src.getText().length() == 0) continue;
            doc.println("<span class=\"sosatext\">");
            doc.println(this.wrapString((Property)src, src.getText()));
            doc.println("</span><br />");
        }
        doc.println("<br />");
    }

    private void exportGenLinks(PrintWriter out) {
        out.println("<p class=\"letters\"><br />");
        out.println(this.htmlText(this.trs("RepSosaOptions.generations")) + "<br />");
        if (this.maxGenReached) {
            out.println("<small>" + this.htmlText(this.trs("RepSosaOptions.limited", this.wp.param_ancestorMaxGen)) + "</small><br />");
        } else {
            out.println("<small>" + this.htmlText(this.trs("RepSosaOptions.unlimited")) + "</small><br />");
        }
        for (Integer gen : this.linkForGen.keySet()) {
            out.println("<a href=\"" + this.linkForGen.get(gen) + "#gen-" + gen + "\">" + gen + "</a>" + "&nbsp;" + "&nbsp;");
        }
        out.println("</p>");
    }

    private String linkSource(String src) {
        String sourceFile;
        String link = "";
        String string = src == null ? "" : (sourceFile = this.sourcePage == null ? "" : (String)this.sourcePage.get(src));
        if (src != null) {
            link = this.indi2srcDir + sourceFile + '#' + src;
        }
        return link;
    }
}

