/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.webbook.creator;

import ancestris.modules.webbook.WebBook;
import ancestris.modules.webbook.WebBookParams;
import ancestris.modules.webbook.creator.WebHelper;
import ancestris.modules.webbook.creator.WebSection;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyPlace;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSearch
extends WebSection {
    private String searchFile = "";
    private String resourceFile = "";

    public WebSearch(boolean generate, WebBook wb, WebBookParams wp, WebHelper wh) {
        super(generate, wb, wp, wh);
    }

    public void init() {
        this.init(this.trs("TXT_Search"), "search", "search_", this.formatFromSize(this.wh.getNbIndis()), 0, 0);
    }

    @Override
    public void create() {
        if (this.wb.sectionIndividualsDetails != null) {
            this.personPage = this.wb.sectionIndividualsDetails.getPagesMap();
            this.prefixPersonDetailsDir = this.buildLinkShort(this, this.wb.sectionIndividualsDetails);
        }
        this.searchFile = this.sectionPrefix + String.format(this.formatNbrs, 0) + this.sectionSuffix;
        this.resourceFile = this.sectionPrefix + String.format(this.formatNbrs, 4) + ".js";
        File dir = this.wh.createDir(this.wh.getDir().getAbsolutePath() + File.separator + this.sectionDir, true);
        this.exportData(dir);
    }

    private void exportData(File dir) {
        this.exportSearch(dir, this.searchFile);
        List<Indi> indis = this.wh.getIndividuals(this.wh.gedcom, null);
        this.exportResources(dir, this.resourceFile, indis);
    }

    private void exportSearch(File dir, String exportfile) {
        String javascriptDir = "js/";
        File file = this.wh.getFileForName(dir, exportfile);
        PrintWriter out = this.wh.getWriter(file, this.UTF8);
        if (out == null) {
            return;
        }
        this.printOpenHTML(out, null, this);
        out.println("<script src=\"" + this.resourceFile + "\"></script>");
        out.println("<script language=\"JavaScript\">");
        try {
            String str = this.wh.readStream(javascriptDir + "search.js");
            out.println(this.filter(str));
        }
        catch (IOException e) {
            this.wb.log.write(this.wb.log.ERROR, "exportResults - " + e.getMessage());
        }
        out.println("</script>");
        out.println("<div class=\"title\"><a name=\"top\">&nbsp;</a>" + this.trs("TXT_Search") + "</div>");
        this.printHomeLink(out, this);
        out.println("<p class=\"searchdecal\">" + this.trs("search_criteria") + "</p>");
        out.println("<form name=\"searchInputForm\" method=\"get\" action=\"" + exportfile + "\" accept-charset=\"iso-8859-1\">");
        out.println("<table border=\"0\" cellspacing=\"0\" cellpadding=\"5\" class=\"searchtable\">");
        out.println("<tr><td>" + this.trs("search_firstname") + ":</td><td><input name=\"key_fn\" type=\"text\" size=\"15\" />&nbsp;<input name=\"key_xfn\" type=\"checkbox\" value=\"on\" />" + this.trs("search_exact") + "</td></tr>");
        out.println("<tr><td>" + this.trs("search_lastname") + ":</td><td><input name=\"key_ln\" type=\"text\" size=\"15\" />&nbsp;<input name=\"key_xln\" type=\"checkbox\" value=\"on\" />" + this.trs("search_exact") + "</td></tr>");
        out.println("<tr><td>" + this.trs("search_place") + ":</td><td><input name=\"key_pl\" type=\"text\" size=\"15\" />&nbsp;<input name=\"key_xpl\" type=\"checkbox\" value=\"on\" />" + this.trs("search_exact") + "</td></tr>");
        out.println("<tr><td>" + this.trs("search_id") + ":</td><td><input name=\"key_id\" type=\"text\" size=\"15\" />&nbsp;<input name=\"key_xid\" type=\"checkbox\" value=\"on\" />" + this.trs("search_exact") + "</td></tr>");
        out.println("<tr><td>" + this.trs("search_sosa") + ":</td><td><input name=\"key_so\" type=\"text\" size=\"15\" />&nbsp;<input name=\"key_xso\" type=\"checkbox\" value=\"on\" />" + this.trs("search_exact") + "</td></tr>");
        out.println("<tr><td>" + this.trs("search_birthd") + ":</td><td>" + this.trs("search_between") + "&nbsp;<input name=\"key_1bi\" type=\"text\" size=\"5\" />&nbsp;" + this.trs("search_dateand") + "&nbsp;<input name=\"key_2bi\" type=\"text\" size=\"5\" />&nbsp;&nbsp;<input name=\"key_xbi\" type=\"checkbox\" value=\"on\" />" + this.trs("search_not") + "</td></tr>");
        out.println("<tr><td>" + this.trs("search_marrid") + ":</td><td>" + this.trs("search_between") + "&nbsp;<input name=\"key_1ma\" type=\"text\" size=\"5\" />&nbsp;" + this.trs("search_dateand") + "&nbsp;<input name=\"key_2ma\" type=\"text\" size=\"5\" />&nbsp;&nbsp;<input name=\"key_xma\" type=\"checkbox\" value=\"on\" />" + this.trs("search_not") + "</td></tr>");
        out.println("<tr><td>" + this.trs("search_deathd") + ":</td><td>" + this.trs("search_between") + "&nbsp;<input name=\"key_1de\" type=\"text\" size=\"5\" />&nbsp;" + this.trs("search_dateand") + "&nbsp;<input name=\"key_2de\" type=\"text\" size=\"5\" />&nbsp;&nbsp;<input name=\"key_xde\" type=\"checkbox\" value=\"on\" />" + this.trs("search_not") + "</td></tr>");
        out.println("<tr><td colspan=\"2\" align=\"center\"><br /><input name=\"andor\" type=\"radio\" value=\"and\" checked />" + this.trs("search_and") + "&nbsp;&nbsp;&nbsp;<input name=\"andor\" type=\"radio\" value=\"or\" />" + this.trs("search_or") + "</td></tr>");
        out.println("<tr><td colspan=\"2\" align=\"center\"><br />");
        out.println("<input name=\"OK\" type=\"submit\" value=\"" + this.trs("search_go") + "\" />&nbsp;&nbsp;");
        out.println("<input name=\"reset\" type=\"reset\" value=\"" + this.trs("search_reset") + "\" />&nbsp;&nbsp;");
        out.println("</td></tr>");
        out.println("</table>");
        out.println("</form>");
        out.println("<br>");
        out.println("<hr>");
        out.println("<p class=\"searchdecal\">" + this.trs("search_result") + "</p>");
        out.println("<br>");
        out.println("<script language=javascript>");
        out.println("   processSearch();");
        out.println("</script>");
        this.printCloseHTML(out);
        this.wh.log.write(exportfile + this.trs("EXEC_DONE"));
        out.close();
    }

    private void exportResources(File dir, String exportfile, List<Indi> indis) {
        List<String> ids;
        String key;
        String word;
        List<String> ids2;
        Object key2;
        String word2;
        File file = this.wh.getFileForName(dir, exportfile);
        PrintWriter out = this.wh.getWriter(file, this.UTF8);
        if (out == null) {
            return;
        }
        TreeMap<String, List<String>> table = new TreeMap<String, List<String>>();
        table.clear();
        for (Indi indi : indis) {
            word2 = indi.getFirstName();
            key2 = "";
            if (word2 != null) {
                key2 = this.cleanString(word2);
            }
            if ((ids2 = (ArrayList<String>)table.get(key2)) == null) {
                ids2 = new ArrayList<String>();
            }
            ids2.add(indi.getId());
            table.put((String)key2, ids2);
        }
        this.writeTable(out, "list_firstnames", table);
        table.clear();
        for (Indi indi : indis) {
            word2 = this.wh.getLastName(indi, "-");
            key2 = "";
            if (word2 != null) {
                key2 = this.cleanString(word2);
            }
            if ((ids2 = (List)table.get(key2)) == null) {
                ids2 = new ArrayList();
            }
            ids2.add(indi.getId());
            table.put((String)key2, ids2);
        }
        this.writeTable(out, "list_lastnames", table);
        table.clear();
        for (Indi indi : indis) {
            List places = indi.getProperties(PropertyPlace.class);
            for (PropertyPlace place : places) {
                if (place == null) continue;
                word = place.getDisplayValue();
                key = "";
                if (word != null) {
                    key = this.cleanString(word);
                }
                if ((ids = (ArrayList<String>)table.get(key)) == null) {
                    ids = new ArrayList<String>();
                }
                ids.add(indi.getId());
                table.put(key, ids);
            }
        }
        this.writeTable(out, "list_places", table);
        table.clear();
        for (Indi indi : indis) {
            word2 = indi.getId();
            key2 = "";
            if (word2 != null) {
                key2 = this.cleanString(word2);
            }
            if ((ids2 = (List)table.get(key2)) == null) {
                ids2 = new ArrayList();
            }
            ids2.add(indi.getId());
            table.put((String)key2, ids2);
        }
        this.writeTable(out, "list_ids", table);
        table.clear();
        for (Indi indi : indis) {
            word2 = this.wh.getSosa(indi);
            key2 = "";
            if (word2 != null) {
                key2 = this.cleanString(word2);
            }
            if ((ids2 = (List)table.get(key2)) == null) {
                ids2 = new ArrayList();
            }
            ids2.add(indi.getId());
            table.put((String)key2, ids2);
        }
        this.writeTable(out, "list_sosas", table);
        table.clear();
        for (Indi indi : indis) {
            ArrayList<String> ids3;
            PropertyDate date;
            PropertyDate propertyDate = date = indi == null ? null : indi.getBirthDate();
            if (indi == null || date == null || !date.isValid()) continue;
            int start = 0;
            try {
                start = date.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN).getYear();
            }
            catch (Throwable ids4) {
                // empty catch block
            }
            String word3 = Integer.toString(start);
            String key3 = "";
            if (word3 != null) {
                key3 = this.cleanString(word3);
            }
            if ((ids3 = (ArrayList<String>)table.get(key3)) == null) {
                ids3 = new ArrayList<String>();
            }
            ids3.add(indi.getId());
            table.put(key3, ids3);
        }
        this.writeTable(out, "list_births", table);
        table.clear();
        ArrayList families = new ArrayList(this.wh.gedcom.getEntities("FAM"));
        for (Fam family : families) {
            Indi wife;
            Indi husband;
            PropertyDate date;
            PropertyDate propertyDate = date = family == null ? null : family.getMarriageDate();
            if (family == null || date == null || !date.isValid()) continue;
            int start = 0;
            try {
                start = date.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN).getYear();
            }
            catch (Throwable key3) {
                // empty catch block
            }
            word = Integer.toString(start);
            key = "";
            if (word != null) {
                key = this.cleanString(word);
            }
            if ((ids = (List)table.get(key)) == null) {
                ids = new ArrayList();
            }
            if ((husband = family.getHusband()) != null) {
                ids.add(husband.getId());
            }
            if ((wife = family.getWife()) != null) {
                ids.add(wife.getId());
            }
            table.put(key, ids);
        }
        this.writeTable(out, "list_marriages", table);
        table.clear();
        for (Indi indi : indis) {
            PropertyDate date;
            PropertyDate propertyDate = date = indi == null ? null : indi.getDeathDate();
            if (indi == null || date == null || !date.isValid()) continue;
            int start = 0;
            try {
                start = date.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN).getYear();
            }
            catch (Throwable word4) {
                // empty catch block
            }
            word = Integer.toString(start);
            key = "";
            if (word != null) {
                key = this.cleanString(word);
            }
            if ((ids = (List)table.get(key)) == null) {
                ids = new ArrayList();
            }
            ids.add(indi.getId());
            table.put(key, ids);
        }
        this.writeTable(out, "list_deaths", table);
        this.writeTableIndis(out, indis);
        this.wh.log.write(exportfile + this.trs("EXEC_DONE"));
        out.close();
    }

    private void writeTable(PrintWriter out, String tableName, Map<String, List<String>> table) {
        StringBuffer list = new StringBuffer("var " + tableName + " = [");
        StringBuffer listID = new StringBuffer("var " + tableName + "ID = [");
        int cpt = 0;
        int cptID = 0;
        for (String key : table.keySet()) {
            list.append((cpt == 0 ? "" : ",") + "\"" + key + "\"");
            listID.append((cpt == 0 ? "" : ",") + "\"");
            List<String> ids = table.get(key);
            cptID = 0;
            for (String id : ids) {
                listID.append((cptID == 0 ? "" : "|") + id);
                ++cptID;
            }
            listID.append("\"");
            ++cpt;
        }
        list.append("]");
        listID.append("]");
        out.println(list.toString());
        out.println(listID.toString());
    }

    private void writeTableIndis(PrintWriter out, List<Indi> indis) {
        StringBuffer list = new StringBuffer("var ID = [");
        StringBuffer listID = new StringBuffer("var IDdisplay = [");
        int cpt = 0;
        for (Indi indi : indis) {
            list.append((cpt == 0 ? "" : ",") + "\"" + indi.getId() + "\"");
            listID.append((cpt == 0 ? "" : ",") + "\"");
            listID.append(this.phpText(indi));
            listID.append("\"");
            ++cpt;
        }
        list.append("]");
        listID.append("]");
        out.println(list.toString());
        out.println(listID.toString());
    }

    private String phpText(Indi indi) {
        String strPriv = this.wh.getPrivDisplay();
        if (this.hidePrivateData && this.wh.isPrivate((Entity)indi)) {
            return "0|" + indi.getId() + "|" + this.getPage(indi) + "|" + strPriv + "|" + strPriv + "|" + strPriv + "|" + strPriv;
        }
        return this.getSex(indi) + "|" + indi.getId() + "|" + this.getPage(indi) + "|" + this.getName(indi) + "|" + this.getSosa(indi) + "|" + this.getBDate(indi) + "|" + this.getDDate(indi);
    }

    private String getSex(Indi indi) {
        if (indi == null) {
            return "0";
        }
        return "" + indi.getSex();
    }

    private String getPage(Indi indi) {
        String id;
        String string = id = indi == null ? "" : indi.getId();
        String page = indi == null ? "" : (this.personPage == null ? "" : (String)this.personPage.get(id));
        int start = this.wb.sectionIndividualsDetails.sectionPrefix.length();
        int end = page.indexOf(this.wb.sectionIndividualsDetails.sectionSuffix);
        return page.substring(start, end);
    }

    private String getName(Indi indi) {
        String name = this.wrapName(indi, 0, false, false, false);
        String result = name.replaceAll("\"", "");
        return result;
    }

    private String getSosa(Indi indi) {
        String sosa = this.wh.getSosa(indi);
        return sosa != null && sosa.length() != 0 ? this.wrapString((Property)indi, sosa) : "";
    }

    private String getBDate(Indi indi) {
        if (indi == null) {
            return "";
        }
        PropertyDate bdate = indi.getBirthDate();
        String date = indi == null || bdate == null ? "" : bdate.getDisplayValue().trim();
        return date;
    }

    private String getDDate(Indi indi) {
        if (indi == null) {
            return "";
        }
        PropertyDate ddate = indi.getDeathDate();
        String date = indi == null || ddate == null ? "" : ddate.getDisplayValue().trim();
        return date;
    }

    private String cleanString(String str) {
        return str.toUpperCase().replaceAll("\"", "").replaceAll("\\\\", "/");
    }

    private String filter(String inputStr) {
        String text = inputStr.replaceAll("search_please", this.trs("search_please")).replaceAll("search_results", this.trs("search_results")).replaceAll("alt_male", this.trs("alt_male")).replaceAll("alt_female", this.trs("alt_female")).replaceAll("alt_unknown", this.trs("alt_unknown")).replaceAll("searcht_sex", this.trs("searcht_sex")).replaceAll("searcht_id", this.trs("searcht_id")).replaceAll("searcht_name", this.trs("searcht_name")).replaceAll("searcht_sosa", this.trs("searcht_sosa")).replaceAll("searcht_bdate", this.trs("searcht_bdate")).replaceAll("searcht_ddate", this.trs("searcht_ddate")).replaceAll(".html#", this.wp.param_PHP_Support.equals("1") ? ".php#" : ".html#");
        return text;
    }
}

