/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.webbook.transfer;

import ancestris.modules.webbook.Log;
import ancestris.modules.webbook.WebBookParams;
import ancestris.modules.webbook.WebBookStarter;
import ancestris.modules.webbook.creator.WebHelper;
import ancestris.modules.webbook.transfer.FTPRegister;
import ancestris.modules.webbook.transfer.FTPUpload;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FTPLoader {
    private Log log = null;
    private static RequestProcessor RP = null;
    private RequestProcessor.Task theTask = null;
    private FTPUpload ftpu = null;
    public String localfile;
    public String targetfile;
    private String host = "";
    private String user = "";
    private String password = "";
    private File localdir = null;
    private String targetdir = "";
    private FTPRegister uploadRegister = null;
    private String shell = "";

    public FTPLoader(WebBookParams wp, WebHelper wh, FTPRegister uploadRegister) {
        this.host = wp.param_FTP_site;
        this.user = wp.param_FTP_user;
        this.password = wp.param_FTP_password;
        this.localdir = wh.getDir();
        this.targetdir = wp.param_FTP_dir;
        this.uploadRegister = uploadRegister;
        this.shell = wp.param_FTP_exec;
        this.log = new Log(wp.param_FTP_log, NbBundle.getMessage(WebBookStarter.class, (String)"OpenIDE-Module-Name") + "_" + NbBundle.getMessage(FTPLoader.class, (String)"EXEC_uploading") + " " + wh.gedcom.getName());
    }

    public synchronized void run() {
        final ProgressHandle ph = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(FTPLoader.class, (String)"TASK_UploadExecution"), (Cancellable)new Cancellable(){

            public boolean cancel() {
                return FTPLoader.this.handleCancel();
            }
        });
        Runnable runnable = new Runnable(){

            public synchronized void run() {
                ph.start();
                FTPLoader.this.log.timeStamp();
                FTPLoader.this.log.write(NbBundle.getMessage(FTPLoader.class, (String)"TASK_UploadExecutionStart"));
                List<File> localFiles = FTPLoader.this.getFilesRecursively(FTPLoader.this.localdir);
                Collections.sort(localFiles);
                FTPLoader.this.ftpu = new FTPUpload(FTPLoader.this.host, FTPLoader.this.user, FTPLoader.this.password, localFiles, FTPLoader.this.localdir.getAbsolutePath(), FTPLoader.this.targetdir, FTPLoader.this.log, FTPLoader.this.uploadRegister, ph);
                FTPLoader.this.ftpu.run();
                if (((FTPLoader)FTPLoader.this).log.endSuccessful) {
                    FTPLoader.this.runUserShell();
                }
                FTPLoader.this.log.write(" ");
                FTPLoader.this.log.write(" ");
                FTPLoader.this.log.write(" ");
                FTPLoader.this.log.timeStamp();
                if (((FTPLoader)FTPLoader.this).log.endSuccessful) {
                    FTPLoader.this.log.write(((FTPLoader)FTPLoader.this).log.NORMAL, NbBundle.getMessage(FTPLoader.class, (String)"TASK_UploadExecutionSuccess"));
                } else {
                    FTPLoader.this.log.write(((FTPLoader)FTPLoader.this).log.ERROR, NbBundle.getMessage(FTPLoader.class, (String)"TASK_UploadExecutionFailed"));
                }
            }
        };
        if (RP == null) {
            RP = new RequestProcessor("FTPLoader", 1, true);
        }
        this.theTask = RP.create(runnable);
        this.theTask.addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                ph.finish();
                FTPLoader.this.log.close();
            }
        });
        this.theTask.schedule(0);
    }

    private boolean handleCancel() {
        if (null == this.theTask) {
            return false;
        }
        this.log.write(this.log.ERROR, NbBundle.getMessage(FTPLoader.class, (String)"TASK_UploadExecutionStopped"));
        this.ftpu.cancel();
        this.theTask.cancel();
        return true;
    }

    protected List<File> getFilesRecursively(File dir) {
        ArrayList<File> filesRet = new ArrayList<File>();
        File[] strs = dir.listFiles();
        if (strs == null) {
            return null;
        }
        List<File> files = Arrays.asList(strs);
        for (File file : files) {
            if (file.isDirectory()) {
                filesRet.addAll(this.getFilesRecursively(file));
                continue;
            }
            filesRet.add(file);
        }
        return filesRet;
    }

    private void runUserShell() {
        this.log.write("   ");
        this.log.write("===========================");
        this.log.write(NbBundle.getMessage(FTPLoader.class, (String)"upload_shell"));
        if (!this.shell.isEmpty()) {
            try {
                this.log.write(NbBundle.getMessage(FTPLoader.class, (String)"shell_launch", (Object)this.shell));
                Runtime.getRuntime().exec(this.shell);
                this.log.write(NbBundle.getMessage(FTPLoader.class, (String)"shell_cannotwait"));
            }
            catch (IOException e) {
                this.log.write(NbBundle.getMessage(FTPLoader.class, (String)"shell_error", (Object[])new String[]{this.shell, e.getMessage()}));
            }
        } else {
            this.log.write(NbBundle.getMessage(FTPLoader.class, (String)"shell_none"));
        }
    }
}

