/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.webbook.transfer;

import ancestris.modules.webbook.Log;
import ancestris.modules.webbook.WebBook;
import ancestris.modules.webbook.transfer.FTPLoader;
import ancestris.modules.webbook.transfer.FTPRegister;
import ancestris.util.swing.DialogManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Timer;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FTPUpload {
    private boolean debug = false;
    public static final int CONN_OK = 125;
    public static final int DATA_OK = 150;
    public static final int CFG_OK = 200;
    public static final int SIZE = 213;
    public static final int READY = 220;
    public static final int ABOR_OK = 225;
    public static final int TRANSFER_OK = 226;
    public static final int PASV_OK = 227;
    public static final int LOGIN_OK = 230;
    public static final int CMD_OK = 250;
    public static final int DIR_OK = 257;
    public static final int PASSWD_REQ = 331;
    public static final int REN_REQ = 350;
    public static final int PASSIVEPORT = 256;
    private String host = "";
    private String user = "";
    private String password = "";
    protected int timeout = 60000;
    protected boolean timeOutError = false;
    private Socket FTPcmd = null;
    private BufferedReader cmdInput;
    private PrintStream cmdOutput;
    private String cmdResponse;
    private int cmdResponseCode;
    private Socket FTPdata = null;
    private DataOutputStream dataOutput;
    private boolean dataBusy = false;
    private int dataTransferred = 0;
    private ProgressHandle progress;
    private boolean taskCancelled;
    private List<File> localFiles;
    private String localRoot;
    private String remoteRoot;
    private Log log;
    private FTPRegister uploadRegister;
    private int totalToTransfer = 0;
    private int cpt = 0;
    private int cptmem = 0;
    private int totalSize = 0;
    private boolean moreThanOneLoop = false;

    public FTPUpload(String host, String user, String password, List<File> localFiles, String localRoot, String remoteRoot, Log log, FTPRegister uploadRegister, ProgressHandle progress) {
        this.host = host;
        this.user = user;
        this.password = password;
        this.localFiles = localFiles;
        this.localRoot = localRoot;
        this.remoteRoot = remoteRoot;
        this.log = log;
        this.uploadRegister = uploadRegister;
        this.progress = progress;
        this.taskCancelled = false;
    }

    public void run() {
        boolean ok = false;
        this.moreThanOneLoop = false;
        while (!ok) {
            this.timeOutError = false;
            this.log.write("   ");
            this.log.write("===========================");
            this.log.write(this.trs("upload_check"));
            ok = this.calculateWhatToDo(this.moreThanOneLoop);
            if (!ok) break;
            this.log.write("   ");
            this.log.write("===========================");
            this.log.write(this.trs("upload_connection"));
            ok = this.connectToServer();
            if (!ok) break;
            this.log.write("   ");
            this.log.write("===========================");
            this.log.write(this.trs("upload_transfer"));
            ok = this.uploadLocalFilesToServer();
            if (!ok) {
                if (!this.timeOutError) break;
                this.closeServerConnection();
                this.moreThanOneLoop = true;
                if (this.cptmem == this.cpt && this.cptmem != 0) break;
                this.cptmem = this.cpt;
                continue;
            }
            this.log.write("   ");
            this.log.write("===========================");
            this.log.write(this.trs("upload_removing"));
            ok = this.removeServerFiles();
            if (ok) continue;
        }
        this.log.write("   ");
        this.log.write("===========================");
        this.log.write(this.trs("upload_closing"));
        this.closeServerConnection();
        this.log.write("   ");
        if (this.cpt < this.totalToTransfer || this.moreThanOneLoop) {
            this.log.write(this.log.ERROR, this.trs("upload_error"));
        }
        if (this.cpt == this.totalToTransfer) {
            this.log.write(this.log.NORMAL, this.trs("upload_alldone"));
        }
    }

    void cancel() {
        this.taskCancelled = true;
    }

    private boolean calculateWhatToDo(boolean moreThanOneLoop) {
        try {
            this.uploadRegister.calculate(this.localFiles);
            if (!moreThanOneLoop) {
                this.totalToTransfer = this.uploadRegister.getNbFilesToTransfer();
            }
            this.log.write(this.trs("upload_foundlocal", this.localFiles.size()));
            this.log.write(this.trs("upload_foundtrsf", this.totalToTransfer));
        }
        catch (Exception e) {
            this.log.write(this.log.ERROR, this.trs("upload_error_check"));
            this.log.write(this.log.ERROR, e.getMessage());
            return false;
        }
        return true;
    }

    private synchronized boolean connectToServer() {
        if (!this.checkConnection()) {
            return false;
        }
        try {
            this.debugMsg("Opening socket");
            this.FTPcmd = new Socket(this.host, 21);
            this.debugMsg("FTPcmd=" + this.FTPcmd);
            this.FTPcmd.setSoTimeout(this.timeout);
            this.cmdInput = new BufferedReader(new InputStreamReader(this.FTPcmd.getInputStream()));
            this.debugMsg("cmdInput=" + this.cmdInput);
            this.cmdOutput = new PrintStream(this.FTPcmd.getOutputStream());
            this.debugMsg("cmdOutput=" + this.cmdOutput);
            this.getResponse();
            if (this.cmdResponseCode != 220) {
                throw new Exception(this.cmdResponse);
            }
            this.cmdOutput.println("USER " + this.user);
            this.debugMsg("==> USER XXXXX");
            this.getResponse();
            if (this.cmdResponseCode != 230 && this.cmdResponseCode != 331) {
                throw new Exception(this.cmdResponse);
            }
            if (this.cmdResponseCode == 331) {
                this.cmdOutput.println("PASS " + this.password);
                this.debugMsg("==> PASS XXXXX");
                this.getResponse();
                if (this.cmdResponseCode != 230) {
                    throw new Exception(this.cmdResponse);
                }
            }
            this.command("TYPE I");
            if (this.cmdResponseCode != 200) {
                throw new Exception(this.cmdResponse);
            }
        }
        catch (Exception e) {
            this.log.write(this.log.ERROR, this.trs("upload_errorConn"));
            this.log.write(this.log.ERROR, e.getMessage());
            this.timeOutError = this.isTimeout(e);
            this.closeServerConnection();
            return false;
        }
        return true;
    }

    private boolean checkConnection() {
        try {
            new URL("https://www.ancestris.org/").openStream();
        }
        catch (IOException ex) {
            DialogManager.createError((String)NbBundle.getMessage(this.getClass(), (String)"fb.title"), (String)(NbBundle.getMessage(this.getClass(), (String)"fb.nointernet") + "\n" + NbBundle.getMessage(this.getClass(), (String)"fb.msg.senderror"))).show();
            return false;
        }
        return true;
    }

    private boolean uploadLocalFilesToServer() {
        String currentLocalDir = "";
        String currentRemoteDir = this.remoteRoot;
        int index = 0;
        this.progress.switchToDeterminate(this.totalToTransfer);
        this.log.write(this.trs("upload_starting"));
        try {
            for (File file : this.localFiles) {
                currentLocalDir = this.getFileDir(file);
                if (this.taskCancelled) {
                    this.abort();
                    break;
                }
                if (!this.uploadRegister.isToTransfer(file)) {
                    if (this.moreThanOneLoop) continue;
                    this.log.write(this.trs("upload_noneed", new String[]{currentLocalDir, file.getName()}));
                    continue;
                }
                if (currentLocalDir.compareTo(currentRemoteDir) != 0) {
                    String dir;
                    this.logEvent("cd " + this.remoteRoot);
                    if (!this.cd(this.remoteRoot)) {
                        this.logEvent(this.trs("upload_dirnotthere"));
                        this.logEvent("mkdir " + this.remoteRoot);
                        this.mkdir(this.remoteRoot);
                        this.logEvent("cd " + this.remoteRoot);
                        if (!this.cd(this.remoteRoot)) {
                            this.logEvent(this.trs("upload_error_ftp_cd"), true);
                            return false;
                        }
                    }
                    String[] dirBits = currentLocalDir.split(File.separator);
                    for (int i = 0; i < dirBits.length && (dir = dirBits[i]).trim().length() != 0; ++i) {
                        this.logEvent("cd " + dir);
                        if (this.cd(dir)) continue;
                        this.log.write(this.trs("upload_dirnotthere"));
                        this.logEvent("mkdir " + dir);
                        this.mkdir(dir);
                        this.logEvent("cd " + dir);
                        this.cd(dir);
                    }
                }
                currentRemoteDir = currentLocalDir;
                String storeName = this.remoteRoot + (currentRemoteDir.length() == 0 ? "" : currentRemoteDir + "/") + file.getName();
                this.logEvent("put " + storeName);
                if (!this.put(file, storeName)) {
                    this.logEvent(this.trs("upload_error_ftp_put"), true);
                    return false;
                }
                ++this.cpt;
                this.uploadRegister.setFileTransferred(file);
                this.totalSize += this.dataTransferred / 1024;
                this.log.write(this.trs("upload_transferred", new Object[]{currentLocalDir, file.getName(), this.dataTransferred}));
                this.log.write(this.trs("upload_donesofar", new Object[]{this.cpt, this.totalToTransfer, this.totalSize}));
                this.progress.progress(++index);
                this.log.write(" ");
            }
            this.log.write(this.trs("upload_trsfComplete"));
        }
        catch (IOException e) {
            this.log.write(this.log.ERROR, this.trs("upload_errorLoop"));
            this.log.write(this.log.ERROR, e.getMessage());
            return false;
        }
        return true;
    }

    private boolean removeServerFiles() {
        int totalToRemove = 0;
        int index = 0;
        String currentRemoteDir = this.remoteRoot;
        List<String> listToRemove = this.uploadRegister.getListToRemove();
        totalToRemove = this.uploadRegister.getNbFilesToRemove();
        this.log.write(this.trs("upload_remove", totalToRemove));
        String FTP_SYNCHRONISE = NbBundle.getMessage(WebBook.class, (String)"transferType.type3");
        if (totalToRemove == 0) {
            this.log.write(this.trs("upload_noremove"));
            return false;
        }
        if (!this.uploadRegister.uploadType.equals(FTP_SYNCHRONISE)) {
            this.log.write(this.trs("upload_usernoremove"));
            return false;
        }
        this.progress.switchToDeterminate(totalToRemove);
        this.log.write(this.trs("upload_startingrm"));
        try {
            Collections.sort(listToRemove);
            String remoteDir = "";
            currentRemoteDir = "";
            String file = "";
            for (String key : listToRemove) {
                remoteDir = this.getFileDir(key);
                file = this.getFile(key);
                if (remoteDir.compareTo(currentRemoteDir) != 0) {
                    currentRemoteDir = remoteDir;
                    this.logEvent("cd " + this.remoteRoot);
                    this.cd(this.remoteRoot);
                    this.logEvent("cd " + remoteDir);
                    if (!this.cd(remoteDir)) {
                        this.logEvent(this.trs("upload_nodir"));
                        this.uploadRegister.setFileRemoved(key);
                        this.progress.progress(++index);
                        continue;
                    }
                }
                this.logEvent("rm " + file);
                if (!this.rm(file)) {
                    this.logEvent(this.trs("upload_cannotrm", file));
                } else {
                    this.logEvent(this.trs("upload_removed", file));
                }
                this.uploadRegister.setFileRemoved(key);
                this.progress.progress(++index);
            }
            this.log.write(this.trs("upload_rmComplete"));
        }
        catch (IOException e) {
            this.log.write(this.log.ERROR, this.trs("upload_errorrm"));
            this.log.write(this.log.ERROR, e.getMessage());
            return false;
        }
        return true;
    }

    private synchronized boolean closeServerConnection() {
        if (this.FTPcmd != null) {
            try {
                this.command("QUIT");
            }
            catch (IOException e) {
                this.log.write(this.log.ERROR, this.trs("upload_errorClose") + e);
            }
        }
        try {
            if (this.dataOutput != null) {
                this.dataOutput.close();
            }
            if (this.FTPdata != null) {
                this.FTPdata.close();
            }
            if (this.cmdOutput != null) {
                this.cmdOutput.close();
            }
            if (this.cmdInput != null) {
                this.cmdInput.close();
            }
            if (this.FTPcmd != null) {
                this.FTPcmd.close();
                this.FTPcmd = null;
            }
        }
        catch (IOException e) {
            this.log.write(this.log.ERROR, this.trs("upload_errorClose"));
            this.log.write(this.log.ERROR, e.getMessage());
        }
        return this.FTPcmd == null;
    }

    private synchronized String command(String command) throws IOException {
        this.cmdOutput.println(command);
        this.debugMsg("==> " + command);
        return this.getResponse();
    }

    private synchronized boolean cd(String dir) throws IOException {
        this.command("CWD " + dir);
        return this.cmdResponseCode == 250;
    }

    private synchronized boolean mkdir(String dir) throws IOException {
        this.command("MKD " + dir);
        return this.cmdResponseCode == 257;
    }

    private synchronized boolean rm(String file) throws IOException {
        this.command("DELE " + file);
        return this.cmdResponseCode == 250;
    }

    private synchronized boolean rmdir(String dir) throws IOException {
        this.command("RMD " + dir);
        return this.cmdResponseCode == 250;
    }

    public boolean put(File fileToTransfer, String storeName) {
        Timer timer = new Timer(120000, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    FTPUpload.this.log.write(FTPUpload.this.trs("upload_error_timeout"));
                    FTPUpload.this.abort();
                    FTPUpload.this.timeOutError = true;
                    FTPUpload.this.dataOutput.close();
                    FTPUpload.this.dataOutput = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        try {
            int amount;
            this.dataBusy = true;
            int port = this.passive();
            if (port < 0) {
                return false;
            }
            this.FTPdata = new Socket(this.host, port);
            this.dataOutput = new DataOutputStream(this.FTPdata.getOutputStream());
            this.FTPdata.setSoTimeout(this.timeout);
            this.command("STOR " + storeName);
            if (this.cmdResponseCode != 150 && this.cmdResponseCode != 125) {
                return false;
            }
            timer.start();
            byte[] b = new byte[16384];
            RandomAccessFile file = new RandomAccessFile(fileToTransfer, "r");
            this.debugMsg(this.trs("upload_uponefile"));
            this.dataTransferred = 0;
            while ((amount = file.read(b)) > 0) {
                this.dataOutput.write(b, 0, amount);
                this.dataTransferred += amount;
            }
            file.close();
            timer.stop();
            this.debugMsg(this.trs("upload_storefile"));
            this.dataOutput.close();
            this.FTPdata.close();
            this.getResponse();
            if (this.cmdResponseCode == 226) {
                this.debugMsg(this.trs("upload_success"));
            }
            this.dataBusy = false;
        }
        catch (Exception e) {
            this.dataBusy = false;
            timer.stop();
            this.timeOutError = this.isTimeout(e);
            this.log.write(this.log.ERROR, this.trs("upload_errorPut"));
            this.log.write(this.log.ERROR, e.getMessage());
            return false;
        }
        return true;
    }

    public boolean put2(File fileToTransfer, String storeName) {
        try {
            int amount;
            URL url = new URL("ftp://" + this.user + ":" + this.password + "@" + this.host + storeName + ";type=i");
            URLConnection urlc = url.openConnection();
            OutputStream output = urlc.getOutputStream();
            FileInputStream input = new FileInputStream(fileToTransfer);
            byte[] buf = new byte[65536];
            while ((amount = input.read(buf)) > 0) {
                output.write(buf, 0, amount);
                this.dataTransferred += amount;
            }
            output.close();
            input.close();
            urlc = null;
        }
        catch (Exception e) {
            this.timeOutError = this.isTimeout(e);
            this.log.write(this.log.ERROR, this.trs("upload_errorPut"));
            this.log.write(this.log.ERROR, e.getMessage());
            return false;
        }
        return true;
    }

    private synchronized int passive() throws IOException {
        this.command("PASV");
        if (this.cmdResponseCode == 227) {
            int[] numbers = new int[6];
            StringTokenizer tempToken = new StringTokenizer(this.cmdResponse, "(");
            String temp = tempToken.nextToken();
            temp = tempToken.nextToken();
            tempToken = new StringTokenizer(temp, ")");
            temp = tempToken.nextToken();
            tempToken = new StringTokenizer(temp, ",");
            for (int i = 0; i < 6; ++i) {
                numbers[i] = Integer.parseInt(tempToken.nextToken());
            }
            int port = numbers[4] * 256 + numbers[5];
            return port;
        }
        return -1;
    }

    private synchronized boolean abort() throws IOException {
        this.command("ABOR");
        return this.cmdResponseCode == 225;
    }

    private synchronized String getResponse() {
        String line = "    ";
        this.cmdResponse = "";
        try {
            do {
                line = this.cmdInput.readLine();
                this.cmdResponseCode = Integer.parseInt(line.substring(0, 3));
                if (this.cmdResponseCode == 230 || this.cmdResponseCode == 331) {
                    line = line.replaceAll(this.user, "XXXXX");
                }
                this.debugMsg("<== " + line);
                this.cmdResponse = this.cmdResponse + line + "\n";
                if (line != null && line.trim().length() != 0) continue;
                line = "999";
                break;
            } while (!Character.isDigit(line.charAt(0)) || !Character.isDigit(line.charAt(1)) || !Character.isDigit(line.charAt(2)) || line.charAt(3) != ' ');
            this.cmdResponseCode = Integer.parseInt(line.substring(0, 3));
        }
        catch (Exception e) {
            this.dataBusy = false;
            this.timeOutError = this.isTimeout(e);
            this.cmdResponseCode = 999;
        }
        return this.cmdResponse;
    }

    private void logEvent(String str, boolean err) {
        this.progress.setDisplayName(str);
        this.log.write(err ? this.log.ERROR : this.log.NORMAL, str);
    }

    private void logEvent(String str) {
        this.logEvent(str, false);
    }

    private String getFileDir(File f) {
        String file = f.getName();
        String fullDir = f.getAbsolutePath();
        int a = this.localRoot.length() == 0 ? 0 : this.localRoot.length() + 1;
        int b = fullDir.indexOf(file) < 1 ? 0 : fullDir.indexOf(file) - 1;
        return b > a ? fullDir.substring(a, b) : "";
    }

    private String getFileDir(String f) {
        int a = f.indexOf(this.remoteRoot) + this.remoteRoot.length();
        int b = f.lastIndexOf("/");
        return b > a ? f.substring(a, b) : "";
    }

    private String getFile(String f) {
        return f.substring(f.lastIndexOf("/") + 1);
    }

    private boolean isTimeout(Exception e) {
        if (this.timeOutError) {
            return true;
        }
        return !(!(e instanceof SocketException) && !(e instanceof SocketTimeoutException) || e.getMessage().indexOf("timed out") <= -1 && e.getMessage().indexOf("Socket closed") <= -1 || this.cpt <= 1);
    }

    private void debugMsg(String str) {
        if (this.debug) {
            this.log.write("DEBUG - " + str);
        }
    }

    private String trs(String string) {
        return NbBundle.getMessage(FTPLoader.class, (String)string);
    }

    private String trs(String string, Object obj) {
        return NbBundle.getMessage(FTPLoader.class, (String)string, (Object)obj);
    }

    public String trs(String string, Object[] arr) {
        return NbBundle.getMessage(FTPLoader.class, (String)string, (Object[])arr);
    }
}

