/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.standard.tools;

import ancestris.modules.editors.standard.tools.ImagePanel;
import ancestris.modules.editors.standard.tools.SourceWrapper;
import ancestris.modules.editors.standard.tools.Utils;
import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Media;
import genj.gedcom.Property;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyMedia;
import genj.gedcom.PropertyXRef;
import genj.gedcom.Source;
import genj.util.Registry;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class SourceChooser
extends JPanel {
    private static BufferedImage SOURCE_UNKNOWN = null;
    private static int THUMB_WIDTH = 90;
    private static int THUMB_HEIGHT = 70;
    private static Map<String, ImageIcon> cacheIcon = new HashMap<String, ImageIcon>();
    private Registry registry = null;
    private ThumbComparator thumbComparator = new ThumbComparator();
    private TreeSet<SourceThumb> allSource = new TreeSet<SourceThumb>(this.thumbComparator);
    private DefaultListModel filteredModel = new DefaultListModel();
    private Gedcom gedcom = null;
    private File mainFile = null;
    private Image mainImage = null;
    private SourceWrapper mainSource = null;
    private String mainTitle = "";
    private String mainText = "";
    private JButton okButton = null;
    private JButton cancelButton = null;
    private ImagePanel imagePanel = null;
    private JLabel filterLabel;
    private JLabel jLabel1;
    private JLayeredPane jLayeredPane1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPaneSource;
    private JSplitPane jSplitPane;
    private JLabel photoTitle;
    private JList sourceList;
    private JPanel sourceMedia;
    private JTextArea sourceText;
    private JTextField textFilter;

    public SourceChooser(Gedcom gedcom, SourceWrapper source, JButton okButton, JButton cancelButton) {
        try {
            if (SOURCE_UNKNOWN == null) {
                SOURCE_UNKNOWN = ImageIO.read(this.getClass().getResourceAsStream("/ancestris/modules/editors/standard/images/source_dummy.png"));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.gedcom = gedcom;
        this.mainSource = source;
        if (source != null) {
            this.mainFile = source.getMediaFile();
            this.mainTitle = source.getTitle();
            this.mainText = source.getText();
        }
        if (this.mainFile != null) {
            try {
                this.mainImage = ImageIO.read(new FileInputStream(this.mainFile));
            }
            catch (Exception ex) {
                this.mainImage = SOURCE_UNKNOWN;
            }
        } else {
            this.mainImage = SOURCE_UNKNOWN;
        }
        this.okButton = okButton;
        this.cancelButton = cancelButton;
        this.createSourceThumbs();
        Thread sourceThread = new Thread(){

            @Override
            public void run() {
                SourceChooser.this.displaySourceThumbs();
                SourceChooser.this.selectSource(SourceChooser.this.mainSource);
            }
        };
        sourceThread.setName("Source reading thread");
        sourceThread.start();
        this.registry = Registry.get(this.getClass());
        this.initComponents();
        this.setPreferredSize(new Dimension(this.registry.get("sourceWindowWidth", this.getPreferredSize().width), this.registry.get("sourceWindowHeight", this.getPreferredSize().height)));
        this.jSplitPane.setDividerLocation(this.registry.get("sourceSplitDividerLocation", this.jSplitPane.getDividerLocation()));
        this.displayIconAndTitle();
        this.sourceList.setCellRenderer(new ListEntryCellRenderer());
        okButton.setEnabled(false);
        this.textFilter.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.filter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.filter();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            private void filter() {
                SourceChooser.this.filterModel(SourceChooser.this.textFilter.getText());
            }
        });
    }

    private void selectSource(SourceWrapper source) {
        SourceThumb selectedSource = null;
        for (SourceThumb sourcei : this.allSource) {
            if (sourcei.entity == null && source == null) {
                selectedSource = sourcei;
                break;
            }
            if (sourcei.entity == null || source == null || !sourcei.entity.equals(source.getTargetSource())) continue;
            selectedSource = sourcei;
            break;
        }
        if (selectedSource != null) {
            final SourceThumb sourcei = selectedSource;
            WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                @Override
                public void run() {
                    SourceChooser.this.sourceList.setSelectedValue(sourcei, true);
                    SourceChooser.this.sourceList.scrollRectToVisible(SourceChooser.this.sourceList.getCellBounds(SourceChooser.this.sourceList.getMinSelectionIndex(), SourceChooser.this.sourceList.getMaxSelectionIndex()));
                }
            });
        }
    }

    private void displayIconAndTitle() {
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                SourceChooser.this.displayIconAndTitle(SourceChooser.this.sourceMedia.getWidth(), SourceChooser.this.sourceMedia.getHeight());
            }
        });
    }

    private void displayIconAndTitle(int width, int height) {
        if (this.mainFile == null && this.mainText != null && !this.mainText.isEmpty()) {
            this.sourceMedia.setVisible(false);
            this.sourceText.setVisible(true);
            this.sourceText.setText(this.mainText);
            this.sourceText.setCaretPosition(0);
        } else if (this.mainImage != null) {
            this.sourceText.setText("");
            this.sourceText.setVisible(false);
            this.sourceMedia.setVisible(true);
            this.imagePanel.setMedia(this.mainFile, SOURCE_UNKNOWN);
        }
        this.jLayeredPane1.revalidate();
        this.jLayeredPane1.repaint();
        this.photoTitle.setText("<html><center>&nbsp;" + this.mainTitle + "&nbsp;</center></html>");
        this.photoTitle.setPreferredSize(new Dimension(width, -1));
    }

    private void initComponents() {
        this.jSplitPane = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jLayeredPane1 = new JLayeredPane();
        this.imagePanel = new ImagePanel(null);
        this.sourceMedia = this.imagePanel;
        this.jScrollPane1 = new JScrollPane();
        this.sourceText = new JTextArea();
        this.photoTitle = new JLabel();
        this.jPanel2 = new JPanel();
        this.filterLabel = new JLabel();
        this.textFilter = new JTextField();
        this.jScrollPaneSource = new JScrollPane();
        this.sourceList = new JList(this.filteredModel);
        this.jLabel1 = new JLabel();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                SourceChooser.this.formComponentResized(evt);
            }
        });
        this.jSplitPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SourceChooser.this.jSplitPanePropertyChange(evt);
            }
        });
        this.jPanel1.setPreferredSize(new Dimension(200, 383));
        this.jLayeredPane1.setBorder(BorderFactory.createEtchedBorder());
        this.sourceMedia.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                SourceChooser.this.sourceMediaComponentResized(evt);
            }
        });
        GroupLayout sourceMediaLayout = new GroupLayout(this.sourceMedia);
        this.sourceMedia.setLayout(sourceMediaLayout);
        sourceMediaLayout.setHorizontalGroup(sourceMediaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 184, Short.MAX_VALUE));
        sourceMediaLayout.setVerticalGroup(sourceMediaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 356, Short.MAX_VALUE));
        this.sourceText.setEditable(false);
        this.sourceText.setColumns(20);
        this.sourceText.setFont(new Font("DejaVu Sans", 2, 12));
        this.sourceText.setLineWrap(true);
        this.sourceText.setRows(5);
        this.sourceText.setText(NbBundle.getMessage(SourceChooser.class, (String)"SourceChooser.sourceText.text"));
        this.sourceText.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.sourceText);
        GroupLayout jLayeredPane1Layout = new GroupLayout(this.jLayeredPane1);
        this.jLayeredPane1.setLayout(jLayeredPane1Layout);
        jLayeredPane1Layout.setHorizontalGroup(jLayeredPane1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE).addGroup(jLayeredPane1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 184, Short.MAX_VALUE)).addGroup(jLayeredPane1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sourceMedia, -1, -1, Short.MAX_VALUE)));
        jLayeredPane1Layout.setVerticalGroup(jLayeredPane1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 352, Short.MAX_VALUE).addGroup(jLayeredPane1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 356, Short.MAX_VALUE)).addGroup(jLayeredPane1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sourceMedia, -1, -1, Short.MAX_VALUE)));
        this.jLayeredPane1.setLayer(this.sourceMedia, JLayeredPane.DEFAULT_LAYER);
        this.jLayeredPane1.setLayer(this.jScrollPane1, JLayeredPane.DEFAULT_LAYER);
        this.photoTitle.setFont(new Font("DejaVu Sans", 1, 12));
        this.photoTitle.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.photoTitle, (String)NbBundle.getMessage(SourceChooser.class, (String)"SourceChooser.photoTitle.text"));
        this.photoTitle.setVerticalAlignment(1);
        this.photoTitle.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLayeredPane1).addComponent(this.photoTitle, -1, 188, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLayeredPane1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.photoTitle)));
        this.jSplitPane.setLeftComponent(this.jPanel1);
        this.jPanel2.setPreferredSize(new Dimension(200, 58));
        Mnemonics.setLocalizedText((JLabel)this.filterLabel, (String)NbBundle.getMessage(SourceChooser.class, (String)"SourceChooser.filterLabel.text"));
        this.textFilter.setText(NbBundle.getMessage(SourceChooser.class, (String)"SourceChooser.textFilter.text"));
        this.sourceList.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.sourceList.setFont(new Font("DejaVu Sans Condensed", 0, 10));
        this.sourceList.setSelectionMode(0);
        this.sourceList.setLayoutOrientation(2);
        this.sourceList.setVisibleRowCount(-1);
        this.sourceList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SourceChooser.this.sourceListMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                SourceChooser.this.sourceListMousePressed(evt);
            }
        });
        this.sourceList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                SourceChooser.this.sourceListValueChanged(evt);
            }
        });
        this.jScrollPaneSource.setViewportView(this.sourceList);
        this.jLabel1.setFont(new Font("DejaVu Sans", 0, 10));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SourceChooser.class, (String)"SourceChooser.jLabel1.text"));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneSource).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.filterLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textFilter, -1, 106, Short.MAX_VALUE)))).addGroup(jPanel2Layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(6, 6, 6).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.filterLabel).addComponent(this.textFilter, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPaneSource, -1, 328, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.jLabel1, -2, 16, -2)));
        this.jSplitPane.setRightComponent(this.jPanel2);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane, GroupLayout.Alignment.TRAILING));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane, GroupLayout.Alignment.TRAILING));
    }

    private void sourceListValueChanged(ListSelectionEvent evt) {
        if (!this.sourceList.isSelectionEmpty()) {
            SourceThumb source = (SourceThumb)this.filteredModel.get(this.sourceList.getSelectedIndex());
            this.mainImage = source.getImage();
            this.mainTitle = source.title;
            this.mainFile = source.file;
            this.mainText = source.text;
            this.displayIconAndTitle();
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }

    private void sourceListMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.okButton.doClick();
        }
    }

    private void formComponentResized(ComponentEvent evt) {
        int h;
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int w = evt.getComponent().getWidth();
        if (w > dim.width * 8 / 10) {
            w = dim.width * 8 / 10;
        }
        if ((h = evt.getComponent().getHeight()) > dim.height * 8 / 10) {
            h = dim.height * 8 / 10;
        }
        this.registry.put("sourceWindowWidth", w);
        this.registry.put("sourceWindowHeight", h);
    }

    private void jSplitPanePropertyChange(PropertyChangeEvent evt) {
        this.registry.put("sourceSplitDividerLocation", this.jSplitPane.getDividerLocation());
    }

    private void sourceListMousePressed(MouseEvent evt) {
        if (evt.getButton() == 3) {
            this.sourceList.setSelectedIndex(this.sourceList.locationToIndex(evt.getPoint()));
            JPopupMenu menu = new JPopupMenu();
            SourceThumb source = this.getSelectedThumb();
            final Entity entity = source.entity;
            Entity[] ents = PropertyXRef.getReferences((Entity)source.entity);
            if (source.isSource && ents.length > 0) {
                for (Entity ent : ents) {
                    JMenuItem menuItem = new JMenuItem(NbBundle.getMessage(this.getClass(), (String)"EditEntity", (Object)ent.toString(true)));
                    menu.add(menuItem);
                    final Entity finalEntity = ent;
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            SourceChooser.this.edit(finalEntity);
                        }
                    });
                }
            } else if (!source.isSource) {
                JMenuItem menuItem = new JMenuItem(NbBundle.getMessage(this.getClass(), (String)"EditEntity", (Object)entity.toString(true)));
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        SourceChooser.this.edit(entity);
                    }
                });
            }
            menu.show(this.sourceList, evt.getX(), evt.getY());
        }
    }

    private void sourceMediaComponentResized(ComponentEvent evt) {
        this.displayIconAndTitle();
    }

    private void edit(Entity entity) {
        this.cancelButton.doClick();
        SelectionDispatcher.fireSelection((Context)new Context(entity));
    }

    private void createSourceThumbs() {
        String[] ENTITIES;
        this.allSource.clear();
        this.allSource.add(new SourceThumb());
        for (String type : ENTITIES = new String[]{"INDI", "FAM", "SUBM"}) {
            Collection entities = this.gedcom.getEntities(type);
            for (Entity entity : entities) {
                List properties = entity.getProperties(PropertyFile.class);
                for (PropertyFile sourceFile : properties) {
                    if (!Utils.parentTagsContains((Property)sourceFile, "SOUR")) continue;
                    String title = "";
                    File file = sourceFile.getFile();
                    Property sourceTitle = sourceFile.getParent().getProperty("TITL");
                    boolean flag = false;
                    if (sourceTitle != null && !sourceTitle.getDisplayValue().trim().isEmpty()) {
                        title = sourceTitle.getDisplayValue().trim();
                        flag = true;
                    } else {
                        title = entity.toString(false).trim();
                        flag = false;
                    }
                    String text = "";
                    Property sourceTextLocal = sourceFile.getParent().getProperty("TEXT");
                    if (sourceTextLocal != null && !sourceTextLocal.getDisplayValue().trim().isEmpty()) {
                        text = sourceTextLocal.getDisplayValue().trim();
                    }
                    SourceThumb source = new SourceThumb(entity, file, title, text);
                    source.setTrueTitle(flag);
                    this.allSource.add(source);
                }
            }
        }
        Collection entities = this.gedcom.getEntities("SOUR");
        for (Source entity : entities) {
            Property propMedia;
            File file = null;
            String title = "";
            boolean flag = false;
            Property propTitle = entity.getProperty("TITL", true);
            if (propTitle != null) {
                title = propTitle.getDisplayValue().trim();
                flag = true;
            }
            String text = "";
            Property propText = entity.getProperty("TEXT");
            if (propText != null && !propText.getDisplayValue().trim().isEmpty()) {
                text = propText.getDisplayValue().trim();
            }
            if ((propMedia = entity.getProperty("OBJE", true)) != null && propMedia instanceof PropertyMedia) {
                PropertyMedia pm = (PropertyMedia)propMedia;
                file = ((Media)pm.getTargetEntity()).getFile();
            }
            SourceThumb source = new SourceThumb(entity, file, title, text);
            source.setTrueTitle(flag);
            Entity[] ents = PropertyXRef.getReferences((Entity)entity);
            source.setUnused(ents.length == 0);
            this.allSource.add(source);
        }
    }

    private void displaySourceThumbs() {
        this.filteredModel.clear();
        for (SourceThumb item : this.allSource) {
            item.setIcon();
            this.filteredModel.addElement(item);
        }
    }

    private SourceThumb getSelectedThumb() {
        return (SourceThumb)this.filteredModel.get(this.sourceList.getSelectedIndex());
    }

    public boolean isSelectedEntitySource() {
        SourceThumb source = this.getSelectedThumb();
        return source == null ? false : source.isSource;
    }

    public Entity getSelectedEntity() {
        SourceThumb source = this.getSelectedThumb();
        return source == null ? null : source.entity;
    }

    public File getSelectedFile() {
        SourceThumb source = this.getSelectedThumb();
        return source == null ? null : source.file;
    }

    public String getSelectedTitle() {
        SourceThumb source = this.getSelectedThumb();
        return source == null ? "" : source.title;
    }

    public void filterModel(String filter) {
        this.sourceList.clearSelection();
        this.sourceList.setModel(new DefaultListModel());
        this.filteredModel.clear();
        for (SourceThumb item : this.allSource) {
            if (!item.title.toLowerCase().contains(filter.toLowerCase())) continue;
            this.filteredModel.addElement(item);
        }
        this.sourceList.setModel(this.filteredModel);
    }

    public int getNbSource() {
        return this.allSource.size();
    }

    private class ThumbComparator
    implements Comparator<SourceThumb> {
        private ThumbComparator() {
        }

        @Override
        public int compare(SourceThumb o1, SourceThumb o2) {
            String ent1 = o1.entity == null ? "0" : "1";
            String ent2 = o2.entity == null ? "0" : "1";
            File file1 = o1.file;
            File file2 = o2.file;
            String str1 = file1 != null ? file1.getAbsolutePath() : "";
            String str2 = file2 != null ? file2.getAbsolutePath() : "";
            String id1 = o1.entity != null ? o1.entity.getId() : "";
            String id2 = o2.entity != null ? o2.entity.getId() : "";
            String total1 = ent1 + o1.title.toLowerCase() + str1 + id1;
            String total2 = ent2 + o2.title.toLowerCase() + str2 + id2;
            return total1.compareTo(total2);
        }
    }

    public class SourceThumb {
        public boolean isSource = false;
        public Entity entity = null;
        public File file = null;
        public ImageIcon icon = null;
        public String title = "";
        public String text = "";
        public boolean isTrueTitle = true;
        public boolean isUnused = false;

        public SourceThumb() {
            this.isSource = true;
            this.entity = null;
            this.title = NbBundle.getMessage(this.getClass(), (String)"NewSourceTitle");
            this.icon = new ImageIcon(SOURCE_UNKNOWN);
        }

        public SourceThumb(Source entity, File file, String title, String text) {
            Entity[] ents;
            this.isSource = true;
            this.entity = entity;
            this.file = file;
            String name = "";
            for (Entity ent : ents = PropertyXRef.getReferences((Entity)entity)) {
                if (!(ent instanceof Indi)) continue;
                name = " - " + ((Indi)ent).toString(true);
                break;
            }
            if (name.isEmpty()) {
                for (Entity ent : ents) {
                    if (!(ent instanceof Fam)) continue;
                    name = " - " + ((Fam)ent).toString(true);
                    break;
                }
            }
            this.title = title + name;
            this.text = text;
        }

        private SourceThumb(Entity entity, File file, String title, String text) {
            this.isSource = entity instanceof Source;
            this.entity = entity;
            this.file = file;
            this.title = title;
            this.text = text;
        }

        public Image getImage() {
            return Utils.getImageFromFile(this.file, this.getClass(), this.text.trim().isEmpty());
        }

        public void setIcon() {
            ImageIcon imageIcon = this.icon = this.file == null ? null : (ImageIcon)cacheIcon.get(this.file.getAbsolutePath());
            if (this.icon == null) {
                this.icon = new ImageIcon(Utils.scaleImage(this.file, this.getClass(), THUMB_WIDTH, THUMB_HEIGHT, this.text.trim().isEmpty()));
                if (this.file != null) {
                    cacheIcon.put(this.file.getAbsolutePath(), this.icon);
                }
            }
        }

        private void setTrueTitle(boolean flag) {
            this.isTrueTitle = flag;
        }

        private void setUnused(boolean b) {
            this.isUnused = b;
        }
    }

    private static class ListEntryCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private ListEntryCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            SourceThumb entry = (SourceThumb)value;
            this.setHorizontalTextPosition(0);
            this.setVerticalTextPosition(3);
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(1);
            int labelWidth = THUMB_WIDTH + 30;
            int nbLines = this.getFontMetrics(this.getFont()).stringWidth(entry.title) / labelWidth + 3;
            int labelHeight = THUMB_HEIGHT + 12 * nbLines;
            this.setPreferredSize(new Dimension(labelWidth, labelHeight));
            String color = entry.isTrueTitle && !entry.isUnused ? "black" : (!entry.isTrueTitle && !entry.isUnused ? "blue" : "red");
            String text = entry.title;
            if (entry.entity == null) {
                text = "<center><i><b>" + text + "</b></i></center>";
            }
            this.setText("<html><center><font color=" + color + ">" + text + "</font></center></html>");
            this.setIcon(entry.icon);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                this.setBorder(BorderFactory.createRaisedBevelBorder());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
                this.setBorder(BorderFactory.createEmptyBorder());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }
}

