/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.downloader.services;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.installer.downloader.DownloadManager;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.exceptions.ParseException;
import org.netbeans.installer.utils.xml.DomExternalizable;
import org.netbeans.installer.utils.xml.DomUtil;
import org.netbeans.installer.utils.xml.visitors.DomVisitor;
import org.netbeans.installer.utils.xml.visitors.RecursiveDomVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PersistentCache {
    private File stateFile;
    private final Map<URL, File> url2File = new HashMap<URL, File>();

    public PersistentCache() {
        this.stateFile = new File(DownloadManager.instance.getWd(), "cacheState.xml");
        if (!this.stateFile.exists()) {
            LogManager.log("cache file not exist so treat it as cache is Empty");
        } else {
            this.load();
        }
    }

    public boolean isIn(URL url) {
        return this.url2File.containsKey(url) && this.url2File.get(url).exists();
    }

    public File getByURL(URL url) {
        if (!this.isIn(url)) {
            return null;
        }
        return this.url2File.get(url);
    }

    public void put(URL key, File file) {
        this.url2File.put(key, file);
        this.dump();
    }

    public void clear() {
        for (File file : this.url2File.values()) {
            file.delete();
        }
    }

    public URL[] keys() {
        return (URL[])this.url2File.keySet().toArray();
    }

    public boolean delete(URL url) {
        if (this.isIn(url)) {
            return this.url2File.get(url).delete();
        }
        return false;
    }

    private void load() {
        try {
            Document state = DomUtil.parseXmlFile(this.stateFile);
            RecursiveDomVisitor visitor = new RecursiveDomVisitor(){

                @Override
                public void visit(Element element) {
                    String name = element.getTagName();
                    if ("cacheEntry".equals(name)) {
                        CacheEntry entry = new CacheEntry();
                        entry.readXML(element);
                        if (entry.file.exists() && entry.file.isFile()) {
                            PersistentCache.this.url2File.put(entry.url, entry.file);
                        }
                    } else {
                        super.visit(element);
                    }
                }
            };
            visitor.visit(state);
        }
        catch (ParseException ex) {
            LogManager.log(ex);
        }
        catch (IOException ex) {
            LogManager.log(ex);
        }
    }

    public synchronized void dump() {
        try {
            Document document = DomUtil.parseXmlFile("<cache/>");
            Element root = document.getDocumentElement();
            for (Map.Entry<URL, File> entry : this.url2File.entrySet()) {
                CacheEntry cacheEntry = new CacheEntry(entry);
                DomUtil.addChild(root, cacheEntry);
            }
            DomUtil.writeXmlFile(document, this.stateFile);
        }
        catch (ParseException wontHappend) {
            LogManager.log("unparsable xml", (Throwable)wontHappend);
        }
        catch (IOException ex) {
            LogManager.log("i/o during loading persistentCache", (Throwable)ex);
        }
    }

    private static class CacheEntry
    implements DomExternalizable {
        private URL url;
        private File file;

        public CacheEntry() {
        }

        public CacheEntry(Map.Entry<URL, File> entry) {
            this.url = entry.getKey();
            this.file = entry.getValue();
        }

        @Override
        public void readXML(Element element) {
            RecursiveDomVisitor visitor = new RecursiveDomVisitor(){

                @Override
                public void visit(Element element) {
                    String name = element.getTagName();
                    if ("file".equals(name)) {
                        CacheEntry.this.file = new File(element.getTextContent());
                    } else if ("url".equals(name)) {
                        try {
                            CacheEntry.this.url = StringUtils.parseUrl(element.getTextContent());
                        }
                        catch (ParseException e) {
                            ErrorManager.notifyDebug("Could not parse URL", e);
                        }
                    } else {
                        super.visit(element);
                    }
                }
            };
            ((DomVisitor)visitor).visit(element);
        }

        @Override
        public Element writeXML(Document document) {
            Element root = document.createElement("cacheEntry");
            DomUtil.addElement(root, "file", this.file.getAbsolutePath());
            DomUtil.addElement(root, "url", this.url.toString());
            return root;
        }
    }
}

