/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.wizard.components.actions;

import java.util.HashMap;
import java.util.List;
import org.netbeans.installer.product.Registry;
import org.netbeans.installer.product.components.Product;
import org.netbeans.installer.product.filters.OrFilter;
import org.netbeans.installer.product.filters.ProductFilter;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.SystemUtils;
import org.netbeans.installer.utils.exceptions.InstallationException;
import org.netbeans.installer.utils.helper.DetailedStatus;
import org.netbeans.installer.utils.helper.Status;
import org.netbeans.installer.utils.progress.CompositeProgress;
import org.netbeans.installer.utils.progress.Progress;
import org.netbeans.installer.wizard.components.WizardAction;

public class InstallAction
extends WizardAction {
    public static final String DEFAULT_TITLE = ResourceUtils.getString(InstallAction.class, "IA.title");
    public static final String DEFAULT_DESCRIPTION = ResourceUtils.getString(InstallAction.class, "IA.description");
    public static final String DEFAULT_PROGRESS_INSTALL_TITLE = ResourceUtils.getString(InstallAction.class, "IA.progress.install.title");
    public static final String PROGRESS_INSTALL_TITLE_PROPERTY = "progress.install.title";
    public static final String DEFAULT_PROGRESS_ROLLBACK_TITLE = ResourceUtils.getString(InstallAction.class, "IA.progress.rollback.title");
    public static final String PROGRESS_ROLLBACK_TITLE_PROPERTY = "progress.rollback.title";
    public static final String DEFAULT_INSTALL_DEPENDENT_FAILED_EXCEPTION = ResourceUtils.getString(InstallAction.class, "IA.install.dependent.failed");
    public static final String INSTALL_DEPENDENT_FAILED_EXCEPTION_PROPERTY = "install.dependent.failed";
    public static final String DEFAULT_INSTALL_UNKNOWN_ERROR = ResourceUtils.getString(InstallAction.class, "IA.install.unknown.error");
    public static final String INSTALL_UNKNOWN_ERROR_PROPERTY = "install.unknown.error";
    public static final int INSTALLATION_ERROR_CODE = 127;
    private CompositeProgress overallProgress;
    private Progress currentProgress;

    public InstallAction() {
        this.setProperty("title", DEFAULT_TITLE);
        this.setProperty("description", DEFAULT_DESCRIPTION);
        this.setProperty(PROGRESS_INSTALL_TITLE_PROPERTY, DEFAULT_PROGRESS_INSTALL_TITLE);
        this.setProperty(PROGRESS_ROLLBACK_TITLE_PROPERTY, DEFAULT_PROGRESS_ROLLBACK_TITLE);
        this.setProperty(INSTALL_DEPENDENT_FAILED_EXCEPTION_PROPERTY, DEFAULT_INSTALL_DEPENDENT_FAILED_EXCEPTION);
        this.setProperty(INSTALL_UNKNOWN_ERROR_PROPERTY, DEFAULT_INSTALL_UNKNOWN_ERROR);
    }

    @Override
    public boolean canExecuteForward() {
        return Registry.getInstance().getProductsToInstall().size() > 0;
    }

    @Override
    public boolean isPointOfNoReturn() {
        return true;
    }

    @Override
    public void execute() {
        LogManager.logIndent("Start products installation");
        Registry registry = Registry.getInstance();
        List<Product> products = registry.getProductsToInstall();
        int percentageChunk = 100 / products.size();
        int percentageLeak = 100 % products.size();
        HashMap<Product, Progress> progresses = new HashMap<Product, Progress>();
        this.overallProgress = new CompositeProgress();
        this.overallProgress.setPercentage(percentageLeak);
        this.overallProgress.synchronizeDetails(true);
        this.getWizardUi().setProgress(this.overallProgress);
        for (int i = 0; i < products.size(); ++i) {
            Product product = products.get(i);
            this.currentProgress = new Progress();
            this.overallProgress.addChild(this.currentProgress, percentageChunk);
            this.overallProgress.setTitle(StringUtils.format(this.getProperty(PROGRESS_INSTALL_TITLE_PROPERTY), product.getDisplayName()));
            boolean isProductRolledback = false;
            try {
                product.install(this.currentProgress);
                if (this.isCanceled()) {
                    LogManager.log("... installation is cancelled : " + product.getDisplayName() + "(" + product.getUid() + "/" + product.getVersion() + ")");
                    this.overallProgress.setTitle(StringUtils.format(this.getProperty(PROGRESS_ROLLBACK_TITLE_PROPERTY), product.getDisplayName()));
                    product.rollback(this.currentProgress);
                    isProductRolledback = true;
                    for (Product toInstall : registry.getProductsToInstall()) {
                        LogManager.log("... marking to-be-installed product as not-installed : " + toInstall);
                        toInstall.setStatus(Status.NOT_INSTALLED);
                    }
                    OrFilter filter = new OrFilter(new ProductFilter(DetailedStatus.INSTALLED_SUCCESSFULLY), new ProductFilter(DetailedStatus.INSTALLED_WITH_WARNINGS));
                    for (Product installed : registry.queryProducts(filter)) {
                        LogManager.log("... marking installed product as to-be-uninstalled : " + installed);
                        installed.setStatus(Status.TO_BE_UNINSTALLED);
                    }
                    for (Product toRollback : registry.getProductsToUninstall()) {
                        LogManager.log("... also rollbacking " + toRollback.getDisplayName() + "(" + toRollback.getUid() + "/" + toRollback.getVersion() + ")");
                        this.overallProgress.setTitle(StringUtils.format(this.getProperty(PROGRESS_ROLLBACK_TITLE_PROPERTY), toRollback.getDisplayName()));
                        toRollback.rollback((Progress)progresses.get(toRollback));
                    }
                    break;
                }
                progresses.put(product, this.currentProgress);
                SystemUtils.sleep(200L);
                continue;
            }
            catch (Throwable e2) {
                InstallationException e2;
                LogManager.log(e2);
                if (!(e2 instanceof InstallationException)) {
                    e2 = new InstallationException(this.getProperty(INSTALL_UNKNOWN_ERROR_PROPERTY), e2);
                }
                if (System.getProperties().get("nbi.exit.code") == null) {
                    System.getProperties().put("nbi.exit.code", new Integer(127));
                }
                product.setStatus(Status.NOT_INSTALLED);
                product.setInstallationError(e2);
                for (Product dependent : registry.getProducts()) {
                    if (dependent.getStatus() != Status.TO_BE_INSTALLED || !registry.satisfiesRequirement(product, dependent)) continue;
                    String exceptionName = StringUtils.format(this.getProperty(INSTALL_DEPENDENT_FAILED_EXCEPTION_PROPERTY), dependent.getDisplayName(), product.getDisplayName());
                    InstallationException dependentError = new InstallationException(exceptionName, e2);
                    dependent.setStatus(Status.NOT_INSTALLED);
                    dependent.setInstallationError(dependentError);
                    products.remove(dependent);
                }
                if (!isProductRolledback) {
                    try {
                        this.overallProgress.setTitle(StringUtils.format(this.getProperty(PROGRESS_ROLLBACK_TITLE_PROPERTY), product.getDisplayName()));
                        product.rollback(this.currentProgress);
                    }
                    catch (Exception uie) {
                        LogManager.log(uie);
                    }
                }
                this.overallProgress.removeChild(this.currentProgress);
                int productsToInstallSize = registry.getProductsToInstall().size();
                if (productsToInstallSize > 0) {
                    int theRestOfPercentage = 100 - this.overallProgress.getPercentage();
                    percentageChunk = theRestOfPercentage / productsToInstallSize;
                    percentageLeak = theRestOfPercentage % productsToInstallSize;
                    this.overallProgress.addPercentage(percentageLeak);
                }
                LogManager.log(1, (Throwable)e2);
            }
        }
        LogManager.logUnindent("... finished products installation");
    }

    @Override
    public void cancel() {
        if (this.currentProgress != null) {
            this.currentProgress.setCanceled(true);
        }
        if (this.overallProgress != null) {
            this.overallProgress.setCanceled(true);
        }
        super.cancel();
    }
}

