/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.editors;

import ancestris.modules.editors.genealogyeditor.editors.EntityEditor;
import ancestris.modules.editors.genealogyeditor.panels.MultimediaObjectCitationsTablePanel;
import ancestris.modules.editors.genealogyeditor.panels.NoteCitationsTablePanel;
import ancestris.modules.editors.genealogyeditor.panels.ReferencesTablePanel;
import ancestris.modules.editors.genealogyeditor.panels.RepositoryCitationEditorPanel;
import ancestris.modules.editors.genealogyeditor.panels.SourceRecordedEventsTablePanel;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Note;
import genj.gedcom.Property;
import genj.gedcom.PropertyChange;
import genj.gedcom.PropertyNote;
import genj.gedcom.PropertyRepository;
import genj.gedcom.PropertyXRef;
import genj.gedcom.Source;
import genj.view.ViewContext;
import java.awt.Component;
import java.awt.Container;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentListener;
import org.openide.util.NbBundle;

public class SourceEditor
extends EntityEditor {
    private Source mSource;
    private Context context;
    private JToolBar SourceTextToolBar;
    private JLabel abbreviationLabel;
    private JTextField abbreviationTextField;
    private JLabel agencyLabel;
    private JTextField agencyTextField;
    private JLabel authorLabel;
    private JTextField authorTextField;
    private JLabel changeDateLabel;
    private JLabel changeDateLabeldate;
    private SourceRecordedEventsTablePanel eventTypePanel;
    private MultimediaObjectCitationsTablePanel multimediaObjectCitationsTablePanel;
    private JPanel multimediaObjectPanel;
    private NoteCitationsTablePanel noteCitationsTablePanel;
    private JPanel notesPanel;
    private JPanel publicationFactsPanel;
    private JScrollPane publicationFactsScrollPane;
    private JTextArea publicationFactsTextArea;
    private JToolBar publicationFactsToolBar;
    private JPanel referencesPanel;
    private ReferencesTablePanel referencesTablePanel;
    private JPanel registeredEventsPanel;
    private JPanel repositoriesPanel;
    private RepositoryCitationEditorPanel repositoryCitationPanel;
    private JLabel sourceIDLabel;
    private JTextField sourceIDTextField;
    private JTabbedPane sourceInformationTabbedPane;
    private JPanel sourceTextPanel;
    private JScrollPane sourceTextScrollPane;
    private JTextArea sourceTextTextArea;
    private JLabel sourceTitleLabel;
    private JTextField sourceTitleTextField;

    public SourceEditor() {
        this(false);
    }

    public SourceEditor(boolean isNew) {
        super(isNew);
        this.initComponents();
        this.authorTextField.getDocument().addDocumentListener((DocumentListener)this.changes);
        this.sourceTitleTextField.getDocument().addDocumentListener((DocumentListener)this.changes);
        this.abbreviationTextField.getDocument().addDocumentListener((DocumentListener)this.changes);
        this.agencyTextField.getDocument().addDocumentListener((DocumentListener)this.changes);
        this.eventTypePanel.addChangeListener((ChangeListener)this.changes);
        this.sourceTextTextArea.getDocument().addDocumentListener((DocumentListener)this.changes);
        this.publicationFactsTextArea.getDocument().addDocumentListener((DocumentListener)this.changes);
        this.noteCitationsTablePanel.addChangeListener((ChangeListener)this.changes);
        this.multimediaObjectCitationsTablePanel.addChangeListener((ChangeListener)this.changes);
    }

    private void initComponents() {
        this.sourceIDLabel = new JLabel();
        this.sourceIDTextField = new JTextField();
        this.authorLabel = new JLabel();
        this.authorTextField = new JTextField();
        this.sourceTitleLabel = new JLabel();
        this.sourceTitleTextField = new JTextField();
        this.agencyLabel = new JLabel();
        this.agencyTextField = new JTextField();
        this.sourceInformationTabbedPane = new JTabbedPane();
        this.registeredEventsPanel = new JPanel();
        this.eventTypePanel = new SourceRecordedEventsTablePanel();
        this.sourceTextPanel = new JPanel();
        this.sourceTextScrollPane = new JScrollPane();
        this.sourceTextTextArea = new JTextArea();
        this.SourceTextToolBar = new JToolBar();
        this.publicationFactsPanel = new JPanel();
        this.publicationFactsToolBar = new JToolBar();
        this.publicationFactsScrollPane = new JScrollPane();
        this.publicationFactsTextArea = new JTextArea();
        this.repositoriesPanel = new JPanel();
        this.repositoryCitationPanel = new RepositoryCitationEditorPanel();
        this.notesPanel = new JPanel();
        this.noteCitationsTablePanel = new NoteCitationsTablePanel();
        this.referencesPanel = new JPanel();
        this.referencesTablePanel = new ReferencesTablePanel();
        this.multimediaObjectPanel = new JPanel();
        this.multimediaObjectCitationsTablePanel = new MultimediaObjectCitationsTablePanel();
        this.abbreviationLabel = new JLabel();
        this.abbreviationTextField = new JTextField();
        this.changeDateLabel = new JLabel();
        this.changeDateLabeldate = new JLabel();
        this.sourceIDLabel.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("SourceEditor.sourceIDLabel.text"), new Object[0]));
        this.sourceIDTextField.setEditable(false);
        this.sourceIDTextField.setColumns(8);
        this.sourceIDTextField.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("SourceEditor.sourceIDTextField.text"), new Object[0]));
        this.authorLabel.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("SourceEditor.authorLabel.text"), new Object[0]));
        this.authorTextField.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("SourceEditor.authorTextField.text"), new Object[0]));
        this.sourceTitleLabel.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("SourceEditor.sourceTitleLabel.text"), new Object[0]));
        this.sourceTitleTextField.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("SourceEditor.sourceTitleTextField.text"), new Object[0]));
        this.agencyLabel.setText(NbBundle.getMessage(SourceEditor.class, (String)"SourceEditor.agencyLabel.text"));
        this.sourceInformationTabbedPane.setRequestFocusEnabled(false);
        GroupLayout registeredEventsPanelLayout = new GroupLayout(this.registeredEventsPanel);
        this.registeredEventsPanel.setLayout(registeredEventsPanelLayout);
        registeredEventsPanelLayout.setHorizontalGroup(registeredEventsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.eventTypePanel, -1, 727, Short.MAX_VALUE));
        registeredEventsPanelLayout.setVerticalGroup(registeredEventsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.eventTypePanel, -1, 339, Short.MAX_VALUE));
        this.sourceInformationTabbedPane.addTab(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("SourceEditor.registeredEventsPanel.TabConstraints.tabTitle"), new Object[0]), this.registeredEventsPanel);
        this.sourceTextTextArea.setColumns(20);
        this.sourceTextTextArea.setLineWrap(true);
        this.sourceTextTextArea.setRows(5);
        this.sourceTextTextArea.setWrapStyleWord(true);
        this.sourceTextScrollPane.setViewportView(this.sourceTextTextArea);
        this.SourceTextToolBar.setFloatable(false);
        this.SourceTextToolBar.setRollover(true);
        GroupLayout sourceTextPanelLayout = new GroupLayout(this.sourceTextPanel);
        this.sourceTextPanel.setLayout(sourceTextPanelLayout);
        sourceTextPanelLayout.setHorizontalGroup(sourceTextPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sourceTextScrollPane, -1, 727, Short.MAX_VALUE).addComponent(this.SourceTextToolBar, -1, -1, Short.MAX_VALUE));
        sourceTextPanelLayout.setVerticalGroup(sourceTextPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sourceTextPanelLayout.createSequentialGroup().addComponent(this.SourceTextToolBar, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sourceTextScrollPane, -1, 308, Short.MAX_VALUE)));
        this.sourceInformationTabbedPane.addTab(NbBundle.getMessage(SourceEditor.class, (String)"SourceEditor.sourceTextPanel.TabConstraints.tabTitle"), this.sourceTextPanel);
        this.publicationFactsToolBar.setFloatable(false);
        this.publicationFactsToolBar.setRollover(true);
        this.publicationFactsTextArea.setColumns(20);
        this.publicationFactsTextArea.setRows(5);
        this.publicationFactsScrollPane.setViewportView(this.publicationFactsTextArea);
        GroupLayout publicationFactsPanelLayout = new GroupLayout(this.publicationFactsPanel);
        this.publicationFactsPanel.setLayout(publicationFactsPanelLayout);
        publicationFactsPanelLayout.setHorizontalGroup(publicationFactsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.publicationFactsToolBar, -1, -1, Short.MAX_VALUE).addComponent(this.publicationFactsScrollPane, -1, 727, Short.MAX_VALUE));
        publicationFactsPanelLayout.setVerticalGroup(publicationFactsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(publicationFactsPanelLayout.createSequentialGroup().addComponent(this.publicationFactsToolBar, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.publicationFactsScrollPane, -1, 308, Short.MAX_VALUE)));
        this.sourceInformationTabbedPane.addTab(NbBundle.getMessage(SourceEditor.class, (String)"SourceEditor.publicationFactsPanel.TabConstraints.tabTitle"), null, this.publicationFactsPanel, NbBundle.getMessage(SourceEditor.class, (String)"SourceEditor.publicationFactsPanel.TabConstraints.toolTipText"));
        this.repositoriesPanel.setRequestFocusEnabled(false);
        GroupLayout repositoriesPanelLayout = new GroupLayout(this.repositoriesPanel);
        this.repositoriesPanel.setLayout(repositoriesPanelLayout);
        repositoriesPanelLayout.setHorizontalGroup(repositoriesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.repositoryCitationPanel, -1, 727, Short.MAX_VALUE));
        repositoriesPanelLayout.setVerticalGroup(repositoriesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.repositoryCitationPanel, -1, 339, Short.MAX_VALUE));
        this.sourceInformationTabbedPane.addTab(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("SourceEditor.repositoriesPanel.TabConstraints.tabTitle"), new Object[0]), new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/repository.png")), this.repositoriesPanel);
        this.notesPanel.setRequestFocusEnabled(false);
        GroupLayout notesPanelLayout = new GroupLayout(this.notesPanel);
        this.notesPanel.setLayout(notesPanelLayout);
        notesPanelLayout.setHorizontalGroup(notesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.noteCitationsTablePanel, -1, -1, Short.MAX_VALUE));
        notesPanelLayout.setVerticalGroup(notesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.noteCitationsTablePanel, -1, 339, Short.MAX_VALUE));
        this.sourceInformationTabbedPane.addTab(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("SourceEditor.notesPanel.TabConstraints.tabTitle"), new Object[0]), new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/note.png")), this.notesPanel);
        this.referencesPanel.setRequestFocusEnabled(false);
        GroupLayout referencesPanelLayout = new GroupLayout(this.referencesPanel);
        this.referencesPanel.setLayout(referencesPanelLayout);
        referencesPanelLayout.setHorizontalGroup(referencesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, referencesPanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.referencesTablePanel, -1, -1, Short.MAX_VALUE)));
        referencesPanelLayout.setVerticalGroup(referencesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.referencesTablePanel, -1, 339, Short.MAX_VALUE));
        this.sourceInformationTabbedPane.addTab(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("SourceEditor.referencesPanel.TabConstraints.tabTitle"), new Object[0]), new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/association.png")), this.referencesPanel);
        GroupLayout multimediaObjectPanelLayout = new GroupLayout(this.multimediaObjectPanel);
        this.multimediaObjectPanel.setLayout(multimediaObjectPanelLayout);
        multimediaObjectPanelLayout.setHorizontalGroup(multimediaObjectPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.multimediaObjectCitationsTablePanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        multimediaObjectPanelLayout.setVerticalGroup(multimediaObjectPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.multimediaObjectCitationsTablePanel, -1, 339, Short.MAX_VALUE));
        this.sourceInformationTabbedPane.addTab(NbBundle.getMessage(SourceEditor.class, (String)"SourceEditor.multimediaObjectPanel.TabConstraints.tabTitle"), new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/media.png")), this.multimediaObjectPanel);
        this.abbreviationLabel.setText(NbBundle.getMessage(SourceEditor.class, (String)"SourceEditor.abbreviationLabel.text"));
        this.changeDateLabel.setHorizontalAlignment(2);
        this.changeDateLabel.setText(NbBundle.getMessage(SourceEditor.class, (String)"SourceEditor.changeDateLabel.text"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sourceInformationTabbedPane).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.authorLabel, GroupLayout.Alignment.LEADING, -1, 63, Short.MAX_VALUE).addComponent(this.sourceTitleLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.agencyLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addComponent(this.abbreviationLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.agencyTextField, GroupLayout.Alignment.TRAILING).addComponent(this.sourceTitleTextField, GroupLayout.Alignment.TRAILING).addComponent(this.authorTextField).addComponent(this.abbreviationTextField))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.sourceIDLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sourceIDTextField, -2, -1, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.changeDateLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.changeDateLabeldate, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sourceIDLabel).addComponent(this.sourceIDTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.authorLabel).addComponent(this.authorTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sourceTitleLabel).addComponent(this.sourceTitleTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.abbreviationLabel).addComponent(this.abbreviationTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.agencyLabel).addComponent(this.agencyTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sourceInformationTabbedPane).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.changeDateLabel, -1, -1, Short.MAX_VALUE).addComponent(this.changeDateLabeldate, -1, -1, Short.MAX_VALUE)).addContainerGap()));
    }

    public ViewContext getContext() {
        return new ViewContext(this.context);
    }

    public Component getEditorComponent() {
        return this;
    }

    protected String getTitleImpl() {
        if (this.context == null || this.context.getEntity() == null) {
            return "";
        }
        return new ViewContext(this.context.getEntity()).getText();
    }

    protected void setContextImpl(Context context) {
        this.context = context;
        Entity entity = context.getEntity();
        if (entity != null && entity instanceof Source) {
            this.mSource = (Source)entity;
            this.setTitle(NbBundle.getMessage(SourceEditor.class, (String)(this.isNew() ? "SourceEditor.create.title" : "SourceEditor.edit.title"), (Object)this.mSource));
            this.sourceIDTextField.setText(this.mSource.getId());
            Property sourceData = this.mSource.getProperty("DATA");
            if (sourceData != null) {
                Property[] sourceDataEvents = sourceData.getProperties("EVEN");
                this.eventTypePanel.setEventTypesList((Entity)this.mSource, sourceData, Arrays.asList(sourceDataEvents));
            } else {
                this.eventTypePanel.setEventTypesList((Entity)this.mSource, null, null);
            }
            Property sourceAuthor = this.mSource.getProperty("AUTH");
            this.authorTextField.setText(sourceAuthor != null ? sourceAuthor.getValue() : "");
            Property sourceTitle = this.mSource.getProperty("TITL");
            this.sourceTitleTextField.setText(sourceTitle != null ? sourceTitle.getValue() : "");
            Property abbreviation = this.mSource.getProperty("ABBR");
            this.abbreviationTextField.setText(abbreviation != null ? abbreviation.getValue() : "");
            Property publicationFacts = this.mSource.getProperty("PUBL");
            this.publicationFactsTextArea.setText(publicationFacts != null ? publicationFacts.getValue() : "");
            Property sourceText = this.mSource.getProperty("TEXT");
            this.sourceTextTextArea.setText(sourceText != null ? sourceText.getValue() : "");
            Property p = this.mSource.getProperty("REPO");
            PropertyRepository repo = (PropertyRepository)(p instanceof PropertyRepository ? p : null);
            this.repositoryCitationPanel.set((Property)this.mSource, repo);
            Property changeDate = this.mSource.getProperty("CHAN");
            if (changeDate != null) {
                this.changeDateLabeldate.setText(((PropertyChange)changeDate).getDisplayValue());
            }
            ArrayList<Note> notesList = new ArrayList<Note>();
            for (PropertyNote noteRef : this.mSource.getProperties(PropertyNote.class)) {
                notesList.add((Note)noteRef.getTargetEntity());
            }
            this.noteCitationsTablePanel.set((Property)this.mSource, Arrays.asList(this.mSource.getProperties("NOTE")));
            this.multimediaObjectCitationsTablePanel.set((Property)this.mSource, Arrays.asList(this.mSource.getProperties("OBJE")));
            ArrayList<Entity> entitiesList = new ArrayList<Entity>();
            for (PropertyXRef entityRef : this.mSource.getProperties(PropertyXRef.class)) {
                entitiesList.add(entityRef.getTargetEntity());
            }
            this.referencesTablePanel.set((Entity)this.mSource, entitiesList);
        }
    }

    public void commit() {
        if (this.changes.hasChanged()) {
            if (!this.sourceTitleTextField.getText().isEmpty()) {
                Property sourceTitle = this.mSource.getProperty("TITL");
                if (sourceTitle == null) {
                    this.mSource.addProperty("TITL", this.sourceTitleTextField.getText());
                } else {
                    sourceTitle.setValue(this.sourceTitleTextField.getText());
                }
            }
            if (!this.publicationFactsTextArea.getText().isEmpty()) {
                Property publicationFacts = this.mSource.getProperty("PUBL");
                if (publicationFacts == null) {
                    this.mSource.addProperty("PUBL", this.publicationFactsTextArea.getText());
                } else {
                    publicationFacts.setValue(this.publicationFactsTextArea.getText());
                }
            }
            if (!this.sourceTextTextArea.getText().isEmpty()) {
                Property sourceText = this.mSource.getProperty("TEXT");
                if (sourceText == null) {
                    this.mSource.addProperty("TEXT", this.sourceTextTextArea.getText());
                } else {
                    sourceText.setValue(this.sourceTextTextArea.getText());
                }
            }
            if (!this.abbreviationTextField.getText().isEmpty()) {
                Property abbreviation = this.mSource.getProperty("ABBR");
                if (abbreviation == null) {
                    this.mSource.addProperty("ABBR", this.abbreviationTextField.getText());
                } else {
                    abbreviation.setValue(this.abbreviationTextField.getText());
                }
            }
            if (!this.authorTextField.getText().isEmpty()) {
                Property sourceAuthor = this.mSource.getProperty("AUTH");
                if (sourceAuthor == null) {
                    this.mSource.addProperty("AUTH", this.authorTextField.getText());
                } else {
                    sourceAuthor.setValue(this.authorTextField.getText());
                }
            }
        }
    }

    public Entity getEditedEntity() {
        return this.mSource;
    }
}

