/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.models;

import genj.gedcom.Fam;
import genj.gedcom.Indi;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.openide.util.NbBundle;

public class FamiliesTableModel
extends AbstractTableModel {
    public static int FAMILY_LIST = 0;
    public static int FAMILY_CHILD = 1;
    public static int FAMILY_SPOUSE = 2;
    private int mFamilyTableType = FAMILY_CHILD;
    private final List<Fam> familiesList = new ArrayList<Fam>();
    private static final String[] familyListColumnsName = new String[]{NbBundle.getMessage(FamiliesTableModel.class, (String)"FamiliesTableModel.familyList.column.ID.title"), NbBundle.getMessage(FamiliesTableModel.class, (String)"FamiliesTableModel.familyList.column.husband.title"), NbBundle.getMessage(FamiliesTableModel.class, (String)"FamiliesTableModel.familyList.column.wife.title"), NbBundle.getMessage(FamiliesTableModel.class, (String)"FamiliesTableModel.familyList.column.weddingDate.title")};
    private static final String[] familyChildColumnsName = new String[]{NbBundle.getMessage(FamiliesTableModel.class, (String)"FamiliesTableModel.familyChild.column.ID.title"), NbBundle.getMessage(FamiliesTableModel.class, (String)"FamiliesTableModel.familyChild.column.husband.title"), NbBundle.getMessage(FamiliesTableModel.class, (String)"FamiliesTableModel.familyChild.column.wife.title"), NbBundle.getMessage(FamiliesTableModel.class, (String)"FamiliesTableModel.familyChild.column.weddingDate.title"), NbBundle.getMessage(FamiliesTableModel.class, (String)"FamiliesTableModel.familyChild.column.children.title")};
    private static final String[] familySpouseColumnsName = new String[]{NbBundle.getMessage(FamiliesTableModel.class, (String)"FamiliesTableModel.familySpouse.column.ID.title"), NbBundle.getMessage(FamiliesTableModel.class, (String)"FamiliesTableModel.familySpouse.column.husband.title"), NbBundle.getMessage(FamiliesTableModel.class, (String)"FamiliesTableModel.familySpouse.column.wife.title"), NbBundle.getMessage(FamiliesTableModel.class, (String)"FamiliesTableModel.familySpouse.column.weddingDate.title"), NbBundle.getMessage(FamiliesTableModel.class, (String)"FamiliesTableModel.familySpouse.column.children.title")};
    private final String[] columnsName;

    public FamiliesTableModel(int familyType) {
        this.mFamilyTableType = familyType;
        this.columnsName = this.mFamilyTableType == FAMILY_CHILD ? familyChildColumnsName : (this.mFamilyTableType == FAMILY_SPOUSE ? familySpouseColumnsName : familyListColumnsName);
    }

    @Override
    public int getRowCount() {
        return this.familiesList.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnsName.length;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row < this.familiesList.size()) {
            Fam family = this.familiesList.get(row);
            if (column == 0) {
                return family.getId();
            }
            if (column == 1) {
                return family.getHusband() != null ? family.getHusband().getName() : "";
            }
            if (column == 2) {
                return family.getWife() != null ? family.getWife().getName() : "";
            }
            if (column == 3) {
                return family.getMarriageDate() != null ? family.getMarriageDate().toString() : "";
            }
            if (column == 4) {
                String children = "";
                int index = 0;
                for (Indi child : family.getChildren(true)) {
                    if (index > 0) {
                        children = children + "\n";
                    }
                    children = children + child.getName();
                    ++index;
                }
                return children;
            }
            return "";
        }
        return "";
    }

    @Override
    public String getColumnName(int col) {
        return this.columnsName[col];
    }

    public void add(Fam family) {
        this.familiesList.add(family);
        this.fireTableDataChanged();
    }

    public void addAll(List<Fam> familiesList) {
        this.familiesList.addAll(familiesList);
        this.fireTableDataChanged();
    }

    public Fam remove(int row) {
        Fam fam = this.familiesList.remove(row);
        this.fireTableDataChanged();
        return fam;
    }

    public void clear() {
        this.familiesList.clear();
        this.fireTableDataChanged();
    }

    public Fam getValueAt(int row) {
        return this.familiesList.get(row);
    }
}

