/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.models;

import genj.gedcom.PropertyFile;
import java.awt.Image;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import sun.awt.shell.ShellFolder;

public class MultimediaFilesTableModel
extends AbstractTableModel {
    List<PropertyFile> multimediaFilesList = new ArrayList<PropertyFile>();
    private final String[] columnsName = new String[]{"", NbBundle.getMessage(MultimediaFilesTableModel.class, (String)"MultimediaFilesTableModel.column.fileName.title")};

    @Override
    public int getRowCount() {
        return this.multimediaFilesList.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnsName.length;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row < this.multimediaFilesList.size()) {
            File multimediaFile = this.multimediaFilesList.get(row).getFile();
            if (multimediaFile != null) {
                switch (column) {
                    case 0: {
                        if (multimediaFile.exists()) {
                            ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/media.png"));
                            try {
                                Image image;
                                try {
                                    image = ImageIO.read(multimediaFile);
                                    if (image != null) {
                                        image = image.getScaledInstance(-1, 32, 1);
                                    }
                                }
                                catch (IOException ex) {
                                    image = ShellFolder.getShellFolder(multimediaFile).getIcon(true);
                                }
                                if (image != null) {
                                    imageIcon = new ImageIcon(image);
                                }
                            }
                            catch (FileNotFoundException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            return imageIcon;
                        }
                        return new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit_delete.png"));
                    }
                    case 1: {
                        return multimediaFile.getAbsolutePath();
                    }
                }
                return "";
            }
            return "";
        }
        return "";
    }

    public Class getColumnClass(int column) {
        if (column == 0) {
            return ImageIcon.class;
        }
        return String.class;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnsName[col];
    }

    public void add(PropertyFile multimediaObject) {
        this.multimediaFilesList.add(multimediaObject);
        this.fireTableDataChanged();
    }

    public void addAll(List<PropertyFile> multimediaObjectsList) {
        this.multimediaFilesList.addAll(multimediaObjectsList);
        this.fireTableDataChanged();
    }

    public PropertyFile getValueAt(int row) {
        return this.multimediaFilesList.get(row);
    }

    public PropertyFile remove(int rowIndex) {
        PropertyFile remove = this.multimediaFilesList.remove(rowIndex);
        this.fireTableDataChanged();
        return remove;
    }

    public void clear() {
        this.multimediaFilesList.clear();
        this.fireTableDataChanged();
    }

    protected ImageIcon createImageIcon(String path, String description) {
        return new ImageIcon(path, description);
    }
}

