/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.panels;

import ancestris.modules.editors.genealogyeditor.AriesTopComponent;
import ancestris.modules.editors.genealogyeditor.editors.IndividualEditor;
import ancestris.modules.editors.genealogyeditor.models.IndividualReferencesTableModel;
import ancestris.modules.editors.genealogyeditor.panels.IndividualsTablePanel;
import ancestris.modules.editors.genealogyeditor.table.EditorTable;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyAlias;
import genj.gedcom.PropertyXRef;
import genj.gedcom.UnitOfWork;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.DialogDescriptor;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class AliasTablePanel
extends JPanel {
    private final IndividualReferencesTableModel mIndividualReferencesTableModel = new IndividualReferencesTableModel();
    private final ChangeListner changeListner = new ChangeListner();
    private final ChangeSupport changeSupport = new ChangeSupport(AliasTablePanel.class);
    private Indi mRoot;
    private PropertyAlias mAlias = null;
    private EditorTable aliasTable;
    private JToolBar childrenToolBar;
    private JButton deleteAliasButton;
    private JButton editAliasButton;
    private JScrollPane jScrollPane1;
    private JButton linkToAliasButton;

    public AliasTablePanel() {
        this.initComponents();
        this.aliasTable.setID(AliasTablePanel.class.getName());
    }

    private void initComponents() {
        this.childrenToolBar = new JToolBar();
        this.linkToAliasButton = new JButton();
        this.editAliasButton = new JButton();
        this.deleteAliasButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.aliasTable = new EditorTable();
        this.childrenToolBar.setFloatable(false);
        this.childrenToolBar.setRollover(true);
        this.linkToAliasButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit_add.png")));
        this.linkToAliasButton.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("AliasTablePanel.linkToAliasButton.text"), new Object[0]));
        this.linkToAliasButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("AliasTablePanel.linkToAliasButton.toolTipText"), new Object[0]));
        this.linkToAliasButton.setFocusable(false);
        this.linkToAliasButton.setHorizontalTextPosition(0);
        this.linkToAliasButton.setVerticalTextPosition(3);
        this.linkToAliasButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AliasTablePanel.this.linkToAliasButtonActionPerformed(evt);
            }
        });
        this.childrenToolBar.add(this.linkToAliasButton);
        this.editAliasButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit.png")));
        this.editAliasButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("AliasTablePanel.editAliasButton.toolTipText"), new Object[0]));
        this.editAliasButton.setFocusable(false);
        this.editAliasButton.setHorizontalTextPosition(0);
        this.editAliasButton.setVerticalTextPosition(3);
        this.editAliasButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AliasTablePanel.this.editAliasButtonActionPerformed(evt);
            }
        });
        this.childrenToolBar.add(this.editAliasButton);
        this.deleteAliasButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit_delete.png")));
        this.deleteAliasButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("AliasTablePanel.deleteAliasButton.toolTipText"), new Object[0]));
        this.deleteAliasButton.setFocusable(false);
        this.deleteAliasButton.setHorizontalTextPosition(0);
        this.deleteAliasButton.setVerticalTextPosition(3);
        this.deleteAliasButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AliasTablePanel.this.deleteAliasButtonActionPerformed(evt);
            }
        });
        this.childrenToolBar.add(this.deleteAliasButton);
        this.aliasTable.setModel(this.mIndividualReferencesTableModel);
        this.aliasTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AliasTablePanel.this.aliasTableMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.aliasTable);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.childrenToolBar, -1, 539, Short.MAX_VALUE).addComponent(this.jScrollPane1));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.childrenToolBar, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 154, Short.MAX_VALUE)));
    }

    private void editAliasButtonActionPerformed(ActionEvent evt) {
        int rowIndex = this.aliasTable.convertRowIndexToModel(this.aliasTable.getSelectedRow());
        if (rowIndex != -1) {
            PropertyXRef individualRef = this.mIndividualReferencesTableModel.getValueAt(rowIndex);
            IndividualEditor individualEditor = new IndividualEditor();
            individualEditor.setContext(new Context((Entity)((Indi)individualRef.getTargetEntity())));
            individualEditor.addChangeListener(this.changeListner);
            AriesTopComponent atc = AriesTopComponent.findEditorWindow(individualRef.getGedcom());
            atc.getOpenEditors().add(individualEditor);
            individualEditor.showPanel();
            individualEditor.removeChangeListener(this.changeListner);
            atc.getOpenEditors().remove((Object)individualEditor);
        }
    }

    private void deleteAliasButtonActionPerformed(ActionEvent evt) {
        PropertyXRef individualRef;
        DialogManager createYesNo;
        int selectedRow = this.aliasTable.getSelectedRow();
        if (selectedRow == -1) {
            return;
        }
        int rowIndex = this.aliasTable.convertRowIndexToModel(this.aliasTable.getSelectedRow());
        Gedcom gedcom = this.mRoot.getGedcom();
        if (rowIndex != -1 && (createYesNo = DialogManager.createYesNo((String)NbBundle.getMessage(AliasTablePanel.class, (String)"AliasTablePanel.deleteAlias.confirmation.title", (Object)(individualRef = this.mIndividualReferencesTableModel.getValueAt(rowIndex)).getTargetEntity()), (String)NbBundle.getMessage(AliasTablePanel.class, (String)"AliasTablePanel.deleteAlias.confirmation.text", (Object)individualRef.getTargetEntity(), (Object)this.mRoot))).show() == DialogManager.YES_OPTION) {
            try {
                this.mIndividualReferencesTableModel.remove(rowIndex);
                gedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        AliasTablePanel.this.mRoot.delProperty((Property)individualRef);
                    }
                });
                if (this.mIndividualReferencesTableModel.getRowCount() <= 0) {
                    this.deleteAliasButton.setEnabled(false);
                    this.editAliasButton.setEnabled(false);
                }
                this.changeListner.stateChanged(null);
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void linkToAliasButtonActionPerformed(ActionEvent evt) {
        Indi selectedIndividual;
        IndividualsTablePanel individualsTablePanel = new IndividualsTablePanel();
        ArrayList<Indi> individualsList = new ArrayList<Indi>(this.mRoot.getGedcom().getIndis());
        individualsTablePanel.setToolBarVisible(false);
        individualsTablePanel.set((Property)this.mRoot, individualsList);
        DialogManager.ADialog individualsTableDialog = new DialogManager.ADialog(NbBundle.getMessage(IndividualsTablePanel.class, (String)"individualsTableDialog.title.select.child"), (JComponent)individualsTablePanel);
        individualsTableDialog.setDialogId(IndividualsTablePanel.class.getName());
        if (individualsTableDialog.show() == DialogDescriptor.OK_OPTION && (selectedIndividual = individualsTablePanel.getSelectedIndividual()) != null) {
            try {
                this.mRoot.getGedcom().doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        AliasTablePanel.this.mAlias = (PropertyAlias)AliasTablePanel.this.mRoot.addProperty("ALIA", "@" + selectedIndividual.getId() + "@");
                        AliasTablePanel.this.mAlias.link();
                        AliasTablePanel.this.mIndividualReferencesTableModel.add((PropertyXRef)AliasTablePanel.this.mAlias);
                    }
                });
                this.deleteAliasButton.setEnabled(true);
                this.editAliasButton.setEnabled(true);
                this.changeListner.stateChanged(null);
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void aliasTableMouseClicked(MouseEvent evt) {
        int rowIndex;
        if (evt.getClickCount() >= 2 && (rowIndex = this.aliasTable.convertRowIndexToModel(this.aliasTable.getSelectedRow())) != -1) {
            PropertyXRef individualRef = this.mIndividualReferencesTableModel.getValueAt(rowIndex);
            IndividualEditor individualEditor = new IndividualEditor();
            individualEditor.setContext(new Context((Entity)((Indi)individualRef.getTargetEntity())));
            individualEditor.addChangeListener(this.changeListner);
            AriesTopComponent atc = AriesTopComponent.findEditorWindow(individualRef.getGedcom());
            atc.getOpenEditors().add(individualEditor);
            individualEditor.showPanel();
            this.changeListner.stateChanged(null);
            atc.getOpenEditors().remove((Object)individualEditor);
        }
    }

    public void set(Indi root, List<? extends PropertyXRef> individualsList) {
        this.mRoot = root;
        this.mIndividualReferencesTableModel.clear();
        this.mIndividualReferencesTableModel.addAll(individualsList);
        if (this.mIndividualReferencesTableModel.getRowCount() > 0) {
            this.deleteAliasButton.setEnabled(true);
            this.editAliasButton.setEnabled(true);
        } else {
            this.deleteAliasButton.setEnabled(false);
            this.editAliasButton.setEnabled(false);
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public class ChangeListner
    implements ChangeListener {
        private boolean mute = false;

        @Override
        public void stateChanged(ChangeEvent ce) {
            AliasTablePanel.this.changeSupport.fireChange();
        }

        public void mute() {
            this.mute = true;
        }

        public void unmute() {
            this.mute = false;
        }
    }
}

