/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.panels;

import ancestris.modules.editors.genealogyeditor.AriesTopComponent;
import ancestris.modules.editors.genealogyeditor.editors.IndividualEditor;
import ancestris.modules.editors.genealogyeditor.models.IndividualReferencesTableModel;
import ancestris.modules.editors.genealogyeditor.panels.IndividualsTablePanel;
import ancestris.modules.editors.genealogyeditor.table.EditorTable;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyXRef;
import genj.gedcom.UnitOfWork;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.DialogDescriptor;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ChildrenTablePanel
extends JPanel {
    private final IndividualReferencesTableModel mIndividualReferencesTableModel = new IndividualReferencesTableModel();
    private final ChangeListner changeListner = new ChangeListner();
    private final ChangeSupport changeSupport = new ChangeSupport(ChildrenTablePanel.class);
    private Fam mRoot;
    private Indi mIndividual;
    PropertyXRef mAddedChild = null;
    private JButton addChildrenButton;
    private EditorTable childrenTable;
    private JToolBar childrenToolBar;
    private JButton deleteChildrenButton;
    private JButton editChildrenButton;
    private JScrollPane jScrollPane1;
    private JButton linkToChildrenButton;

    public ChildrenTablePanel() {
        this.initComponents();
        this.childrenTable.setID(ChildrenTablePanel.class.getName());
    }

    private void initComponents() {
        this.childrenToolBar = new JToolBar();
        this.addChildrenButton = new JButton();
        this.linkToChildrenButton = new JButton();
        this.editChildrenButton = new JButton();
        this.deleteChildrenButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.childrenTable = new EditorTable();
        this.childrenToolBar.setFloatable(false);
        this.childrenToolBar.setRollover(true);
        this.addChildrenButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit_add.png")));
        this.addChildrenButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("ChildrenTablePanel.addChildrenButton.toolTipText"), new Object[0]));
        this.addChildrenButton.setFocusable(false);
        this.addChildrenButton.setHorizontalTextPosition(0);
        this.addChildrenButton.setVerticalTextPosition(3);
        this.addChildrenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChildrenTablePanel.this.addChildrenButtonActionPerformed(evt);
            }
        });
        this.childrenToolBar.add(this.addChildrenButton);
        this.linkToChildrenButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/link_add.png")));
        this.linkToChildrenButton.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("ChildrenTablePanel.linkToChildrenButton.text"), new Object[0]));
        this.linkToChildrenButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("ChildrenTablePanel.linkToChildrenButton.toolTipText"), new Object[0]));
        this.linkToChildrenButton.setFocusable(false);
        this.linkToChildrenButton.setHorizontalTextPosition(0);
        this.linkToChildrenButton.setVerticalTextPosition(3);
        this.linkToChildrenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChildrenTablePanel.this.linkToChildrenButtonActionPerformed(evt);
            }
        });
        this.childrenToolBar.add(this.linkToChildrenButton);
        this.editChildrenButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit.png")));
        this.editChildrenButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("ChildrenTablePanel.editChildrenButton.toolTipText"), new Object[0]));
        this.editChildrenButton.setFocusable(false);
        this.editChildrenButton.setHorizontalTextPosition(0);
        this.editChildrenButton.setVerticalTextPosition(3);
        this.editChildrenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChildrenTablePanel.this.editChildrenButtonActionPerformed(evt);
            }
        });
        this.childrenToolBar.add(this.editChildrenButton);
        this.deleteChildrenButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit_delete.png")));
        this.deleteChildrenButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("ChildrenTablePanel.deleteChildrenButton.toolTipText"), new Object[0]));
        this.deleteChildrenButton.setFocusable(false);
        this.deleteChildrenButton.setHorizontalTextPosition(0);
        this.deleteChildrenButton.setVerticalTextPosition(3);
        this.deleteChildrenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChildrenTablePanel.this.deleteChildrenButtonActionPerformed(evt);
            }
        });
        this.childrenToolBar.add(this.deleteChildrenButton);
        this.childrenTable.setModel(this.mIndividualReferencesTableModel);
        this.childrenTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ChildrenTablePanel.this.childrenTableMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.childrenTable);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.childrenToolBar, -1, 539, Short.MAX_VALUE).addComponent(this.jScrollPane1));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.childrenToolBar, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 154, Short.MAX_VALUE)));
    }

    private void addChildrenButtonActionPerformed(ActionEvent evt) {
        Gedcom gedcom = this.mRoot.getGedcom();
        int undoNb = gedcom.getUndoNb();
        try {
            this.mRoot.getGedcom().doUnitOfWork(new UnitOfWork(){

                public void perform(Gedcom gedcom) throws GedcomException {
                    ChildrenTablePanel.this.mIndividual = (Indi)gedcom.createEntity("INDI");
                    ChildrenTablePanel.this.mAddedChild = ChildrenTablePanel.this.mRoot.addChild(ChildrenTablePanel.this.mIndividual);
                    String lastName = "";
                    if (ChildrenTablePanel.this.mRoot.getHusband() != null) {
                        lastName = ChildrenTablePanel.this.mRoot.getHusband().getLastName();
                    } else if (ChildrenTablePanel.this.mRoot.getWife() != null) {
                        lastName = ChildrenTablePanel.this.mRoot.getWife().getLastName();
                    }
                    ChildrenTablePanel.this.mIndividual.setName("", lastName);
                }
            });
            IndividualEditor individualEditor = new IndividualEditor();
            individualEditor.setContext(new Context((Entity)this.mIndividual));
            individualEditor.addChangeListener(this.changeListner);
            AriesTopComponent atc = AriesTopComponent.findEditorWindow(gedcom);
            atc.getOpenEditors().add(individualEditor);
            if (individualEditor.showPanel()) {
                this.mIndividualReferencesTableModel.add(this.mAddedChild);
                this.deleteChildrenButton.setEnabled(true);
                this.editChildrenButton.setEnabled(true);
            } else {
                while (gedcom.getUndoNb() > undoNb && gedcom.canUndo()) {
                    gedcom.undoUnitOfWork(false);
                }
            }
            individualEditor.removeChangeListener(this.changeListner);
            atc.getOpenEditors().remove((Object)individualEditor);
        }
        catch (GedcomException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void editChildrenButtonActionPerformed(ActionEvent evt) {
        int rowIndex = this.childrenTable.convertRowIndexToModel(this.childrenTable.getSelectedRow());
        if (rowIndex != -1) {
            PropertyXRef individualRef = this.mIndividualReferencesTableModel.getValueAt(rowIndex);
            int undoNb = this.mRoot.getGedcom().getUndoNb();
            IndividualEditor individualEditor = new IndividualEditor();
            individualEditor.setContext(new Context((Entity)((Indi)individualRef.getTargetEntity())));
            individualEditor.addChangeListener(this.changeListner);
            AriesTopComponent atc = AriesTopComponent.findEditorWindow(this.mRoot.getGedcom());
            atc.getOpenEditors().add(individualEditor);
            individualEditor.showPanel();
            individualEditor.removeChangeListener(this.changeListner);
            atc.getOpenEditors().remove((Object)individualEditor);
        }
    }

    private void deleteChildrenButtonActionPerformed(ActionEvent evt) {
        PropertyXRef individualRef;
        DialogManager createYesNo;
        int rowIndex = this.childrenTable.convertRowIndexToModel(this.childrenTable.getSelectedRow());
        Gedcom gedcom = this.mRoot.getGedcom();
        if (rowIndex != -1 && (createYesNo = DialogManager.createYesNo((String)NbBundle.getMessage(ChildrenTablePanel.class, (String)"ChildrenTableDialog.deleteChildConfirmation.title", (Object)(individualRef = this.mIndividualReferencesTableModel.getValueAt(rowIndex)).getTargetEntity()), (String)NbBundle.getMessage(ChildrenTablePanel.class, (String)"ChildrenTableDialog.deleteChildConfirmation.text", (Object)individualRef.getTargetEntity(), (Object)this.mRoot))).show() == DialogManager.YES_OPTION) {
            try {
                gedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        ChildrenTablePanel.this.mRoot.delProperty((Property)individualRef);
                    }
                });
                this.mIndividualReferencesTableModel.remove(rowIndex);
                if (this.mIndividualReferencesTableModel.getRowCount() <= 0) {
                    this.deleteChildrenButton.setEnabled(false);
                    this.editChildrenButton.setEnabled(false);
                }
                this.changeListner.stateChanged(null);
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void linkToChildrenButtonActionPerformed(ActionEvent evt) {
        Indi selectedIndividual;
        IndividualsTablePanel individualsTablePanel = new IndividualsTablePanel();
        ArrayList<Indi> individualsList = new ArrayList<Indi>(this.mRoot.getGedcom().getIndis());
        individualsTablePanel.setToolBarVisible(false);
        individualsTablePanel.set((Property)this.mRoot, individualsList);
        DialogManager.ADialog individualsTableDialog = new DialogManager.ADialog(NbBundle.getMessage(IndividualsTablePanel.class, (String)"individualsTableDialog.title.select.child"), (JComponent)individualsTablePanel);
        individualsTableDialog.setDialogId(IndividualsTablePanel.class.getName());
        if (individualsTableDialog.show() == DialogDescriptor.OK_OPTION && (selectedIndividual = individualsTablePanel.getSelectedIndividual()) != null) {
            try {
                this.mRoot.getGedcom().doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        PropertyXRef addChild = ChildrenTablePanel.this.mRoot.addChild(selectedIndividual);
                        ChildrenTablePanel.this.mIndividualReferencesTableModel.add(addChild);
                    }
                });
                this.deleteChildrenButton.setEnabled(true);
                this.editChildrenButton.setEnabled(true);
                this.changeListner.stateChanged(null);
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void childrenTableMouseClicked(MouseEvent evt) {
        int rowIndex;
        if (evt.getClickCount() >= 2 && (rowIndex = this.childrenTable.convertRowIndexToModel(this.childrenTable.getSelectedRow())) != -1) {
            PropertyXRef individualRef = this.mIndividualReferencesTableModel.getValueAt(rowIndex);
            IndividualEditor individualEditor = new IndividualEditor();
            individualEditor.setContext(new Context((Entity)((Indi)individualRef.getTargetEntity())));
            individualEditor.addChangeListener(this.changeListner);
            AriesTopComponent atc = AriesTopComponent.findEditorWindow(individualRef.getGedcom());
            atc.getOpenEditors().add(individualEditor);
            individualEditor.showPanel();
            this.changeListner.stateChanged(null);
            atc.getOpenEditors().remove((Object)individualEditor);
        }
    }

    public void set(Fam root, List<? extends PropertyXRef> individualsList) {
        this.mRoot = root;
        this.mIndividualReferencesTableModel.clear();
        this.mIndividualReferencesTableModel.addAll(individualsList);
        if (this.mIndividualReferencesTableModel.getRowCount() > 0) {
            this.deleteChildrenButton.setEnabled(true);
            this.editChildrenButton.setEnabled(true);
        } else {
            this.deleteChildrenButton.setEnabled(false);
            this.editChildrenButton.setEnabled(false);
        }
    }

    public Indi getSelectedChildren() {
        int selectedRow = this.childrenTable.getSelectedRow();
        if (selectedRow != -1) {
            int rowIndex = this.childrenTable.convertRowIndexToModel(selectedRow);
            return (Indi)this.mIndividualReferencesTableModel.getValueAt(rowIndex).getTargetEntity();
        }
        return null;
    }

    public void setToolBarVisible(boolean visible) {
        this.childrenToolBar.setVisible(visible);
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public class ChangeListner
    implements ChangeListener {
        private boolean mute = false;

        @Override
        public void stateChanged(ChangeEvent ce) {
            ChildrenTablePanel.this.changeSupport.fireChange();
        }

        public void mute() {
            this.mute = true;
        }

        public void unmute() {
            this.mute = false;
        }
    }
}

