/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.panels;

import ancestris.modules.editors.genealogyeditor.AriesTopComponent;
import ancestris.modules.editors.genealogyeditor.editors.FamilyEditor;
import ancestris.modules.editors.genealogyeditor.models.FamiliesTableModel;
import ancestris.modules.editors.genealogyeditor.table.EditorTable;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.UnitOfWork;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import org.openide.DialogDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class FamiliesTablePanel
extends JPanel {
    public static int LIST_FAM = 0;
    public static int EDIT_FAMC = 1;
    public static int EDIT_FAMS = 2;
    private FamiliesTableModel mFamiliesTableModel;
    private Property mRoot;
    private int mFamilyEditingType;
    private Fam mCreateFamily = null;
    private JButton addFamilyNameButton;
    private JButton deleteFamilyNameButton;
    private JButton editFamilyNameButton;
    private JScrollPane familyNamesScrollPane;
    private EditorTable familyNamesTable;
    private JToolBar familyNamesToolBar;
    private JButton linkToFamilyButton;

    public FamiliesTablePanel() {
        this.mFamilyEditingType = LIST_FAM;
        this.mFamiliesTableModel = new FamiliesTableModel(FamiliesTableModel.FAMILY_LIST);
        this.initComponents();
        this.familyNamesTable.setID(FamiliesTablePanel.class.getName());
        if (this.mFamilyEditingType == LIST_FAM) {
            this.familyNamesToolBar.setVisible(false);
        }
    }

    public FamiliesTablePanel(int familyEditingType) {
        this.mFamilyEditingType = familyEditingType;
        if (this.mFamilyEditingType == EDIT_FAMC) {
            this.mFamiliesTableModel = new FamiliesTableModel(FamiliesTableModel.FAMILY_CHILD);
        } else if (this.mFamilyEditingType == EDIT_FAMS) {
            this.mFamiliesTableModel = new FamiliesTableModel(FamiliesTableModel.FAMILY_SPOUSE);
        } else if (this.mFamilyEditingType == LIST_FAM) {
            this.mFamiliesTableModel = new FamiliesTableModel(FamiliesTableModel.FAMILY_LIST);
        }
        this.initComponents();
        this.familyNamesTable.setID(FamiliesTablePanel.class.getName());
        if (this.mFamilyEditingType == LIST_FAM) {
            this.familyNamesToolBar.setVisible(false);
        }
    }

    private void initComponents() {
        this.familyNamesToolBar = new JToolBar();
        this.addFamilyNameButton = new JButton();
        this.linkToFamilyButton = new JButton();
        this.editFamilyNameButton = new JButton();
        this.deleteFamilyNameButton = new JButton();
        this.familyNamesScrollPane = new JScrollPane();
        this.familyNamesTable = new EditorTable();
        this.familyNamesToolBar.setFloatable(false);
        this.familyNamesToolBar.setRollover(true);
        this.addFamilyNameButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit_add.png")));
        this.addFamilyNameButton.setFocusable(false);
        this.addFamilyNameButton.setHorizontalTextPosition(0);
        this.addFamilyNameButton.setVerticalTextPosition(3);
        this.addFamilyNameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FamiliesTablePanel.this.addFamilyNameButtonActionPerformed(evt);
            }
        });
        this.familyNamesToolBar.add(this.addFamilyNameButton);
        this.linkToFamilyButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/link_add.png")));
        this.linkToFamilyButton.setFocusable(false);
        this.linkToFamilyButton.setHorizontalTextPosition(4);
        this.linkToFamilyButton.setVerticalTextPosition(3);
        this.linkToFamilyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FamiliesTablePanel.this.linkToFamilyButtonActionPerformed(evt);
            }
        });
        this.familyNamesToolBar.add(this.linkToFamilyButton);
        this.editFamilyNameButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit.png")));
        this.editFamilyNameButton.setFocusable(false);
        this.editFamilyNameButton.setHorizontalTextPosition(0);
        this.editFamilyNameButton.setVerticalTextPosition(3);
        this.editFamilyNameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FamiliesTablePanel.this.editFamilyNameButtonActionPerformed(evt);
            }
        });
        this.familyNamesToolBar.add(this.editFamilyNameButton);
        this.deleteFamilyNameButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit_delete.png")));
        this.deleteFamilyNameButton.setFocusable(false);
        this.deleteFamilyNameButton.setHorizontalTextPosition(0);
        this.deleteFamilyNameButton.setVerticalTextPosition(3);
        this.deleteFamilyNameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FamiliesTablePanel.this.deleteFamilyNameButtonActionPerformed(evt);
            }
        });
        this.familyNamesToolBar.add(this.deleteFamilyNameButton);
        this.familyNamesTable.setModel(this.mFamiliesTableModel);
        this.familyNamesTable.setSelectionBackground(new Color(89, 142, 195));
        this.familyNamesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FamiliesTablePanel.this.familyNamesTableMouseClicked(evt);
            }
        });
        this.familyNamesScrollPane.setViewportView(this.familyNamesTable);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.familyNamesToolBar, -1, 539, Short.MAX_VALUE).addComponent(this.familyNamesScrollPane));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.familyNamesToolBar, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.familyNamesScrollPane, -1, 154, Short.MAX_VALUE)));
    }

    private void addFamilyNameButtonActionPerformed(ActionEvent evt) {
        Gedcom gedcom = this.mRoot.getGedcom();
        int undoNb = gedcom.getUndoNb();
        try {
            gedcom.doUnitOfWork(new UnitOfWork(){

                public void perform(Gedcom gedcom) throws GedcomException {
                    FamiliesTablePanel.this.mCreateFamily = (Fam)gedcom.createEntity("FAM");
                }
            });
            FamilyEditor familyEditor = new FamilyEditor();
            familyEditor.setContext(new Context((Entity)this.mCreateFamily));
            AriesTopComponent atc = AriesTopComponent.findEditorWindow(gedcom);
            atc.getOpenEditors().add(familyEditor);
            if (familyEditor.showPanel()) {
                gedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        if (FamiliesTablePanel.this.mFamilyEditingType == EDIT_FAMC) {
                            FamiliesTablePanel.this.mCreateFamily.addChild((Indi)FamiliesTablePanel.this.mRoot);
                        } else if (FamiliesTablePanel.this.mFamilyEditingType == EDIT_FAMS) {
                            if (((Indi)FamiliesTablePanel.this.mRoot).getSex() == 1) {
                                FamiliesTablePanel.this.mCreateFamily.setHusband((Indi)FamiliesTablePanel.this.mRoot);
                            } else {
                                FamiliesTablePanel.this.mCreateFamily.setWife((Indi)FamiliesTablePanel.this.mRoot);
                            }
                        }
                    }
                });
                this.mFamiliesTableModel.add(this.mCreateFamily);
                this.editFamilyNameButton.setEnabled(true);
                this.deleteFamilyNameButton.setEnabled(true);
            } else {
                while (gedcom.getUndoNb() > undoNb && gedcom.canUndo()) {
                    gedcom.undoUnitOfWork(false);
                }
            }
            atc.getOpenEditors().remove((Object)familyEditor);
        }
        catch (GedcomException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void editFamilyNameButtonActionPerformed(ActionEvent evt) {
        int rowIndex = this.familyNamesTable.convertRowIndexToModel(this.familyNamesTable.getSelectedRow());
        Gedcom gedcom = this.mRoot.getGedcom();
        if (rowIndex != -1) {
            Fam family = this.mFamiliesTableModel.getValueAt(rowIndex);
            FamilyEditor familyEditor = new FamilyEditor();
            familyEditor.setContext(new Context((Entity)family));
            AriesTopComponent atc = AriesTopComponent.findEditorWindow(gedcom);
            atc.getOpenEditors().add(familyEditor);
            familyEditor.showPanel();
            atc.getOpenEditors().remove((Object)familyEditor);
        }
    }

    private void deleteFamilyNameButtonActionPerformed(ActionEvent evt) {
        int rowIndex;
        Fam family;
        DialogManager createYesNo;
        final int selectedRow = this.familyNamesTable.getSelectedRow();
        Gedcom gedcom = this.mRoot.getGedcom();
        if (selectedRow != -1 && (createYesNo = DialogManager.createYesNo((String)NbBundle.getMessage(FamiliesTablePanel.class, (String)"FamiliesTableDialog.deleteFamilyConfirmation.title", (Object)(family = this.mFamiliesTableModel.getValueAt(rowIndex = this.familyNamesTable.convertRowIndexToModel(selectedRow)))), (String)NbBundle.getMessage(FamiliesTablePanel.class, (String)"FamiliesTableDialog.deleteFamilyConfirmation.text", (Object)family, (Object)this.mRoot))).show() == DialogManager.YES_OPTION) {
            try {
                gedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        FamiliesTablePanel.this.mRoot.delProperty((Property)FamiliesTablePanel.this.mFamiliesTableModel.remove(FamiliesTablePanel.this.familyNamesTable.convertRowIndexToModel(selectedRow)));
                    }
                });
                if (this.mFamiliesTableModel.getRowCount() <= 0) {
                    this.editFamilyNameButton.setEnabled(false);
                    this.deleteFamilyNameButton.setEnabled(false);
                }
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void linkToFamilyButtonActionPerformed(ActionEvent evt) {
        Fam selectedFamily;
        FamiliesTablePanel familiesTablePanel = new FamiliesTablePanel(LIST_FAM);
        familiesTablePanel.set(this.mRoot, new ArrayList<Fam>(this.mRoot.getGedcom().getFamilies()));
        DialogManager.ADialog familiesTableDialog = new DialogManager.ADialog(NbBundle.getMessage(FamiliesTablePanel.class, (String)"familiesTableDialog.linkto.title"), (JComponent)familiesTablePanel);
        familiesTableDialog.setDialogId(FamiliesTablePanel.class.getName());
        if (familiesTableDialog.show() == DialogDescriptor.OK_OPTION && (selectedFamily = familiesTablePanel.getSelectedFamily()) != null) {
            try {
                this.mRoot.getGedcom().doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        if (FamiliesTablePanel.this.mFamilyEditingType == EDIT_FAMC) {
                            selectedFamily.addChild((Indi)FamiliesTablePanel.this.mRoot);
                        } else if (FamiliesTablePanel.this.mFamilyEditingType == EDIT_FAMS) {
                            if (((Indi)FamiliesTablePanel.this.mRoot).getSex() == 1) {
                                selectedFamily.setHusband((Indi)FamiliesTablePanel.this.mRoot);
                            } else {
                                selectedFamily.setWife((Indi)FamiliesTablePanel.this.mRoot);
                            }
                        }
                    }
                });
                this.mFamiliesTableModel.add(selectedFamily);
                this.editFamilyNameButton.setEnabled(true);
                this.deleteFamilyNameButton.setEnabled(true);
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void familyNamesTableMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() >= 2) {
            int rowIndex = this.familyNamesTable.convertRowIndexToModel(this.familyNamesTable.getSelectedRow());
            Gedcom gedcom = this.mRoot.getGedcom();
            if (rowIndex != -1) {
                Fam family = this.mFamiliesTableModel.getValueAt(rowIndex);
                FamilyEditor familyEditor = new FamilyEditor();
                familyEditor.setContext(new Context((Entity)family));
                AriesTopComponent atc = AriesTopComponent.findEditorWindow(gedcom);
                atc.getOpenEditors().add(familyEditor);
                familyEditor.showPanel();
                atc.getOpenEditors().remove((Object)familyEditor);
            }
        }
    }

    public void set(Property root, List<Fam> familiesList) {
        this.mRoot = root;
        this.mFamiliesTableModel.clear();
        this.mFamiliesTableModel.addAll(familiesList);
        if (this.mFamiliesTableModel.getRowCount() > 0) {
            this.editFamilyNameButton.setEnabled(true);
            this.deleteFamilyNameButton.setEnabled(true);
        } else {
            this.editFamilyNameButton.setEnabled(false);
            this.deleteFamilyNameButton.setEnabled(false);
        }
    }

    public Fam getSelectedFamily() {
        int selectedRow = this.familyNamesTable.getSelectedRow();
        if (selectedRow != -1) {
            int rowIndex = this.familyNamesTable.convertRowIndexToModel(selectedRow);
            return this.mFamiliesTableModel.getValueAt(rowIndex);
        }
        return null;
    }
}

