/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.panels;

import ancestris.modules.editors.genealogyeditor.AriesTopComponent;
import ancestris.modules.editors.genealogyeditor.editors.IndividualEditor;
import ancestris.modules.editors.genealogyeditor.models.IndividualsTableModel;
import ancestris.modules.editors.genealogyeditor.table.EditorTable;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.UnitOfWork;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.RowFilter;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class IndividualsTablePanel
extends JPanel {
    private final IndividualsTableModel mIndividualsTableModel = new IndividualsTableModel();
    private Property mRoot;
    Indi mIndividual;
    private final TableRowSorter<TableModel> mPlaceTableSorter;
    String[] mIndividualsTableColumnsTitle = null;
    private JButton addIndividualButton;
    private JButton clearFilterButton;
    private JButton deleteIndividualButton;
    private JButton editIndividualButton;
    private JButton filterButton;
    private JTextField filterTextField;
    private JToolBar individualsEditToolBar;
    private EditorTable individualsTable;
    private JScrollPane individualsTableScrollPane;
    private JToolBar individualsToolBar;
    private JToolBar individualsearchToolBar;
    private JComboBox<String> searchComboBox;
    private JLabel searchLabel;

    public IndividualsTablePanel() {
        int columnCount = this.mIndividualsTableModel.getColumnCount();
        this.mIndividualsTableColumnsTitle = new String[columnCount];
        for (int index = 0; index < columnCount; ++index) {
            this.mIndividualsTableColumnsTitle[index] = this.mIndividualsTableModel.getColumnName(index);
        }
        this.initComponents();
        this.individualsTable.setID(IndividualsTablePanel.class.getName());
        this.mPlaceTableSorter = new TableRowSorter<TableModel>(this.individualsTable.getModel());
        this.individualsTable.setRowSorter(this.mPlaceTableSorter);
    }

    private void initComponents() {
        this.individualsToolBar = new JToolBar();
        this.individualsEditToolBar = new JToolBar();
        this.addIndividualButton = new JButton();
        this.editIndividualButton = new JButton();
        this.deleteIndividualButton = new JButton();
        this.individualsearchToolBar = new JToolBar();
        this.searchLabel = new JLabel();
        this.searchComboBox = new JComboBox();
        this.filterTextField = new JTextField();
        this.filterButton = new JButton();
        this.clearFilterButton = new JButton();
        this.individualsTableScrollPane = new JScrollPane();
        this.individualsTable = new EditorTable();
        this.individualsToolBar.setFloatable(false);
        this.individualsToolBar.setRollover(true);
        this.individualsEditToolBar.setFloatable(false);
        this.individualsEditToolBar.setRollover(true);
        this.addIndividualButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit_add.png")));
        this.addIndividualButton.setFocusable(false);
        this.addIndividualButton.setHorizontalTextPosition(0);
        this.addIndividualButton.setVerticalTextPosition(3);
        this.addIndividualButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndividualsTablePanel.this.addIndividualButtonActionPerformed(evt);
            }
        });
        this.individualsEditToolBar.add(this.addIndividualButton);
        this.editIndividualButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit.png")));
        this.editIndividualButton.setFocusable(false);
        this.editIndividualButton.setHorizontalTextPosition(0);
        this.editIndividualButton.setVerticalTextPosition(3);
        this.editIndividualButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndividualsTablePanel.this.editIndividualButtonActionPerformed(evt);
            }
        });
        this.individualsEditToolBar.add(this.editIndividualButton);
        this.deleteIndividualButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit_delete.png")));
        this.deleteIndividualButton.setFocusable(false);
        this.deleteIndividualButton.setHorizontalTextPosition(0);
        this.deleteIndividualButton.setVerticalTextPosition(3);
        this.deleteIndividualButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndividualsTablePanel.this.deleteIndividualButtonActionPerformed(evt);
            }
        });
        this.individualsEditToolBar.add(this.deleteIndividualButton);
        this.individualsToolBar.add(this.individualsEditToolBar);
        this.individualsearchToolBar.setFloatable(false);
        this.individualsearchToolBar.setRollover(true);
        this.searchLabel.setText(NbBundle.getMessage(IndividualsTablePanel.class, (String)"IndividualsTablePanel.searchLabel.text"));
        this.individualsearchToolBar.add(this.searchLabel);
        this.searchComboBox.setModel(new DefaultComboBoxModel<String>(this.mIndividualsTableColumnsTitle));
        this.individualsearchToolBar.add(this.searchComboBox);
        this.filterTextField.setText(NbBundle.getMessage(IndividualsTablePanel.class, (String)"IndividualsTablePanel.filterTextField.text"));
        this.filterTextField.setPreferredSize(new Dimension(150, 27));
        this.filterTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndividualsTablePanel.this.filterTextFieldfilterGedcomPlaceButtonActionPerformed(evt);
            }
        });
        this.filterTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                IndividualsTablePanel.this.filterTextFieldKeyTyped(evt);
            }
        });
        this.individualsearchToolBar.add(this.filterTextField);
        this.filterButton.setText(NbBundle.getMessage(IndividualsTablePanel.class, (String)"IndividualsTablePanel.filterButton.text"));
        this.filterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndividualsTablePanel.this.filterButtonActionPerformed(evt);
            }
        });
        this.individualsearchToolBar.add(this.filterButton);
        this.clearFilterButton.setText(NbBundle.getMessage(IndividualsTablePanel.class, (String)"IndividualsTablePanel.clearFilterButton.text"));
        this.clearFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndividualsTablePanel.this.clearFilterButtonActionPerformed(evt);
            }
        });
        this.individualsearchToolBar.add(this.clearFilterButton);
        this.individualsToolBar.add(this.individualsearchToolBar);
        this.individualsTable.setModel(this.mIndividualsTableModel);
        this.individualsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                IndividualsTablePanel.this.individualsTableMouseClicked(evt);
            }
        });
        this.individualsTableScrollPane.setViewportView(this.individualsTable);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.individualsToolBar, -1, -1, Short.MAX_VALUE).addComponent(this.individualsTableScrollPane, -1, 419, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.individualsToolBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.individualsTableScrollPane, -1, 107, Short.MAX_VALUE)));
    }

    private void addIndividualButtonActionPerformed(ActionEvent evt) {
        Gedcom gedcom = this.mRoot.getGedcom();
        int undoNb = gedcom.getUndoNb();
        try {
            gedcom.doUnitOfWork(new UnitOfWork(){

                public void perform(Gedcom gedcom) throws GedcomException {
                    IndividualsTablePanel.this.mIndividual = (Indi)gedcom.createEntity("INDI");
                }
            });
            IndividualEditor individualEditor = new IndividualEditor();
            individualEditor.setContext(new Context((Entity)this.mIndividual));
            if (individualEditor.showPanel()) {
                this.mIndividualsTableModel.add(this.mIndividual);
                this.editIndividualButton.setEnabled(true);
                this.deleteIndividualButton.setEnabled(true);
            } else {
                while (gedcom.getUndoNb() > undoNb && gedcom.canUndo()) {
                    gedcom.undoUnitOfWork(false);
                }
            }
        }
        catch (GedcomException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void editIndividualButtonActionPerformed(ActionEvent evt) {
        int rowIndex = this.individualsTable.convertRowIndexToModel(this.individualsTable.getSelectedRow());
        Gedcom gedcom = this.mRoot.getGedcom();
        if (rowIndex != -1) {
            Indi individual = this.mIndividualsTableModel.getValueAt(rowIndex);
            IndividualEditor individualEditor = new IndividualEditor();
            individualEditor.setContext(new Context((Entity)individual));
            AriesTopComponent atc = AriesTopComponent.findEditorWindow(gedcom);
            atc.getOpenEditors().add(individualEditor);
            individualEditor.showPanel();
            atc.getOpenEditors().remove((Object)individualEditor);
        }
    }

    private void deleteIndividualButtonActionPerformed(ActionEvent evt) {
    }

    private void individualsTableMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() >= 2) {
            int rowIndex = this.individualsTable.convertRowIndexToModel(this.individualsTable.getSelectedRow());
            Gedcom gedcom = this.mRoot.getGedcom();
            if (rowIndex != -1) {
                Indi individual = this.mIndividualsTableModel.getValueAt(rowIndex);
                IndividualEditor individualEditor = new IndividualEditor();
                individualEditor.setContext(new Context((Entity)individual));
                AriesTopComponent atc = AriesTopComponent.findEditorWindow(gedcom);
                atc.getOpenEditors().add(individualEditor);
                individualEditor.showPanel();
                atc.getOpenEditors().remove((Object)individualEditor);
            }
        }
    }

    private void filterTextFieldfilterGedcomPlaceButtonActionPerformed(ActionEvent evt) {
        this.newFilter(this.filterTextField.getText());
    }

    private void filterTextFieldKeyTyped(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.newFilter(this.filterTextField.getText());
        }
    }

    private void filterButtonActionPerformed(ActionEvent evt) {
        this.newFilter(this.filterTextField.getText());
    }

    private void clearFilterButtonActionPerformed(ActionEvent evt) {
        this.filterTextField.setText("");
        this.newFilter(this.filterTextField.getText());
    }

    public void set(Property root, List<Indi> individualsList) {
        this.mRoot = root;
        this.mIndividualsTableModel.clear(individualsList);
        this.mIndividualsTableModel.addAll(individualsList);
        if (this.mIndividualsTableModel.getRowCount() > 0) {
            this.editIndividualButton.setEnabled(true);
            this.deleteIndividualButton.setEnabled(true);
        } else {
            this.editIndividualButton.setEnabled(false);
            this.deleteIndividualButton.setEnabled(false);
        }
    }

    public Indi getSelectedIndividual() {
        int selectedRow = this.individualsTable.getSelectedRow();
        if (selectedRow != -1) {
            int rowIndex = this.individualsTable.convertRowIndexToModel(selectedRow);
            return this.mIndividualsTableModel.getValueAt(rowIndex);
        }
        return null;
    }

    public void setToolBarVisible(boolean visible) {
        this.individualsEditToolBar.setVisible(visible);
    }

    private void newFilter(String filter) {
        RowFilter rf;
        try {
            rf = RowFilter.regexFilter("(?i)" + filter, this.searchComboBox.getSelectedIndex());
        }
        catch (PatternSyntaxException e) {
            return;
        }
        this.mPlaceTableSorter.setRowFilter(rf);
    }
}

