/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.searchduplicates;

import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.modules.gedcom.searchduplicates.Bundle;
import ancestris.modules.gedcom.searchduplicates.ResultPanel;
import ancestris.modules.gedcom.utilities.GedcomUtilities;
import ancestris.modules.gedcom.utilities.matchers.EntityMatcher;
import ancestris.modules.gedcom.utilities.matchers.FamMatcher;
import ancestris.modules.gedcom.utilities.matchers.FamMatcherOptions;
import ancestris.modules.gedcom.utilities.matchers.IndiMatcher;
import ancestris.modules.gedcom.utilities.matchers.IndiMatcherOptions;
import ancestris.modules.gedcom.utilities.matchers.MatcherOptions;
import ancestris.modules.gedcom.utilities.matchers.MediaMatcher;
import ancestris.modules.gedcom.utilities.matchers.MediaMatcherOptions;
import ancestris.modules.gedcom.utilities.matchers.NoteMatcher;
import ancestris.modules.gedcom.utilities.matchers.NoteMatcherOptions;
import ancestris.modules.gedcom.utilities.matchers.PotentialMatch;
import ancestris.modules.gedcom.utilities.matchers.RepositoryMatcher;
import ancestris.modules.gedcom.utilities.matchers.RepositoryMatcherOptions;
import ancestris.modules.gedcom.utilities.matchers.SourceMatcher;
import ancestris.modules.gedcom.utilities.matchers.SourceMatcherOptions;
import ancestris.modules.gedcom.utilities.matchers.SubmitterMatcher;
import ancestris.modules.gedcom.utilities.matchers.SubmitterMatcherOptions;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.gedcom.UnitOfWork;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class SearchDuplicatesPlugin
extends AncestrisPlugin
implements Runnable {
    private static final Logger log = Logger.getLogger(SearchDuplicatesPlugin.class.getName());
    private Gedcom gedcom;
    private TreeMap<String, EntityMatcher> entitiesMatchers = new TreeMap<String, EntityMatcher>(){
        {
            this.put("INDI", new IndiMatcher());
            this.put("FAM", new FamMatcher());
            this.put("NOTE", new NoteMatcher());
            this.put("SOUR", new SourceMatcher());
            this.put("REPO", new RepositoryMatcher());
            this.put("SUBM", new SubmitterMatcher());
            this.put("OBJE", new MediaMatcher());
        }
    };
    private final List<String> entities2Ckeck;
    private Map<String, ? extends MatcherOptions> selectedOptions;
    private ProgressHandle progressHandle;

    public SearchDuplicatesPlugin() {
        this.gedcom = null;
        this.entities2Ckeck = null;
        this.selectedOptions = null;
    }

    public SearchDuplicatesPlugin(Gedcom leftGedcom, List<String> entities2Ckeck, Map<String, ? extends MatcherOptions> selectedOptions, ProgressHandle progressHandle) {
        this.gedcom = leftGedcom;
        this.entities2Ckeck = entities2Ckeck;
        this.selectedOptions = selectedOptions;
        this.progressHandle = progressHandle;
    }

    @Override
    public void run() {
        final LinkedList matchesLinkedList = new LinkedList();
        HashMap<String, Integer> duplicatesHashMap = new HashMap<String, Integer>();
        if (this.gedcom == null) {
            return;
        }
        int num = 0;
        for (String tag : this.entities2Ckeck) {
            num += this.gedcom.getEntities(tag).size();
        }
        this.progressHandle.start();
        this.progressHandle.switchToDeterminate(num);
        try {
            num = 0;
            for (String tag : this.entities2Ckeck) {
                ArrayList entities = new ArrayList(this.gedcom.getEntities(tag));
                log.log(Level.FINE, "Checking: {0}", tag);
                if (tag.equals("INDI")) {
                    this.entitiesMatchers.get(tag).setOptions((MatcherOptions)((IndiMatcherOptions)this.selectedOptions.get("INDI")));
                } else if (tag.equals("FAM")) {
                    this.entitiesMatchers.get(tag).setOptions((MatcherOptions)((FamMatcherOptions)this.selectedOptions.get("FAM")));
                } else if (tag.equals("NOTE")) {
                    this.entitiesMatchers.get(tag).setOptions((MatcherOptions)((NoteMatcherOptions)this.selectedOptions.get("NOTE")));
                } else if (tag.equals("REPO")) {
                    this.entitiesMatchers.get(tag).setOptions((MatcherOptions)((RepositoryMatcherOptions)this.selectedOptions.get("REPO")));
                } else if (tag.equals("SOUR")) {
                    this.entitiesMatchers.get(tag).setOptions((MatcherOptions)((SourceMatcherOptions)this.selectedOptions.get("SOUR")));
                } else if (tag.equals("SUBM")) {
                    this.entitiesMatchers.get(tag).setOptions((MatcherOptions)((SubmitterMatcherOptions)this.selectedOptions.get("SUBM")));
                } else if (tag.equals("OBJE")) {
                    this.entitiesMatchers.get(tag).setOptions((MatcherOptions)((MediaMatcherOptions)this.selectedOptions.get("OBJE")));
                }
                List potentialMatches = this.entitiesMatchers.get(tag).getPotentialMatches(entities, this.progressHandle, num);
                num += entities.size();
                for (PotentialMatch e : potentialMatches) {
                    String idRight;
                    String idLeft = ((Entity)e.getLeft()).getId();
                    if (idLeft.compareToIgnoreCase(idRight = ((Entity)e.getRight()).getId()) <= 0) continue;
                    e.swap();
                }
                matchesLinkedList.addAll(potentialMatches);
                duplicatesHashMap.put(tag, potentialMatches.size());
            }
            Collections.sort(matchesLinkedList, new Comparator<PotentialMatch<? extends Entity>>(){

                @Override
                public int compare(PotentialMatch<? extends Entity> e1, PotentialMatch<? extends Entity> e2) {
                    if (e2.getCertainty() - e1.getCertainty() != 0) {
                        return e2.getCertainty() - e1.getCertainty();
                    }
                    return ((Entity)e1.getLeft()).toString(true).toLowerCase().compareTo(((Entity)e2.getLeft()).toString(true).toLowerCase());
                }
            });
            SwingUtilities.invokeLater(new Runnable(){
                ResultPanel entityViewPanel;
                DialogDescriptor checkDuplicatePanelDescriptor;
                int linkedListIndex;
                final JButton firstButton;
                final JButton previousButton;
                final JButton swapButton;
                final JButton nextButton;
                final JButton lastButton;
                final JButton mergeButton;
                final JButton cleanButton;
                final JButton closeButton;
                {
                    this.entityViewPanel = new ResultPanel(SearchDuplicatesPlugin.this.gedcom);
                    this.linkedListIndex = -1;
                    this.firstButton = new JButton();
                    this.previousButton = new JButton();
                    this.swapButton = new JButton();
                    this.nextButton = new JButton();
                    this.lastButton = new JButton();
                    this.mergeButton = new JButton();
                    this.cleanButton = new JButton();
                    this.closeButton = new JButton();
                }

                @Override
                public void run() {
                    AbstractAction doFirst = new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (firstButton.isEnabled()) {
                                this.firstButtonActionPerformed(e);
                            }
                        }
                    };
                    this.firstButton.setAction(doFirst);
                    this.firstButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcom/searchduplicates/first.png")));
                    this.firstButton.setToolTipText(Bundle.SearchDuplicatesPlugin_firstButton());
                    this.firstButton.setEnabled(false);
                    this.firstButton.setDefaultCapable(true);
                    this.firstButton.putClientProperty("defaultButton", Boolean.FALSE);
                    AbstractAction doPrevious = new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (previousButton.isEnabled()) {
                                this.previousButtonActionPerformed(e);
                            }
                        }
                    };
                    this.previousButton.setAction(doPrevious);
                    this.previousButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcom/searchduplicates/previous.png")));
                    this.previousButton.setToolTipText(Bundle.SearchDuplicatesPlugin_previousButton());
                    this.previousButton.setEnabled(false);
                    this.previousButton.setDefaultCapable(true);
                    this.previousButton.putClientProperty("defaultButton", Boolean.FALSE);
                    AbstractAction doSwap = new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (swapButton.isEnabled()) {
                                this.swapButtonActionPerformed(e);
                            }
                        }
                    };
                    this.swapButton.setAction(doSwap);
                    this.swapButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcom/searchduplicates/swap.png")));
                    this.swapButton.setToolTipText(Bundle.SearchDuplicatesPlugin_swapButton());
                    this.swapButton.setEnabled(true);
                    this.swapButton.setDefaultCapable(true);
                    this.swapButton.putClientProperty("defaultButton", Boolean.FALSE);
                    AbstractAction doNext = new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (nextButton.isEnabled()) {
                                this.nextButtonActionPerformed(e);
                            }
                        }
                    };
                    this.nextButton.setAction(doNext);
                    this.nextButton.setDefaultCapable(true);
                    this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcom/searchduplicates/next.png")));
                    this.nextButton.setToolTipText(Bundle.SearchDuplicatesPlugin_nextButton());
                    this.nextButton.setEnabled(false);
                    AbstractAction doLast = new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (lastButton.isEnabled()) {
                                this.lastButtonActionPerformed(e);
                            }
                        }
                    };
                    this.lastButton.setAction(doLast);
                    this.lastButton.setDefaultCapable(true);
                    this.lastButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcom/searchduplicates/last.png")));
                    this.lastButton.setToolTipText(Bundle.SearchDuplicatesPlugin_lastButton());
                    this.lastButton.setEnabled(false);
                    this.lastButton.putClientProperty("defaultButton", Boolean.FALSE);
                    AbstractAction doMerge = new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (mergeButton.isEnabled()) {
                                this.mergeButtonActionPerformed(e);
                            }
                        }
                    };
                    this.mergeButton.setAction(doMerge);
                    this.mergeButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcom/searchduplicates/merge.png")));
                    this.mergeButton.setToolTipText(Bundle.SearchDuplicatesPlugin_mergeButton());
                    this.mergeButton.setDefaultCapable(true);
                    this.mergeButton.setEnabled(true);
                    AbstractAction doClean = new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (cleanButton.isEnabled()) {
                                this.cleanButtonActionPerformed(e);
                            }
                        }
                    };
                    this.cleanButton.setAction(doClean);
                    this.cleanButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcom/searchduplicates/clean.png")));
                    this.cleanButton.setToolTipText(Bundle.SearchDuplicatesPlugin_cleanButton());
                    this.cleanButton.setDefaultCapable(true);
                    this.cleanButton.setEnabled(true);
                    this.closeButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcom/searchduplicates/close.png")));
                    this.closeButton.setToolTipText(Bundle.SearchDuplicatesPlugin_closeButton());
                    this.closeButton.setDefaultCapable(true);
                    this.closeButton.setEnabled(true);
                    if (matchesLinkedList.size() > 0) {
                        this.checkDuplicatePanelDescriptor = new DialogDescriptor((Object)this.entityViewPanel, "", false, new Object[]{this.firstButton, this.previousButton, this.swapButton, this.nextButton, this.lastButton, this.mergeButton, this.cleanButton, this.closeButton}, (Object)this.mergeButton, 0, null, null);
                        this.checkDuplicatePanelDescriptor.setClosingOptions(new Object[]{this.closeButton});
                        this.linkedListIndex = 0;
                        if (this.linkedListIndex < matchesLinkedList.size() - 1) {
                            this.nextButton.setEnabled(true);
                            this.lastButton.setEnabled(true);
                        }
                        this.entityViewPanel.setEntities((PotentialMatch<? extends Entity>)((PotentialMatch)matchesLinkedList.get(this.linkedListIndex)));
                        this.setTitle();
                        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.checkDuplicatePanelDescriptor);
                        this.entityViewPanel.getInputMap(2).put(KeyStroke.getKeyStroke(38, 128), "doFirst");
                        this.entityViewPanel.getInputMap(2).put(KeyStroke.getKeyStroke(37, 128), "doPrevious");
                        this.entityViewPanel.getInputMap(2).put(KeyStroke.getKeyStroke(8, 128), "doSwap");
                        this.entityViewPanel.getInputMap(2).put(KeyStroke.getKeyStroke(39, 128), "doNext");
                        this.entityViewPanel.getInputMap(2).put(KeyStroke.getKeyStroke(40, 128), "doLast");
                        this.entityViewPanel.getInputMap(2).put(KeyStroke.getKeyStroke(10, 128), "doMerge");
                        this.entityViewPanel.getInputMap(2).put(KeyStroke.getKeyStroke(32, 128), "doClean");
                        this.entityViewPanel.getActionMap().put("doFirst", doFirst);
                        this.entityViewPanel.getActionMap().put("doPrevious", doPrevious);
                        this.entityViewPanel.getActionMap().put("doSwap", doSwap);
                        this.entityViewPanel.getActionMap().put("doNext", doNext);
                        this.entityViewPanel.getActionMap().put("doLast", doLast);
                        this.entityViewPanel.getActionMap().put("doMerge", doMerge);
                        this.entityViewPanel.getActionMap().put("doClean", doClean);
                        dialog.setModal(true);
                        dialog.setVisible(true);
                        dialog.toFront();
                    } else {
                        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(SearchDuplicatesPlugin.class, (String)"CheckDuplicates.noDuplicates"), 1);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    }
                }

                private void firstButtonActionPerformed(ActionEvent evt) {
                    this.linkedListIndex = 0;
                    this.mergeButton.setEnabled(!((PotentialMatch)matchesLinkedList.get(this.linkedListIndex)).isMerged());
                    this.entityViewPanel.setEntities((PotentialMatch<? extends Entity>)((PotentialMatch)matchesLinkedList.get(this.linkedListIndex)));
                    this.setTitle();
                    if (this.linkedListIndex <= 0) {
                        this.firstButton.setEnabled(false);
                        this.previousButton.setEnabled(false);
                    }
                    if (this.linkedListIndex < matchesLinkedList.size() - 1) {
                        this.nextButton.setEnabled(true);
                        this.lastButton.setEnabled(true);
                    }
                }

                private void previousButtonActionPerformed(ActionEvent evt) {
                    --this.linkedListIndex;
                    this.mergeButton.setEnabled(!((PotentialMatch)matchesLinkedList.get(this.linkedListIndex)).isMerged());
                    this.entityViewPanel.setEntities((PotentialMatch<? extends Entity>)((PotentialMatch)matchesLinkedList.get(this.linkedListIndex)));
                    this.setTitle();
                    if (this.linkedListIndex <= 0) {
                        this.firstButton.setEnabled(false);
                        this.previousButton.setEnabled(false);
                    }
                    if (this.linkedListIndex < matchesLinkedList.size() - 1) {
                        this.nextButton.setEnabled(true);
                        this.lastButton.setEnabled(true);
                    }
                }

                private void swapButtonActionPerformed(ActionEvent evt) {
                    PotentialMatch e = (PotentialMatch)matchesLinkedList.get(this.linkedListIndex);
                    e.swap();
                    this.entityViewPanel.setEntities((PotentialMatch<? extends Entity>)e);
                }

                private void nextButtonActionPerformed(ActionEvent evt) {
                    ++this.linkedListIndex;
                    this.mergeButton.setEnabled(!((PotentialMatch)matchesLinkedList.get(this.linkedListIndex)).isMerged());
                    this.entityViewPanel.setEntities((PotentialMatch<? extends Entity>)((PotentialMatch)matchesLinkedList.get(this.linkedListIndex)));
                    this.setTitle();
                    if (this.linkedListIndex >= matchesLinkedList.size() - 1) {
                        this.nextButton.setEnabled(false);
                        this.lastButton.setEnabled(false);
                    }
                    if (this.linkedListIndex > 0) {
                        this.firstButton.setEnabled(true);
                        this.previousButton.setEnabled(true);
                    }
                }

                private void lastButtonActionPerformed(ActionEvent evt) {
                    this.linkedListIndex = matchesLinkedList.size() - 1;
                    this.mergeButton.setEnabled(!((PotentialMatch)matchesLinkedList.get(this.linkedListIndex)).isMerged());
                    this.entityViewPanel.setEntities((PotentialMatch<? extends Entity>)((PotentialMatch)matchesLinkedList.get(this.linkedListIndex)));
                    this.setTitle();
                    if (this.linkedListIndex >= matchesLinkedList.size() - 1) {
                        this.nextButton.setEnabled(false);
                        this.lastButton.setEnabled(false);
                    }
                    if (this.linkedListIndex > 0) {
                        this.firstButton.setEnabled(true);
                        this.previousButton.setEnabled(true);
                    }
                }

                private void mergeButtonActionPerformed(ActionEvent evt) {
                    boolean merge = false;
                    if (this.entityViewPanel.getSelectedProperties().isEmpty()) {
                        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(SearchDuplicatesPlugin.class, (String)"SearchDuplicatesPlugin.noSelectedProperties"), 2);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                        if (nd.getValue() == NotifyDescriptor.OK_OPTION) {
                            merge = true;
                        }
                    } else {
                        merge = true;
                    }
                    if (merge) {
                        final Entity left = (Entity)((PotentialMatch)matchesLinkedList.get(this.linkedListIndex)).getLeft();
                        final Entity right = (Entity)((PotentialMatch)matchesLinkedList.get(this.linkedListIndex)).getRight();
                        final List<Property> selectedProperties = this.entityViewPanel.getSelectedProperties();
                        try {
                            SearchDuplicatesPlugin.this.gedcom.doUnitOfWork(new UnitOfWork(){

                                public void perform(Gedcom gedcom) throws GedcomException {
                                    GedcomUtilities.MergeEntities((Gedcom)gedcom, (Entity)left, (Entity)right, (List)selectedProperties);
                                }
                            });
                        }
                        catch (GedcomException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        ((PotentialMatch)matchesLinkedList.get(this.linkedListIndex)).setMerged(true);
                        this.mergeButton.setEnabled(!((PotentialMatch)matchesLinkedList.get(this.linkedListIndex)).isMerged());
                        this.entityViewPanel.setEntities((PotentialMatch<? extends Entity>)((PotentialMatch)matchesLinkedList.get(this.linkedListIndex)));
                        this.setTitle();
                    }
                }

                private void cleanButtonActionPerformed(ActionEvent evt) {
                    Entity right = (Entity)((PotentialMatch)matchesLinkedList.get(this.linkedListIndex)).getRight();
                    this.linkedListIndex = SearchDuplicatesPlugin.this.cleanList(matchesLinkedList, right, this.linkedListIndex);
                    matchesLinkedList.remove(this.linkedListIndex);
                    if (matchesLinkedList.size() > 0) {
                        if (this.linkedListIndex >= matchesLinkedList.size() - 1) {
                            this.nextButton.setEnabled(false);
                            this.lastButton.setEnabled(false);
                            this.linkedListIndex = matchesLinkedList.size() - 1;
                        }
                        if (this.linkedListIndex <= 0) {
                            this.firstButton.setEnabled(false);
                            this.previousButton.setEnabled(false);
                            this.linkedListIndex = 0;
                        }
                        if (this.linkedListIndex > 0) {
                            this.firstButton.setEnabled(true);
                            this.previousButton.setEnabled(true);
                        }
                        if (this.linkedListIndex < matchesLinkedList.size() - 1) {
                            this.nextButton.setEnabled(true);
                            this.lastButton.setEnabled(true);
                        }
                        this.mergeButton.setEnabled(!((PotentialMatch)matchesLinkedList.get(this.linkedListIndex)).isMerged());
                        this.entityViewPanel.setEntities((PotentialMatch<? extends Entity>)((PotentialMatch)matchesLinkedList.get(this.linkedListIndex)));
                        this.setTitle();
                    } else {
                        this.closeButton.doClick();
                        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(SearchDuplicatesPlugin.class, (String)"CheckDuplicates.mergeCompleted"), 1);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    }
                }

                private void setTitle() {
                    String part1 = "";
                    part1 = ((PotentialMatch)matchesLinkedList.get(this.linkedListIndex)).isMerged() ? NbBundle.getMessage(this.getClass(), (String)"SearchDuplicatesPlugin.title.part1b") : NbBundle.getMessage(this.getClass(), (String)"SearchDuplicatesPlugin.title.part1a", (Object)((PotentialMatch)matchesLinkedList.get(this.linkedListIndex)).getCertainty());
                    String part2 = NbBundle.getMessage(this.getClass(), (String)"SearchDuplicatesPlugin.title.part2", (Object)(this.linkedListIndex + 1), (Object)matchesLinkedList.size());
                    this.checkDuplicatePanelDescriptor.setTitle(part1 + " - " + part2);
                }
            });
        }
        catch (InterruptedException ex) {
            log.log(Level.FINE, "the task was CANCELLED");
        }
    }

    private int cleanList(LinkedList<PotentialMatch<? extends Entity>> matchesLinkedList, Entity rightEntity, int linkedListIndex) {
        PotentialMatch<? extends Entity> currentMatch = matchesLinkedList.get(linkedListIndex);
        LinkedList<PotentialMatch> matchToRemove = new LinkedList<PotentialMatch>();
        for (PotentialMatch potentialMatch : matchesLinkedList) {
            if (potentialMatch.equals(currentMatch) || !potentialMatch.getLeft().equals(rightEntity) && !potentialMatch.getRight().equals(rightEntity)) continue;
            matchToRemove.add(potentialMatch);
        }
        matchesLinkedList.removeAll(matchToRemove);
        int index = 0;
        for (PotentialMatch potentialMatch : matchesLinkedList) {
            if (potentialMatch.equals(currentMatch)) {
                return index;
            }
            ++index;
        }
        return 0;
    }
}

