/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.util.Hashtable;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.WindowWaiter;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.ListDriver;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.jemmy.util.EmptyVisualizer;

public class JComboBoxOperator
extends JComponentOperator
implements Timeoutable,
Outputable {
    public static final String TEXT_DPROP = "Text";
    public static final String ITEM_PREFIX_DPROP = "Item";
    private static final long BEFORE_SELECTING_TIMEOUT = 0L;
    private static final long WAIT_LIST_TIMEOUT = 60000L;
    private TestOut output;
    private Timeouts timeouts;
    private JButtonOperator button;
    private JTextFieldOperator text;
    ListDriver driver = DriverManager.getListDriver(this.getClass());

    public JComboBoxOperator(JComboBox b) {
        super(b);
    }

    public JComboBoxOperator(ContainerOperator cont, ComponentChooser chooser, int index) {
        this((JComboBox)cont.waitSubComponent(new JComboBoxFinder(chooser), index));
        this.copyEnvironment(cont);
    }

    public JComboBoxOperator(ContainerOperator cont, ComponentChooser chooser) {
        this(cont, chooser, 0);
    }

    public JComboBoxOperator(ContainerOperator cont, String text, int index) {
        this((JComboBox)JComboBoxOperator.waitComponent(cont, (ComponentChooser)new JComboBoxByItemFinder(text, -1, cont.getComparator()), index));
        this.copyEnvironment(cont);
    }

    public JComboBoxOperator(ContainerOperator cont, String text) {
        this(cont, text, 0);
    }

    public JComboBoxOperator(ContainerOperator cont, int index) {
        this((JComboBox)JComboBoxOperator.waitComponent(cont, (ComponentChooser)new JComboBoxFinder(), index));
        this.copyEnvironment(cont);
    }

    public JComboBoxOperator(ContainerOperator cont) {
        this(cont, 0);
    }

    public static JComboBox findJComboBox(Container cont, ComponentChooser chooser, int index) {
        return (JComboBox)JComboBoxOperator.findComponent(cont, new JComboBoxFinder(chooser), index);
    }

    public static JComboBox findJComboBox(Container cont, ComponentChooser chooser) {
        return JComboBoxOperator.findJComboBox(cont, chooser, 0);
    }

    public static JComboBox findJComboBox(Container cont, String text, boolean ce, boolean ccs, int itemIndex, int index) {
        return JComboBoxOperator.findJComboBox(cont, new JComboBoxByItemFinder(text, itemIndex, new Operator.DefaultStringComparator(ce, ccs)), index);
    }

    public static JComboBox findJComboBox(Container cont, String text, boolean ce, boolean ccs, int itemIndex) {
        return JComboBoxOperator.findJComboBox(cont, text, ce, ccs, itemIndex, 0);
    }

    public static JComboBox waitJComboBox(Container cont, ComponentChooser chooser, int index) {
        return (JComboBox)JComboBoxOperator.waitComponent(cont, (ComponentChooser)new JComboBoxFinder(chooser), index);
    }

    public static JComboBox waitJComboBox(Container cont, ComponentChooser chooser) {
        return JComboBoxOperator.waitJComboBox(cont, chooser, 0);
    }

    public static JComboBox waitJComboBox(Container cont, String text, boolean ce, boolean ccs, int itemIndex, int index) {
        return JComboBoxOperator.waitJComboBox(cont, new JComboBoxByItemFinder(text, itemIndex, new Operator.DefaultStringComparator(ce, ccs)), index);
    }

    public static JComboBox waitJComboBox(Container cont, String text, boolean ce, boolean ccs, int itemIndex) {
        return JComboBoxOperator.waitJComboBox(cont, text, ce, ccs, itemIndex, 0);
    }

    @Override
    public void setTimeouts(Timeouts timeouts) {
        super.setTimeouts(timeouts);
        this.timeouts = timeouts;
    }

    @Override
    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    @Override
    public void setOutput(TestOut output) {
        super.setOutput(output);
        this.output = output;
    }

    @Override
    public TestOut getOutput() {
        return this.output;
    }

    @Override
    public void copyEnvironment(Operator anotherOperator) {
        super.copyEnvironment(anotherOperator);
        this.driver = (ListDriver)DriverManager.getDriver("drivers.list", this.getClass(), anotherOperator.getProperties());
    }

    public JButton findJButton() {
        return (JButton)this.waitSubComponent(new ComponentChooser(){

            @Override
            public boolean checkComponent(Component comp) {
                return comp instanceof JButton;
            }

            @Override
            public String getDescription() {
                return "Button for combobox popup menu opening";
            }
        });
    }

    public JTextField findJTextField() {
        return (JTextField)this.waitSubComponent(new ComponentChooser(){

            @Override
            public boolean checkComponent(Component comp) {
                return comp instanceof JTextField;
            }

            @Override
            public String getDescription() {
                return "ComboBox's text field";
            }
        });
    }

    public JButtonOperator getButton() {
        if (this.button == null) {
            this.button = new JButtonOperator(this.findJButton());
            this.button.copyEnvironment(this);
            this.button.setOutput(this.getOutput().createErrorOutput());
        }
        return this.button;
    }

    public JTextFieldOperator getTextField() {
        if (((JComboBox)this.getSource()).isEditable()) {
            this.text = new JTextFieldOperator(this.findJTextField());
            this.text.copyEnvironment(this);
            this.text.setOutput(this.getOutput().createErrorOutput());
        }
        return this.text;
    }

    public JList waitList() {
        ListWater pw = new ListWater();
        pw.setOutput(this.output.createErrorOutput());
        pw.setTimeoutsToCloneOf(this.timeouts, "JComboBoxOperator.WaitListTimeout");
        try {
            return (JList)pw.waitAction(null);
        }
        catch (InterruptedException e) {
            this.output.printStackTrace(e);
            return null;
        }
    }

    public void pushComboButton() {
        this.makeComponentVisible();
        this.getButton().push();
    }

    public int findItemIndex(String item, Operator.StringComparator comparator) {
        ComboBoxModel model = this.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            if (!comparator.equals(model.getElementAt(i).toString(), item)) continue;
            return i;
        }
        return -1;
    }

    public int waitItem(final String item, final Operator.StringComparator comparator) {
        this.getOutput().printLine("Wait item \"" + item + "\" available in combo box \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait item \"" + item + "\" available in combo box.");
        this.waitState(new ComponentChooser(){

            @Override
            public boolean checkComponent(Component comp) {
                return JComboBoxOperator.this.findItemIndex(item, comparator) > -1;
            }

            @Override
            public String getDescription() {
                return "Item \"" + item + "\" available in combo box.";
            }
        });
        return this.findItemIndex(item, comparator);
    }

    public int waitItem(final int itemIndex) {
        this.getOutput().printLine("Wait item of index \"" + itemIndex + "\" available in combo box \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait item of index \"" + itemIndex + "\" available in combo box.");
        this.waitState(new ComponentChooser(){

            @Override
            public boolean checkComponent(Component comp) {
                return JComboBoxOperator.this.getModel().getSize() > itemIndex;
            }

            @Override
            public String getDescription() {
                return "Item \"" + itemIndex + "\" available in combo box.";
            }
        });
        return itemIndex;
    }

    public void selectItem(String item, Operator.StringComparator comparator) {
        this.output.printLine("Select \"" + item + "\" item in combobox\n    : " + this.toStringSource());
        this.output.printGolden("Select \"" + item + "\" item in combobox");
        this.selectItem(this.waitItem(item, comparator));
    }

    public void selectItem(String item, boolean ce, boolean cc) {
        this.selectItem(item, new Operator.DefaultStringComparator(ce, cc));
    }

    public void selectItem(String item) {
        this.selectItem(item, this.getComparator());
    }

    public void selectItem(int index) {
        this.output.printLine("Select " + Integer.toString(index) + "'th item in combobox\n    : " + this.toStringSource());
        this.output.printGolden("Select " + Integer.toString(index) + "'th item in combobox");
        try {
            this.waitComponentEnabled();
        }
        catch (InterruptedException e) {
            throw new JemmyException("Interrupted", e);
        }
        this.driver.selectItem(this, this.waitItem(index));
        if (this.getVerification()) {
            this.waitItemSelected(index);
        }
    }

    public void typeText(String text) {
        this.makeComponentVisible();
        JTextFieldOperator tfo = this.getTextField();
        tfo.copyEnvironment(this);
        tfo.setVisualizer(new EmptyVisualizer());
        tfo.typeText(text);
    }

    public void clearText() {
        this.makeComponentVisible();
        JTextFieldOperator tfo = this.getTextField();
        tfo.copyEnvironment(this);
        tfo.setVisualizer(new EmptyVisualizer());
        tfo.clearText();
    }

    public void enterText(String text) {
        this.makeComponentVisible();
        JTextFieldOperator tfo = this.getTextField();
        tfo.copyEnvironment(this);
        tfo.setVisualizer(new EmptyVisualizer());
        tfo.enterText(text);
    }

    public void waitItemSelected(final int index) {
        this.getOutput().printLine("Wait " + Integer.toString(index) + "'th item to be selected in component \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait " + Integer.toString(index) + "'th item to be selected");
        this.waitState(new ComponentChooser(){

            @Override
            public boolean checkComponent(Component comp) {
                return JComboBoxOperator.this.getSelectedIndex() == index;
            }

            @Override
            public String getDescription() {
                return "Has " + Integer.toString(index) + "'th item selected";
            }
        });
    }

    public void waitItemSelected(String item) {
        this.getOutput().printLine("Wait \"" + item + "\" item to be selected in component \n    : " + this.toStringSource());
        this.getOutput().printGolden("WaitWait \"" + item + "\" item to be selected");
        this.waitState(new JComboBoxByItemFinder(item, -1, this.getComparator()));
    }

    @Override
    public Hashtable getDump() {
        Hashtable result = super.getDump();
        if (((JComboBox)this.getSource()).getSelectedItem() != null && ((JComboBox)this.getSource()).getSelectedItem().toString() != null) {
            result.put(TEXT_DPROP, ((JComboBox)this.getSource()).getSelectedItem().toString());
        }
        Object[] items = new String[((JComboBox)this.getSource()).getItemCount()];
        for (int i = 0; i < ((JComboBox)this.getSource()).getItemCount(); ++i) {
            if (((JComboBox)this.getSource()).getItemAt(i) == null || ((JComboBox)this.getSource()).getItemAt(i).toString() == null) continue;
            items[i] = ((JComboBox)this.getSource()).getItemAt(i).toString();
        }
        this.addToDump(result, ITEM_PREFIX_DPROP, items);
        return result;
    }

    public void actionPerformed(final ActionEvent actionEvent) {
        this.runMapping(new Operator.MapVoidAction("actionPerformed"){

            @Override
            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).actionPerformed(actionEvent);
            }
        });
    }

    public void addActionListener(final ActionListener actionListener) {
        this.runMapping(new Operator.MapVoidAction("addActionListener"){

            @Override
            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).addActionListener(actionListener);
            }
        });
    }

    public void addItem(final Object object) {
        this.runMapping(new Operator.MapVoidAction("addItem"){

            @Override
            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).addItem(object);
            }
        });
    }

    public void addItemListener(final ItemListener itemListener) {
        this.runMapping(new Operator.MapVoidAction("addItemListener"){

            @Override
            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).addItemListener(itemListener);
            }
        });
    }

    public void configureEditor(final ComboBoxEditor comboBoxEditor, final Object object) {
        this.runMapping(new Operator.MapVoidAction("configureEditor"){

            @Override
            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).configureEditor(comboBoxEditor, object);
            }
        });
    }

    public void contentsChanged(final ListDataEvent listDataEvent) {
        this.runMapping(new Operator.MapVoidAction("contentsChanged"){

            @Override
            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).contentsChanged(listDataEvent);
            }
        });
    }

    public String getActionCommand() {
        return (String)this.runMapping(new Operator.MapAction("getActionCommand"){

            @Override
            public Object map() {
                return ((JComboBox)JComboBoxOperator.this.getSource()).getActionCommand();
            }
        });
    }

    public ComboBoxEditor getEditor() {
        return (ComboBoxEditor)this.runMapping(new Operator.MapAction("getEditor"){

            @Override
            public Object map() {
                return ((JComboBox)JComboBoxOperator.this.getSource()).getEditor();
            }
        });
    }

    public Object getItemAt(final int i) {
        return this.runMapping(new Operator.MapAction("getItemAt"){

            @Override
            public Object map() {
                return ((JComboBox)JComboBoxOperator.this.getSource()).getItemAt(i);
            }
        });
    }

    public int getItemCount() {
        return this.runMapping(new Operator.MapIntegerAction("getItemCount"){

            @Override
            public int map() {
                return ((JComboBox)JComboBoxOperator.this.getSource()).getItemCount();
            }
        });
    }

    public JComboBox.KeySelectionManager getKeySelectionManager() {
        return (JComboBox.KeySelectionManager)this.runMapping(new Operator.MapAction("getKeySelectionManager"){

            @Override
            public Object map() {
                return ((JComboBox)JComboBoxOperator.this.getSource()).getKeySelectionManager();
            }
        });
    }

    public int getMaximumRowCount() {
        return this.runMapping(new Operator.MapIntegerAction("getMaximumRowCount"){

            @Override
            public int map() {
                return ((JComboBox)JComboBoxOperator.this.getSource()).getMaximumRowCount();
            }
        });
    }

    public ComboBoxModel getModel() {
        return (ComboBoxModel)this.runMapping(new Operator.MapAction("getModel"){

            @Override
            public Object map() {
                return ((JComboBox)JComboBoxOperator.this.getSource()).getModel();
            }
        });
    }

    public ListCellRenderer getRenderer() {
        return (ListCellRenderer)this.runMapping(new Operator.MapAction("getRenderer"){

            @Override
            public Object map() {
                return ((JComboBox)JComboBoxOperator.this.getSource()).getRenderer();
            }
        });
    }

    public int getSelectedIndex() {
        return this.runMapping(new Operator.MapIntegerAction("getSelectedIndex"){

            @Override
            public int map() {
                return ((JComboBox)JComboBoxOperator.this.getSource()).getSelectedIndex();
            }
        });
    }

    public Object getSelectedItem() {
        return this.runMapping(new Operator.MapAction("getSelectedItem"){

            @Override
            public Object map() {
                return ((JComboBox)JComboBoxOperator.this.getSource()).getSelectedItem();
            }
        });
    }

    public Object[] getSelectedObjects() {
        return (Object[])this.runMapping(new Operator.MapAction("getSelectedObjects"){

            @Override
            public Object map() {
                return ((JComboBox)JComboBoxOperator.this.getSource()).getSelectedObjects();
            }
        });
    }

    public ComboBoxUI getUI() {
        return (ComboBoxUI)this.runMapping(new Operator.MapAction("getUI"){

            @Override
            public Object map() {
                return ((JComboBox)JComboBoxOperator.this.getSource()).getUI();
            }
        });
    }

    public void hidePopup() {
        this.runMapping(new Operator.MapVoidAction("hidePopup"){

            @Override
            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).hidePopup();
            }
        });
    }

    public void insertItemAt(final Object object, final int i) {
        this.runMapping(new Operator.MapVoidAction("insertItemAt"){

            @Override
            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).insertItemAt(object, i);
            }
        });
    }

    public void intervalAdded(final ListDataEvent listDataEvent) {
        this.runMapping(new Operator.MapVoidAction("intervalAdded"){

            @Override
            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).intervalAdded(listDataEvent);
            }
        });
    }

    public void intervalRemoved(final ListDataEvent listDataEvent) {
        this.runMapping(new Operator.MapVoidAction("intervalRemoved"){

            @Override
            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).intervalRemoved(listDataEvent);
            }
        });
    }

    public boolean isEditable() {
        return this.runMapping(new Operator.MapBooleanAction("isEditable"){

            @Override
            public boolean map() {
                return ((JComboBox)JComboBoxOperator.this.getSource()).isEditable();
            }
        });
    }

    public boolean isLightWeightPopupEnabled() {
        return this.runMapping(new Operator.MapBooleanAction("isLightWeightPopupEnabled"){

            @Override
            public boolean map() {
                return ((JComboBox)JComboBoxOperator.this.getSource()).isLightWeightPopupEnabled();
            }
        });
    }

    public boolean isPopupVisible() {
        return this.runMapping(new Operator.MapBooleanAction("isPopupVisible"){

            @Override
            public boolean map() {
                return ((JComboBox)JComboBoxOperator.this.getSource()).isPopupVisible();
            }
        });
    }

    public void processKeyEvent(final KeyEvent keyEvent) {
        this.runMapping(new Operator.MapVoidAction("processKeyEvent"){

            @Override
            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).processKeyEvent(keyEvent);
            }
        });
    }

    public void removeActionListener(final ActionListener actionListener) {
        this.runMapping(new Operator.MapVoidAction("removeActionListener"){

            @Override
            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).removeActionListener(actionListener);
            }
        });
    }

    public void removeAllItems() {
        this.runMapping(new Operator.MapVoidAction("removeAllItems"){

            @Override
            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).removeAllItems();
            }
        });
    }

    public void removeItem(final Object object) {
        this.runMapping(new Operator.MapVoidAction("removeItem"){

            @Override
            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).removeItem(object);
            }
        });
    }

    public void removeItemAt(final int i) {
        this.runMapping(new Operator.MapVoidAction("removeItemAt"){

            @Override
            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).removeItemAt(i);
            }
        });
    }

    public void removeItemListener(final ItemListener itemListener) {
        this.runMapping(new Operator.MapVoidAction("removeItemListener"){

            @Override
            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).removeItemListener(itemListener);
            }
        });
    }

    public boolean selectWithKeyChar(final char c) {
        return this.runMapping(new Operator.MapBooleanAction("selectWithKeyChar"){

            @Override
            public boolean map() {
                return ((JComboBox)JComboBoxOperator.this.getSource()).selectWithKeyChar(c);
            }
        });
    }

    public void setActionCommand(final String string) {
        this.runMapping(new Operator.MapVoidAction("setActionCommand"){

            @Override
            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).setActionCommand(string);
            }
        });
    }

    public void setEditable(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setEditable"){

            @Override
            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).setEditable(b);
            }
        });
    }

    public void setEditor(final ComboBoxEditor comboBoxEditor) {
        this.runMapping(new Operator.MapVoidAction("setEditor"){

            @Override
            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).setEditor(comboBoxEditor);
            }
        });
    }

    public void setKeySelectionManager(final JComboBox.KeySelectionManager keySelectionManager) {
        this.runMapping(new Operator.MapVoidAction("setKeySelectionManager"){

            @Override
            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).setKeySelectionManager(keySelectionManager);
            }
        });
    }

    public void setLightWeightPopupEnabled(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setLightWeightPopupEnabled"){

            @Override
            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).setLightWeightPopupEnabled(b);
            }
        });
    }

    public void setMaximumRowCount(final int i) {
        this.runMapping(new Operator.MapVoidAction("setMaximumRowCount"){

            @Override
            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).setMaximumRowCount(i);
            }
        });
    }

    public void setModel(final ComboBoxModel comboBoxModel) {
        this.runMapping(new Operator.MapVoidAction("setModel"){

            @Override
            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).setModel(comboBoxModel);
            }
        });
    }

    public void setPopupVisible(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setPopupVisible"){

            @Override
            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).setPopupVisible(b);
            }
        });
    }

    public void setRenderer(final ListCellRenderer listCellRenderer) {
        this.runMapping(new Operator.MapVoidAction("setRenderer"){

            @Override
            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).setRenderer(listCellRenderer);
            }
        });
    }

    public void setSelectedIndex(final int i) {
        this.runMapping(new Operator.MapVoidAction("setSelectedIndex"){

            @Override
            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).setSelectedIndex(i);
            }
        });
    }

    public void setSelectedItem(final Object object) {
        this.runMapping(new Operator.MapVoidAction("setSelectedItem"){

            @Override
            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).setSelectedItem(object);
            }
        });
    }

    public void setUI(final ComboBoxUI comboBoxUI) {
        this.runMapping(new Operator.MapVoidAction("setUI"){

            @Override
            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).setUI(comboBoxUI);
            }
        });
    }

    public void showPopup() {
        this.runMapping(new Operator.MapVoidAction("showPopup"){

            @Override
            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).showPopup();
            }
        });
    }

    static {
        Timeouts.initDefault("JComboBoxOperator.BeforeSelectingTimeout", 0L);
        Timeouts.initDefault("JComboBoxOperator.WaitListTimeout", 60000L);
    }

    public static class JComboBoxByItemFinder
    implements ComponentChooser {
        String label;
        int itemIndex;
        Operator.StringComparator comparator;

        public JComboBoxByItemFinder(String lb, int ii, Operator.StringComparator comparator) {
            this.label = lb;
            this.itemIndex = ii;
            this.comparator = comparator;
        }

        public JComboBoxByItemFinder(String lb, int ii) {
            this(lb, ii, Operator.getDefaultStringComparator());
        }

        @Override
        public boolean checkComponent(Component comp) {
            if (comp instanceof JComboBox) {
                if (this.label == null) {
                    return true;
                }
                if (((JComboBox)comp).getModel().getSize() > this.itemIndex) {
                    int ii = this.itemIndex;
                    if (ii == -1 && (ii = ((JComboBox)comp).getSelectedIndex()) == -1) {
                        return false;
                    }
                    return this.comparator.equals(((JComboBox)comp).getModel().getElementAt(ii).toString(), this.label);
                }
            }
            return false;
        }

        @Override
        public String getDescription() {
            return "JComboBox with text \"" + this.label + "\" in " + new Integer(this.itemIndex).toString() + "'th item";
        }
    }

    public static class JComboBoxFinder
    extends Operator.Finder {
        public JComboBoxFinder(ComponentChooser sf) {
            super(JComboBox.class, sf);
        }

        public JComboBoxFinder() {
            super(JComboBox.class);
        }
    }

    private class ListWater
    extends Waiter {
        ComponentChooser cChooser;
        ComponentChooser pChooser;

        public ListWater() {
            this.cChooser = new ComponentChooser(){

                @Override
                public boolean checkComponent(Component comp) {
                    if (comp instanceof JList) {
                        Container cont = (Container)comp;
                        while ((cont = cont.getParent()) != null) {
                            if (!(cont instanceof ComboPopup)) continue;
                            return true;
                        }
                    }
                    return false;
                }

                @Override
                public String getDescription() {
                    return "Popup menu";
                }
            };
            this.pChooser = new PopupWindowChooser(this.cChooser);
        }

        @Override
        public Object actionProduced(Object obj) {
            Window popupWindow = null;
            popupWindow = this.pChooser.checkComponent(JComboBoxOperator.this.getWindow()) ? JComboBoxOperator.this.getWindow() : WindowWaiter.getWindow(JComboBoxOperator.this.getWindow(), this.pChooser);
            if (popupWindow != null) {
                ComponentSearcher sc = new ComponentSearcher(popupWindow);
                sc.setOutput(TestOut.getNullOutput());
                return sc.findComponent(this.cChooser);
            }
            return null;
        }

        @Override
        public String getDescription() {
            return "Wait popup expanded";
        }
    }

    private static class PopupWindowChooser
    implements ComponentChooser {
        ComponentChooser pChooser;

        public PopupWindowChooser(ComponentChooser pChooser) {
            this.pChooser = pChooser;
        }

        @Override
        public boolean checkComponent(Component comp) {
            ComponentSearcher cs = new ComponentSearcher((Container)comp);
            cs.setOutput(TestOut.getNullOutput());
            return cs.findComponent(this.pChooser) != null;
        }

        @Override
        public String getDescription() {
            return "Popup window";
        }
    }
}

