/*
 * Decompiled with CFR 0.152.
 */
package ancestris.api.search;

import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SearchCommunicator {
    private static Set<SearchCommunicator> instances = null;
    private Gedcom gedcom;

    public SearchCommunicator() {
        if (instances == null) {
            instances = new HashSet<SearchCommunicator>();
        }
        instances.add(this);
    }

    public static void unregister(SearchCommunicator sc) {
        sc.fireClosing();
        if (sc != null && instances.contains(sc)) {
            instances.remove(sc);
        }
    }

    public static List<Property> getResults(Gedcom searchGedcom) {
        if (searchGedcom == null) {
            return null;
        }
        ArrayList<Property> ret = new ArrayList<Property>();
        if (instances == null) {
            return ret;
        }
        for (SearchCommunicator instance : instances) {
            List<Property> list;
            Gedcom iGedcom = instance.getGedcom();
            if (iGedcom == null || searchGedcom.getOrigin() == null || iGedcom.getOrigin() == null || !searchGedcom.getOrigin().getName().equals(iGedcom.getOrigin().getName()) || (list = instance.getResults()) == null) continue;
            ret.addAll(list);
        }
        return ret;
    }

    public void fireNewResults() {
        if (instances == null) {
            return;
        }
        for (SearchCommunicator instance : instances) {
            Gedcom iGedcom = instance.getGedcom();
            if (this.gedcom == null || !iGedcom.getOrigin().getName().equals(this.gedcom.getOrigin().getName())) continue;
            instance.changedResults(this.gedcom);
        }
    }

    public void fireClosing() {
        if (instances == null) {
            return;
        }
        for (SearchCommunicator instance : instances) {
            Gedcom iGedcom = instance.getGedcom();
            if (this.gedcom == null || !iGedcom.getOrigin().getName().equals(this.gedcom.getOrigin().getName())) continue;
            instance.closing(this.gedcom);
        }
    }

    public void setGedcom(Gedcom gedcom) {
        this.gedcom = gedcom;
    }

    public Gedcom getGedcom() {
        return this.gedcom;
    }

    public List<Property> getResults() {
        return null;
    }

    public void changedResults(Gedcom gedcom) {
    }

    public void closing(Gedcom gedcom) {
    }
}

