/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.console;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.NbPreferences;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public class Console
implements OutputListener {
    private InputOutput io = null;
    private OutputWriter out = null;
    private OutputWriter error = null;
    private boolean displayIDELog = NbPreferences.forModule(Console.class).getBoolean("DisplayConsole", false);

    public Console(String tabName) {
        this.io = IOProvider.getDefault().getIO(tabName, true);
        this.out = this.io.getOut();
        this.error = this.io.getErr();
        if (this.displayIDELog) {
            this.io.select();
        }
    }

    public void show() {
        this.io.select();
    }

    public void println(String s) {
        try {
            this.out.println(s, null);
        }
        catch (IOException ex) {
            Logger.getLogger(Console.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void printError(String s) {
        try {
            this.error.println(s, (OutputListener)this);
        }
        catch (IOException ex) {
            Logger.getLogger(Console.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void close() {
        this.out.close();
        this.io.getErr().close();
    }

    public void outputLineSelected(OutputEvent oe) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void outputLineAction(OutputEvent oe) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void outputLineCleared(OutputEvent oe) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

