/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.geo;

import ancestris.api.place.Place;
import ancestris.api.place.PlaceFactory;
import ancestris.modules.geo.GeoFilter;
import ancestris.modules.geo.GeoInternetSearch;
import ancestris.modules.geo.GeoListTopComponent;
import ancestris.modules.geo.GeoPlacesList;
import ancestris.modules.place.geonames.GeonamesResearcher;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyLatitude;
import genj.gedcom.PropertyLongitude;
import genj.gedcom.PropertyPlace;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;
import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.geonames.InsufficientStyleException;
import org.geonames.Toponym;
import org.jxmapviewer.viewer.GeoPosition;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class GeoNodeObject {
    private final GeoPlacesList gplOwner;
    public boolean isEvent;
    private static final int GEO_CONFIRMED = 2;
    private static final int GEO_PROPOSED = 1;
    private static final int GEO_UNKNOWN = 0;
    private static final String COLOR_CONFIRMED = "color='!textText'";
    private static final String COLOR_PROPOSED = "color='#0066ff'";
    private static final String COLOR_UNKNOWN = "color='#ff2300'";
    private GeonamesResearcher geonamesResearcher = new GeonamesResearcher();
    public Place defaultPlace = this.geonamesResearcher.defaultPlace();
    private PropertyPlace place;
    private Double latitude = null;
    private Double longitude = null;
    private int geo_type = 0;
    private String EMPTY_PLACE = NbBundle.getMessage(GeoListTopComponent.class, (String)"GeoEmpty");
    private Place toponym = null;
    public boolean isInError = false;
    private String placeDisplayFormat = "";
    private String placeKey = "";
    private Property property;
    private List<GeoNodeObject> events = new ArrayList<GeoNodeObject>();
    private List<PropertyChangeListener> listeners = Collections.synchronizedList(new LinkedList());

    public GeoNodeObject(GeoPlacesList gplOwner, PropertyPlace place, boolean avoidInternetSearch) {
        this.gplOwner = gplOwner;
        this.place = place;
        this.placeDisplayFormat = gplOwner.getPlaceDisplayFormat(place);
        this.placeKey = gplOwner.getPlaceKey(place);
        this.property = place.getParent();
        this.isEvent = false;
        this.toponym = this.getToponymFromPlace(place, avoidInternetSearch);
        this.setGedcomCoordinates();
        this.events.add(new GeoNodeObject(gplOwner, place.getParent(), place));
    }

    public GeoNodeObject(GeoPlacesList gplOwner, Property event, PropertyPlace pp) {
        this.isEvent = true;
        this.events = null;
        this.property = event;
        this.place = pp;
        this.gplOwner = gplOwner;
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.listeners.add(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.listeners.remove(pcl);
    }

    public Place getToponymFromPlace(PropertyPlace place, boolean avoidInternetSearch) {
        ArrayList<Place> placeList = new ArrayList<Place>();
        boolean foundLocally = false;
        String searchedPlace = place.getPlaceToLocalFormat();
        if (searchedPlace.isEmpty()) {
            searchedPlace = place.getFirstAvailableJurisdiction().trim();
        }
        if (avoidInternetSearch && this.placeDisplayFormat.equals(this.EMPTY_PLACE)) {
            return this.defaultPlace;
        }
        if (avoidInternetSearch) {
            placeList.add(PlaceFactory.findPlace((String)searchedPlace));
            boolean bl = foundLocally = !placeList.isEmpty();
        }
        if (!foundLocally) {
            this.geonamesResearcher.searchPlace(searchedPlace, place.getNumericalJurisdictions(), place.getCity(), placeList, 1, null);
        }
        if (!foundLocally && !placeList.isEmpty()) {
            PlaceFactory.rememberPlace((String)searchedPlace, (Place)((Place)placeList.get(0)));
        }
        return placeList.isEmpty() ? null : (Place)placeList.get(0);
    }

    private void setGedcomCoordinates() {
        PropertyLongitude lon;
        this.latitude = null;
        this.longitude = null;
        PropertyLatitude lat = this.place.getLatitude(true);
        if (lat != null) {
            this.latitude = lat.getDoubleValue();
        }
        if ((lon = this.place.getLongitude(true)) != null) {
            this.longitude = lon.getDoubleValue();
        }
        if (this.latitude == null || this.longitude == null) {
            if (this.toponym == null) {
                this.toponym = this.geonamesResearcher.defaultPlace();
            }
            this.geo_type = this.toponym.getLatitude().compareTo(this.defaultPlace.getLatitude()) == 0 && this.toponym.getLongitude().compareTo(this.defaultPlace.getLongitude()) == 0 ? 0 : 1;
            this.latitude = this.toponym.getLatitude();
            this.longitude = this.toponym.getLongitude();
        } else {
            this.geo_type = 2;
        }
    }

    public boolean isUnknown() {
        return this.geo_type == 0;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public GeoPosition getGeoPosition() {
        return new GeoPosition(this.latitude.doubleValue(), this.longitude.doubleValue());
    }

    public String getTextCoordinates() {
        Double lat = this.getLatitude();
        Double lon = this.getLongitude();
        char we = 'E';
        char ns = 'N';
        if (lat < 0.0) {
            lat = -lat.doubleValue();
            ns = 'S';
        }
        if (lon < 0.0) {
            lon = -lon.doubleValue();
            we = 'W';
        }
        DecimalFormat format = new DecimalFormat("0.0");
        return ns + format.format(lat) + " " + we + format.format(lon);
    }

    public Image getIcon() {
        if (this.isEvent) {
            return this.property.getImage(true).getImage();
        }
        if (this.geo_type == 0) {
            return ImageUtilities.loadImage((String)"ancestris/modules/geo/geo_red.png");
        }
        return ImageUtilities.loadImage((String)"ancestris/modules/geo/geo.png");
    }

    public String getColor() {
        String color = COLOR_UNKNOWN;
        switch (this.geo_type) {
            case 2: {
                color = COLOR_CONFIRMED;
                break;
            }
            case 1: {
                color = COLOR_PROPOSED;
                break;
            }
            case 0: {
                color = COLOR_UNKNOWN;
            }
        }
        return color;
    }

    public String getNbOfEvents() {
        return "" + this.events.size();
    }

    public String toString() {
        if (this.isEvent) {
            return this.toDisplayString();
        }
        return this.placeKey;
    }

    public String toDisplayString() {
        if (this.isEvent) {
            return this.property.getPropertyName() + " - " + this.property.getEntity().toString();
        }
        return this.placeDisplayFormat;
    }

    public Gedcom getGedcom() {
        return this.place != null ? this.place.getGedcom() : (this.property != null ? this.property.getGedcom() : null);
    }

    public Property getProperty() {
        return this.property;
    }

    public PropertyPlace getPlace() {
        return this.place;
    }

    public String getCity() {
        return this.place == null || this.place.toString().trim().isEmpty() ? NbBundle.getMessage(GeoListTopComponent.class, (String)"GeoEmpty") : this.place.getCity();
    }

    public String getPopulation() {
        return this.getPopulation(this.toponym);
    }

    public String getPopulation(Place topo) {
        if (topo == null) {
            return "0";
        }
        Long pop = Long.getLong("0");
        pop = topo.getPopulation();
        DecimalFormat format = new DecimalFormat("#,##0");
        return pop != null ? format.format(pop) : "0";
    }

    public GeoNodeObject[] getAllEvents() {
        if (this.events != null) {
            Collections.sort(this.events, GeoListTopComponent.sortEvents);
            return this.events.toArray(new GeoNodeObject[this.events.size()]);
        }
        return null;
    }

    public GeoNodeObject[] getFilteredEvents(GeoFilter filter) {
        ArrayList<GeoNodeObject> list = new ArrayList<GeoNodeObject>();
        if (this.events != null) {
            for (GeoNodeObject event : this.events) {
                if (!filter.compliesEvent(event)) continue;
                list.add(event);
            }
            Collections.sort(list, GeoListTopComponent.sortEvents);
            return list.toArray(new GeoNodeObject[list.size()]);
        }
        return null;
    }

    public List<PropertyPlace> getEventsPlaces() {
        if (this.events != null) {
            ArrayList<PropertyPlace> propPlaces = new ArrayList<PropertyPlace>();
            for (GeoNodeObject geoNodeObject : this.events) {
                propPlaces.add(geoNodeObject.getPlace());
            }
            return propPlaces;
        }
        return null;
    }

    public void updateAllEventsPlaces(PropertyPlace place) {
        if (place != null) {
            this.gplOwner.setMapCoord(place, this.getEventsPlaces());
            this.gplOwner.launchPlacesSearch(false);
        }
    }

    public List<Indi> getIndis() {
        ArrayList<Indi> indis = new ArrayList<Indi>();
        Entity ent = this.property.getEntity();
        if (ent instanceof Indi) {
            indis.add((Indi)ent);
        } else if (ent instanceof Fam) {
            Indi indi = ((Fam)ent).getHusband();
            if (indi != null) {
                indis.add(indi);
            }
            if ((indi = ((Fam)ent).getWife()) != null) {
                indis.add(indi);
            }
        }
        return indis;
    }

    public int getEventsMaxDate() {
        int date = -99999;
        Property dateProp = this.property.getProperty("DATE");
        if (dateProp != null && dateProp instanceof PropertyDate) {
            int year = 0;
            PropertyDate p = (PropertyDate)dateProp;
            try {
                year = p.isRange() ? p.getEnd().getPointInTime((Calendar)PointInTime.GREGORIAN).getYear() : p.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN).getYear();
            }
            catch (GedcomException gedcomException) {
                // empty catch block
            }
            if (date < year) {
                date = year;
            }
        }
        return date;
    }

    public int getEventsMinDate() {
        int date = 99999;
        Property dateProp = this.property.getProperty("DATE");
        if (dateProp != null && dateProp instanceof PropertyDate) {
            int year = 0;
            PropertyDate p = (PropertyDate)dateProp;
            try {
                year = p.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN).getYear();
            }
            catch (GedcomException gedcomException) {
                // empty catch block
            }
            if (date > year) {
                date = year;
            }
        }
        return date;
    }

    public String getEventTag() {
        return this.property.getTag();
    }

    public String[] getEventsInfo(GeoFilter filter) {
        if (filter == null) {
            return null;
        }
        GeoNodeObject[] eventsOfNode = this.getFilteredEvents(filter);
        if (eventsOfNode == null) {
            return null;
        }
        String[] str = new String[]{"nb individus", "patronyme le plus fr\u00e9quent", "nb events", "births", "marriages", "deaths", "other events", "date min", "date max"};
        HashSet<String> indiv = new HashSet<String>();
        TreeMap<String, Integer> pat = new TreeMap<String, Integer>();
        int dateMin = 99999;
        int dateMax = -99999;
        int eBirths = 0;
        int eMarriages = 0;
        int eDeaths = 0;
        int eOther = 0;
        for (GeoNodeObject eventOfNode : eventsOfNode) {
            Property prop = eventOfNode.property;
            Entity ent = prop.getEntity();
            String tag = prop.getTag();
            if (filter.isBirth(tag)) {
                ++eBirths;
            } else if (filter.isMarriage(tag)) {
                ++eMarriages;
            } else if (filter.isDeath(tag)) {
                ++eDeaths;
            } else {
                ++eOther;
            }
            String patronym = "";
            if (ent instanceof Indi) {
                patronym = ((Indi)ent).getLastName();
                Integer nb = (Integer)pat.get(patronym);
                if (nb == null) {
                    nb = 0;
                }
                Integer n = nb;
                Integer n2 = nb = Integer.valueOf(nb + 1);
                pat.put(patronym, nb);
                indiv.add(ent.toString());
            } else if (ent instanceof Fam) {
                Integer n;
                Indi indi = ((Fam)ent).getHusband();
                if (indi != null && filter.compliesIndi(indi)) {
                    patronym = indi.getLastName();
                    Integer nb = (Integer)pat.get(patronym);
                    if (nb == null) {
                        nb = 0;
                    }
                    Integer n3 = nb;
                    n = nb = Integer.valueOf(nb + 1);
                    pat.put(patronym, nb);
                    indiv.add(indi.toString());
                }
                if ((indi = ((Fam)ent).getWife()) != null && filter.compliesIndi(indi)) {
                    patronym = indi.getLastName();
                    Integer nb = (Integer)pat.get(patronym);
                    if (nb == null) {
                        nb = 0;
                    }
                    Integer n4 = nb;
                    n = nb = Integer.valueOf(nb + 1);
                    pat.put(patronym, nb);
                    indiv.add(indi.toString());
                }
            }
            Property dateProp = prop.getProperty("DATE");
            if (dateProp == null || !(dateProp instanceof PropertyDate)) continue;
            int year1 = 0;
            int year2 = 0;
            PropertyDate p = (PropertyDate)dateProp;
            try {
                if (p.isRange()) {
                    year1 = p.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN).getYear();
                    year2 = p.getEnd().getPointInTime((Calendar)PointInTime.GREGORIAN).getYear();
                } else {
                    year2 = year1 = p.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN).getYear();
                }
            }
            catch (GedcomException gedcomException) {
                // empty catch block
            }
            if (dateMin > year1) {
                dateMin = year1;
            }
            if (dateMax >= year2) continue;
            dateMax = year2;
        }
        Iterator it = pat.keySet().iterator();
        Integer max = 0;
        String patMax = "";
        while (it.hasNext()) {
            String key = (String)it.next();
            Integer nb = (Integer)pat.get(key);
            if (nb <= max) continue;
            max = nb;
            patMax = key;
        }
        str[0] = "" + indiv.size();
        str[1] = "" + patMax + " (" + max + ")";
        str[2] = "" + eventsOfNode.length;
        str[3] = "" + eBirths;
        str[4] = "" + eMarriages;
        str[5] = "" + eDeaths;
        str[6] = "" + eOther;
        str[7] = "" + (dateMin == 99999 ? "-" : Integer.valueOf(dateMin));
        str[8] = "" + (dateMax == -99999 ? "-" : Integer.valueOf(dateMax));
        return str;
    }

    void addEvent(Property parent, PropertyPlace pp) {
        this.events.add(new GeoNodeObject(this.gplOwner, parent, pp));
    }

    public String displayToponym(Place place) {
        Toponym topo = place.getToponym();
        if (topo == null) {
            return "";
        }
        String spa = " ";
        String sep = "   \n";
        String name = topo.getName() == null ? NbBundle.getMessage(GeoInternetSearch.class, (String)"TXT_UNKNOWN") : topo.getName();
        StringBuilder str = new StringBuilder();
        try {
            String timezone = this.dispName("");
            if (topo.getTimezone() != null) {
                timezone = topo.getTimezone().getTimezoneId() + " (" + topo.getTimezone().getGmtOffset() + ")";
            }
            str.append(NbBundle.getMessage(GeoNodeObject.class, (String)"TXT_Name")).append(spa).append(name).append(sep);
            str.append(NbBundle.getMessage(GeoNodeObject.class, (String)"TXT_Coord")).append(spa).append(this.getTextCoordinates()).append(sep);
            str.append(NbBundle.getMessage(GeoNodeObject.class, (String)"TXT_Time")).append(spa).append(timezone).append(sep);
            str.append(sep);
            str.append(NbBundle.getMessage(GeoNodeObject.class, (String)"TXT_CdInsee")).append(spa).append(this.dispName(topo.getAdminCode4())).append(sep);
            str.append(NbBundle.getMessage(GeoNodeObject.class, (String)"TXT_Distri")).append(spa).append(this.dispName(topo.getAdminName3())).append(" (").append(this.dispName(topo.getAdminCode3())).append(")").append(sep);
            str.append(NbBundle.getMessage(GeoNodeObject.class, (String)"TXT_Dept")).append(spa).append(this.dispName(topo.getAdminName2())).append(" (").append(this.dispName(topo.getAdminCode2())).append(")").append(sep);
            str.append(NbBundle.getMessage(GeoNodeObject.class, (String)"TXT_Region")).append(spa).append(this.dispName(topo.getAdminName1())).append(" (").append(this.dispName(topo.getAdminCode1())).append(")").append(sep);
            str.append(NbBundle.getMessage(GeoNodeObject.class, (String)"TXT_Cntry")).append(spa).append(this.dispName(topo.getCountryName())).append(sep);
            str.append(sep);
            str.append(NbBundle.getMessage(GeoNodeObject.class, (String)"TXT_Pop")).append(spa).append(topo.getPopulation());
            str.append(sep);
            str.append(" ");
        }
        catch (InsufficientStyleException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return str.toString();
    }

    private String dispName(String str) {
        return str == null || str.isEmpty() ? "-" : str;
    }
}

