/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.geo;

import ancestris.modules.editors.geoplace.PlaceEditor;
import ancestris.modules.geo.GeoMapTopComponent;
import ancestris.modules.geo.GeoNodeObject;
import genj.gedcom.Property;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.LayoutStyle;
import org.openide.util.NbBundle;

public class HoverPanel
extends JPanel {
    private GeoMapTopComponent parent = null;
    private GeoNodeObject[] selectedMarkers = null;
    private GeoNodeObject currentGno;
    private Color backgroundColor;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JScrollBar jScrollBar1;

    public HoverPanel(GeoMapTopComponent parent) {
        this.parent = parent;
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.initComponents();
        this.setMouseListener();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.backgroundColor);
        g.fill3DRect(10, 0, this.getWidth() - 10, this.getHeight(), true);
        Polygon triangle = new Polygon();
        triangle.addPoint(0, 35);
        triangle.addPoint(10, 20);
        triangle.addPoint(10, 50);
        g.fillPolygon(triangle);
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.jLabel16 = new JLabel();
        this.jLabel17 = new JLabel();
        this.jLabel18 = new JLabel();
        this.jLabel19 = new JLabel();
        this.jLabel20 = new JLabel();
        this.jLabel21 = new JLabel();
        this.jLabel22 = new JLabel();
        this.jLabel23 = new JLabel();
        this.jScrollBar1 = new JScrollBar();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.setBackground(new Color(254, 254, 254));
        this.setAlignmentX(0.0f);
        this.setAlignmentY(0.0f);
        this.setOpaque(false);
        this.jLabel2.setFont(new Font("DejaVu Sans", 1, 12));
        this.jLabel2.setForeground(new Color(254, 254, 254));
        this.jLabel2.setText(NbBundle.getMessage(HoverPanel.class, (String)"HoverPanel.jLabel2.text"));
        this.jLabel2.setAlignmentY(0.0f);
        this.jLabel3.setForeground(new Color(254, 254, 254));
        this.jLabel3.setText(NbBundle.getMessage(HoverPanel.class, (String)"HoverPanel.jLabel3.text"));
        this.jLabel3.setAlignmentY(0.0f);
        this.jLabel4.setForeground(new Color(254, 254, 254));
        this.jLabel4.setText(NbBundle.getMessage(HoverPanel.class, (String)"HoverPanel.jLabel4.text"));
        this.jLabel4.setAlignmentY(0.0f);
        this.jLabel6.setFont(new Font("DejaVu Sans", 2, 12));
        this.jLabel6.setForeground(new Color(254, 254, 254));
        this.jLabel6.setText(NbBundle.getMessage(HoverPanel.class, (String)"HoverPanel.jLabel6.text"));
        this.jLabel6.setAlignmentY(0.0f);
        this.jLabel5.setFont(new Font("DejaVu Sans", 1, 12));
        this.jLabel5.setForeground(new Color(254, 254, 254));
        this.jLabel5.setText(NbBundle.getMessage(HoverPanel.class, (String)"HoverPanel.jLabel5.text"));
        this.jLabel5.setAlignmentY(0.0f);
        this.jLabel7.setFont(new Font("DejaVu Sans", 1, 12));
        this.jLabel7.setForeground(new Color(254, 254, 254));
        this.jLabel7.setText(NbBundle.getMessage(HoverPanel.class, (String)"HoverPanel.jLabel7.text"));
        this.jLabel7.setAlignmentY(0.0f);
        this.jLabel8.setFont(new Font("DejaVu Sans", 1, 12));
        this.jLabel8.setForeground(new Color(254, 254, 254));
        this.jLabel8.setText(NbBundle.getMessage(HoverPanel.class, (String)"HoverPanel.jLabel8.text"));
        this.jLabel8.setAlignmentY(0.0f);
        this.jLabel9.setFont(new Font("DejaVu Sans", 1, 12));
        this.jLabel9.setForeground(new Color(254, 254, 254));
        this.jLabel9.setText(NbBundle.getMessage(HoverPanel.class, (String)"HoverPanel.jLabel9.text"));
        this.jLabel9.setAlignmentY(0.0f);
        this.jLabel10.setForeground(new Color(254, 254, 254));
        this.jLabel10.setText(NbBundle.getMessage(HoverPanel.class, (String)"HoverPanel.jLabel10.text"));
        this.jLabel11.setForeground(new Color(254, 254, 254));
        this.jLabel11.setText(NbBundle.getMessage(HoverPanel.class, (String)"HoverPanel.jLabel11.text"));
        this.jLabel12.setForeground(new Color(254, 254, 254));
        this.jLabel12.setText(NbBundle.getMessage(HoverPanel.class, (String)"HoverPanel.jLabel12.text"));
        this.jLabel13.setForeground(new Color(254, 254, 254));
        this.jLabel13.setText(NbBundle.getMessage(HoverPanel.class, (String)"HoverPanel.jLabel13.text"));
        this.jLabel14.setForeground(new Color(254, 254, 254));
        this.jLabel14.setText(NbBundle.getMessage(HoverPanel.class, (String)"HoverPanel.jLabel14.text"));
        this.jLabel15.setFont(new Font("DejaVu Sans", 1, 12));
        this.jLabel15.setForeground(new Color(254, 254, 254));
        this.jLabel15.setText(NbBundle.getMessage(HoverPanel.class, (String)"HoverPanel.jLabel15.text"));
        this.jLabel16.setForeground(new Color(254, 254, 254));
        this.jLabel16.setText(NbBundle.getMessage(HoverPanel.class, (String)"HoverPanel.jLabel16.text"));
        this.jLabel17.setForeground(new Color(254, 254, 254));
        this.jLabel17.setText(NbBundle.getMessage(HoverPanel.class, (String)"HoverPanel.jLabel17.text"));
        this.jLabel18.setForeground(new Color(254, 254, 254));
        this.jLabel18.setText(NbBundle.getMessage(HoverPanel.class, (String)"HoverPanel.jLabel18.text"));
        this.jLabel19.setForeground(new Color(254, 254, 254));
        this.jLabel19.setText(NbBundle.getMessage(HoverPanel.class, (String)"HoverPanel.jLabel19.text"));
        this.jLabel20.setForeground(new Color(254, 254, 254));
        this.jLabel20.setText(NbBundle.getMessage(HoverPanel.class, (String)"HoverPanel.jLabel20.text"));
        this.jLabel21.setForeground(new Color(254, 254, 254));
        this.jLabel21.setText(NbBundle.getMessage(HoverPanel.class, (String)"HoverPanel.jLabel21.text"));
        this.jLabel22.setForeground(new Color(254, 254, 254));
        this.jLabel22.setText(NbBundle.getMessage(HoverPanel.class, (String)"HoverPanel.jLabel22.text"));
        this.jLabel23.setForeground(new Color(254, 254, 254));
        this.jLabel23.setText(NbBundle.getMessage(HoverPanel.class, (String)"HoverPanel.jLabel23.text"));
        this.jScrollBar1.setBackground(new Color(254, 254, 254));
        this.jScrollBar1.setForeground(new Color(255, 250, 250));
        this.jScrollBar1.setPreferredSize(new Dimension(14, 48));
        this.jScrollBar1.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent evt) {
                HoverPanel.this.jScrollBar1AdjustmentValueChanged(evt);
            }
        });
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/geo/edit.png")));
        this.jButton1.setText(NbBundle.getMessage(HoverPanel.class, (String)"HoverPanel.jButton1.text"));
        this.jButton1.setToolTipText(NbBundle.getMessage(HoverPanel.class, (String)"HoverPanel.jButton1.toolTipText"));
        this.jButton1.setMaximumSize(new Dimension(20, 20));
        this.jButton1.setMinimumSize(new Dimension(20, 20));
        this.jButton1.setPreferredSize(new Dimension(20, 20));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HoverPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/geo/GoToList.png")));
        this.jButton2.setText(NbBundle.getMessage(HoverPanel.class, (String)"HoverPanel.jButton2.text"));
        this.jButton2.setToolTipText(NbBundle.getMessage(HoverPanel.class, (String)"HoverPanel.jButton2.toolTipText"));
        this.jButton2.setPreferredSize(new Dimension(20, 20));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HoverPanel.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(25, 25, 25).addComponent(this.jScrollBar1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel11).addComponent(this.jLabel12).addComponent(this.jLabel10).addComponent(this.jLabel17).addComponent(this.jLabel16).addComponent(this.jLabel19).addComponent(this.jLabel18).addComponent(this.jLabel13)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel14).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel15)).addComponent(this.jLabel5).addComponent(this.jLabel7).addComponent(this.jLabel8).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel21).addComponent(this.jLabel20).addComponent(this.jLabel23).addComponent(this.jLabel22))))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addGap(18, 18, 18).addComponent(this.jLabel6)).addGroup(layout.createSequentialGroup().addComponent(this.jButton1, -2, -1, -2).addGap(2, 2, 2).addComponent(this.jButton2, -2, -1, -2).addGap(4, 4, 4).addComponent(this.jLabel2))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollBar1, -1, 177, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButton2, -2, -1, -2).addComponent(this.jButton1, -2, -1, -2).addComponent(this.jLabel2)).addGap(2, 2, 2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jLabel6).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.jLabel5)).addGap(1, 1, 1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.jLabel7)).addGap(1, 1, 1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel12).addComponent(this.jLabel8)).addGap(1, 1, 1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel16).addComponent(this.jLabel20)).addGap(1, 1, 1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel17).addComponent(this.jLabel21)).addGap(1, 1, 1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel18).addComponent(this.jLabel22)).addGap(1, 1, 1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel19).addComponent(this.jLabel23)).addGap(1, 1, 1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel13).addComponent(this.jLabel9).addComponent(this.jLabel14).addComponent(this.jLabel15)))).addContainerGap()));
    }

    private void jScrollBar1AdjustmentValueChanged(AdjustmentEvent evt) {
        this.currentGno = this.selectedMarkers[this.jScrollBar1.getValue()];
        this.displayInfo();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        new PlaceEditor().edit((Property)this.currentGno.getPlace(), (Object)this.currentGno.getGeoPosition());
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.parent.showListAtLocation(this.currentGno);
    }

    public void setPanel(GeoNodeObject gno, Color color) {
        GeoNodeObject[] markers = this.parent.getMarkers();
        if (markers == null) {
            return;
        }
        this.backgroundColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), 200);
        Double lat = gno.getLatitude();
        Double lon = gno.getLongitude();
        ArrayList<GeoNodeObject> list = new ArrayList<GeoNodeObject>();
        for (int i = 0; i < markers.length; ++i) {
            GeoNodeObject geoNodeObject = markers[i];
            if (!geoNodeObject.getLatitude().equals(lat) || !geoNodeObject.getLongitude().equals(lon) || !this.parent.getFilter().compliesNode(geoNodeObject)) continue;
            list.add(geoNodeObject);
        }
        this.selectedMarkers = list.toArray(new GeoNodeObject[list.size()]);
        if (this.selectedMarkers == null || this.selectedMarkers.length == 0) {
            return;
        }
        this.currentGno = this.selectedMarkers[0];
        this.jScrollBar1.setVisible(this.selectedMarkers.length > 1);
        this.jScrollBar1.setUnitIncrement(1);
        this.jScrollBar1.setMinimum(0);
        this.jScrollBar1.setMaximum(this.selectedMarkers.length);
        this.jScrollBar1.setValue(0);
        this.displayInfo();
    }

    private void displayInfo() {
        this.jLabel2.setText("<html>" + this.currentGno.toDisplayString() + "</html>");
        this.jLabel6.setText("(" + this.currentGno.getTextCoordinates() + ")");
        this.jLabel4.setText(this.currentGno.getPopulation());
        String[] info = this.currentGno.getEventsInfo(this.parent.getFilter());
        this.jLabel5.setText(info[0]);
        this.jLabel7.setText(info[1]);
        this.jLabel8.setText(info[2]);
        this.jLabel20.setText(info[3]);
        this.jLabel21.setText(info[4]);
        this.jLabel22.setText(info[5]);
        this.jLabel23.setText(info[6]);
        this.jLabel9.setText(info[7]);
        this.jLabel15.setText(info[8]);
    }

    private void setMouseListener() {
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (HoverPanel.this.currentGno == null || e.getClickCount() < 2) {
                    return;
                }
                HoverPanel.this.parent.showListAtLocation(HoverPanel.this.currentGno);
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
    }
}

