/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.utilities;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.gedcom.PropertyForeignXRef;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;

public class GedcomUtilities {
    private static final Logger LOG = Logger.getLogger(GedcomUtilities.class.getName(), null);
    public static final int ENT_ALL = 0;
    public static final int ENT_INDI = 1;
    public static final int ENT_FAM = 2;
    public static final int ENT_NOTE = 3;
    public static final int ENT_SOUR = 4;
    public static final int ENT_SUBM = 5;
    public static final int ENT_REPO = 6;
    public static final String[] entityTypes = new String[]{"All", "INDI", "FAM", "NOTE", "SOUR", "SUBM", "REPO"};

    public static void deleteTags(Gedcom gedcom, String tagToRemove, int entityType) {
        LOG.log(Level.FINER, "deleting_tag {0}", tagToRemove);
        int iCounter = 0;
        Collection entities = entityType == 0 ? gedcom.getEntities() : gedcom.getEntities(entityTypes[entityType]);
        for (Entity entity : entities) {
            List<Property> propsToDelete = GedcomUtilities.getPropertiesRecursively((Property)entity, tagToRemove);
            for (Property prop : propsToDelete) {
                Property parent;
                if (prop == null || (parent = prop.getParent()) == null) continue;
                String propText = parent.getTag() + " " + tagToRemove + " '" + prop.toString() + "'";
                parent.delProperty(prop);
                ++iCounter;
                LOG.log(Level.FINER, "deleting_tag {0} {1} {2}", new Object[]{entity.getTag(), entity.toString(), propText});
            }
        }
        LOG.log(Level.FINER, "DeletedNb {0}", iCounter);
    }

    private static List<Property> getPropertiesRecursively(Property parent, String tag) {
        Property[] children = parent.getProperties();
        ArrayList<Property> propertiesList = new ArrayList<Property>();
        if (parent.getTag().compareTo(tag) == 0) {
            propertiesList.add(parent);
        }
        for (int c = 0; c < children.length; ++c) {
            Property child = children[c];
            propertiesList.addAll(GedcomUtilities.getPropertiesRecursively(child, tag));
        }
        return propertiesList;
    }

    public static void MergeEntities(Gedcom gedcom, Entity dest, Entity src, List<Property> allProperties) {
        LOG.log(Level.FINER, "Merging {0} with {1}", new Object[]{src.getId(), dest.getId()});
        ArrayList<Property> properties = new ArrayList<Property>();
        boolean found = false;
        for (Property prop : allProperties) {
            if (prop == null) continue;
            found = false;
            for (Property parent : GedcomUtilities.getAncestors(prop)) {
                if (!allProperties.contains(parent)) continue;
                found = true;
                break;
            }
            if (found) continue;
            properties.add(prop);
        }
        for (Property prop : properties) {
            TagPath tagPath = prop.getParent().getPath();
            Property propDest = dest.getProperty(tagPath);
            if (propDest == null) {
                dest.setValue(tagPath, "");
                propDest = dest.getProperty(tagPath);
            }
            try {
                GedcomUtilities.movePropertyRecursively(prop, propDest);
            }
            catch (GedcomException ex) {
                LOG.log(Level.SEVERE, "Unexpected Gedcom exception {0}", ex);
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        gedcom.deleteEntity(src);
    }

    private static List<Property> getAncestors(Property prop) {
        ArrayList<Property> ancestors = new ArrayList<Property>();
        for (Property parent = prop.getParent(); parent != null; parent = parent.getParent()) {
            ancestors.add(parent);
        }
        return ancestors;
    }

    public static void movePropertyRecursively(Property propertySrc, Property parentPropertyDest) throws GedcomException {
        Property propertyDest;
        if (propertySrc.getMetaProperty().isSingleton() && (propertyDest = parentPropertyDest.getProperty(propertySrc.getTag())) != null) {
            parentPropertyDest.delProperty(propertyDest);
        }
        if (propertySrc instanceof PropertyForeignXRef) {
            PropertyForeignXRef pfxref = (PropertyForeignXRef)propertySrc;
            PropertyXRef pxref = pfxref.getTarget();
            pxref.unlink();
            pxref.setValue(parentPropertyDest.getEntity().getId());
            pxref.link();
        } else {
            int n = parentPropertyDest.getNoOfProperties();
            propertyDest = parentPropertyDest.addProperty(propertySrc.getTag(), propertySrc.getValue(), n);
            if (propertyDest instanceof PropertyXRef) {
                ((PropertyXRef)propertyDest).link();
            }
            for (Property children : propertySrc.getProperties()) {
                GedcomUtilities.movePropertyRecursively(children, propertyDest);
            }
            if (propertySrc instanceof PropertyXRef) {
                PropertyXRef pxref = (PropertyXRef)propertySrc;
                Entity ent = pxref.getTargetEntity();
                ent.delProperty((Property)pxref.getTarget());
                propertySrc = null;
            } else {
                propertySrc.getParent().delProperty(propertySrc);
            }
        }
    }

    public static <T> List<T> searchProperties(Gedcom gedcom, Class<T> type, int entityType) {
        LOG.log(Level.FINER, "Searching for property {0}", type.getClass());
        Collection entities = entityType == 0 ? gedcom.getEntities() : gedcom.getEntities(entityTypes[entityType]);
        ArrayList<T> foundProperties = new ArrayList<T>();
        for (Entity entity : entities) {
            foundProperties.addAll(GedcomUtilities.searchPropertiesRecursively((Property)entity, type));
        }
        LOG.log(Level.FINER, "found  {0}", foundProperties.size());
        return foundProperties;
    }

    private static <T> List<T> searchPropertiesRecursively(Property parent, Class<T> type) {
        ArrayList<Object> foundProperties = new ArrayList<Object>();
        for (Property child : parent.getProperties()) {
            if (type.isAssignableFrom(child.getClass())) {
                foundProperties.add(child);
            }
            foundProperties.addAll(GedcomUtilities.searchPropertiesRecursively(child, type));
        }
        return foundProperties;
    }
}

