/*
 * Decompiled with CFR 0.152.
 */
package ancestris.api.place;

import ancestris.api.place.Place;
import genj.gedcom.PropertyLatitude;
import genj.gedcom.PropertyLongitude;
import genj.gedcom.PropertyPlace;
import java.util.StringTokenizer;
import org.geonames.Toponym;
import org.jxmapviewer.viewer.GeoPosition;
import org.openide.util.NbPreferences;

public class PlaceFactory
implements Place {
    private PropertyPlace propertyPlace = null;
    private Double latitude;
    private Double longitude = 0.0;
    private Long population = 0L;

    public PlaceFactory(PropertyPlace place) {
        this.propertyPlace = place;
        if (this.propertyPlace != null) {
            PropertyLongitude pLon = this.propertyPlace.getLongitude(true);
            this.longitude = pLon != null ? pLon.getDoubleValue() : null;
            PropertyLatitude pLat = this.propertyPlace.getLatitude(true);
            this.latitude = pLat != null ? pLat.getDoubleValue() : null;
        }
    }

    public PlaceFactory(PropertyPlace place, GeoPosition geoPoint) {
        this.propertyPlace = place;
        this.latitude = geoPoint.getLatitude();
        this.longitude = geoPoint.getLongitude();
    }

    private PlaceFactory(Double lat, Double lon, Long pop) {
        this.propertyPlace = null;
        this.latitude = lat;
        this.longitude = lon;
        this.population = pop;
    }

    @Override
    public int compareTo(Place that) {
        if (this.propertyPlace == null) {
            return -1;
        }
        return that.getValueStartingWithCity().compareToIgnoreCase(this.propertyPlace.getValueStartingWithCity());
    }

    @Override
    public Double getLongitude() {
        return this.longitude;
    }

    @Override
    public Double getLatitude() {
        return this.latitude;
    }

    @Override
    public Long getPopulation() {
        return this.population;
    }

    @Override
    public Toponym getToponym() {
        return null;
    }

    @Override
    public String getCity() {
        if (this.propertyPlace == null) {
            return "";
        }
        return this.propertyPlace.getCity();
    }

    @Override
    public String getFirstAvailableJurisdiction() {
        if (this.propertyPlace == null) {
            return "";
        }
        return this.propertyPlace.getFirstAvailableJurisdiction();
    }

    @Override
    public String[] getFormat() {
        if (this.propertyPlace == null) {
            return null;
        }
        return this.propertyPlace.getFormat();
    }

    @Override
    public String getFormatAsString() {
        if (this.propertyPlace == null) {
            return "";
        }
        return this.propertyPlace.getFormatAsString();
    }

    @Override
    public String getJurisdiction(int hierarchyLevel) {
        if (this.propertyPlace == null) {
            return "";
        }
        return this.propertyPlace.getJurisdiction(hierarchyLevel);
    }

    @Override
    public String[] getJurisdictions() {
        if (this.propertyPlace == null) {
            return null;
        }
        return this.propertyPlace.getJurisdictions();
    }

    @Override
    public String getValueStartingWithCity() {
        if (this.propertyPlace == null) {
            return "";
        }
        return this.propertyPlace.getValueStartingWithCity();
    }

    @Override
    public void setFormatAsString(boolean global, String format) {
        if (this.propertyPlace == null) {
            return;
        }
        this.propertyPlace.setFormatAsString(global, format);
    }

    @Override
    public String getPlaceToLocalFormat() {
        if (this.propertyPlace == null) {
            return "";
        }
        return this.propertyPlace.getPlaceToLocalFormat();
    }

    public static Place findPlace(String searchedPlaceKey) {
        String code = NbPreferences.forModule(PlaceFactory.class).get(searchedPlaceKey, null);
        return PlaceFactory.Code2Place(code);
    }

    public static void rememberPlace(String searchedPlaceKey, Place place) {
        NbPreferences.forModule(PlaceFactory.class).put(searchedPlaceKey, PlaceFactory.Place2Code(place));
    }

    private static Place Code2Place(String code) {
        if (code == null || code.isEmpty()) {
            return null;
        }
        Double lat = 0.0;
        Double lon = 0.0;
        Long pop = 0L;
        try {
            StringTokenizer tokens = new StringTokenizer(code, ";");
            if (tokens.hasMoreTokens()) {
                lat = Double.parseDouble(tokens.nextToken());
            }
            if (tokens.hasMoreTokens()) {
                lon = Double.parseDouble(tokens.nextToken());
            }
            if (tokens.hasMoreTokens()) {
                pop = Long.parseLong(tokens.nextToken());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new PlaceFactory(lat, lon, pop);
    }

    private static String Place2Code(Place place) {
        if (place == null) {
            return "";
        }
        return place.getLatitude() + ";" + place.getLongitude() + ";" + place.getPopulation();
    }
}

