/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.history;

import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.gedcom.GedcomFileListener;
import ancestris.modules.gedcom.history.GedcomHistory;
import ancestris.modules.gedcom.history.GedcomHistoryTopComponent;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.openide.modules.Places;
import org.openide.util.Exceptions;
import org.openide.windows.TopComponent;

public class GedcomHistoryPlugin
extends AncestrisPlugin
implements GedcomFileListener {
    private static final Logger log = Logger.getLogger(GedcomHistoryPlugin.class.getName());
    private static final HashMap<Gedcom, GedcomHistory> gedcomHistoryMap = new HashMap();

    public void commitRequested(Context context) {
        String gedcomName = context.getGedcom().getName().substring(0, context.getGedcom().getName().lastIndexOf(".") == -1 ? context.getGedcom().getName().length() : context.getGedcom().getName().lastIndexOf("."));
        log.log(Level.FINE, "Commit requested {0}", context.getGedcom().getName());
        File cacheSubdirectory = Places.getCacheSubdirectory((String)GedcomHistoryPlugin.class.getCanonicalName());
        File historyFile = new File(cacheSubdirectory.getAbsolutePath() + System.getProperty("file.separator") + gedcomName + ".hist");
        GedcomHistory gedcomHistory = gedcomHistoryMap.get(context.getGedcom());
        if (gedcomHistory != null && !gedcomHistory.getHistoryList().isEmpty()) {
            int maxSize;
            int size = gedcomHistory.getHistoryList().size();
            if (size > (maxSize = 10000)) {
                gedcomHistory.getHistoryList().subList(0, size - maxSize).clear();
            }
            log.log(Level.FINE, "Saving history File {0}", historyFile.getAbsoluteFile());
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{GedcomHistory.class});
                Marshaller m = jaxbContext.createMarshaller();
                m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                m.marshal((Object)gedcomHistory, (Writer)new FileWriter(historyFile));
            }
            catch (JAXBException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public void gedcomClosed(Gedcom gedcom) {
        String gedcomName = gedcom.getName().substring(0, gedcom.getName().lastIndexOf(".") == -1 ? gedcom.getName().length() : gedcom.getName().lastIndexOf("."));
        log.log(Level.FINE, "Closing gedcom {0}", gedcomName);
        if (gedcomHistoryMap.get(gedcom) != null) {
            gedcom.removeGedcomListener((GedcomListener)gedcomHistoryMap.get(gedcom));
            gedcomHistoryMap.remove(gedcom);
            Set openedTopComponent = TopComponent.getRegistry().getOpened();
            for (TopComponent topComponent : openedTopComponent) {
                if (!(topComponent instanceof GedcomHistoryTopComponent) || !((GedcomHistoryTopComponent)topComponent).getGedcom().equals(gedcom)) continue;
                topComponent.close();
            }
        } else {
            log.log(Level.FINE, "No history register found for gedcom {0}", gedcomName);
        }
    }

    public void gedcomOpened(Gedcom gedcom) {
        String gedcomName = gedcom.getName().substring(0, gedcom.getName().lastIndexOf(".") == -1 ? gedcom.getName().length() : gedcom.getName().lastIndexOf("."));
        if (!gedcomHistoryMap.containsKey(gedcom)) {
            File cacheSubdirectory = Places.getCacheSubdirectory((String)GedcomHistoryPlugin.class.getCanonicalName());
            File historyFile = new File(cacheSubdirectory.getAbsolutePath() + System.getProperty("file.separator") + gedcomName + ".hist");
            log.log(Level.FINE, "Opening history file {0}", historyFile.getAbsoluteFile());
            if (historyFile.exists()) {
                try {
                    JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{GedcomHistory.class});
                    Unmarshaller um = context.createUnmarshaller();
                    try {
                        GedcomHistory gedcomHistory = (GedcomHistory)um.unmarshal((Reader)new FileReader(historyFile));
                        gedcomHistoryMap.put(gedcom, gedcomHistory);
                        gedcom.addGedcomListener((GedcomListener)gedcomHistoryMap.get(gedcom));
                    }
                    catch (FileNotFoundException ex) {
                        gedcomHistoryMap.put(gedcom, new GedcomHistory(gedcomName));
                        gedcom.addGedcomListener((GedcomListener)gedcomHistoryMap.get(gedcom));
                    }
                }
                catch (JAXBException ex) {
                    gedcomHistoryMap.put(gedcom, new GedcomHistory(gedcomName));
                    gedcom.addGedcomListener((GedcomListener)gedcomHistoryMap.get(gedcom));
                }
            } else {
                gedcomHistoryMap.put(gedcom, new GedcomHistory(gedcomName));
                gedcom.addGedcomListener((GedcomListener)gedcomHistoryMap.get(gedcom));
            }
        } else {
            log.log(Level.FINE, "History file already open for gedcom {0}", gedcomName);
        }
    }

    public GedcomHistory getGedcomHistory(Gedcom gedcom) {
        return gedcomHistoryMap.get(gedcom);
    }
}

