/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.history;

import ancestris.modules.gedcom.history.EntityHistory;
import ancestris.modules.gedcom.history.GedcomHistory;
import genj.gedcom.Gedcom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import org.openide.util.NbBundle;

class GedcomHistoryTableModel
extends AbstractTableModel {
    public static final int DATE = 0;
    public static final int ENTITY_TAG = 1;
    public static final int ENTITY_ID = 2;
    public static final int ACTION = 3;
    public static final int PROPERTY = 4;
    public static final int OLD_VALUE = 5;
    public static final int NEW_VALUE = 6;
    private String[] columnNames = new String[]{NbBundle.getMessage(this.getClass(), (String)"HistoryTableModel.columnNames.date"), NbBundle.getMessage(this.getClass(), (String)"HistoryTableModel.columnNames.entityTag"), NbBundle.getMessage(this.getClass(), (String)"HistoryTableModel.columnNames.entityId"), NbBundle.getMessage(this.getClass(), (String)"HistoryTableModel.columnNames.action"), NbBundle.getMessage(this.getClass(), (String)"HistoryTableModel.columnNames.Property"), NbBundle.getMessage(this.getClass(), (String)"HistoryTableModel.columnNames.oldValue"), NbBundle.getMessage(this.getClass(), (String)"HistoryTableModel.columnNames.newValue")};
    private ArrayList<EntityHistory> gedcomHistoryList = null;
    private final Gedcom gedcom;

    public GedcomHistoryTableModel(GedcomHistory gedcomHistory, Gedcom gedcom) {
        if (gedcomHistory == null) {
            throw new IllegalArgumentException("gedcomHistory can't be null");
        }
        if (gedcomHistory.getHistoryList() == null) {
            throw new IllegalArgumentException("gedcomHistoryList can't be null");
        }
        this.gedcomHistoryList = gedcomHistory.getHistoryList();
        this.gedcom = gedcom;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.gedcomHistoryList == null ? 0 : this.gedcomHistoryList.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.gedcomHistoryList != null) {
            EntityHistory entityHistory = this.gedcomHistoryList.get(row);
            switch (col) {
                case 0: {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm");
                    return dateFormat.format(entityHistory.getDate().getTime());
                }
                case 1: {
                    return Gedcom.getName((String)entityHistory.getEntityTag());
                }
                case 2: {
                    return entityHistory.getEntityId();
                }
                case 3: {
                    return NbBundle.getMessage(this.getClass(), (String)("HistoryTableModel.Action." + entityHistory.getAction()));
                }
                case 4: {
                    return entityHistory.getPropertyPath();
                }
                case 5: {
                    return entityHistory.getOldValue();
                }
                case 6: {
                    return entityHistory.getNewValue();
                }
            }
            return "";
        }
        return "";
    }

    public Class<? extends Object> getColumnClass(int c) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
    }
}

