/*
 * Decompiled with CFR 0.152.
 */
package genj.search;

import genj.search.Matcher;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class SimpleMatcher
extends Matcher {
    private String[] words;

    @Override
    public void init(String pattern) {
        StringTokenizer tokens = new StringTokenizer(pattern.toLowerCase());
        this.words = new String[tokens.countTokens()];
        for (int i = 0; i < this.words.length; ++i) {
            this.words[i] = tokens.nextToken();
        }
    }

    @Override
    protected void match(String input, List<Matcher.Match> result) {
        String removedAccents = Normalizer.normalize(input, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "").toLowerCase();
        ArrayList<Matcher.Match> matches = new ArrayList<Matcher.Match>(this.words.length);
        for (int i = 0; i < this.words.length; ++i) {
            int start = removedAccents.indexOf(this.words[i]);
            if (start < 0) {
                return;
            }
            while (start >= 0) {
                int end = start + this.words[i].length();
                matches.add(new Matcher.Match(start, end - start));
                start = removedAccents.indexOf(this.words[i], start + 1);
            }
        }
        result.addAll(matches);
    }
}

