/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.exports.geneanet;

import ancestris.core.actions.AbstractAncestrisContextAction;
import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.gedcom.SaveOptionsWidget;
import ancestris.modules.exports.geneanet.FilterPlaceOption;
import ancestris.modules.exports.geneanet.GeneanetExport;
import ancestris.util.swing.FileChooserBuilder;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.io.Filter;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public final class GeneanetExportAction
extends AbstractAncestrisContextAction {
    private static final Logger LOG = Logger.getLogger("ancestris.app", null);

    public GeneanetExportAction() {
        this.setImage("ancestris/modules/exports/geneanet/geneanet.png");
        this.setText(NbBundle.getMessage(GeneanetExportAction.class, (String)"CTL_GeneanetExportAction"));
    }

    protected void contextChanged() {
        this.setEnabled(!this.contextProperties.isEmpty());
        super.contextChanged();
    }

    protected void actionPerformedImpl(ActionEvent event) {
        Context contextToOpen = this.getContext();
        if (contextToOpen != null) {
            Gedcom myGedcom = contextToOpen.getGedcom();
            String gedcomName = this.removeExtension(myGedcom.getName());
            ArrayList<FilterPlaceOption> theFilters = new ArrayList<FilterPlaceOption>(5);
            AncestrisPlugin.lookupAll(Filter.class).stream().filter(f -> f.canApplyTo(myGedcom)).forEachOrdered(f -> theFilters.add((FilterPlaceOption)f));
            Lookup.getDefault().lookupAll(Filter.class).stream().filter(f -> f.canApplyTo(myGedcom)).forEachOrdered(f -> theFilters.add((FilterPlaceOption)f));
            theFilters.add(new FilterPlaceOption());
            SaveOptionsWidget options = new SaveOptionsWidget(theFilters.toArray(new Filter[0]));
            File file = new FileChooserBuilder(GeneanetExportAction.class).setFilesOnly(true).setDefaultBadgeProvider().setTitle(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"FileChooserTitle", (Object)myGedcom.getName())).setApproveText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"FileChooserOKButton")).setFileFilter((FileFilter)FileChooserBuilder.getGedcomFilter()).setAcceptAllFileFilterUsed(false).setDefaultExtension(FileChooserBuilder.getGedcomFilter().getExtensions()[0]).setAccessory((JComponent)options).setFileHiding(true).setSelectedFile(new File(gedcomName + "-geneanet")).showSaveDialog();
            if (file != null) {
                GeneanetExport exportGeneanet = new GeneanetExport(myGedcom, file, options);
                GeneanetExportAction.showWaitCursor();
                boolean b = exportGeneanet.execute();
                String result = b ? NbBundle.getMessage(GeneanetExport.class, (String)"GeneanetExportAction.End") : NbBundle.getMessage(GeneanetExport.class, (String)"GeneanetExportAction.Error");
                GeneanetExportAction.hideWaitCursor();
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)result, b ? 1 : 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                try {
                    String fileStr = "https://my.geneanet.org/arbre/";
                    URI uri = new URI(fileStr);
                    if (Desktop.isDesktopSupported()) {
                        Desktop.getDesktop().browse(uri);
                    }
                }
                catch (IOException | URISyntaxException ex) {
                    LOG.log(Level.FINE, "Unable to contact Geneanet", ex);
                }
            }
        }
    }

    private String removeExtension(String filename) {
        int extensionIndex;
        String separator = System.getProperty("file.separator");
        int lastSeparatorIndex = filename.lastIndexOf(separator);
        if (lastSeparatorIndex != -1) {
            filename = filename.substring(lastSeparatorIndex + 1);
        }
        if ((extensionIndex = filename.lastIndexOf(".")) == -1) {
            return filename;
        }
        return filename.substring(0, extensionIndex);
    }

    private static void showWaitCursor() {
        Mutex.EVENT.readAccess(() -> {
            JFrame mainWindow = (JFrame)WindowManager.getDefault().getMainWindow();
            mainWindow.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
            mainWindow.getGlassPane().setVisible(true);
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(GeneanetExportAction.class, (String)"GeneanetExportAction.Start"));
        });
    }

    private static void hideWaitCursor() {
        Mutex.EVENT.readAccess(() -> {
            StatusDisplayer.getDefault().setStatusText("");
            JFrame mainWindow = (JFrame)WindowManager.getDefault().getMainWindow();
            mainWindow.getGlassPane().setVisible(false);
            mainWindow.getGlassPane().setCursor(null);
        });
    }
}

