/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.placeeditor.models;

import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.PropertyPlace;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;

public class GedcomPlaceTableModel
extends AbstractTableModel {
    private Gedcom gedcom = null;
    private Map<String, Set<PropertyPlace>> placesMap = null;
    private String currentPlaceFormat = null;
    private String[] columsTitle;
    private String[][] data = null;
    private int nbColumns = 0;
    private int nbRows = 0;

    public GedcomPlaceTableModel(Gedcom gedcom) {
        this.gedcom = gedcom;
        String[] placeFormat = PropertyPlace.getFormat((Gedcom)gedcom);
        this.currentPlaceFormat = this.convertToString(placeFormat);
        this.nbColumns = placeFormat.length + 2;
        this.columsTitle = new String[this.nbColumns];
        for (int index = 0; index < placeFormat.length; ++index) {
            this.columsTitle[index] = placeFormat[index];
        }
        this.columsTitle[index] = "Latitude";
        this.columsTitle[index + 1] = "Longitude";
    }

    public void update() {
        String[] placeFormat = PropertyPlace.getFormat((Gedcom)this.gedcom);
        String newPlaceFormat = this.convertToString(placeFormat);
        if (!newPlaceFormat.equals(this.currentPlaceFormat)) {
            this.nbColumns = placeFormat.length + 2;
            this.columsTitle = new String[this.nbColumns];
            for (int index = 0; index < placeFormat.length; ++index) {
                this.columsTitle[index] = placeFormat[index];
            }
            this.columsTitle[index] = "Latitude";
            this.columsTitle[index + 1] = "Longitude";
            this.fireTableStructureChanged();
        }
        this.placesMap = this.getGeoPlaces();
        Set<String> places = this.placesMap.keySet();
        this.nbRows = places.size();
        this.data = new String[this.nbRows][this.nbColumns];
        int row = 0;
        for (String place : places) {
            this.data[row] = PropertyPlace.getFormat((String)place);
            ++row;
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.nbRows;
    }

    @Override
    public int getColumnCount() {
        return this.nbColumns;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.data != null) {
            if (row >= 0 && row < this.data.length && column >= 0 && this.data[row] != null && column < this.data[row].length) {
                return this.data[row][column];
            }
            return "";
        }
        return "";
    }

    public Class getColumnClass(int column) {
        return String.class;
    }

    @Override
    public String getColumnName(int col) {
        return this.columsTitle[col];
    }

    public Set<PropertyPlace> getValueAt(int row) {
        if (this.placesMap != null) {
            Object[] toArray = this.placesMap.keySet().toArray();
            return this.placesMap.get(toArray[row]);
        }
        return null;
    }

    private Map<String, Set<PropertyPlace>> getGeoPlaces() {
        TreeMap<String, Set<PropertyPlace>> ret = new TreeMap<String, Set<PropertyPlace>>();
        for (String placeStr : this.gedcom.getReferenceSet("PLAC").getKeys((Comparator)this.gedcom.getCollator())) {
            Set props = this.gedcom.getReferenceSet("PLAC").getReferences((Object)placeStr);
            for (Property prop : props) {
                String geoPlace = ((PropertyPlace)prop).getGeoValue();
                HashSet<PropertyPlace> set = (HashSet<PropertyPlace>)ret.get(geoPlace);
                if (set == null) {
                    set = new HashSet<PropertyPlace>();
                    ret.put(geoPlace, set);
                }
                set.add((PropertyPlace)prop);
            }
        }
        return ret;
    }

    public void eraseModel() {
        Iterator<Map.Entry<String, Set<PropertyPlace>>> it = this.placesMap.entrySet().iterator();
        while (it.hasNext()) {
            Set<PropertyPlace> set = it.next().getValue();
            Iterator<PropertyPlace> it2 = set.iterator();
            while (it2.hasNext()) {
                it2.next();
                it2.remove();
            }
            it.remove();
        }
        this.placesMap = null;
    }

    private String convertToString(String[] placeFormat) {
        String ret = "";
        for (String str : placeFormat) {
            ret = ret + str + ",";
        }
        return ret;
    }
}

