/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.placeeditor.topcomponents;

import genj.gedcom.Gedcom;
import genj.util.Registry;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class EditorTable
extends JTable {
    private Registry registry = null;
    private String mTableId = null;
    private TableRowSorter<TableModel> sorter = null;

    public EditorTable() {
    }

    public EditorTable(TableModel dm) {
        super(dm);
    }

    public void setID(Gedcom gedcom, String tableId, int selectedColumn) {
        this.registry = gedcom.getRegistry();
        this.mTableId = tableId;
        for (int index = 0; index < this.columnModel.getColumnCount(); ++index) {
            int columnSize = this.registry.get(this.mTableId + ".column" + index + ".size", 100);
            this.columnModel.getColumn(index).setPreferredWidth(columnSize);
        }
        this.getColumnModel().addColumnModelListener(new EditorTableTableColumnModelListener());
        final Collator collator = gedcom.getCollator();
        Comparator strComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                return collator.compare(o1.toString().replace(" ", "!"), o2.toString().replace(" ", "!"));
            }
        };
        this.sorter = new TableRowSorter<TableModel>(this.getModel());
        for (int c = 0; c < this.getColumnModel().getColumnCount(); ++c) {
            this.sorter.setComparator(c, strComparator);
        }
        this.setRowSorter(this.sorter);
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        sortKeys.add(new RowSorter.SortKey(selectedColumn, SortOrder.ASCENDING));
        for (int c = 0; c < this.getColumnCount(); ++c) {
            if (c == selectedColumn) continue;
            sortKeys.add(new RowSorter.SortKey(c, SortOrder.ASCENDING));
        }
        this.sorter.setSortKeys(sortKeys);
        this.sorter.sort();
    }

    public TableRowSorter<TableModel> getSorter() {
        return this.sorter;
    }

    private class EditorTableTableColumnModelListener
    implements TableColumnModelListener {
        private EditorTableTableColumnModelListener() {
        }

        @Override
        public void columnAdded(TableColumnModelEvent tcme) {
        }

        @Override
        public void columnRemoved(TableColumnModelEvent tcme) {
        }

        @Override
        public void columnMoved(TableColumnModelEvent tcme) {
        }

        @Override
        public void columnMarginChanged(ChangeEvent ce) {
            for (int index = 0; index < EditorTable.this.columnModel.getColumnCount(); ++index) {
                EditorTable.this.registry.put(EditorTable.this.mTableId + ".column" + index + ".size", EditorTable.this.columnModel.getColumn(index).getPreferredWidth());
            }
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent lse) {
        }
    }
}

