/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.placeeditor.topcomponents;

import ancestris.modules.editors.geoplace.PlaceEditorPanel;
import ancestris.modules.editors.placeeditor.models.GedcomPlaceTableModel;
import ancestris.modules.editors.placeeditor.topcomponents.EditorTable;
import ancestris.util.swing.DialogManager;
import ancestris.view.AncestrisTopComponent;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.GedcomMetaListener;
import genj.gedcom.Property;
import genj.gedcom.PropertyPlace;
import genj.gedcom.UnitOfWork;
import genj.util.Registry;
import java.awt.Container;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.LayoutStyle;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.RowFilter;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.openide.awt.Mnemonics;
import org.openide.awt.UndoRedo;
import org.openide.explorer.ExplorerManager;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.RetainLocation;
import org.openide.windows.WindowManager;

@RetainLocation(value="ancestris-output")
public final class PlacesListTopComponent
extends AncestrisTopComponent
implements ExplorerManager.Provider,
GedcomMetaListener {
    static final Logger LOG = Logger.getLogger("ancestris.editor");
    private Registry registry = null;
    static final String ICON_PATH = "ancestris/modules/editors/placeeditor/actions/Place.png";
    private static final String PREFERRED_ID = "PlaceListTopComponent";
    private Gedcom gedcom = null;
    private GedcomPlaceTableModel gedcomPlaceTableModel;
    private TableRowSorter<TableModel> placeTableSorter;
    private PlaceEditorPanel placesEditor = null;
    private boolean isBusyCommitting = false;
    private UndoRedoListener undoRedoListener;
    private JButton clearFilterGedcomPlaceButton;
    private JButton filterGedcomPlaceButton;
    private JTextField filterGedcomPlaceTextField;
    private JScrollPane jScrollPane1;
    private JLabel nbPlaces;
    private EditorTable placeTable;
    private JComboBox searchPlaceComboBox;
    private JLabel searchPlaceLabel;
    private boolean updateTable = false;

    public Image getImageIcon() {
        return ImageUtilities.loadImage((String)ICON_PATH, (boolean)true);
    }

    public void setName() {
        this.setName(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_PlacesTableTopComponent"));
    }

    public void setToolTipText() {
        this.setToolTipText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"HINT_PlacesTableTopComponent"));
    }

    public boolean createPanel() {
        this.gedcom = this.getGedcom();
        this.registry = this.gedcom.getRegistry();
        this.gedcomPlaceTableModel = new GedcomPlaceTableModel(this.gedcom);
        this.initComponents();
        this.placeTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    JToolTip tooltip = new JToolTip();
                    tooltip.setTipText(NbBundle.getMessage(this.getClass(), (String)"PlacesListTopComponent.edit.tip"));
                    PopupFactory popupFactory = PopupFactory.getSharedInstance();
                    int x = e.getXOnScreen();
                    int y = e.getYOnScreen();
                    final Popup tooltipContainer = popupFactory.getPopup(e.getComponent(), tooltip, x, y);
                    tooltipContainer.show();
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(2000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            tooltipContainer.hide();
                        }
                    }).start();
                } else if (e.getClickCount() == 2) {
                    int rowIndex = PlacesListTopComponent.this.placeTable.convertRowIndexToModel(PlacesListTopComponent.this.placeTable.getSelectedRow());
                    final Set<PropertyPlace> propertyPlaces = ((GedcomPlaceTableModel)PlacesListTopComponent.this.placeTable.getModel()).getValueAt(rowIndex);
                    PlacesListTopComponent.this.placesEditor = new PlaceEditorPanel();
                    PlacesListTopComponent.this.placesEditor.set(PlacesListTopComponent.this.gedcom, propertyPlaces);
                    final boolean search = propertyPlaces.iterator().next().getLatitude(true) == null;
                    WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                        @Override
                        public void run() {
                            if (search) {
                                PlacesListTopComponent.this.placesEditor.runSearch();
                            }
                            JButton OKButton = new JButton(NbBundle.getMessage(this.getClass(), (String)"Button_Ok"));
                            JButton cancelButton = new JButton(NbBundle.getMessage(this.getClass(), (String)"Button_Cancel"));
                            Object[] options = new Object[]{OKButton, cancelButton};
                            Object o = DialogManager.create((String)NbBundle.getMessage(PlaceEditorPanel.class, (String)"PlaceEditorPanel.edit.all", (Object)((PropertyPlace)propertyPlaces.iterator().next()).getGeoValue()), (JComponent)PlacesListTopComponent.this.placesEditor).setMessageType(-1).setOptions(options).show();
                            PlacesListTopComponent.this.placesEditor.close();
                            if (o == OKButton) {
                                PlacesListTopComponent.this.commit();
                                PlacesListTopComponent.this.updateGedcomPlaceTable();
                            }
                        }
                    });
                }
            }
        });
        String city = PropertyPlace.getCityTag((Gedcom)this.gedcom);
        String memoField = this.registry.get("placeTableFilter", city);
        if (!memoField.isEmpty()) {
            this.searchPlaceComboBox.setSelectedItem(memoField);
        }
        this.placeTable.setID(this.gedcom, PlacesListTopComponent.class.getName(), this.searchPlaceComboBox.getSelectedIndex());
        this.placeTableSorter = this.placeTable.getSorter();
        this.updateGedcomPlaceTable();
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                PlacesListTopComponent.this.filterGedcomPlaceTextField.requestFocusInWindow();
            }
        });
        return true;
    }

    private void updateGedcomPlaceTable() {
        this.gedcomPlaceTableModel.update();
        this.nbPlaces.setText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"PlacesListTopComponent.nbPlaces.text", (Object)this.gedcomPlaceTableModel.getRowCount()));
        this.placeTableSorter.sort();
    }

    private void newFilter(String filter) {
        RowFilter rf;
        try {
            rf = RowFilter.regexFilter("(?i)" + filter, this.searchPlaceComboBox.getSelectedIndex());
        }
        catch (PatternSyntaxException e) {
            return;
        }
        this.placeTableSorter.setRowFilter(rf);
    }

    private void initComponents() {
        this.searchPlaceLabel = new JLabel();
        this.filterGedcomPlaceTextField = new JTextField();
        this.filterGedcomPlaceButton = new JButton();
        this.clearFilterGedcomPlaceButton = new JButton();
        this.searchPlaceComboBox = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.placeTable = new EditorTable();
        this.nbPlaces = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.searchPlaceLabel, (String)NbBundle.getMessage(PlacesListTopComponent.class, (String)"PlacesListTopComponent.searchPlaceLabel.text"));
        this.filterGedcomPlaceTextField.setText(NbBundle.getMessage(PlacesListTopComponent.class, (String)"PlacesListTopComponent.filterGedcomPlaceTextField.text"));
        this.filterGedcomPlaceTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                PlacesListTopComponent.this.filterGedcomPlaceTextFieldKeyTyped(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.filterGedcomPlaceButton, (String)NbBundle.getMessage(PlacesListTopComponent.class, (String)"PlacesListTopComponent.filterGedcomPlaceButton.text"));
        this.filterGedcomPlaceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlacesListTopComponent.this.filterGedcomPlaceButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.clearFilterGedcomPlaceButton, (String)NbBundle.getMessage(PlacesListTopComponent.class, (String)"PlacesListTopComponent.clearFilterGedcomPlaceButton.text"));
        this.clearFilterGedcomPlaceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlacesListTopComponent.this.clearFilterGedcomPlaceButtonActionPerformed(evt);
            }
        });
        this.searchPlaceComboBox.setModel(new DefaultComboBoxModel<String>(PropertyPlace.getFormat((Gedcom)this.gedcom)));
        this.searchPlaceComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PlacesListTopComponent.this.searchPlaceComboBoxItemStateChanged(evt);
            }
        });
        this.placeTable.setAutoCreateRowSorter(true);
        this.placeTable.setModel(this.gedcomPlaceTableModel);
        this.jScrollPane1.setViewportView(this.placeTable);
        this.nbPlaces.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.nbPlaces, (String)NbBundle.getMessage(PlacesListTopComponent.class, (String)"PlacesListTopComponent.nbPlaces.text"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.searchPlaceLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchPlaceComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filterGedcomPlaceTextField, -2, 217, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filterGedcomPlaceButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearFilterGedcomPlaceButton).addGap(18, 18, 18).addComponent(this.nbPlaces, -1, 86, Short.MAX_VALUE).addContainerGap()).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.searchPlaceLabel).addComponent(this.filterGedcomPlaceTextField, -2, -1, -2).addComponent(this.filterGedcomPlaceButton).addComponent(this.clearFilterGedcomPlaceButton).addComponent(this.searchPlaceComboBox, -2, -1, -2).addComponent(this.nbPlaces)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 85, Short.MAX_VALUE).addGap(0, 0, 0)));
    }

    private void filterGedcomPlaceTextFieldKeyTyped(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.newFilter(this.filterGedcomPlaceTextField.getText());
        }
    }

    private void filterGedcomPlaceButtonActionPerformed(ActionEvent evt) {
        this.newFilter(this.filterGedcomPlaceTextField.getText());
    }

    private void clearFilterGedcomPlaceButtonActionPerformed(ActionEvent evt) {
        this.filterGedcomPlaceTextField.setText("");
        this.newFilter(this.filterGedcomPlaceTextField.getText());
    }

    private void searchPlaceComboBoxItemStateChanged(ItemEvent evt) {
        this.registry.put("placeTableFilter", (String)this.searchPlaceComboBox.getSelectedItem());
    }

    public void componentOpened() {
        this.undoRedoListener = new UndoRedoListener();
        UndoRedo undoRedo = this.getUndoRedo();
        undoRedo.addChangeListener((ChangeListener)this.undoRedoListener);
    }

    public void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    public void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    public void gedcomEntityAdded(Gedcom gedcom, Entity entity) {
        if (!this.updateTable && !entity.getProperties(PropertyPlace.class).isEmpty()) {
            this.updateTable = true;
        }
    }

    public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
        if (!this.updateTable && !entity.getProperties(PropertyPlace.class).isEmpty()) {
            this.updateTable = true;
        }
    }

    public void gedcomPropertyChanged(Gedcom gedcom, Property property) {
        if (!this.updateTable && property.getTag().equals("PLAC")) {
            this.updateTable = true;
        }
    }

    public void gedcomPropertyAdded(Gedcom gedcom, Property property, int pos, Property added) {
        if (!this.updateTable && property.getTag().equals("PLAC")) {
            this.updateTable = true;
        }
    }

    public void gedcomPropertyDeleted(Gedcom gedcom, Property property, int pos, Property deleted) {
        if (!this.updateTable && property.getTag().equals("PLAC")) {
            this.updateTable = true;
        }
    }

    public void gedcomHeaderChanged(Gedcom gedcom) {
    }

    public void gedcomWriteLockAcquired(Gedcom gedcom) {
        this.updateTable = false;
    }

    public void gedcomBeforeUnitOfWork(Gedcom gedcom) {
    }

    public void gedcomAfterUnitOfWork(Gedcom gedcom) {
    }

    public void gedcomWriteLockReleased(Gedcom gedcom) {
        if (this.updateTable) {
            this.updateGedcomPlaceTable();
            this.updateTable = false;
        }
    }

    private void commit() {
        if (this.isBusyCommitting) {
            return;
        }
        this.isBusyCommitting = true;
        try {
            if (this.gedcom.isWriteLocked()) {
                this.placesEditor.commit();
            } else {
                this.gedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        PlacesListTopComponent.this.placesEditor.commit();
                    }
                });
            }
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Error committing editor", t);
        }
        finally {
            this.isBusyCommitting = false;
        }
    }

    public void componentClosed() {
        super.componentClosed();
        this.gedcomPlaceTableModel.eraseModel();
    }

    private class UndoRedoListener
    implements ChangeListener {
        private UndoRedoListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            PlacesListTopComponent.this.updateGedcomPlaceTable();
        }
    }
}

