/*
 * Decompiled with CFR 0.152.
 */
package modules.editors.gedcomproperties.utils;

import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.PropertyPlace;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import modules.editors.gedcomproperties.utils.PlaceFormatConverterPanel;
import org.openide.util.NbBundle;

public class GedcomPlacesConverter {
    private final String PLACETAG = "PLAC";
    private final Gedcom gedcom;
    private final int fromFormatLength;
    private final String[] toPlaceFormat;
    private final String[] map;
    private int nbOfDifferentFoundPlaces = 0;
    private int nbOfDifferentChangedPlaces = 0;
    private int nbOfFoundPlaces = 0;
    private int nbOfChangedPlaces = 0;
    private Exception error = null;
    private final Set<String> listOfCorrectPlaces = new TreeSet<String>();
    private final Set<String> listOfIncorrectPlaces = new TreeSet<String>();

    public GedcomPlacesConverter(Gedcom gedcom, String fromFormat, String toFormat, String conversionMap) {
        this.gedcom = gedcom;
        this.fromFormatLength = PropertyPlace.getFormat((String)fromFormat).length;
        this.toPlaceFormat = PropertyPlace.getFormat((String)toFormat);
        this.map = PropertyPlace.getFormat((String)conversionMap);
    }

    public boolean convert() {
        this.nbOfDifferentFoundPlaces = 0;
        this.nbOfDifferentChangedPlaces = 0;
        this.nbOfFoundPlaces = 0;
        this.nbOfChangedPlaces = 0;
        Exception error = null;
        String[] newPlace = new String[this.toPlaceFormat.length];
        List allPlaces = this.gedcom.getPropertiesByClass(PropertyPlace.class);
        TreeSet<String> allUniquePlaces = new TreeSet<String>();
        for (Property place : allPlaces) {
            allUniquePlaces.add(place.getValue());
        }
        this.nbOfFoundPlaces = allPlaces.size();
        this.nbOfDifferentFoundPlaces = allUniquePlaces.size();
        for (Property place : allPlaces) {
            String key = place.getValue();
            String[] currentJurisdictions = PropertyPlace.getFormat((String)key);
            if (currentJurisdictions.length != this.fromFormatLength) {
                this.listOfIncorrectPlaces.add(key);
                continue;
            }
            for (int i = 0; i < newPlace.length; ++i) {
                if (!this.map[i].isEmpty()) {
                    int j = Integer.valueOf(this.map[i]);
                    if (j < 0 || j > currentJurisdictions.length - 1) {
                        newPlace[i] = key;
                        continue;
                    }
                    newPlace[i] = currentJurisdictions[j];
                    continue;
                }
                newPlace[i] = "";
            }
            try {
                place.setValue(this.getDisplayOfPlace(newPlace));
                ++this.nbOfChangedPlaces;
                this.listOfCorrectPlaces.add(key);
            }
            catch (Exception e) {
                String msg = new Exception(e).getLocalizedMessage();
                error = new Exception(NbBundle.getMessage(PlaceFormatConverterPanel.class, (String)"ERR_Exception") + " " + msg + "!");
                return false;
            }
        }
        this.nbOfDifferentChangedPlaces = this.listOfCorrectPlaces.size();
        if (this.nbOfChangedPlaces < this.nbOfFoundPlaces) {
            error = new Exception(NbBundle.getMessage(PlaceFormatConverterPanel.class, (String)"ERR_WrongFormat"));
            return false;
        }
        return true;
    }

    public boolean isWithError() {
        return this.error != null;
    }

    public String[] getIncorrectPlaces() {
        if (this.listOfIncorrectPlaces == null) {
            return null;
        }
        return this.listOfIncorrectPlaces.toArray(new String[this.listOfIncorrectPlaces.size()]);
    }

    private String getDisplayOfPlace(String[] newPlace) {
        String ret = "";
        String sep = ",";
        for (int i = 0; i < newPlace.length; ++i) {
            if (i == newPlace.length - 1) {
                sep = "";
            }
            ret = ret + newPlace[i] + sep;
        }
        return ret;
    }

    public int getNbOfDifferentFoundPlaces() {
        return this.nbOfDifferentFoundPlaces;
    }

    public int getNbOfDifferentChangedPlaces() {
        return this.nbOfDifferentChangedPlaces;
    }

    public int getNbOfFoundPlaces() {
        return this.nbOfFoundPlaces;
    }

    public int getNbOfChangedPlaces() {
        return this.nbOfChangedPlaces;
    }

    public Exception getError() {
        if (this.error == null) {
            this.error = new Exception(NbBundle.getMessage(PlaceFormatConverterPanel.class, (String)"ERR_Unknown"));
        }
        return this.error;
    }
}

