/*
 * Decompiled with CFR 0.152.
 */
package modules.editors.gedcomproperties.utils;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import modules.editors.gedcomproperties.utils.MediaManagerPanel;
import modules.editors.gedcomproperties.utils.PathData;
import org.openide.util.NbBundle;

public class MediaPathTableModel
extends AbstractTableModel {
    private MediaManagerPanel parent = null;
    private static int NBCOLUMNS = 5;
    private String rootPath = "";
    private String[] columnNames = new String[]{NbBundle.getMessage(this.getClass(), (String)"COL_NbMedia"), NbBundle.getMessage(this.getClass(), (String)"COL_Found"), NbBundle.getMessage(this.getClass(), (String)"COL_newPath"), NbBundle.getMessage(this.getClass(), (String)"COL_searchPathButton"), NbBundle.getMessage(this.getClass(), (String)"COL_makeRelative")};
    private Object[][] data;

    public MediaPathTableModel(MediaManagerPanel parent, Set<PathData> pathDataList, String rootPath) {
        this.parent = parent;
        this.rootPath = rootPath;
        if (pathDataList == null) {
            this.data = new Object[0][NBCOLUMNS];
            return;
        }
        this.resetData(pathDataList);
    }

    public void resetData(Set<PathData> pathDataList) {
        this.data = new Object[pathDataList.size()][NBCOLUMNS];
        int i = 0;
        for (PathData pathData : pathDataList) {
            this.data[i][0] = pathData.getNbMedia();
            this.data[i][1] = pathData.found;
            this.data[i][2] = pathData.newPath;
            this.data[i][3] = "...";
            this.data[i][4] = pathData.relative;
            ++i;
        }
    }

    public void fireUpdateTable() {
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.data.length;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.data[rowIndex][columnIndex];
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c) != null ? this.getValueAt(0, c).getClass() : String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col > 2;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.data[rowIndex][columnIndex] = aValue;
        if (aValue instanceof Boolean) {
            Boolean rel = (Boolean)aValue;
            String newPath = (String)this.data[rowIndex][2];
            Path rootbase = Paths.get(this.rootPath, new String[0]);
            Path newpath = Paths.get(newPath, new String[0]);
            if (rel.booleanValue() && !newpath.isAbsolute()) {
                return;
            }
            if (!rel.booleanValue() && newpath.isAbsolute()) {
                return;
            }
            if (rel.booleanValue()) {
                Path relativePath = rootbase.relativize(newpath);
                this.data[rowIndex][2] = relativePath.toString() + File.separator;
            } else {
                newpath = Paths.get(this.rootPath + File.separator + newPath, new String[0]);
                Path absolutePath = newpath.normalize();
                this.data[rowIndex][2] = absolutePath.toString() + File.separator;
            }
            this.fireTableCellUpdated(rowIndex, 2);
            this.parent.updateMap(rowIndex, (String)this.data[rowIndex][2]);
        }
    }
}

