/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.viewers.entityviewer.panels;

import ancestris.modules.viewers.entityviewer.nodes.EntityTag2Icon;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.TagPath;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class SelectEntityPanel
extends JPanel {
    EntityComboBoxModel entityComboBoxModel;
    private final ArrayList<TagPath> SORTS = new ArrayList<TagPath>(){
        {
            this.add(new TagPath("INDI"));
            this.add(new TagPath("INDI:NAME"));
            this.add(new TagPath("INDI:BIRT:DATE"));
            this.add(new TagPath("INDI:DEAT:DATE"));
            this.add(new TagPath("FAM"));
            this.add(new TagPath("FAM:MARR:DATE"));
            this.add(new TagPath("FAM:HUSB:*:..:NAME"));
            this.add(new TagPath("FAM:WIFE:*:..:NAME"));
            this.add(new TagPath("OBJE"));
            this.add(new TagPath("OBJE:TITL"));
            this.add(new TagPath("OBJE:FILE:TITL"));
            this.add(new TagPath("NOTE"));
            this.add(new TagPath("NOTE:NOTE"));
            this.add(new TagPath("SOUR"));
            this.add(new TagPath("SOUR:TITL"));
            this.add(new TagPath("SOUR:ABBR"));
            this.add(new TagPath("SOUR:AUTH"));
            this.add(new TagPath("SOUR:REPO"));
            this.add(new TagPath("SUBM"));
            this.add(new TagPath("REPO"));
            this.add(new TagPath("REPO:NAME"));
            this.add(new TagPath("REPO:REFN"));
            this.add(new TagPath("REPO:RIN"));
        }
    };
    private JComboBox<Entity> entityComboBox;
    private JLabel entityTypeLabel;

    public SelectEntityPanel(Gedcom gedcom, String entityTag) {
        Collection entities = gedcom.getEntities(entityTag);
        this.entityComboBoxModel = new EntityComboBoxModel(entityTag);
        this.entityComboBoxModel.addAll(entities);
        this.entityComboBoxModel.setSelectedItem(entities.isEmpty() ? null : entities.toArray()[0]);
        this.initComponents();
        this.entityTypeLabel.setIcon(EntityTag2Icon.getIcon(entityTag));
        this.entityComboBox.setSelectedIndex(entities.isEmpty() ? -1 : 0);
    }

    private void initComponents() {
        this.entityTypeLabel = new JLabel();
        this.entityComboBox = new JComboBox();
        this.entityTypeLabel.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/viewers/entityviewer/resources/Individual.png")));
        this.entityComboBox.setModel(this.entityComboBoxModel);
        this.entityComboBox.setRenderer(new ComboBoxRenderer());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.entityTypeLabel, -2, 20, -2).addGap(4, 4, 4).addComponent(this.entityComboBox, 0, 207, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.entityTypeLabel, -1, -1, Short.MAX_VALUE).addComponent(this.entityComboBox, -2, 26, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public Entity getSelectedEntity() {
        return (Entity)this.entityComboBoxModel.getSelectedItem();
    }

    public void setSelectedEntity(Entity selectedEntity) {
        this.entityComboBoxModel.setSelectedItem(selectedEntity);
    }

    private class ComboBoxRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return super.getListCellRendererComponent((JList<?>)list, ((Entity)value).toString(true), index, isSelected, cellHasFocus);
        }
    }

    public class EntityComboBoxModel
    extends AbstractListModel<Entity>
    implements ComboBoxModel<Entity> {
        Entity selectedEntity;
        ArrayList<Entity> entityList = new ArrayList();
        private List<TagPath> sorts = new ArrayList<TagPath>();

        public EntityComboBoxModel(String entityTag) {
            for (TagPath tagPath : SelectEntityPanel.this.SORTS) {
                if (!tagPath.getFirst().equals(entityTag)) continue;
                this.sorts.add(tagPath);
            }
        }

        @Override
        public int getSize() {
            return this.entityList.size();
        }

        @Override
        public Entity getElementAt(int i) {
            return this.entityList.get(i);
        }

        @Override
        public void setSelectedItem(Object o) {
            this.selectedEntity = (Entity)o;
        }

        public boolean addAll(Collection<? extends Entity> c) {
            int size = this.entityList.size();
            this.entityList.ensureCapacity(size);
            boolean addAll = this.entityList.addAll(c);
            this.fireIntervalAdded(this, size, this.entityList.size());
            return addAll;
        }

        public void clear() {
            int size = this.entityList.size();
            this.entityList.clear();
            this.fireIntervalRemoved(this, 0, size);
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedEntity;
        }
    }
}

