/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.imports.gedcom;

import ancestris.api.imports.Import;
import ancestris.modules.gedcom.utilities.GedcomUtilities;
import ancestris.modules.imports.gedcom.Bundle;
import ancestris.modules.imports.gedcom.ImportGramps;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import java.io.IOException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ImportAncestrologie
extends Import {
    String previousLine = "";
    private boolean header = false;

    public boolean isGeneric() {
        return false;
    }

    public String toString() {
        return Bundle.importancestrologie_name();
    }

    protected String getImportComment() {
        return Bundle.importancestrologie_note();
    }

    protected void firstPass() {
        super.firstPass();
    }

    protected boolean process() throws IOException {
        String tag = this.input.getTag();
        TagPath path = this.input.getPath();
        if (path.toString().equals("SOUR:EVEN")) {
            String result = this.output.writeLine(this.input.getLevel(), "NOTE", this.input.getValue());
            this.console.println(NbBundle.getMessage(ImportGramps.class, (String)"Import.fixTagNotAllowed", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        if (super.process()) {
            return true;
        }
        if (path.toString().contains("TIME") && !path.toString().contains("CHAN")) {
            String result = this.output.writeLine(this.input.getLevel(), "_TIME", this.input.getValue());
            this.console.println(NbBundle.getMessage(ImportGramps.class, (String)"Import.fixTagNotAllowed", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        return false;
    }

    public boolean fixGedcom(Gedcom gedcom) {
        boolean ret = super.fixGedcom(gedcom);
        ret |= this.processEntities(gedcom);
        this.incrementProgress();
        return ret |= super.convertAssociations(gedcom);
    }

    public boolean processEntities(Gedcom gedcom) {
        boolean hasErrors = false;
        Property[] props = null;
        Property host = null;
        Property date = null;
        for (Indi indi : gedcom.getIndis()) {
            for (Property prop : props = indi.getProperties("ADDR")) {
                host = indi.addProperty("RESI", "");
                date = prop.getProperty("DATE");
                if (date != null) {
                    host.addProperty("DATE", date.getValue());
                    prop.delProperty(date);
                }
                try {
                    GedcomUtilities.movePropertyRecursively((Property)prop, (Property)host);
                }
                catch (GedcomException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                ++this.nbChanges;
            }
            hasErrors = true;
        }
        return hasErrors;
    }
}

