/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.imports.gedcom;

import ancestris.api.imports.Import;
import ancestris.modules.imports.gedcom.Bundle;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyFamilyChild;
import java.io.IOException;
import java.util.List;

public class ImportGenbox
extends Import {
    public boolean isGeneric() {
        return false;
    }

    public String toString() {
        return Bundle.importgenbox_name();
    }

    protected String getImportComment() {
        return Bundle.importgenbox_note();
    }

    protected boolean process() throws IOException {
        if (this.processAGE()) {
            return true;
        }
        return super.process();
    }

    private boolean processAGE() throws IOException {
        if (this.input.getTag().equals("AGE")) {
            String old;
            String newValue = old = this.input.getValue();
            if (old.matches("\\d+")) {
                newValue = old + "y";
            }
            newValue = newValue.replace(" day", "d");
            newValue = newValue.replace("ds", "d");
            newValue = newValue.replace(" month", "m");
            newValue = newValue.replace(" mth", "m");
            newValue = newValue.replace("ms", "m");
            newValue = newValue.replace(" yr", "y");
            if ((newValue = newValue.replace("ys", "y")) != null) {
                this.output.writeLine(this.input.getLevel(), this.input.getTag(), newValue);
                return true;
            }
        }
        return false;
    }

    public boolean fixGedcom(Gedcom gedcom) {
        this.fixFAMC(gedcom);
        this.incrementProgress();
        this.fixCONC(gedcom);
        this.incrementProgress();
        return super.fixGedcom(gedcom);
    }

    private boolean fixCONC(Gedcom gedcom) {
        for (Entity e : gedcom.getEntities()) {
            this.fixCONCrecurse((Property)e);
        }
        return true;
    }

    private void fixCONCrecurse(Property prop) {
        if (prop.getTag().equals("TITL") || prop.getTag().equals("PAGE")) {
            Property[] propConc = prop.getProperties("CONC");
            if (propConc.length == 0) {
                return;
            }
            if (prop.getProperty("CONT") != null) {
                return;
            }
            StringBuilder sb = new StringBuilder(prop.getValue());
            for (Property p : propConc) {
                sb.append(p.getValue());
            }
            prop.delProperties("CONC");
            prop.setValue(sb.toString());
            return;
        }
        for (Property child : prop.getProperties()) {
            this.fixCONCrecurse(child);
        }
    }

    private boolean fixFAMC(Gedcom gedcom) {
        for (Indi indi : gedcom.getIndis()) {
            PropertyFamilyChild famc;
            List famcs = indi.getProperties(PropertyFamilyChild.class);
            if (famcs.size() <= 1 || (famc = (PropertyFamilyChild)indi.getProperty("FAMC")) == null) continue;
            for (PropertyFamilyChild fc : famcs) {
                if (famc.equals(fc) || !famc.getFamily().equals(fc.getFamily())) continue;
                fc.getParent().delProperty((Property)fc);
            }
        }
        return true;
    }
}

