/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.imports.gedcom;

import ancestris.api.imports.Import;
import ancestris.modules.imports.gedcom.Bundle;
import ancestris.modules.imports.gedcom.ImportGramps;
import ancestris.util.swing.FileChooserBuilder;
import genj.gedcom.Gedcom;
import genj.gedcom.Grammar;
import genj.gedcom.Property;
import genj.gedcom.PropertyFile;
import java.util.List;
import org.openide.util.NbBundle;

public class ImportGeneanet
extends Import {
    public boolean isGeneric() {
        return false;
    }

    public String toString() {
        return Bundle.importgeneanet_name();
    }

    protected String getImportComment() {
        return Bundle.importgeneanet_note();
    }

    public boolean fixGedcom(Gedcom gedcom) {
        boolean ret = super.fixGedcom(gedcom);
        ret |= super.convertAssociations(gedcom);
        this.incrementProgress();
        return ret |= this.fixOther(gedcom);
    }

    public boolean fixOther(Gedcom gedcom) {
        boolean hasErrors = false;
        if (gedcom.getGrammar().equals(Grammar.V551)) {
            List fileList = gedcom.getPropertiesByClass(PropertyFile.class);
            Property obje = null;
            Property form = null;
            for (Property file : fileList) {
                obje = file.getParent();
                form = obje.getProperty("FORM");
                if (form != null) {
                    if (file.getProperty("FORM") == null) {
                        file.addProperty("FORM", form.getValue());
                    }
                    obje.delProperty(form);
                    this.console.println(NbBundle.getMessage(ImportGramps.class, (String)"Import.fixMediaForm", (Object)file.toString()));
                    hasErrors = true;
                    continue;
                }
                if (file.getProperty("FORM") != null) continue;
                String value = file.getValue();
                String ext = "";
                ext = value.startsWith("http") ? "web" : FileChooserBuilder.getExtension((String)value);
                if (ext == null) {
                    ext = "none";
                }
                file.addProperty("FORM", ext);
                this.console.println(NbBundle.getMessage(ImportGramps.class, (String)"Import.fixMediaForm", (Object)file.toString()));
                hasErrors = true;
            }
        }
        return hasErrors;
    }
}

