/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.imports.gedcom;

import ancestris.api.imports.Import;
import ancestris.modules.imports.gedcom.Bundle;
import ancestris.util.swing.FileChooserBuilder;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.PropertyFile;
import genj.gedcom.TagPath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.openide.util.NbBundle;

public class ImportGramps
extends Import {
    public boolean isGeneric() {
        return false;
    }

    public String toString() {
        return Bundle.importgramps_name();
    }

    protected String getImportComment() {
        return Bundle.importgramps_note();
    }

    protected void firstPass() {
        super.firstPass();
    }

    protected boolean process() throws IOException {
        if (super.process()) {
            return true;
        }
        if (this.input.getLevel() == 1 && this.input.getTag().equals("GEDC")) {
            this.output.writeLine(1, "DEST", "ANY");
            this.output.writeLine(1, "GEDC", "");
            this.console.println(NbBundle.getMessage(ImportGramps.class, (String)"Import.fixDestination"));
            return true;
        }
        String tag = this.input.getTag();
        TagPath path = this.input.getPath();
        if ("INDI:BIRT:TYPE".equalsIgnoreCase(path.toString())) {
            String result = this.output.writeLine(this.input.getLevel(), "NOTE", this.input.getValue());
            this.console.println(NbBundle.getMessage(ImportGramps.class, (String)"Import.fixTagNotAllowed", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        if ("FAM:MARR:TYPE".equalsIgnoreCase(path.toString())) {
            String result = this.output.writeLine(this.input.getLevel(), "NOTE", this.input.getValue());
            this.console.println(NbBundle.getMessage(ImportGramps.class, (String)"Import.fixTagNotAllowed", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        if ("INDI:DEAT:TYPE".equalsIgnoreCase(path.toString())) {
            String result = this.output.writeLine(this.input.getLevel(), "NOTE", this.input.getValue());
            this.console.println(NbBundle.getMessage(ImportGramps.class, (String)"Import.fixTagNotAllowed", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        if ("INDI:WILL:TYPE".equalsIgnoreCase(path.toString())) {
            String result = this.output.writeLine(this.input.getLevel(), "NOTE", this.input.getValue());
            this.console.println(NbBundle.getMessage(ImportGramps.class, (String)"Import.fixTagNotAllowed", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        if (path.toString().contains("DATE:TIME") && !path.toString().contains("CHAN")) {
            String result = this.output.writeLine(this.input.getLevel(), "_TIME", this.input.getValue());
            this.console.println(NbBundle.getMessage(ImportGramps.class, (String)"Import.fixTagNotAllowed", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        return false;
    }

    public boolean fixGedcom(Gedcom gedcom) {
        boolean ret = super.fixGedcom(gedcom);
        ret |= this.processEntities(gedcom);
        this.incrementProgress();
        ret |= this.processCONC(gedcom);
        this.incrementProgress();
        return ret |= super.convertAssociations(gedcom);
    }

    public boolean processEntities(Gedcom gedcom) {
        boolean hasErrors = false;
        Object props = null;
        Property prop = null;
        Object host = null;
        this.console.println(NbBundle.getMessage(ImportGramps.class, (String)"Import.fixMedia"));
        List propsList = gedcom.getPropertiesByClass(PropertyFile.class);
        for (Property file : propsList) {
            prop = file.getParent().getProperty("FORM");
            if (prop != null) {
                file.addProperty("FORM", prop.getValue());
                prop.getParent().delProperty(prop);
                hasErrors = true;
            }
            if ((prop = file.getProperty("FORM")) != null) continue;
            file.addProperty("FORM", FileChooserBuilder.getExtension((String)file.getValue()));
            hasErrors = true;
        }
        this.console.println("=============================");
        return hasErrors;
    }

    public boolean processCONC(Gedcom gedcom) {
        boolean hasErrors = false;
        this.console.println(NbBundle.getMessage(ImportGramps.class, (String)"Import.fixCONC"));
        ArrayList list = new ArrayList();
        for (Entity entity : gedcom.getEntities()) {
            this.getPropertiesRecursively(list, "CONC", (Property)entity);
        }
        for (Property prop : list) {
            Property parent = prop.getParent();
            int nb = parent.getAllProperties("CONC").size();
            if (parent.getTag().equals("NOTE") || nb != 1) continue;
            this.console.println("CONC : " + prop.getValue() + " ==> " + parent.getTag());
            parent.setValue(parent.getValue() + prop.getValue());
            parent.delProperty(prop);
        }
        this.console.println("=============================");
        return hasErrors;
    }
}

