/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.imports.gedcom;

import ancestris.api.imports.Import;
import ancestris.modules.imports.gedcom.Bundle;
import ancestris.modules.imports.gedcom.ImportGramps;
import ancestris.util.swing.FileChooserBuilder;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Media;
import genj.gedcom.Property;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertySource;
import genj.gedcom.PropertyXRef;
import genj.gedcom.Source;
import genj.gedcom.TagPath;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openide.util.NbBundle;

public class ImportHeredis
extends Import {
    private boolean repoOK = false;
    private static int clerepo = 0;
    private static final HashMap<String, Integer> hashrepo = new HashMap();
    private static final StringBuilder sb = new StringBuilder();

    public boolean isGeneric() {
        return false;
    }

    public String toString() {
        return Bundle.importheredis_name();
    }

    protected String getImportComment() {
        return Bundle.importheredis_note();
    }

    protected void init() {
        super.init();
    }

    protected void firstPass() {
        super.firstPass();
        this.firstPassRepo();
    }

    protected boolean process() throws IOException {
        if (this.input.getLevel() == 2 && this.input.getTag().equals("VERS") && this.input.getValue().startsWith("5.5")) {
            GEDCOM_VERSION = "5.5.1";
            this.output.writeLine(2, "VERS", GEDCOM_VERSION);
            this.console.println(NbBundle.getMessage(ImportHeredis.class, (String)"Import.fixVersion", (Object)GEDCOM_VERSION));
            return true;
        }
        if (this.input.getLevel() == 3 && this.input.getTag().equals("WEB")) {
            this.output.writeLine(3, "WWW", "http://" + this.input.getValue());
            return true;
        }
        if (this.input.getLevel() == 2 && this.input.getTag().equals("SURN")) {
            this.output.writeLine(2, "SURN", this.input.getValue().replaceAll("\\(", ",\\(").replaceAll(",+", ", ").replaceAll(", \\Z", ""));
            return true;
        }
        if (this.input.getLevel() == 2 && this.input.getTag().equals("_SHAR")) {
            this.output.writeLine(2, "ASSO", this.input.getValue());
            return true;
        }
        if (this.processAddr()) {
            return true;
        }
        if (this.processRepo()) {
            return true;
        }
        if (super.process()) {
            return true;
        }
        if (this.processJulianHeredis()) {
            return true;
        }
        if (this.processFrenchRepHeredis()) {
            return true;
        }
        if (this.processTagNotAllowed()) {
            return true;
        }
        return this.processSwapTags();
    }

    protected void finalise() throws IOException {
        super.finalise();
        this.finaliseRepo();
    }

    public boolean fixGedcom(Gedcom gedcom) {
        boolean ret = super.fixGedcom(gedcom);
        ret |= this.processEntities(gedcom);
        this.incrementProgress();
        return ret |= super.convertAssociations(gedcom);
    }

    public void complete() {
        super.complete();
    }

    private void firstPassRepo() {
        if (!this.repoOK && this.input.getLevel() == 1 && this.input.getTag().equals("REPO")) {
            String value = this.input.getValue();
            if (!value.matches("\\@[A-Z0-9]+\\@")) {
                if (!hashrepo.containsKey(value)) {
                    hashrepo.put(this.input.getValue(), ++clerepo);
                    sb.append("0 @REPO").append(clerepo).append("@ REPO").append(EOL);
                    sb.append("1 NAME ").append(this.input.getValue()).append(EOL);
                }
            } else {
                this.repoOK = true;
            }
        }
    }

    private boolean processRepo() throws IOException {
        if (!this.repoOK && this.input.getLevel() == 1 && this.input.getTag().equals("REPO")) {
            if (hashrepo.containsKey(this.input.getValue())) {
                this.output.writeLine(1, "REPO", "@REPO" + hashrepo.get(this.input.getValue()) + "@");
                String str = this.input.getLine();
                this.console.println(NbBundle.getMessage(ImportHeredis.class, (String)"Import.fixRepo", (Object)str.substring(0, Math.min(str.length(), 30))));
            }
            return true;
        }
        return false;
    }

    private void finaliseRepo() throws IOException {
        if (!this.repoOK) {
            this.output.write(sb.toString());
        }
    }

    private boolean processAddr() throws IOException {
        if (this.input.getTag().equals("ADDR")) {
            String prevTag = this.input.getPath().get(this.input.getPath().length() - 2);
            if (prevTag.equals("INDI")) {
                this.output.writeLine(this.input.getLevel(), null, "RESI", null);
                this.output.shiftLine(this.input);
                return true;
            }
            if (prevTag.equals("FAM")) {
                this.output.writeLine(this.input.getLevel(), null, "_RESI", null);
                this.output.shiftLine(this.input);
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean processTagNotAllowed() throws IOException {
        String value;
        String tag = this.input.getTag();
        TagPath path = this.input.getPath();
        if ("SOUR:DATE".equalsIgnoreCase(path.toString())) {
            String result = this.output.writeLine(this.input.getLevel(), "_" + tag, this.input.getValue());
            this.console.println(NbBundle.getMessage(ImportHeredis.class, (String)"Import.fixTagNotAllowed", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        if (path.toString().endsWith("OBJE:DATE")) {
            String result = this.output.writeLine(this.input.getLevel(), "_" + tag, this.input.getValue());
            this.console.println(NbBundle.getMessage(ImportHeredis.class, (String)"Import.fixTagNotAllowed", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        if ("INDI:ASSO:TITL".equalsIgnoreCase(path.toString())) {
            String result = this.output.writeLine(this.input.getLevel(), "_" + tag, this.input.getValue());
            this.console.println(NbBundle.getMessage(ImportHeredis.class, (String)"Import.fixTagNotAllowed", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        if ("SOUR:RESN".equalsIgnoreCase(path.toString())) {
            String result = this.output.writeLine(this.input.getLevel(), "_" + tag, this.input.getValue());
            this.console.println(NbBundle.getMessage(ImportHeredis.class, (String)"Import.fixTagNotAllowed", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        if ("OBJE:RESN".equalsIgnoreCase(path.toString())) {
            String result = this.output.writeLine(this.input.getLevel(), "_" + tag, this.input.getValue());
            this.console.println(NbBundle.getMessage(ImportHeredis.class, (String)"Import.fixTagNotAllowed", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        if ("RESN".equalsIgnoreCase(tag) && this.input.getLevel() == 3) {
            String result = this.output.writeLine(this.input.getLevel(), "_" + tag, this.input.getValue());
            this.console.println(NbBundle.getMessage(ImportHeredis.class, (String)"Import.fixTagNotAllowed", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        if ("SOUR:NOTE:RESN".equalsIgnoreCase(path.toString())) {
            String result = this.output.writeLine(this.input.getLevel(), "_" + tag, this.input.getValue());
            this.console.println(NbBundle.getMessage(ImportHeredis.class, (String)"Import.fixTagNotAllowed", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        if ("REPO:NOTE:RESN".equalsIgnoreCase(path.toString())) {
            String result = this.output.writeLine(this.input.getLevel(), "_" + tag, this.input.getValue());
            this.console.println(NbBundle.getMessage(ImportHeredis.class, (String)"Import.fixTagNotAllowed", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        if ("INDI:NOTE:RESN".equalsIgnoreCase(path.toString())) {
            String result = this.output.writeLine(this.input.getLevel() - 1, tag, this.input.getValue());
            this.console.println(NbBundle.getMessage(ImportHeredis.class, (String)"Import.fixTagNotAllowed", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        if ("FAM:NOTE:RESN".equalsIgnoreCase(path.toString())) {
            String result = this.output.writeLine(this.input.getLevel() - 1, tag, this.input.getValue());
            this.console.println(NbBundle.getMessage(ImportHeredis.class, (String)"Import.fixTagNotAllowed", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        if ("SOUR:TYPE".equalsIgnoreCase(path.toString())) {
            String result = this.output.writeLine(this.input.getLevel(), "NOTE", this.input.getValue());
            this.console.println(NbBundle.getMessage(ImportHeredis.class, (String)"Import.fixTagNotAllowed", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        if (path.toString().endsWith("PAGE:CONT")) {
            String result = this.output.writeLine(this.input.getLevel(), "_" + tag, this.input.getValue());
            this.console.println(NbBundle.getMessage(ImportHeredis.class, (String)"Import.fixTagNotAllowed", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        if (path.toString().startsWith("INDI") && "HUSB".equalsIgnoreCase(tag)) {
            String result = this.output.writeLine(this.input.getLevel(), "_" + tag, this.input.getValue());
            this.console.println(NbBundle.getMessage(ImportHeredis.class, (String)"Import.fixTagNotAllowed", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        if (path.toString().startsWith("INDI") && "AGE".equalsIgnoreCase(tag) && path.toString().contains("HUSB")) {
            String result = this.output.writeLine(this.input.getLevel(), "_" + tag, this.input.getValue());
            this.console.println(NbBundle.getMessage(ImportHeredis.class, (String)"Import.fixTagNotAllowed", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        if (path.toString().startsWith("INDI") && "WIFE".equalsIgnoreCase(tag)) {
            String result = this.output.writeLine(this.input.getLevel(), "_" + tag, this.input.getValue());
            this.console.println(NbBundle.getMessage(ImportHeredis.class, (String)"Import.fixTagNotAllowed", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        if (path.toString().startsWith("INDI") && "AGE".equalsIgnoreCase(tag) && path.toString().contains("WIFE")) {
            String result = this.output.writeLine(this.input.getLevel(), "_" + tag, this.input.getValue());
            this.console.println(NbBundle.getMessage(ImportHeredis.class, (String)"Import.fixTagNotAllowed", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        if ("TIME".equals(tag) && !path.toString().startsWith("HEAD") && !path.toString().contains("CHAN")) {
            String result = this.output.writeLine(this.input.getLevel(), "_" + tag, this.input.getValue());
            this.console.println(NbBundle.getMessage(ImportHeredis.class, (String)"Import.fixTagNotAllowed", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        if ("AGE".equals(tag) && !(value = this.input.getValue()).contains("y") && !value.contains("m") && !value.contains("d")) {
            String result = this.output.writeLine(this.input.getLevel(), tag, this.input.getValue() + "y");
            this.console.println(NbBundle.getMessage(ImportHeredis.class, (String)"Import.fixAge", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        if ("SEX".equals(tag) && "?".equals(this.input.getValue())) {
            String result = this.output.writeLine(this.input.getLevel(), tag, "U");
            this.console.println(NbBundle.getMessage(ImportHeredis.class, (String)"Import.fixUnknownSex", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        return false;
    }

    private boolean processSwapTags() throws IOException {
        String tag = this.input.getTag();
        TagPath path = this.input.getPath();
        if ("SOUR:TITL".equalsIgnoreCase(path.toString())) {
            String result = this.output.writeLine(this.input.getLevel(), "ABBR", this.input.getValue());
            this.console.println(NbBundle.getMessage(ImportHeredis.class, (String)"Import.swappedTitlAbbr", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        if ("SOUR:ABBR".equalsIgnoreCase(path.toString())) {
            String result = this.output.writeLine(this.input.getLevel(), "TITL", this.input.getValue());
            this.console.println(NbBundle.getMessage(ImportHeredis.class, (String)"Import.swappedAbbrTitl", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        return false;
    }

    private boolean processJulianHeredis() throws IOException {
        String newValue;
        if (this.input.getTag().equals("DATE") && (newValue = this.julianCalCheck(this.input.getValue())) != null) {
            String result = this.output.writeLine(this.input.getLevel(), this.input.getTag(), newValue);
            this.console.println(NbBundle.getMessage(ImportHeredis.class, (String)"Import.fixJulianCalendar", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        return false;
    }

    private boolean processFrenchRepHeredis() throws IOException {
        String newValue;
        if (this.input.getTag().equals("DATE") && (newValue = this.frenchCalCheck(this.input.getValue())) != null) {
            String result = this.output.writeLine(this.input.getLevel(), this.input.getTag(), newValue);
            this.console.println(NbBundle.getMessage(ImportHeredis.class, (String)"Import.fixRepCalendar", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        return false;
    }

    private String julianCalCheck(String in) {
        String JULIAN_TAG = "@#DJULIAN@";
        Pattern julian_cal = Pattern.compile("(@#DJULIAN@ )(.*)");
        Pattern date_value = Pattern.compile("(FROM|BEF|AFT|BET|AND|TO|ABT|CAL|EST) (.*)");
        Pattern date_range = Pattern.compile("(FROM|BEF|AFT|BET|AND|TO) (.*) (TO|AND) (.*)");
        String result = "";
        Matcher matcher = julian_cal.matcher(in);
        if (matcher.matches() && matcher.groupCount() > 1) {
            String date_parameter = matcher.group(2);
            Matcher m1 = date_range.matcher(date_parameter);
            if (m1.matches()) {
                result = result + m1.group(1) + " " + "@#DJULIAN@" + " " + m1.group(2);
                result = result + " " + m1.group(3) + " " + "@#DJULIAN@" + " " + m1.group(4);
                return result;
            }
            m1 = date_value.matcher(date_parameter);
            if (m1.matches()) {
                result = result + m1.group(1) + " " + "@#DJULIAN@" + " " + m1.group(2);
                return result;
            }
            result = result + "@#DJULIAN@ " + matcher.group(2);
            return result;
        }
        return null;
    }

    private String frenchCalCheck(String in) {
        String FRENCH_TAG = "@#DFRENCH R@";
        Pattern french_cal = Pattern.compile("(@#DFRENCH R@ )(.*)");
        Pattern date_value = Pattern.compile("(FROM|BEF|AFT|BET|AND|TO|ABT|CAL|EST) (.*)");
        Pattern date_range = Pattern.compile("(FROM|BEF|AFT|BET|AND|TO) (.*) (TO|AND) (.*)");
        String result = "";
        Matcher matcher = french_cal.matcher(in);
        if (matcher.matches() && matcher.groupCount() > 1) {
            String date_parameter = matcher.group(2);
            Matcher m1 = date_range.matcher(date_parameter);
            if (m1.matches()) {
                result = result + m1.group(1) + " " + "@#DFRENCH R@" + " " + ImportHeredis.convDateFormat(m1.group(2));
                result = result + " " + m1.group(3) + " " + "@#DFRENCH R@" + " " + ImportHeredis.convDateFormat(m1.group(4));
                return result;
            }
            m1 = date_value.matcher(date_parameter);
            if (m1.matches()) {
                result = result + m1.group(1) + " " + "@#DFRENCH R@" + " " + ImportHeredis.convDateFormat(m1.group(2));
                return result;
            }
            result = result + "@#DFRENCH R@ " + ImportHeredis.convDateFormat(matcher.group(2));
            return result;
        }
        return null;
    }

    private static String convDateFormat(String from) {
        HashMap<String, String> repmonconvtable = new HashMap<String, String>(){
            {
                this.put("I", "1");
                this.put("II", "2");
                this.put("III", "3");
                this.put("IV", "4");
                this.put("V", "5");
                this.put("VI", "6");
                this.put("VII", "7");
                this.put("VIII", "8");
                this.put("IX", "9");
                this.put("X", "10");
                this.put("XI", "11");
                this.put("XII", "12");
            }
        };
        Pattern french_date = Pattern.compile("(.*) an (\\w*)(.*)");
        Matcher m = french_date.matcher(from);
        if (m.matches() && m.groupCount() > 2) {
            String result = m.group(1) + " " + (String)repmonconvtable.get(m.group(2));
            if (m.groupCount() > 3) {
                result = result + m.group(3);
            }
            return result;
        }
        return from;
    }

    public boolean processEntities(Gedcom gedcom) {
        int i;
        boolean hasErrors = false;
        Property[] props = null;
        Property prop = null;
        Property host = null;
        Property form = null;
        boolean moved = false;
        this.console.println(NbBundle.getMessage(ImportHeredis.class, (String)"Import.fixMedia"));
        for (Indi indi : gedcom.getIndis()) {
            props = indi.getProperties("RESN");
            if (props == null || props.length <= 1) continue;
            for (i = 1; i < props.length; ++i) {
                prop = props[i];
                prop.getParent().delProperty(prop);
            }
            hasErrors = true;
        }
        for (Fam fam : gedcom.getFamilies()) {
            props = fam.getProperties("RESN");
            if (props == null || props.length <= 1) continue;
            for (i = 1; i < props.length; ++i) {
                prop = props[i];
                prop.getParent().delProperty(prop);
            }
            hasErrors = true;
        }
        List fileList = gedcom.getPropertiesByClass(PropertyFile.class);
        Property obje = null;
        for (Property file : fileList) {
            obje = file.getParent();
            form = obje.getProperty("FORM");
            if (form == null) continue;
            if (file != null && file.getProperty("FORM") == null) {
                file.addProperty("FORM", form.getValue());
            } else {
                obje.addProperty("_FORM", form.getValue());
            }
            obje.delProperty(form);
            this.console.println(NbBundle.getMessage(ImportGramps.class, (String)"Import.fixMediaForm", (Object)file.toString()));
            hasErrors = true;
        }
        for (Media media : gedcom.getMedias()) {
            prop = media.getProperty("FORM");
            if (prop != null && (host = media.getProperty("FILE")) != null) {
                host.addProperty("FORM", prop.getValue());
                prop.getParent().delProperty(prop);
                hasErrors = true;
            }
            if ((host = media.getProperty("FILE")) == null) continue;
            prop = host.getProperty("FORM");
            if (prop == null) {
                String ext = FileChooserBuilder.getExtension((String)host.getValue());
                if (ext == null) {
                    ext = "none";
                }
                host.addProperty("FORM", ext);
                hasErrors = true;
            }
            if ((prop = host.getProperty("TITL")) != null) continue;
            PropertyFile filep = (PropertyFile)host;
            File file = filep.getFile();
            String title = file != null ? file.getName() : "";
            int i2 = title.indexOf(".");
            host.addProperty("TITL", i2 == -1 ? title : title.substring(0, i2));
            hasErrors = true;
        }
        for (Source source : gedcom.getSources()) {
            moved = false;
            prop = source.getProperty("QUAY");
            if (prop != null) {
                for (PropertyXRef xref : source.getProperties(PropertyXRef.class)) {
                    Property quay;
                    if (!xref.isValid() || !((host = xref.getTarget()) instanceof PropertySource) || (quay = host.getProperty("QUAY")) != null) continue;
                    host.addProperty("QUAY", prop.getValue());
                    moved = true;
                }
                if (!moved) {
                    source.addProperty("_QUAY", prop.getValue());
                }
                source.delProperty(prop);
                hasErrors = true;
            }
            if ((prop = source.getProperty("WWW")) != null) {
                host = source.getProperty("REPO");
                if (host != null) {
                    host.addProperty("NOTE", prop.getValue());
                }
                source.delProperty(prop);
                hasErrors = true;
            }
            if ((prop = source.getProperty("EMAIL")) == null) continue;
            host = source.getProperty("REPO");
            if (host != null && host instanceof PropertyXRef) {
                PropertyXRef repo = (PropertyXRef)host;
                if ((host = repo.getTarget()) != null) {
                    host.getParent().addProperty("EMAIL", prop.getValue());
                }
            } else {
                source.addProperty("_EMAIL", prop.getValue());
            }
            source.delProperty(prop);
            hasErrors = true;
        }
        this.console.println("=============================");
        return hasErrors;
    }
}

