/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.imports.gedcom;

import ancestris.api.imports.Import;
import ancestris.modules.imports.gedcom.Bundle;
import ancestris.modules.imports.gedcom.ImportGramps;
import ancestris.modules.imports.gedcom.ImportHeredis;
import ancestris.util.swing.FileChooserBuilder;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Media;
import genj.gedcom.Property;
import genj.gedcom.PropertyChild;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyPlace;
import genj.gedcom.PropertyXRef;
import genj.gedcom.Source;
import genj.gedcom.TagPath;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.openide.util.NbBundle;

public class ImportMacFamilyTree
extends Import {
    private static int counter = 0;
    private static final HashMap<Integer, String> hashFixes = new HashMap();
    String previousLine = "";

    public boolean isGeneric() {
        return false;
    }

    public String toString() {
        return Bundle.importmacfamilytree_name();
    }

    protected String getImportComment() {
        return Bundle.importmacfamilytree_note();
    }

    protected void firstPass() {
        super.firstPass();
        this.detectBadLines();
    }

    protected boolean process() throws IOException {
        if (this.beforeProcess()) {
            return true;
        }
        if (super.process()) {
            return true;
        }
        return this.afterProcess();
    }

    public boolean fixGedcom(Gedcom gedcom) {
        boolean ret = super.fixGedcom(gedcom);
        this.incrementProgress();
        return ret |= this.processEntities(gedcom);
    }

    private void detectBadLines() {
        if (this.input.getLine().startsWith("/")) {
            hashFixes.put(counter, this.previousLine);
            ++counter;
        }
        this.previousLine = this.input.getLine();
    }

    private boolean beforeProcess() throws IOException {
        String tag = this.input.getTag();
        TagPath path = this.input.getPath();
        if (hashFixes.containsValue(this.input.getLine())) {
            try {
                String str = this.input.getValue() + "/";
                this.output.writeLine(this.input.getLevel(), this.input.getXref(), this.input.getTag(), str);
                this.console.println("Fixed line " + str);
                return true;
            }
            catch (IOException str) {
                // empty catch block
            }
        }
        if ("OBJE:URL".equalsIgnoreCase(path.toString())) {
            String result = this.output.writeLine(this.input.getLevel(), "FILE", this.input.getValue());
            result = result + "\n" + this.output.writeLine(this.input.getLevel(), "FORM", "url");
            this.console.println(NbBundle.getMessage(ImportHeredis.class, (String)"Import.fixTagNotAllowed", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        if ("INDI:ASSO:DATE".equalsIgnoreCase(path.toString())) {
            String result = this.output.writeLine(this.input.getLevel(), "_" + tag, this.input.getValue());
            this.console.println(NbBundle.getMessage(ImportHeredis.class, (String)"Import.fixTagNotAllowed", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        return false;
    }

    private boolean afterProcess() {
        return false;
    }

    public boolean processEntities(Gedcom gedcom) {
        boolean hasErrors = false;
        Object props = null;
        Property prop = null;
        Property prop2 = null;
        PropertyXRef host = null;
        for (Fam fam : gedcom.getFamilies()) {
            Property[] children = fam.getProperties("CHIL");
            for (Property child : children) {
                prop = child.getProperty("PEDI");
                if (prop == null) continue;
                host = ((PropertyChild)child).getTarget();
                host.addProperty("PEDI", prop.getValue());
                prop.getParent().delProperty(prop);
                this.console.println(NbBundle.getMessage(ImportGramps.class, (String)"Import.fixPedi", (Object)host.getEntity().toString(true)));
                hasErrors = true;
            }
        }
        for (Object entity : gedcom.getEntities()) {
            List changes = entity.getAllProperties("CHAN");
            for (Property chan : changes) {
                if (!chan.getValue().trim().isEmpty()) continue;
                chan.getParent().delProperty(chan);
                this.console.println(NbBundle.getMessage(ImportGramps.class, (String)"Import.fixEmptyChan", (Object)entity.toString(true)));
                hasErrors = true;
            }
            if (!entity.getTag().equals("INDI")) continue;
            this.reduceEvents((Entity)entity, "BIRT");
            this.reduceEvents((Entity)entity, "BAPM");
            this.reduceEvents((Entity)entity, "DEAT");
            this.reduceEvents((Entity)entity, "BURI");
            this.reduceEvents((Entity)entity, "CREM");
            this.reduceEvents((Entity)entity, "CONF");
        }
        List placeList = gedcom.getPropertiesByClass(PropertyPlace.class);
        for (Property place : placeList) {
            prop = place.getParent().getProperty("LONG");
            prop2 = place.getParent().getProperty("LATI");
            if (prop == null) continue;
            Property map = place.addProperty("MAP", "");
            map.addProperty("LONG", prop.getValue());
            prop.getParent().delProperty(prop);
            if (prop2 != null) {
                map.addProperty("LATI", prop2.getValue());
                prop2.getParent().delProperty(prop2);
            }
            hasErrors = true;
            this.console.println(NbBundle.getMessage(ImportGramps.class, (String)"Import.fixPlaceCoord", (Object)place.getValue()));
        }
        for (Media media : gedcom.getMedias()) {
            host = media.getProperty("FILE");
            prop = media.getProperty("TITL");
            if (host == null || prop == null) continue;
            host.addProperty("TITL", prop.getValue());
            media.delProperty(prop);
            hasErrors = true;
            this.console.println(NbBundle.getMessage(ImportGramps.class, (String)"Import.fixMediaTitle", (Object)media.toString()));
        }
        List fileList = gedcom.getPropertiesByClass(PropertyFile.class);
        for (Property file : fileList) {
            prop = file.getParent().getProperty("FORM");
            if (prop != null) {
                file.addProperty("FORM", prop.getValue());
                prop.getParent().delProperty(prop);
                this.console.println(NbBundle.getMessage(ImportGramps.class, (String)"Import.fixMediaForm", (Object)file.toString()));
                hasErrors = true;
            }
            if ((prop = file.getProperty("FORM")) != null) continue;
            String ext = FileChooserBuilder.getExtension((String)file.getValue());
            if (ext == null) {
                ext = "none";
            }
            file.addProperty("FORM", ext);
            this.console.println(NbBundle.getMessage(ImportGramps.class, (String)"Import.fixMediaForm", (Object)file.toString()));
            hasErrors = true;
        }
        for (Source sour : gedcom.getSources()) {
            Property plac = sour.getProperty("PLAC");
            Property date = sour.getProperty("DATE");
            Property agnc = sour.getProperty("AGNC");
            if (plac != null || date != null || agnc != null) {
                Property even;
                Property data = sour.getProperty("DATA");
                if (data == null) {
                    data = sour.addProperty("DATA", "");
                }
                if (agnc != null) {
                    data.addProperty("AGNC", agnc.getValue());
                    sour.delProperty(agnc);
                    hasErrors = true;
                }
                if ((even = data.getProperty("EVEN")) == null) {
                    even = data.addProperty("EVEN", "");
                }
                if (date != null) {
                    even.addProperty("DATE", date.getValue());
                    sour.delProperty(date);
                    hasErrors = true;
                }
                if (plac != null) {
                    even.addProperty("PLAC", plac.getValue());
                    sour.delProperty(plac);
                    hasErrors = true;
                }
            }
            this.console.println(NbBundle.getMessage(ImportGramps.class, (String)"Import.fixSource", (Object)sour.toString()));
        }
        this.console.println("=============================");
        return hasErrors;
    }
}

