/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.imports.gedcom;

import ancestris.api.imports.Import;
import ancestris.modules.gedcom.utilities.GedcomUtilities;
import ancestris.modules.imports.gedcom.Bundle;
import ancestris.modules.imports.gedcom.ImportHeredis;
import ancestris.util.swing.FileChooserBuilder;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.gedcom.PropertyFile;
import genj.gedcom.TagPath;
import java.io.File;
import java.io.IOException;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.NbBundle;

public class ImportRootsTrust
extends Import {
    private static final Logger LOG = Logger.getLogger("ancestris.app", null);

    public boolean isGeneric() {
        return false;
    }

    public String toString() {
        return Bundle.importrootstrust_name();
    }

    protected String getImportComment() {
        return Bundle.importrootstrust_note();
    }

    protected void firstPass() {
        super.firstPass();
    }

    protected boolean process() throws IOException {
        String tag = this.input.getTag();
        TagPath path = this.input.getPath();
        if (this.input.getLevel() == 2 && this.input.getTag().equals("VERS") && this.input.getValue().startsWith("5.5")) {
            GEDCOM_VERSION = "5.5.1";
            this.output.writeLine(2, "VERS", GEDCOM_VERSION);
            this.console.println(NbBundle.getMessage(ImportHeredis.class, (String)"Import.fixVersion", (Object)GEDCOM_VERSION));
            ++this.nbChanges;
            return true;
        }
        if ("OBJE:FILE:TEXT".equalsIgnoreCase(path.toString())) {
            String result = this.output.writeLine(this.input.getLevel(), "_" + tag, this.input.getValue());
            this.console.println(NbBundle.getMessage(ImportHeredis.class, (String)"Import.fixTagNotAllowed", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        if ("OBJE:FILE:DATE".equalsIgnoreCase(path.toString())) {
            String result = this.output.writeLine(this.input.getLevel(), "_" + tag, this.input.getValue());
            this.console.println(NbBundle.getMessage(ImportHeredis.class, (String)"Import.fixTagNotAllowed", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        if ("INDI:ALIA".equalsIgnoreCase(path.toString())) {
            String result = this.output.writeLine(this.input.getLevel(), "NAME", this.input.getValue());
            result = result + "\n" + this.output.writeLine(this.input.getLevel() + 1, "TYPE", "aka");
            this.console.println(NbBundle.getMessage(Import.class, (String)"Import.fixNames", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        if ("INDI:NAME:OBJE".equalsIgnoreCase(path.toString())) {
            this.output.writeLine(this.input.getLevel() - 1, this.input.getXref(), tag, this.input.getValue());
            return true;
        }
        return super.process();
    }

    protected void finalise() throws IOException {
        super.finalise();
    }

    public boolean fixGedcom(Gedcom gedcom) {
        boolean ret = super.fixGedcom(gedcom);
        this.incrementProgress();
        return ret |= this.fixOther(gedcom);
    }

    public void complete() {
        super.complete();
    }

    /*
     * WARNING - void declaration
     */
    public boolean fixOther(Gedcom gedcom) {
        boolean hasErrors = false;
        Stack<Property> propToDelete = new Stack<Property>();
        for (Entity entity : gedcom.getEntities()) {
            Property host;
            Property host2;
            for (Property page : entity.getAllProperties("PAGE")) {
                void var8_10;
                String string = page.getValue();
                int n = page.getNoOfProperties();
                for (int i = 0; i < n; ++i) {
                    Property prop = page.getProperty(i);
                    String tag = prop.getTag();
                    if ("CONC".equals(tag)) {
                        String string2 = (String)var8_10 + prop.getValue();
                        propToDelete.add(prop);
                        continue;
                    }
                    if (!"CONT".equals(tag)) continue;
                    String string3 = (String)var8_10 + " " + prop.getValue();
                    propToDelete.add(prop);
                }
                if (n <= 0) continue;
                page.setValue((String)var8_10);
                while (!propToDelete.empty()) {
                    page.delProperty((Property)propToDelete.pop());
                }
                ++this.nbChanges;
                hasErrors = true;
            }
            if (entity.getTag().equals("INDI") && (host2 = entity.getProperty("NAME")) != null) {
                Property[] props;
                for (Property sour : props = host2.getProperties("SOUR")) {
                    try {
                        GedcomUtilities.movePropertyRecursively((Property)sour, (Property)entity);
                        ++this.nbChanges;
                    }
                    catch (GedcomException ex) {
                        LOG.log(Level.INFO, "Error with SOUR", ex);
                    }
                }
                for (Property note : props = host2.getProperties("NOTE")) {
                    try {
                        GedcomUtilities.movePropertyRecursively((Property)note, (Property)entity);
                        ++this.nbChanges;
                    }
                    catch (GedcomException ex) {
                        LOG.log(Level.INFO, "Error with NOTE", ex);
                    }
                }
            }
            if (entity.getTag().equals("INDI")) {
                this.reduceEvents(entity, "BIRT");
                this.reduceEvents(entity, "BAPM");
                this.reduceEvents(entity, "DEAT");
                this.reduceEvents(entity, "BURI");
                this.reduceEvents(entity, "CREM");
            }
            if (!entity.getTag().equals("OBJE")) continue;
            Property prop = entity.getProperty("FORM");
            if (prop != null && (host = entity.getProperty("FILE")) != null) {
                host.addProperty("FORM", prop.getValue());
                prop.getParent().delProperty(prop);
                hasErrors = true;
            }
            if ((host = entity.getProperty("FILE")) != null) {
                prop = host.getProperty("FORM");
                if (prop == null) {
                    void var8_17;
                    String string = FileChooserBuilder.getExtension((String)host.getValue());
                    if (string == null) {
                        String string4 = "none";
                    }
                    host.addProperty("FORM", (String)var8_17);
                    hasErrors = true;
                }
                if ((prop = host.getProperty("TITL")) != null) continue;
                PropertyFile propertyFile = (PropertyFile)host;
                File file = propertyFile.getFile();
                String title = file != null ? file.getName() : "";
                int i = title.indexOf(".");
                host.addProperty("TITL", i == -1 ? title : title.substring(0, i));
                hasErrors = true;
                continue;
            }
            entity.addDefaultProperties();
        }
        return hasErrors;
    }
}

