/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.beans;

import ancestris.core.actions.AbstractAncestrisAction;
import genj.edit.beans.CCPMenu;
import genj.edit.beans.PropertyBean;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;
import genj.util.swing.DateWidget;
import genj.util.swing.ImageIcon;
import genj.util.swing.NestedBlockLayout;
import genj.util.swing.PopupWidget;
import genj.util.swing.TextFieldWidget;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;

public class DateBean
extends PropertyBean {
    private static final ImageIcon PIT = new ImageIcon(PropertyBean.class, "/genj/gedcom/images/Time");
    private static final NestedBlockLayout H = new NestedBlockLayout("<row><choose/><date1/><label2/><date2/><phrase/></row>");
    private static final NestedBlockLayout V = new NestedBlockLayout("<table><row><choose/><date1/></row><row><label2/><date2/></row><row><phrase cols=\"2\"/></row></table>");
    private PropertyDate.Format format;
    private DateWidget date1;
    private DateWidget date2;
    private PopupWidget choose;
    private JLabel label2;
    private TextFieldWidget phrase;

    public DateBean() {
        this.setLayout((LayoutManager)V.copy());
        this.setAlignmentX(0.0f);
        ArrayList<ChangeFormat> actions = new ArrayList<ChangeFormat>(10);
        for (int i = 0; i < PropertyDate.FORMATS.length; ++i) {
            actions.add(new ChangeFormat(PropertyDate.FORMATS[i]));
        }
        this.choose = new PopupWidget();
        this.choose.addItems(actions);
        this.add((Component)this.choose);
        this.date1 = new DateWidget();
        this.date1.setComponentPopupMenu((JPopupMenu)new CCPMenu((JComponent)this.date1));
        this.date1.addChangeListener((ChangeListener)this.changeSupport);
        this.add((Component)this.date1);
        this.label2 = new JLabel();
        this.add(this.label2);
        this.date2 = new DateWidget();
        this.date2.addChangeListener((ChangeListener)this.changeSupport);
        this.date2.setComponentPopupMenu((JPopupMenu)new CCPMenu((JComponent)this.date2));
        this.add((Component)this.date2);
        this.phrase = new TextFieldWidget("", 10);
        this.phrase.setComponentPopupMenu((JPopupMenu)new CCPMenu((JTextComponent)this.phrase));
        this.phrase.addChangeListener((ChangeListener)this.changeSupport);
        this.add((Component)this.phrase);
        this.setPreferHorizontal(false);
        this.setFormat(PropertyDate.FORMATS[0]);
        this.setPreferedCalendar((Calendar)PointInTime.GREGORIAN, (Calendar)PointInTime.FRENCHR);
        this.defaultFocus = this.date1;
    }

    public void setPreferedCalendar(Calendar prefered, Calendar alternate) {
        this.date1.setPreferedCalendar(prefered, alternate);
        this.date2.setPreferedCalendar(prefered, alternate);
    }

    public void setPreferHorizontal(boolean set) {
        this.setLayout((LayoutManager)(set ? H.copy() : V.copy()));
        PropertyDate.Format f = this.format;
        this.format = null;
        this.setFormat(f);
        this.revalidate();
        this.repaint();
    }

    protected void commitImpl(Property property) {
        PropertyDate p = (PropertyDate)property;
        this.setValueToProperty(p);
    }

    public void setValueToProperty(PropertyDate pDate) {
        pDate.setValue(this.format, this.date1.getValue(), this.date2.getValue(), this.phrase.getText());
    }

    public void addActionListener(ActionListener a) {
        this.date1.addActionListener(a);
        this.date2.addActionListener(a);
    }

    public void removeActionListener(ActionListener a) {
        this.date1.removeActionListener(a);
        this.date2.removeActionListener(a);
    }

    public PropertyDate.Format getFormat() {
        return this.format;
    }

    public PointInTime getFromPIT() {
        return this.date1.getValue(false);
    }

    public PointInTime getToPIT() {
        return this.date2.getValue(false);
    }

    public void setFormat(PropertyDate.Format set) {
        if (this.format == set) {
            return;
        }
        this.format = set;
        this.changeSupport.fireChangeEvent();
        this.choose.setToolTipText(this.format.getName());
        String prefix1 = this.format.getPrefix1Name();
        this.choose.setIcon((Icon)(prefix1 == null ? PIT : null));
        this.choose.setText(prefix1 == null ? "" : prefix1);
        if (this.format.isRange()) {
            this.date2.setVisible(true);
            this.label2.setVisible(true);
            this.label2.setText(this.format.getPrefix2Name());
        } else {
            this.date2.setVisible(false);
            this.label2.setVisible(false);
        }
        this.phrase.setVisible(this.format.usesPhrase());
        this.revalidate();
        this.repaint();
    }

    public void setPropertyImpl(Property prop) {
        if (prop == null) {
            PointInTime pit = new PointInTime();
            this.date1.setValue(pit);
            this.date2.setValue(pit);
            this.phrase.setText("");
            this.setFormat(PropertyDate.FORMATS[0]);
        } else {
            PropertyDate date = (PropertyDate)prop;
            this.date1.setValue(date.getStart());
            this.date2.setValue(date.getEnd());
            this.phrase.setText(date.getPhrase());
            this.setFormat(date.getFormat());
        }
    }

    public boolean isCommittable() {
        return this.date1.getValue() != null && this.date2.getValue() != null;
    }

    private class ChangeFormat
    extends AbstractAncestrisAction {
        private PropertyDate.Format formatToSet;

        private ChangeFormat(PropertyDate.Format set) {
            this.formatToSet = set;
            super.setText(set.getName());
        }

        public void actionPerformed(ActionEvent event) {
            DateBean.this.setFormat(this.formatToSet);
            DateBean.this.date1.requestFocusInWindow();
        }
    }
}

